/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.connectors.CMConnector.CMConnector;
import com.cognos.cm.connectors.CMConnector.CMResponseException;
import com.cognos.cm.connectors.CMConnector.CMResponseTimeoutException;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreMultipleCMsUtil;
import com.cognos.cm.dbstore.ICMDbStoreMultipleCMsUtil;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Servlet;
import com.cognos.cm.store.CMStoreConnection;
import com.cognos.cm.store.CMStoreConnectionProblemReporter;
import com.cognos.cm.store.CMStoreException;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.util.UrlUtils;
import com.cognos.cmutils.date.DateUtils;
import java.util.ArrayList;

public class MultipleCMsSyncThread
extends Thread
implements CMStoreConnectionProblemReporter {
    public static final int SYNC_MODE_NEGOTIATING = 0;
    public static final int SYNC_MODE_ACTIVE = 1;
    public static final int SYNC_MODE_STANDBY = 2;
    public static final int SYNC_MODE_SWITCHOVER = 3;
    public static final int PINGTIMEOUT = 60000;
    private int mode_ = 0;
    private boolean bTerminate_ = false;
    private final Servlet servlet_;
    private String thisCMURI_;
    private final ArrayList<?> cmURIs_;
    private final String thisPathNoProtocol_;
    private final Object waitOnObject_ = new Object();
    private final Object modeSyncObject_ = new Object();
    private final Object inNegotiateGuard = new Object();
    private boolean inNegotiate;
    private boolean isDBLocked_ = false;
    private boolean switchoverRetry_ = false;
    private boolean checkForActiveRetry_ = false;
    private int checkForRequestedRetry_ = 0;
    private int checkForActiveInDbRetry_ = 0;
    private boolean becomeActiveAsSuspended_ = false;
    private String thisDispatcherPath = null;
    private ICMDbStoreMultipleCMsUtil multipleCMUtils = CMDbStoreMultipleCMsUtil.getInstance();

    public MultipleCMsSyncThread(Servlet servlet, String CMURL) throws CMException {
        super("CRN.CM.MultipleCMsSyncThread");
        this.servlet_ = servlet;
        this.thisDispatcherPath = UrlUtils.convertURItoDispatcherPath(CMURL, false);
        this.thisPathNoProtocol_ = UrlUtils.removeProtocol(this.thisDispatcherPath);
        IConfiguration config = ConfigurationFactory.getConfig();
        this.thisCMURI_ = config.getString("localCMURL");
        if (this.thisCMURI_ == null) {
            throw new CMException("cmMissingLocalCMURL");
        }
        this.thisCMURI_ = UrlUtils.convertURItoDispatcherPath(this.thisCMURI_, true);
        this.cmURIs_ = (ArrayList)config.getObject("contentManagers");
        if (this.cmURIs_ == null) {
            throw new CMException("cmInvalidCMURLs");
        }
        this.readAdvancedSettingsFromDb();
        boolean activeCMExists = this.checkForActiveCM(true);
        if (activeCMExists) {
            this.becomeStandby(false, false);
        } else if (this.thisHasHighestCapacity()) {
            try {
                this.multipleCMUtils.resetDispatcherState();
            }
            catch (Throwable ex) {
                CMIndications.logException(ex);
            }
            this.becomeActive(false, true);
        } else {
            this.negotiateActiveCM(AdvancedSettings.CMSYNC_NEGOTIATIONTIMEFORSTARTUP);
            if (this.thisIsNegotiatedCM()) {
                try {
                    this.multipleCMUtils.resetDispatcherState();
                }
                catch (Throwable ex) {
                    CMIndications.logException(ex);
                }
                this.becomeActive(false);
            } else {
                this.becomeStandby(false, false);
            }
        }
    }

    protected void readAdvancedSettingsFromDb() {
        try {
            AdvancedSettings.update(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void terminate() {
        this.bTerminate_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CMExecutionContext.setUp();
        while (!this.bTerminate_) {
            try {
                boolean needToWait = false;
                boolean activeCMExistsSet = false;
                boolean activeCMExists = true;
                if (this.checkForActiveInDbRetry_ <= 0) {
                    this.checkForActiveInDbRetry_ = (int)(AdvancedSettings.CMSYNC_CHECKACTIVETIME / AdvancedSettings.CMSYNC_HEARTBEATTIME);
                }
                if (this.mode_ == 2 && (this.switchoverRetry_ || this.checkForActiveRetry_ || this.checkForRequestedRetry_ > 0)) {
                    activeCMExists = this.checkForActiveCM(!this.switchoverRetry_);
                    activeCMExistsSet = true;
                }
                Object object = this.modeSyncObject_;
                synchronized (object) {
                    if (this.mode_ == 0) {
                        if (this.thisHasHighestCapacity()) {
                            MultipleCMsSyncThread.info("This Content Manager has highest capacity, will attempt to become active.");
                            this.becomeActive(true);
                        } else {
                            MultipleCMsSyncThread.info("Negotiating with other Content Managers.");
                            this.negotiateActiveCM(AdvancedSettings.CMSYNC_NEGOTIATIONTIME);
                            if (this.thisIsNegotiatedCM()) {
                                MultipleCMsSyncThread.info("This Content Manager is the negotiated active Content Manager.");
                                this.becomeActive(true);
                            } else {
                                MultipleCMsSyncThread.info("This Content Manager is not the negotiated active Content Manager.");
                                this.becomeStandby(true, false);
                            }
                        }
                    } else if (this.mode_ == 1) {
                        --this.checkForActiveInDbRetry_;
                        if (this.checkForActiveInDbRetry_ <= 0) {
                            this.checkCMIsStillActive();
                        }
                        needToWait = true;
                    } else if (this.mode_ == 2) {
                        String requestedCMURL = null;
                        if (this.switchoverRetry_ && (requestedCMURL = this.getRequestedCMURL(null)) == null) {
                            this.switchoverRetry_ = false;
                            this.becomeActiveAsSuspended_ = false;
                        }
                        if (this.switchoverRetry_) {
                            if (activeCMExistsSet && !activeCMExists && requestedCMURL != null && UrlUtils.localContentManager(requestedCMURL)) {
                                this.becomeActive(true);
                                if (this.mode_ == 2) {
                                    needToWait = true;
                                }
                            } else {
                                needToWait = true;
                            }
                        } else if (this.checkForActiveRetry_) {
                            if (activeCMExistsSet && !activeCMExists) {
                                this.checkForActiveRetry_ = false;
                                this.becomeNegotiating();
                            } else if (activeCMExistsSet && activeCMExists) {
                                this.checkForActiveRetry_ = false;
                            }
                        } else if (this.checkForRequestedRetry_ > 0) {
                            if (this.checkForRequestedRetry_ == 1) {
                                if (activeCMExistsSet && !activeCMExists) {
                                    this.removeRequestedActiveCM();
                                    this.becomeNegotiating();
                                }
                                this.checkForRequestedRetry_ = 0;
                            } else {
                                --this.checkForRequestedRetry_;
                                needToWait = true;
                            }
                        } else {
                            needToWait = true;
                        }
                    } else if (this.mode_ == 3) {
                        this.makeSwitchOverFromThis();
                    }
                }
                if (!needToWait) continue;
                this.goToSleep(AdvancedSettings.CMSYNC_HEARTBEATTIME);
            }
            catch (CMException cmex) {
                CMIndications.logException(cmex);
                try {
                    Thread.sleep(AdvancedSettings.CMSYNC_HEARTBEATTIME);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Exception ex) {
                CMIndications.logException(ex);
                try {
                    Thread.sleep(AdvancedSettings.CMSYNC_HEARTBEATTIME);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable ex) {}
        }
        if (this.bTerminate_) {
            try {
                this.shutdown();
            }
            catch (Throwable e) {
                CMIndications.logThrowable(e);
            }
            finally {
                CMExecutionContext.tearDown();
            }
        }
    }

    public final int getMode() {
        return this.mode_;
    }

    private void goToSleep(long heartBeatTime) throws InterruptedException {
        long sleepTime = System.currentTimeMillis();
        Thread.sleep(heartBeatTime);
        sleepTime = System.currentTimeMillis() - sleepTime;
        if (sleepTime > heartBeatTime + heartBeatTime / 2L) {
            MultipleCMsSyncThread.info("Java thread sleep took " + sleepTime + "ms instead of " + heartBeatTime + "ms");
        }
    }

    private void becomeStandby(boolean initialize, boolean switchFromActive) {
        MultipleCMsSyncThread.info("Content Manager is becoming standby.");
        this.mode_ = 2;
        this.isDBLocked_ = false;
        if (initialize) {
            initializeAsRunnable initializeRunnable = null;
            initializeRunnable = switchFromActive ? new initializeAsRunnable(this, 3, CMServlet.CMisSuspended_) : new initializeAsRunnable(this, 2, CMServlet.CMisSuspended_);
            Thread thread = new Thread(initializeRunnable);
            thread.start();
        }
    }

    private boolean checkCurrentCM() {
        boolean ret = true;
        try {
            String activeCMURI = this.multipleCMUtils.getRunningContentStoreName(CMDbStoreFactory.getAdminConnection());
            CMConnector.ping(activeCMURI);
        }
        catch (CMStoreNotAvailable e1) {
            ret = false;
        }
        catch (CMException e1) {
            ret = false;
        }
        return ret;
    }

    private void becomeActive(boolean initialize) throws CMException {
        this.becomeActive(initialize, false);
    }

    private boolean isDelaySycSucceeded(boolean initialize, boolean newInit) {
        boolean delaySucceeded = false;
        if (AdvancedSettings.CMSYNC_FAILOVER_DELAY_MS != 0L && !newInit && !this.isCurrentActiveCMInstance()) {
            MultipleCMsSyncThread.info("sync delay");
            if (!this.checkCurrentCM()) {
                long cmsync_delay_ms = AdvancedSettings.CMSYNC_FAILOVER_DELAY_MS;
                MultipleCMsSyncThread.info("Sleep for " + cmsync_delay_ms + " ms");
                try {
                    Thread.sleep(cmsync_delay_ms);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.checkCurrentCM()) {
                MultipleCMsSyncThread.log("sync aborted, successfully avoided an unnecessary cm fail-over");
                this.becomeStandby(initialize, false);
                MultipleCMsSyncThread.info("Become active -- Compelete:::::" + this.mode_);
            } else {
                delaySucceeded = true;
                MultipleCMsSyncThread.info("sync delay Complete");
            }
        } else {
            delaySucceeded = true;
            MultipleCMsSyncThread.info("No delayAdvancedSetting CMSYNC_FAILOVER_DELAY_MS=" + String.valueOf(AdvancedSettings.CMSYNC_FAILOVER_DELAY_MS));
        }
        return delaySucceeded;
    }

    private void becomeActive(boolean initialize, boolean newInit) throws CMException {
        MultipleCMsSyncThread.info("Content Manager will attempt to become active.");
        if (!this.isDelaySycSucceeded(initialize, newInit)) {
            return;
        }
        if (!this.isDBLocked_) {
            MultipleCMsSyncThread.info("Content Manager will attempt to lock the database.");
            this.lockDatabase();
        }
        boolean becomeActiveAsSuspended = this.becomeActiveAsSuspended_;
        this.becomeActiveAsSuspended_ = false;
        if (this.isDBLocked_) {
            MultipleCMsSyncThread.info("Content Manager has a lock on the database, becoming active.");
            this.initializedAsActive(initialize, becomeActiveAsSuspended);
        } else {
            MultipleCMsSyncThread.log("Content Manager could not lock the database, becoming standby.");
            this.becomeStandby(initialize, false);
        }
        MultipleCMsSyncThread.info("Become active -- Compelete:::::" + this.mode_);
    }

    private void lockDatabase() throws CMStoreNotAvailable, CMException {
        CMDbConnection lockConnection_ = CMDbStoreFactory.getAdminConnection();
        try {
            this.isDBLocked_ = this.multipleCMUtils.lockDatabase(lockConnection_, this.becomeActiveAsSuspended_);
        }
        finally {
            CMDbStoreFactory.releaseConnection(lockConnection_);
        }
    }

    private void initializedAsActive(boolean initialize, boolean becomeActiveAsSuspended) {
        this.mode_ = 1;
        this.switchoverRetry_ = false;
        if (initialize) {
            CMDbStoreFactory.clearCache();
            initializeAsRunnable initializeRunnable = new initializeAsRunnable(this, 1, becomeActiveAsSuspended);
            Thread thread = new Thread(initializeRunnable);
            thread.start();
        }
    }

    private void becomeNegotiating() {
        MultipleCMsSyncThread.info("Content Manager has started the negotiation process.");
        this.mode_ = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForActiveCM(boolean checkHeartbeat) throws CMException {
        MultipleCMsSyncThread.info("Checking for active Content Manager. Will check heartbeat=" + checkHeartbeat + ".");
        if (this.mode_ == 1) {
            return true;
        }
        CMDbConnection lockConnection_ = CMDbStoreFactory.getAdminConnection();
        try {
            String activeCMURI = this.multipleCMUtils.getRunningContentStoreName(lockConnection_);
            if (activeCMURI == null) {
                MultipleCMsSyncThread.info("There is no active Content Manager URI in the database.");
                boolean bl = false;
                return bl;
            }
            if (UrlUtils.localContentManager(activeCMURI)) {
                MultipleCMsSyncThread.info("This Content Manager isn't active however it is listed as active in the database.");
                this.multipleCMUtils.releaseDatabaseLock(lockConnection_, activeCMURI, false);
                boolean bl = false;
                return bl;
            }
            boolean retry = false;
            long timeBeforeRequest = 0L;
            do {
                long extime;
                block29: {
                    block28: {
                        try {
                            if (timeBeforeRequest == 0L) {
                                MultipleCMsSyncThread.info("Putting a heart beat in the database for Content Manager: " + this.thisCMURI_ + ".");
                                timeBeforeRequest = DateUtils.getUTCTime();
                                this.multipleCMUtils.setHeartbeat(lockConnection_, this.thisCMURI_);
                            }
                            MultipleCMsSyncThread.info("Pinging active Content Manager " + activeCMURI + ".");
                            CMConnector.ping(activeCMURI);
                            MultipleCMsSyncThread.info("Ping was successful.");
                            if (!checkHeartbeat) {
                                boolean bl = true;
                                return bl;
                            }
                            if (!this.recentHeartbeat()) break block28;
                        }
                        catch (CMResponseTimeoutException ex) {
                            MultipleCMsSyncThread.info("Ping timed out, will retry in " + AdvancedSettings.CMSYNC_HEARTBEATTIME + " ms.");
                            retry = true;
                            try {
                                Thread.sleep(AdvancedSettings.CMSYNC_HEARTBEATTIME);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        catch (CMResponseException ex) {
                            boolean checkDBActivity = false;
                            MultipleCMsSyncThread.info("An error occured while executing the ping to the active Content Manager.");
                            if (!retry) {
                                long timeAfterRequest = DateUtils.getUTCTime();
                                long timeLeftToWait = AdvancedSettings.CMSYNC_SHORTNETWORKINTERRUPTIONTIME - (timeAfterRequest - timeBeforeRequest);
                                if (timeLeftToWait > 0L) {
                                    MultipleCMsSyncThread.info("Will retry ping.");
                                    retry = true;
                                    try {
                                        Thread.sleep(timeLeftToWait);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                } else {
                                    checkDBActivity = true;
                                }
                            } else {
                                checkDBActivity = true;
                            }
                            if (!checkDBActivity) break block29;
                            MultipleCMsSyncThread.info("Will stop trying to ping, checking database heartbeat instead.");
                            retry = false;
                            if (this.recentHeartbeat()) {
                                MultipleCMsSyncThread.info("Active Content Manager is still able to communicate through the database.");
                                boolean bl = true;
                                return bl;
                            }
                            MultipleCMsSyncThread.info("Active Content Manager is not able to communicate through the database.");
                            this.multipleCMUtils.releaseDatabaseLock(lockConnection_, activeCMURI, false);
                            boolean bl = false;
                            return bl;
                        }
                        MultipleCMsSyncThread.info("A recent heartbeat from the active Content Manager was detected.");
                        boolean bl = true;
                        return bl;
                    }
                    MultipleCMsSyncThread.info("No recent heartbeat from the active Content Manager was detected.");
                    this.multipleCMUtils.releaseDatabaseLock(lockConnection_, activeCMURI, false);
                    boolean bl = false;
                    return bl;
                }
                if ((extime = DateUtils.getUTCTime() - timeBeforeRequest) <= AdvancedSettings.CMSYNC_PINGTIMEOUT * 2L) continue;
                CMIndications.Audit_Message("*** checkForActiveCM timeout");
            } while (retry);
            boolean bl = true;
            return bl;
        }
        finally {
            CMDbStoreFactory.releaseConnection(lockConnection_);
        }
    }

    private void shutdown() throws CMException {
        if (this.isDBLocked_) {
            CMDbConnection lockConnection_ = CMDbStoreFactory.getAdminConnection();
            try {
                this.multipleCMUtils.releaseDatabaseLock(lockConnection_, null, true);
            }
            finally {
                CMDbStoreFactory.releaseConnection(lockConnection_);
            }
            this.isDBLocked_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean negotiateActiveCM(long negotiationTime) throws CMException {
        boolean bUpdated = false;
        CMDbConnection lockConnection_ = CMDbStoreFactory.getAdminConnection();
        try {
            bUpdated = this.multipleCMUtils.updateNegotiatedActiveCM(lockConnection_, this.thisPathNoProtocol_);
            if (!bUpdated) {
                CMIndications.logException(new CMException("cmFailedNegotiate"));
                boolean bl = bUpdated;
                return bl;
            }
        }
        finally {
            CMDbStoreFactory.releaseConnection(lockConnection_);
        }
        if (ContentManager.startedSelf_) {
            return bUpdated;
        }
        try {
            Object object = this.waitOnObject_;
            synchronized (object) {
                this.waitOnObject_.wait(negotiationTime);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return bUpdated;
    }

    private boolean isCurrentActiveCMInstance() {
        boolean isCurrentActiveCMInstance = false;
        try {
            String activeCMURI = this.multipleCMUtils.getRunningContentStoreName(CMDbStoreFactory.getAdminConnection());
            if (activeCMURI != null) {
                isCurrentActiveCMInstance = this.thisDispatcherPath.contains(activeCMURI);
            }
        }
        catch (CMStoreNotAvailable e) {
            e.printStackTrace();
        }
        catch (CMException e) {
            e.printStackTrace();
        }
        return isCurrentActiveCMInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean thisIsNegotiatedCM() throws CMException {
        boolean bThisIsNegotiatedCM = false;
        CMDbConnection lockConnection_ = CMDbStoreFactory.getAdminConnection();
        try {
            String negotiatedCMURL = this.multipleCMUtils.getNegotiatedActiveCM(lockConnection_);
            bThisIsNegotiatedCM = negotiatedCMURL != null && negotiatedCMURL.equalsIgnoreCase(this.thisPathNoProtocol_);
            boolean bl = bThisIsNegotiatedCM;
            return bl;
        }
        finally {
            CMDbStoreFactory.releaseConnection(lockConnection_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequestedCMURL(CMDbConnection con) throws CMException {
        CMDbConnection lockConnection_ = con != null ? con : CMDbStoreFactory.getAdminConnection();
        try {
            String requestedCMURL;
            String string = requestedCMURL = this.multipleCMUtils.getRequestedActiveCM(lockConnection_);
            return string;
        }
        finally {
            if (con == null) {
                CMDbStoreFactory.releaseConnection(lockConnection_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean thisHasHighestCapacity() throws CMException {
        CMDbConnection lockConnection_ = CMDbStoreFactory.getAdminConnection();
        try {
            String highestCapacityCMURL = this.multipleCMUtils.getHighestCapacityCM(lockConnection_);
            if (highestCapacityCMURL == null || UrlUtils.contentManagerNamesEqual(highestCapacityCMURL, this.thisPathNoProtocol_)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            CMDbStoreFactory.releaseConnection(lockConnection_);
        }
    }

    private void removeRequestedActiveCM() throws CMException {
        CMDbConnection con = CMDbStoreFactory.getAdminConnection();
        try {
            this.multipleCMUtils.setRequestedActiveCM(con, null);
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchOver(String contentManagerURI) throws CMException {
        MultipleCMsSyncThread.info("Content Manager received a switch over request. Requested active CM: " + contentManagerURI + ".");
        if (contentManagerURI == null) {
            throw new CMException("cmFailedActivate");
        }
        if (UrlUtils.localContentManager(contentManagerURI)) {
            return;
        }
        boolean success = false;
        Object object = this.modeSyncObject_;
        synchronized (object) {
            if (this.mode_ != 1) {
                throw new CMException("cmFailedActivate");
            }
            CMDbConnection con = null;
            try {
                con = CMDbStoreFactory.getConnection();
                String path = UrlUtils.convertURItoDispatcherPath(contentManagerURI, false);
                this.multipleCMUtils.setRequestedActiveCM(con, path);
                CMConnector cmConnector = CMConnector.getConnector(contentManagerURI);
                try {
                    cmConnector.setTimeoutInMilliseconds((int)AdvancedSettings.CMSYNC_PINGTIMEOUT);
                    MultipleCMsSyncThread.info("Sending elect to Content Manager " + contentManagerURI + ".");
                    cmConnector.electNotify();
                }
                catch (CMResponseException ex) {
                    MultipleCMsSyncThread.info("Requested active Content Manager is not responding to the elect call.\n" + ex.getFullMessage());
                    throw new CMException("cmFailedActivateNotResponding", new CMException.Parm("Path", contentManagerURI));
                }
                catch (CMResponseTimeoutException ex) {
                    MultipleCMsSyncThread.info("Requested active Content Manager is not responding to the elect call.\n" + ex.getFullMessage());
                    throw new CMException("cmFailedActivateNotResponding", new CMException.Parm("Path", contentManagerURI));
                }
                this.mode_ = 3;
                success = true;
            }
            finally {
                if (con != null) {
                    if (this.mode_ != 3) {
                        MultipleCMsSyncThread.info("An error occured while trying to enter switch over mode. Removing requested Content Manager from the database.");
                        this.multipleCMUtils.setRequestedActiveCM(con, null);
                    }
                    CMDbStoreFactory.releaseConnection(con);
                }
            }
        }
        if (success) {
            long start_time = DateUtils.getUTCTime();
            String requestedCMURI = null;
            MultipleCMsSyncThread.info("Waiting for new Content Manager to become active.");
            try {
                do {
                    Thread.sleep(AdvancedSettings.CMSYNC_HEARTBEATTIME);
                    CMDbConnection con = CMDbStoreFactory.getAdminConnection();
                    requestedCMURI = this.multipleCMUtils.getRequestedActiveCM(con);
                    CMDbStoreFactory.releaseConnection(con);
                    if (DateUtils.getUTCTime() - start_time <= AdvancedSettings.CMSYNC_PINGTIMEOUT * 2L) continue;
                    CMIndications.Audit_Message("*** switchOver timeout");
                } while (requestedCMURI != null);
            }
            catch (InterruptedException con) {
            }
            catch (CMException ex) {
                MultipleCMsSyncThread.info("An exception occured while waiting for the other Content Manager to become active: \n" + ex.getFullMessage());
            }
            MultipleCMsSyncThread.info("Finished waiting for other Content Manager to become active.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSwitchOverFromThis() throws CMException {
        CMDbConnection lockConnection_ = CMDbStoreFactory.getAdminConnection();
        try {
            this.mode_ = 2;
            CMServlet.CMRunningMode_ = 2;
            if (this.isDBLocked_) {
                this.multipleCMUtils.releaseDatabaseLock(lockConnection_, null, false);
                this.isDBLocked_ = false;
            }
            initializeAsRunnable initializeRunnable = new initializeAsRunnable(this, 3, CMServlet.CMisSuspended_);
            Thread thread = new Thread(initializeRunnable);
            thread.start();
        }
        finally {
            CMDbStoreFactory.releaseConnection(lockConnection_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void negotiate() throws CMException {
        String requestedCMURL;
        boolean activeCMExists;
        CMDbConnection con;
        block29: {
            block28: {
                block27: {
                    block26: {
                        MultipleCMsSyncThread.info("A request to start the negotiation process has been received");
                        con = CMDbStoreFactory.getAdminConnection();
                        MultipleCMsSyncThread.debug("Attempting to acquire exclusive look on negotiate method.");
                        if (this.acquireNegotiateLock()) break block26;
                        MultipleCMsSyncThread.debug("Unable to aquire exclusive lock on negotiate method, returning.");
                        this.releaseNegotiateLock();
                        MultipleCMsSyncThread.debug("Released exclusive lock on the negotiate method.");
                        CMDbStoreFactory.releaseConnection(con);
                        return;
                    }
                    MultipleCMsSyncThread.debug("Successfully acuired exclusive lock on negotiate method");
                    Object object = this.modeSyncObject_;
                    // MONITORENTER : object
                    if (this.mode_ != 1) break block27;
                    // MONITOREXIT : object
                    this.releaseNegotiateLock();
                    MultipleCMsSyncThread.debug("Released exclusive lock on the negotiate method.");
                    CMDbStoreFactory.releaseConnection(con);
                    return;
                }
                // MONITOREXIT : object
                if (!CMServlet.CMisSuspended_) break block28;
                MultipleCMsSyncThread.info("This Content Manager will not participate in the negotiation process since it is suspended");
                String requestedCMURL2 = this.getRequestedCMURL(con);
                if (requestedCMURL2 != null && UrlUtils.localContentManager(requestedCMURL2)) {
                    this.multipleCMUtils.setRequestedActiveCM(con, null);
                }
                this.releaseNegotiateLock();
                MultipleCMsSyncThread.debug("Released exclusive lock on the negotiate method.");
                CMDbStoreFactory.releaseConnection(con);
                return;
            }
            activeCMExists = true;
            requestedCMURL = null;
            try {
                requestedCMURL = this.getRequestedCMURL(con);
                activeCMExists = this.checkForActiveCM(requestedCMURL == null);
            }
            catch (CMException ex) {
                this.checkForActiveRetry_ = true;
                MultipleCMsSyncThread.info("An error occured while trying to determine if there is an active Content Manager, will retry.\n" + ex.getLocalizedMessage());
                this.releaseNegotiateLock();
                MultipleCMsSyncThread.debug("Released exclusive lock on the negotiate method.");
                CMDbStoreFactory.releaseConnection(con);
                return;
            }
            Object object = this.modeSyncObject_;
            // MONITORENTER : object
            if (this.mode_ != 1) break block29;
            // MONITOREXIT : object
            this.releaseNegotiateLock();
            MultipleCMsSyncThread.debug("Released exclusive lock on the negotiate method.");
            CMDbStoreFactory.releaseConnection(con);
            return;
        }
        if (activeCMExists) {
            if (requestedCMURL == null) {
                MultipleCMsSyncThread.info("There is healthy active Content Manager no Content Manager has been requested to become active, ignoring negotiation request");
                // MONITOREXIT : object
                this.releaseNegotiateLock();
                MultipleCMsSyncThread.debug("Released exclusive lock on the negotiate method.");
                CMDbStoreFactory.releaseConnection(con);
                return;
            }
            if (UrlUtils.localContentManager(requestedCMURL)) {
                this.becomeActiveAsSuspended_ = this.multipleCMUtils.isActiveCMSuspended(con);
                this.switchoverRetry_ = true;
                MultipleCMsSyncThread.info("There is a healthy active Content Manager but this Content Manager has been request to become active, will attempt switch over");
                // MONITOREXIT : object
                this.releaseNegotiateLock();
                MultipleCMsSyncThread.debug("Released exclusive lock on the negotiate method.");
                CMDbStoreFactory.releaseConnection(con);
                return;
            }
            MultipleCMsSyncThread.info("There is healthy active Content Manager but " + requestedCMURL + " has been requested to become active");
        } else {
            MultipleCMsSyncThread.info("There is no active Content Manager");
            if (requestedCMURL == null) {
                this.becomeActiveAsSuspended_ = this.multipleCMUtils.isActiveCMSuspended(con);
                this.becomeNegotiating();
                // MONITOREXIT : object
                this.releaseNegotiateLock();
                MultipleCMsSyncThread.debug("Released exclusive lock on the negotiate method.");
                CMDbStoreFactory.releaseConnection(con);
                return;
            }
        }
        try {
            MultipleCMsSyncThread.info("Will retry getting a request Content Manager");
            if (this.checkForRequestedRetry_ == 0) {
                this.checkForRequestedRetry_ = Math.max(10, (int)(AdvancedSettings.CMSYNC_PINGTIMEOUT / AdvancedSettings.CMSYNC_HEARTBEATTIME));
            }
            // MONITOREXIT : object
            return;
        }
        finally {
            this.releaseNegotiateLock();
            MultipleCMsSyncThread.debug("Released exclusive lock on the negotiate method.");
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireNegotiateLock() {
        Object object = this.inNegotiateGuard;
        synchronized (object) {
            if (this.inNegotiate) {
                return false;
            }
            this.inNegotiate = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseNegotiateLock() {
        Object object = this.inNegotiateGuard;
        synchronized (object) {
            this.inNegotiate = false;
        }
    }

    @Override
    public void connectionBroken() {
    }

    @Override
    public void connectionInconsistent(CMStoreConnection storeConnection) {
        if (!(storeConnection instanceof CMDbConnection)) {
            return;
        }
        CMDbConnection con = (CMDbConnection)storeConnection;
        if (this.mode_ == 1) {
            this.checkConnectionInconsistentWhenActive(con);
        }
    }

    private void checkConnectionInconsistentWhenActive(CMDbConnection con) {
        if (this.mode_ == 1) {
            String activeCMURI;
            block6: {
                activeCMURI = null;
                try {
                    activeCMURI = this.multipleCMUtils.getRunningContentStoreName(con);
                }
                catch (CMException ex) {
                    if (this.cmURIs_.size() > 1 && !(ex instanceof CMStoreException) && (ex.ex_ == null || !(ex.ex_ instanceof CMStoreException))) break block6;
                    return;
                }
            }
            if (activeCMURI == null || !UrlUtils.localContentManager(activeCMURI)) {
                MultipleCMsSyncThread.info("This Content Manager is no longer listed as active in the database. Becoming standby.");
                this.becomeStandby(true, true);
                return;
            }
            MultipleCMsSyncThread.debug("This Content Manager is listed as active in the database");
            try {
                MultipleCMsSyncThread.debug("Active Content Manager will try to clear heartbeats from database.");
                this.multipleCMUtils.clearAllHeartbeats(con);
                MultipleCMsSyncThread.debug("Active Content Manager successfully cleared heartbeats from database.");
            }
            catch (CMException e) {
                MultipleCMsSyncThread.debug("An exception occured while trying to clear heartbeats form database.");
                CMIndications.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CMIsSuspended() {
        Object object = this.modeSyncObject_;
        synchronized (object) {
            if (this.mode_ != 1) {
                return;
            }
            CMDbConnection con = null;
            try {
                con = CMDbStoreFactory.getAdminConnection();
                this.multipleCMUtils.activeCMIsSuspended(con, true);
            }
            catch (CMException cMException) {
            }
            finally {
                if (con != null) {
                    CMDbStoreFactory.releaseConnection(con);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CMIsResumed() {
        Object object = this.modeSyncObject_;
        synchronized (object) {
            if (this.mode_ != 1) {
                return;
            }
            CMDbConnection con = null;
            try {
                con = CMDbStoreFactory.getAdminConnection();
                this.multipleCMUtils.activeCMIsSuspended(con, false);
            }
            catch (CMException cMException) {
            }
            finally {
                CMDbStoreFactory.releaseConnection(con);
            }
        }
    }

    private void checkCMIsStillActive() throws CMException {
        MultipleCMsSyncThread.debug("Checking if this Content Manager is still listed as active in the database.");
        CMDbConnection con = CMDbStoreFactory.getAdminConnection();
        try {
            if (this.mode_ == 1) {
                this.checkConnectionInconsistentWhenActive(con);
            }
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recentHeartbeat() throws CMException {
        boolean heartbeat = true;
        CMDbConnection con = CMDbStoreFactory.getAdminConnection();
        try {
            try {
                if (AdvancedSettings.CMSYNC_FAILOVER_DELAY_MS > 0L) {
                    Thread.sleep(AdvancedSettings.CMSYNC_FAILOVER_DELAY_MS);
                } else {
                    Thread.sleep(AdvancedSettings.CMSYNC_STANDBYWAITTIMEFORACTIVE);
                }
            }
            catch (InterruptedException e) {
                CMIndications.logException(e);
            }
            heartbeat = !this.multipleCMUtils.clearHeartbeat(con, this.thisCMURI_);
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
        return heartbeat;
    }

    private static void log(String message) {
        CMIndications.Audit_Message(message);
    }

    private static void info(String message) {
        CMIndications.CMTraceText("Trace.CM.ELECT", 20000, message);
    }

    private static void debug(String message) {
        CMIndications.CMTraceText("Trace.CM.ELECT", 10000, message);
    }

    class initializeAsRunnable
    implements Runnable {
        private MultipleCMsSyncThread syncThread_ = null;
        private int mode_ = 2;
        private boolean suspended_ = false;

        initializeAsRunnable(MultipleCMsSyncThread syncThread, int mode, boolean suspended) {
            this.syncThread_ = syncThread;
            this.mode_ = mode;
            this.suspended_ = suspended;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean retry = true;
            try {
                CMExecutionContext.setUp();
                while (retry) {
                    if (this.mode_ == 1) {
                        MultipleCMsSyncThread.info("Initializing Content Store for active mode.");
                        MultipleCMsSyncThread.this.servlet_.initializeContentStoreForActive(this.suspended_);
                    } else if (this.mode_ == 2) {
                        MultipleCMsSyncThread.info("Initializing Content Store for standby mode.");
                        MultipleCMsSyncThread.this.servlet_.initializeContentStoreForStandby(true, this.suspended_);
                    } else if (this.mode_ == 3) {
                        MultipleCMsSyncThread.info("Initializing Content Store for standby mode since a switch over is occuring.");
                        MultipleCMsSyncThread.this.servlet_.initializeContentStoreForStandby(false, this.suspended_);
                    }
                    int error = MultipleCMsSyncThread.this.servlet_.clearError();
                    if (error == 1) {
                        MultipleCMsSyncThread.info("A recoverable error occure while initializing, will retry.");
                        try {
                            Thread.sleep(AdvancedSettings.INITRETRYTIME);
                        }
                        catch (InterruptedException e) {
                            CMIndications.logException(e);
                        }
                        continue;
                    }
                    if (error == 2) {
                        MultipleCMsSyncThread.info("A non-recoverable error occure while initializing, terminating.");
                        this.syncThread_.terminate();
                    }
                    retry = false;
                }
            }
            finally {
                CMExecutionContext.tearDown();
            }
        }
    }
}

