/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.accman.CMCAMNamespace;
import com.cognos.cm.cam.AAAProvider_OpenIDProxy;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMStringArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class NamespaceManager {
    private AtomicReference<HashMap<String, CMCAMNamespace>> namespaces = new AtomicReference(new HashMap());
    private AAAProvider_OpenIDProxy oidcProxy = null;

    public CMCAMNamespace getNamespace(String id) {
        return this.namespaces.get().get(id.toLowerCase().toUpperCase());
    }

    public boolean isActiveNamespace(String id) {
        CMCAMNamespace ns = this.getNamespace(id);
        return ns != null && ns.isActive();
    }

    public void deactivateNamespace(String id) {
        CMCAMNamespace ns = this.removeNamespace(id);
        if (ns == null) {
            return;
        }
        CMCAMNamespace inactive = new CMCAMNamespace(ns.getID(), ns.getName(), false, ns.isOpenID());
        this.addNamespace(inactive);
    }

    public CMCAMNamespace getNamespaceByName(String name) {
        for (CMCAMNamespace ns : this.namespaces.get().values()) {
            if (!ns.getName().equalsIgnoreCase(name)) continue;
            return ns;
        }
        return null;
    }

    public Collection<String> listNamespaces() {
        return this.namespaces.get().values().stream().map(ns -> ns.getID()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNamespace(CMCAMNamespace ns) {
        String id = ns.getID().toLowerCase().toUpperCase();
        NamespaceManager namespaceManager = this;
        synchronized (namespaceManager) {
            HashMap<String, CMCAMNamespace> newMap;
            HashMap<String, CMCAMNamespace> oldMap;
            do {
                oldMap = this.namespaces.get();
                newMap = new HashMap<String, CMCAMNamespace>(oldMap);
                newMap.put(id, ns);
            } while (!this.namespaces.compareAndSet(oldMap, newMap));
            if (ns.isOpenID()) {
                this.configureOpenIDProviderProxy(newMap.values());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMCAMNamespace removeNamespace(String nsid) {
        CMCAMNamespace ns = null;
        String id = nsid.toLowerCase().toUpperCase();
        NamespaceManager namespaceManager = this;
        synchronized (namespaceManager) {
            HashMap<String, CMCAMNamespace> newMap;
            HashMap<String, CMCAMNamespace> oldMap;
            do {
                if ((ns = (newMap = new HashMap<String, CMCAMNamespace>(oldMap = this.namespaces.get())).remove(id)) != null) continue;
                return null;
            } while (!this.namespaces.compareAndSet(oldMap, newMap));
            if (ns.isOpenID()) {
                this.configureOpenIDProviderProxy(newMap.values());
            }
        }
        return ns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize(CMStore store, boolean switchOver) {
        ICMLockManager lockMgr = store.getLockManager();
        CMStoreQueryResults results = null;
        CMProperty capabilities = CMObjectClass.NAMESPACE.getProperty("_capabilities");
        try {
            CMStoreXPath path = new CMStoreXPath("/directory/namespace");
            CMProperty[] props = new CMProperty[]{CMProperty.ID, CMProperty.DEFAULTNAME, CMProperty.ACTIVE, capabilities};
            path.setLockManagerUsageFlag(13);
            lockMgr.requestLocks(path);
            store.beginTransaction();
            results = store.executeQuery(path, props, null, 7, 33280, null);
            while (results.next()) {
                String id = results.getValue(CMProperty.ID).toString();
                String name = results.getValue(CMProperty.DEFAULTNAME).toString();
                boolean active = switchOver ? this.getActiveValue(results) : false;
                CMStringArray caps = (CMStringArray)results.getValue(capabilities);
                CMCAMNamespace ns = new CMCAMNamespace(id, name, active, caps);
                this.addNamespace(ns);
            }
            if (!switchOver) {
                results.reset();
                store.update(results, Arrays.asList(CMProperty.ACTIVE), Arrays.asList(Boolean.FALSE));
            }
            store.commitTransaction();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            CMIndications.logException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.rollbackOpenTransaction(store);
            this.releaseLocks(lockMgr);
        }
    }

    private boolean getActiveValue(CMStoreQueryResults results) throws CMException {
        Object value = results.getValue(CMProperty.ACTIVE);
        return value != null ? "true".equals(value.toString()) : true;
    }

    private void rollbackOpenTransaction(CMStore store) {
        try {
            store.rollbackOpenTransaction();
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
    }

    private void releaseLocks(ICMLockManager lockMgr) {
        try {
            lockMgr.releaseLocks();
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
    }

    private void configureOpenIDProviderProxy(Collection<CMCAMNamespace> namespaces) {
        boolean enable = this.hasActiveOpenIdNamespaces(namespaces);
        if (enable && this.oidcProxy == null) {
            this.oidcProxy = new AAAProvider_OpenIDProxy(CMServlet.AAA);
            CMServlet.AAA = this.oidcProxy;
        }
        if (this.oidcProxy != null) {
            this.oidcProxy.enable(enable);
        }
    }

    private boolean hasActiveOpenIdNamespaces(Collection<CMCAMNamespace> namespaces) {
        for (CMCAMNamespace ns : namespaces) {
            if (!ns.isOpenID() || !ns.isActive()) continue;
            return true;
        }
        return false;
    }
}

