/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.CAMVariableExtractorPlugin;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.stax.PathParser;

public class PostProcessingPathLocator {
    private String[] pathToPlugin;
    private XMLElement doc;
    private CAMVariableExtractorPlugin plugin;

    public PostProcessingPathLocator(PathParser pathParser, XMLElement soapDoc, CAMVariableExtractorPlugin plugin) {
        this.pathToPlugin = pathParser.getSteps();
        this.doc = soapDoc;
        this.plugin = plugin;
    }

    public void parse() {
        XMLElement element = this.doc;
        int i = 0;
        if (element.name_.equals(this.pathToPlugin[i])) {
            i = 1;
        }
        while (i < this.pathToPlugin.length) {
            String elementName = this.pathToPlugin[i];
            if (element != null) {
                element = element.getOptionalChildWithName(elementName);
            }
            ++i;
        }
        if (element != null) {
            this.activatePlugin(element);
        }
    }

    private void activatePlugin(XMLElement element) {
        this.plugin.activate();
        this.passControlToPlugin(element);
        this.plugin.deactivate();
    }

    private void passControlToPlugin(XMLElement element) {
        for (XMLElement childElement : element.children_) {
            this.firePluginEvents(childElement);
        }
    }

    private void firePluginEvents(XMLElement childElement) {
        this.plugin.startElement(childElement.name_);
        if (childElement.hasChildren()) {
            this.passControlToPlugin(childElement);
        } else {
            this.plugin.text(childElement.value_);
        }
        this.plugin.endElement(childElement.name_);
    }
}

