/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.multipart.Base64;
import com.cognos.cm.multipart.RequestAttachment;
import com.cognos.cm.server.ASyncRequestManager;
import com.cognos.cm.server.AsyncRequestState;
import com.cognos.cm.util.DOMWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Request {
    public String command;
    public boolean bContinueOnError;
    public String sRelativeURI;
    public long nMaxObjects;
    public long nSkipObjects;
    public int rc;
    public HashMap<String, RequestAttachment> RequestAttachments;
    public String threadId;
    private boolean isRequestAsync = false;

    public void setIsRequestAsync(boolean b) {
        this.isRequestAsync = b;
    }

    public boolean checkIfRequestHasBeenCancelled() {
        if (!this.isRequestAsync) {
            return false;
        }
        ASyncRequestManager arm = ASyncRequestManager.getInstance();
        AsyncRequestState ars = arm.getRequestStatus(this.threadId);
        if (ars == null) {
            return true;
        }
        return AsyncRequestState.isRequestCancelled(ars.getRequestState());
    }

    public void addRequestAttachment(String name, RequestAttachment attach) {
        if (this.RequestAttachments == null) {
            this.RequestAttachments = new HashMap();
        }
        this.RequestAttachments.put(name, attach);
    }

    public Object getDataProp(Element dataProp) {
        String href = dataProp.getAttribute("href");
        String contentType = dataProp.getAttribute("contentType");
        String encoding = dataProp.getAttribute("encoding");
        if (href.length() != 0) {
            if (contentType.length() != 0 || encoding.length() != 0 || dataProp.hasChildNodes()) {
                return null;
            }
            if (href.substring(0, 4).compareToIgnoreCase("cid:") == 0) {
                return href.substring(4);
            }
        } else if (dataProp.hasChildNodes()) {
            return this.extractInlineData(dataProp, contentType, encoding);
        }
        return null;
    }

    public static String getCharacterContent(Element elem) {
        if (!elem.hasChildNodes()) {
            return null;
        }
        try {
            Node child = elem.getFirstChild();
            if (child.getNextSibling() != null || child.getNodeType() != 3) {
                return null;
            }
            return child.getNodeValue();
        }
        catch (DOMException e) {
            return null;
        }
    }

    private Object extractInlineData(Element dataProp, String contentType, String encoding) {
        if (contentType.length() == 0 || contentType.compareToIgnoreCase("text/xml") == 0) {
            contentType = "text/xml";
        }
        if (encoding.length() == 0) {
            encoding = contentType == "text/xml" ? "none" : "base64Binary";
        }
        if (encoding.compareToIgnoreCase("base64Binary") == 0 || encoding.compareToIgnoreCase("hexBinary") == 0) {
            Node dataContent = dataProp.getFirstChild();
            if (dataProp.getLastChild() != dataContent || dataContent.getNodeType() == 3) {
                // empty if block
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                if (encoding.compareToIgnoreCase("base64Binary") == 0) {
                    Base64.decode(dataContent.getNodeValue(), outputStream);
                }
                return new BlobWrapper(contentType, outputStream.toByteArray());
            }
            catch (IOException iOException) {}
        } else if (encoding.compareToIgnoreCase("none") == 0 && contentType == "text/xml") {
            NodeList nodeList = dataProp.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node curNode = nodeList.item(i);
                if (curNode.getNodeType() != 1) continue;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    DOMWriter domWriter = new DOMWriter(false, outputStream);
                    domWriter.print(curNode);
                    outputStream.close();
                    return new BlobWrapper(contentType, outputStream.toByteArray());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public class BlobWrapper {
        public String contentType_;
        public byte[] data_;

        public BlobWrapper(String cType, byte[] data) {
            this.contentType_ = cType;
            this.data_ = data;
        }
    }
}

