/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.store.CMStore;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class RequestHandlerFactory {
    private static Map packageBases_ = new HashMap();

    public RequestHandler getNewHandler(CMStore store, String sNamespace, String sName) throws CMException {
        RequestHandler rh = null;
        Class<?> cls = null;
        String sClassName = packageBases_.get(sNamespace) + sName;
        try {
            cls = Class.forName(sClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (cls == null) {
            try {
                sClassName = sClassName + "Request";
                cls = Class.forName(sClassName);
            }
            catch (ClassNotFoundException e) {
                throw new CMException((Exception)e, "cmUnknownRequest", new CMException.Parm("Name", sName));
            }
        }
        if (cls == null) {
            throw new CMException("cmUnknownRequest", new CMException.Parm("Name", sName));
        }
        try {
            Class[] paramTypes = new Class[]{CMStore.class};
            Constructor<?> c = cls.getConstructor(paramTypes);
            Object[] args = new Object[]{store};
            rh = (RequestHandler)c.newInstance(args);
        }
        catch (Exception e) {
            throw new CMException(e, "cmBadRequest");
        }
        if (rh != null) {
            rh.init();
            return rh;
        }
        throw new CMException("cmUnknownRequest", new CMException.Parm("Name", sName));
    }

    private static void addPackageBase(String namespaceURI, String packageBase) {
        packageBases_.put(namespaceURI, packageBase);
    }

    static {
        RequestHandlerFactory.addPackageBase("http://developer.cognos.com/schemas/bibus/3/", "com.cognos.cm.request.");
        RequestHandlerFactory.addPackageBase("http://developer.cognos.com/schemas/contentManagerService/1", "com.cognos.cm.request.contentManagerService.v1.");
    }
}

