/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreAddResults;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.multitenancy.TenantIdCopyAction;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.request.delete;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMTempOutputStream;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public abstract class RequestHandlerWithTarget
extends RequestHandler {
    public static final int ACTION_REPLACE = 1;
    public static final int ACTION_FAIL = 2;
    public static final int ACTION_UPDATE = 3;
    protected CMObjectClass targetClass_;
    protected int targetTenantId_;
    protected String sTargetPath_;
    protected String sTargetSearchPath_;
    protected boolean targetInCognosNamespace_;
    protected int targetObjectID_;
    protected CMIntList copiedObjectIDs_;
    protected CMIntList returnObjectIDs_;

    public RequestHandlerWithTarget(CMStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTarget(CMStorePath targetContext) throws CMException, CMStoreObjectNotFound {
        block6: {
            this.targetObjectID_ = -1;
            CMStoreQueryResults resultsTarget = null;
            CMStore store = CMExecutionContext.get().getStore();
            resultsTarget = store.executeQuery(targetContext, null, null, 5, 130, null);
            try {
                if (resultsTarget.next()) {
                    this.targetObjectID_ = resultsTarget.getObjectID();
                    this.targetTenantId_ = resultsTarget.getTenantID();
                    this.targetClass_ = resultsTarget.getObjectClass();
                    this.sTargetPath_ = resultsTarget.getPath();
                    this.sTargetSearchPath_ = resultsTarget.getSearchPath();
                    this.targetInCognosNamespace_ = store.objectInCognosNamespace(this.targetObjectID_);
                    if (resultsTarget.next()) {
                        throw new CMException("cmBadTargetSelectionMany", new CMException.Parm("Path", CMQueryUtils.getPath(this.store_, targetContext)));
                    }
                    break block6;
                }
                throw new CMException("cmBadTargetNotFound", new CMException.Parm("Path", CMQueryUtils.getPath(this.store_, targetContext)));
            }
            finally {
                if (resultsTarget != null) {
                    resultsTarget.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTargetOverwrite(CMStore store, CMStoreQueryResults resultsSrc, CMStorePath srcPath, String newName) throws CMException {
        if (resultsSrc.getParentObjectID() == this.targetObjectID_ && !this.targetClass_.isMaxOccursPerTenant(resultsSrc.getObjectClass())) {
            if (newName == null) {
                throw new CMException("cmBadCopyTargetOverwrite", new CMException.Parm("Path", CMQueryUtils.getPath(store, srcPath)));
            }
            String targetObjectSearchPath = this.sTargetSearchPath_ + "/*[@name=" + CMStoreXPath.attributeQuoteString(newName) + "]";
            CMStoreQueryResults resultsTargetObject = null;
            try {
                resultsTargetObject = store.executeQuery(new CMStoreXPath(targetObjectSearchPath), null, null, 0, 512, null);
                if (resultsTargetObject.next() && resultsTargetObject.getObjectID() == resultsSrc.getObjectID()) {
                    throw new CMException("cmBadCopyTargetOverwrite", new CMException.Parm("Path", CMQueryUtils.getPath(store, srcPath)));
                }
            }
            finally {
                if (resultsTargetObject != null) {
                    resultsTargetObject.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CMStoreQueryResults copy(CMStoreQueryResults srcObjects, int targetObjectID, String newName, boolean recursive, boolean clearInvalidReferences, int action, int perm, List<String> permissions, CMIntList sourceIds, CMIntList targetIds, CMIntList correctOwnerIds, TenantIdCopyAction copyAction) throws CMException {
        CMStore store;
        boolean bReturnResults;
        block14: {
            if (action != 3) {
                throw new IllegalArgumentException("Unsupported action: " + action);
            }
            bReturnResults = false;
            if (this.returnObjectIDs_ == null) {
                this.returnObjectIDs_ = new CMIntList();
                bReturnResults = true;
            }
            store = CMExecutionContext.get().getStore();
            try {
                if (srcObjects == null) break block14;
                while (srcObjects.next()) {
                    if (this.copiedObjectIDs_ == null) {
                        this.copiedObjectIDs_ = new CMIntList();
                    }
                    boolean copyDescendants = this.copyOrUpdateObject(store, srcObjects, targetObjectID, newName, recursive, perm, permissions, sourceIds, targetIds, correctOwnerIds, copyAction);
                    if (this.copiedObjectIDs_.size() <= 0) continue;
                    if (recursive && copyDescendants) {
                        String childSrcPath = srcObjects.getSearchPath() + "/*";
                        int childTargetObjectID = this.copiedObjectIDs_.get(this.copiedObjectIDs_.size() - 1);
                        CMStoreQueryResults childResults = null;
                        CMStoreQueryResults copyResults = null;
                        try {
                            childResults = store.executeQuery(new CMStoreXPath(childSrcPath), null, null, 3, perm, permissions);
                            copyResults = this.copy(childResults, childTargetObjectID, null, true, clearInvalidReferences, action, perm, permissions, sourceIds, targetIds, correctOwnerIds, copyAction);
                        }
                        catch (Throwable throwable) {
                            CMQueryUtils.safeQueryResultsRelease(copyResults);
                            CMQueryUtils.safeQueryResultsRelease(childResults);
                            throw throwable;
                        }
                        CMQueryUtils.safeQueryResultsRelease(copyResults);
                        CMQueryUtils.safeQueryResultsRelease(childResults);
                    }
                    if (!bReturnResults) continue;
                    int rootTargetObjectID = this.copiedObjectIDs_.get(0);
                    this.returnObjectIDs_.add(rootTargetObjectID);
                    if (recursive) {
                        this.deleteUnmodifiedDescendants(store, rootTargetObjectID, perm, clearInvalidReferences);
                    }
                    this.copiedObjectIDs_ = null;
                }
            }
            finally {
                if (srcObjects != null) {
                    srcObjects.release();
                }
            }
        }
        if (bReturnResults && this.returnObjectIDs_.size() > 0) {
            int[] returnids = this.returnObjectIDs_.toArray();
            this.returnObjectIDs_ = null;
            if (CMDbConnection.dbms_ == 8) {
                return new CMDbStoreAddResults((CMDbStore)store, returnids);
            }
            return store.executeQuery(returnids, new CMProperty[]{CMProperty.DEFAULTNAME, CMProperty.OBJECTCLASS}, null, 0, perm, permissions);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyOrUpdateObject(CMStore store, CMStoreQueryResults srcObject, int targetObjectID, String newName, boolean recursive, int perm, List<String> permissions, CMIntList sourceIds, CMIntList targetIds, CMIntList correctOwnerIds, TenantIdCopyAction copyAction) throws CMException {
        boolean copyDescendants = recursive;
        CMObjectClass srcObjectClass = srcObject.getObjectClass();
        if (srcObjectClass.isExternal() && !store.objectInCognosNamespace(srcObject.getObjectID()) || srcObjectClass == CMObjectClass.SCHEDULE || srcObjectClass == CMObjectClass.HISTORY) {
            return false;
        }
        String name = newName;
        if (name == null) {
            name = srcObject.getName();
        }
        String targetSearchPathStr = store.getObjectSearchPath(targetObjectID) + "/*[@name=" + CMStoreXPath.attributeQuoteString(name) + "]";
        CMStoreXPath targetSearchPath = new CMStoreXPath(targetSearchPathStr, 17);
        targetSearchPath.setLocksHaveBeenObtained();
        CMStoreQueryResults updateQuery = null;
        try {
            updateQuery = store.executeQuery(targetSearchPath, null, null, 7, 6, null);
            if (updateQuery != null && updateQuery.next()) {
                int tenantIdToBeUsed = copyAction instanceof TenantIdCopyAction.SetTargetTenantId ? ((TenantIdCopyAction.SetTargetTenantId)copyAction).getTargetTenantId() : srcObject.getTenantID();
                if (tenantIdToBeUsed != updateQuery.getTenantID()) {
                    throw new CMException("cmOperationWithUpdateInvalidTenant", new CMException.Parm("operation", this.getOperationName()));
                }
                this.updateObject(store, srcObject, updateQuery, newName, permissions, sourceIds, targetIds);
            } else {
                this.copyObject(store, srcObject, targetObjectID, newName, recursive, perm, permissions, sourceIds, targetIds, correctOwnerIds, copyAction);
                copyDescendants = false;
            }
        }
        finally {
            if (updateQuery != null) {
                updateQuery.release();
            }
        }
        return copyDescendants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyObject(CMStore store, CMStoreQueryResults srcObject, int targetObjectID, String newName, boolean recursive, int perm, List<String> permissions, CMIntList sourceIds, CMIntList targetIds, CMIntList correctOwnerIds, TenantIdCopyAction copyAction) throws CMException {
        CMStoreQueryResults srcQuery = null;
        CMStoreQueryResults copyResults = null;
        try {
            srcQuery = store.executeQuery(new CMStoreXPath(srcObject.getSearchPath()), null, null, 3, perm, permissions);
            if (srcQuery != null && (copyResults = store.copy(srcQuery, 1, targetObjectID, newName, recursive, sourceIds, targetIds, correctOwnerIds, copyAction)) != null) {
                while (copyResults.next()) {
                    this.copiedObjectIDs_.add(copyResults.getObjectID());
                }
            }
        }
        finally {
            if (copyResults != null) {
                copyResults.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObject(CMStore store, CMStoreQueryResults srcObject, CMStoreQueryResults targetObject, String newName, List<String> permissions, CMIntList sourceIds, CMIntList targetIds) throws CMException {
        block45: {
            CMObjectClass srcObjectClass = srcObject.getObjectClass();
            if (srcObjectClass != targetObject.getObjectClass()) {
                throw new CMException("cmCopyWithUpdateFailedBadClass", new CMException.Parm("ClassTarget", targetObject.getObjectClass().getName()), new CMException.Parm("ClassNew", srcObjectClass.getName()), new CMException.Parm("Path", targetObject.getSearchPath()));
            }
            CMStoreQueryResults srcQuery = null;
            CMTempOutputStream tempOutStream = null;
            ArrayList<InputStream> tempInStreams = null;
            ArrayList<CMTempOutputStream> tempOutStreams = null;
            CMProperty[] properties = srcObjectClass.getPropertiesForCopy();
            if (properties != null) {
                try {
                    srcQuery = store.executeQuery(new CMStoreXPath(srcObject.getSearchPath()), properties, null, 0, 1, permissions);
                    if (srcQuery == null || !srcQuery.next()) break block45;
                    int sourceId = srcQuery.getObjectID();
                    ArrayList<CMProperty> updateProps = new ArrayList<CMProperty>();
                    ArrayList<Object> updateValues = new ArrayList<Object>();
                    for (int i = 0; i < properties.length; ++i) {
                        CMProperty property = properties[i];
                        if (property == CMProperty.STOREID || property.isStoreIDBased() && property != CMProperty.OWNER || newName != null && property == CMProperty.NAME) continue;
                        Object value = srcQuery.getValue(i);
                        if (srcQuery.wasAcquired()) continue;
                        if (value != null) {
                            if (value instanceof CMDbStoreString) {
                                value = value.toString();
                            } else {
                                if (value instanceof Reader) {
                                    Reader reader = (Reader)value;
                                    try {
                                        value = CMStreamUtils.readReaderIntoString((Reader)reader);
                                    }
                                    catch (IOException e) {
                                        throw new CMException(e, "cmCopyWithUpdateFailedUnexpected");
                                    }
                                    finally {
                                        try {
                                            reader.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                                if (value instanceof InputStream) {
                                    try {
                                        try {
                                            tempOutStream = new CMTempOutputStream();
                                            CMStreamUtils.copyStream((InputStream)((InputStream)value), (OutputStream)tempOutStream);
                                        }
                                        finally {
                                            if (tempOutStream != null) {
                                                try {
                                                    tempOutStream.close();
                                                }
                                                catch (IOException reader) {}
                                            }
                                        }
                                        value = tempOutStream.getInputStream();
                                        if (tempInStreams == null) {
                                            tempInStreams = new ArrayList<InputStream>();
                                            tempOutStreams = new ArrayList<CMTempOutputStream>();
                                        }
                                        tempInStreams.add((InputStream)value);
                                        tempOutStreams.add(tempOutStream);
                                    }
                                    catch (IOException e) {
                                        if (tempOutStream != null) {
                                            try {
                                                tempOutStream.delete();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                        throw new CMException(e, "cmCopyWithUpdateFailedUnexpected");
                                    }
                                }
                            }
                        }
                        updateProps.add(property);
                        updateValues.add(value);
                    }
                    store.update(targetObject, updateProps, updateValues);
                    int targetId = targetObject.getObjectID();
                    this.copiedObjectIDs_.add(targetId);
                    sourceIds.add(sourceId);
                    targetIds.add(targetId);
                }
                finally {
                    if (srcQuery != null) {
                        srcQuery.release();
                    }
                    if (tempInStreams != null) {
                        for (int i = 0; i < tempInStreams.size(); ++i) {
                            InputStream is = (InputStream)tempInStreams.get(i);
                            CMTempOutputStream os = (CMTempOutputStream)tempOutStreams.get(i);
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                            try {
                                os.delete();
                                continue;
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUnmodifiedDescendants(CMStore store, int rootTargetObjectID, int perm, boolean clearInvalidReferences) throws CMException {
        String storeID = store.getObjectStoreID(rootTargetObjectID);
        CMStoreXPath rootTargetPath = new CMStoreXPath(CMStoreXPath.encodeStoreIdToPathString(storeID) + "//*");
        CMStoreQueryResults targetDescendantResults = null;
        CMIntList deletionObjectIDs = new CMIntList();
        CMIntList parentObjectIDs = new CMIntList();
        try {
            targetDescendantResults = store.executeQuery(rootTargetPath, null, null, 0, 130, null);
            if (targetDescendantResults != null) {
                while (targetDescendantResults.next()) {
                    int targetObjectID;
                    if (targetDescendantResults.getObjectClass() == CMObjectClass.SCHEDULE || this.copiedObjectIDs_.contains(targetObjectID = targetDescendantResults.getObjectID())) continue;
                    deletionObjectIDs.add(targetObjectID);
                    parentObjectIDs.add(targetDescendantResults.getParentObjectID());
                }
            }
        }
        finally {
            if (targetDescendantResults != null) {
                targetDescendantResults.release();
            }
        }
        if (deletionObjectIDs.size() > 0) {
            int i;
            CMIntList rootDeletionObjectIDs = new CMIntList();
            for (i = 0; i < deletionObjectIDs.size(); ++i) {
                if (deletionObjectIDs.contains(parentObjectIDs.get(i))) continue;
                rootDeletionObjectIDs.add(deletionObjectIDs.get(i));
            }
            for (i = 0; i < rootDeletionObjectIDs.size(); ++i) {
                int objectID = rootDeletionObjectIDs.get(i);
                delete.deleteDescendants(store, store.getObjectSearchPath(objectID), perm, clearInvalidReferences);
            }
        }
    }

    protected void deleteConflictingObjects(CMStore store, String name, String objectPath, boolean clearInvalidReferences) throws CMException {
        StringBuffer pathBuf = new StringBuffer(this.sTargetSearchPath_);
        pathBuf.append("/*[@name=");
        pathBuf.append(CMStoreXPath.attributeQuoteString(name));
        pathBuf.append("]");
        CMStoreXPath conflictingPath = new CMStoreXPath(pathBuf.toString());
        CMStoreXPath srcPath = new CMStoreXPath(objectPath);
        if (store.isDescendantOrSelf(srcPath, conflictingPath)) {
            throw new CMException("cmCopyOverAncestor", new CMException.Parm("Path", CMQueryUtils.getPath(store, srcPath)));
        }
        delete.deleteDescendants(store, conflictingPath, 10, clearInvalidReferences);
    }

    @Override
    public boolean handle(IConfiguration config_, Request r) throws CMException {
        return false;
    }

    @Override
    public void validate(IConfiguration c, Request r) throws CMException {
    }

    protected abstract String getOperationName();
}

