/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.CAM.AAAException;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.cam.AAAProvider;
import com.cognos.cm.cmInfo;
import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.constants.PortalOptionEnum;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePairArray;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.DiagnosticsContext;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.indications.CMSessionLogging;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.multipart.MultipartParser;
import com.cognos.cm.multipart.RequestAttachment;
import com.cognos.cm.multipart.RequestByteArrayAttachment;
import com.cognos.cm.multipart.RequestFileAttachment;
import com.cognos.cm.multipart.ResponseAttachment;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.properties.CMPropertySets;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.properties.CMStringNameValuePair;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.request.add;
import com.cognos.cm.request.logoff;
import com.cognos.cm.request.logon;
import com.cognos.cm.request.update;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AccountTemplates;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.Bridge;
import com.cognos.cm.server.BridgeImpl;
import com.cognos.cm.server.BytesCounter;
import com.cognos.cm.server.CAMParsingPlugin;
import com.cognos.cm.server.CMBreadcrumbs;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.CamAction;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.DatabaseConfigInfo;
import com.cognos.cm.server.ExtendedUserCapabilities;
import com.cognos.cm.server.Header;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.LicenseManager;
import com.cognos.cm.server.LimitedInputStream;
import com.cognos.cm.server.ParsingPlugin;
import com.cognos.cm.server.Request;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.RequestHandlerFactory;
import com.cognos.cm.server.RequestManagerStaxParser;
import com.cognos.cm.server.SAXAttributes;
import com.cognos.cm.server.SOAPHeader;
import com.cognos.cm.server.UserPreferences;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMCacheCAMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.support.axis.AxisRequestHandler;
import com.cognos.cm.trustedServices.trustedService;
import com.cognos.cm.util.CMBuildVersion;
import com.cognos.cm.util.CMNamespacePrefixes;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cm.util.ICMQueryUtils;
import com.cognos.cm.util.RequestPasswordRemover;
import com.cognos.cm.util.io.CountingOutputStream;
import com.cognos.cmutils.url.CMURLEncoder;
import com.cognos.cmutils.xml.XMLUtils;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.PerfTimer;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.util.NameValuePair;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RequestManager
implements Cloneable {
    public static final Counter requestSizeCounter = new AccumulatingCounter().makeThreadLocal();
    public static final Counter responseSizeCounter = new AccumulatingCounter().makeThreadLocal();
    public static final Counter BridgeTimeCounter = new AccumulatingCounter().makeThreadLocal();
    private static final Timer inBridge = new Timer(BridgeTimeCounter);
    public boolean bCurrentSOAPMessageAuthenticated;
    public String providerName_;
    public String providerPatch_;
    private final RequestHandlerFactory handlerFactory_;
    private InputStream inputStream_;
    private BytesCounter inputBytesCounter;
    private ByteArrayOutputStream baOutputStream_;
    private OutputStreamWriter baOutputStreamWriter_;
    private PrintWriter baOutputStreamPrinter_;
    private ByteArrayOutputStream baInterimOutputStream_;
    private CountingOutputStream responseos_;
    private boolean bHasFaulted_;
    private boolean bFaultIsServer_;
    private boolean bRequestSuccessful_;
    private boolean internalRequest;
    private boolean bWSDLCAMRequest_;
    private boolean loggedRequest_;
    private boolean bRequestFromTool_;
    private String sProcessAxisValidation_ = null;
    public String strIndicationsStatus_ = "Success";
    private IConfiguration config_;
    protected HashMap<String, RequestAttachment> requestAttachments_ = new HashMap();
    private ArrayList<ResponseAttachment> responseAttachments_;
    private CMNamespacePrefixes nsPrefixes = new CMNamespacePrefixes();
    private static boolean bCheckPolicies_ = true;
    private static boolean bUseAccMan_ = true;
    private boolean bNeedToWriteSOAPRespBegin_ = true;
    private boolean bNeedToWriteSOAPRespEnd_ = true;
    private static boolean bConfigLoaded_;
    private static boolean g_bFileLogRequestSoap_;
    private static boolean g_bFileLogRequestSoap_UserOnly_;
    private static OutputStreamWriter g_fwLogRequestSoap_;
    public static long nMaxRequestSize;
    public static long nAvgRequestSize;
    public static long nNumRequests;
    private byte[] fullSoapRequest_;
    private String requestEncoding_ = "UTF-8";
    private HttpServletRequest servletRequest_;
    private static final String USERCAPABILITIESEX_COOKIE = "userCapabilitiesEx";
    private static final String sEOL = "\r\n";
    private static final String sSOAPBIBusEmpty;
    private static final byte[] baSOAPBIBusEmpty;
    private static final String sSOAPBIBusBegin_Seg1;
    private static final byte[] baSOAPBIBusBegin_Seg1;
    private static final String sSOAPBIBusBegin_Seg2 = "\"\r\n";
    private static final byte[] baSOAPBIBusBegin_Seg2;
    private static final String sSOAPBIBusBegin_Seg3;
    private static final byte[] baSOAPBIBusBegin_Seg3;
    private static final String sSOAPBIBusBegin_Seg4;
    private static final byte[] baSOAPBIBusBegin_Seg4;
    private static final String sSOAPBIBusBegin_Seg5;
    private static final byte[] baSOAPBIBusBegin_Seg5;
    private static final String sSOAPBIBusBegin_Seg6 = "  \t</bus:biBusHeader>\r\n";
    private static final byte[] baSOAPBIBusBegin_Seg6;
    private static final String sSOAPBIBusEnd_Seg1 = "  </SOAP-ENV:Header>\r\n  <SOAP-ENV:Body>\r\n";
    private static final byte[] baSOAPBIBusEnd_Seg1;
    private static final String sSOAPBIBusEnd_Seg2_Server;
    private static final byte[] baSOAPBIBusEnd_Seg2_Server;
    private static final String sSOAPBIBusEnd_Seg3_Client;
    private static final byte[] baSOAPBIBusEnd_Seg3_Client;
    private static final String sSOAPRespEnd_Seg1 = "\t</detail>\r\n  </SOAP-ENV:Fault>\r\n";
    private static final byte[] baSOAPRespEnd_Seg1;
    private static final String sSOAPRespEnd_Seg2 = "  </SOAP-ENV:Body>\r\n</SOAP-ENV:Envelope>\r\n";
    private static final byte[] baSOAPRespEnd_Seg2;
    private boolean bDoNotLogLevel3Audit_ = false;
    private ParsingPlugin camParsingAction;
    private static Bridge bridgeHandler;
    private String requestSoapAction;
    private String currCommand_;
    private Request currRequest_;
    private RequestHandler currHandler_;
    private long startTime_ = 0L;
    private long startRequestSystemMillis_ = 0L;
    private String CRNCookieMaxAge = "0";
    public CamAction camAction;
    private boolean bThereWasACAMElement_;
    public boolean bThisIsATrustedProcess_;
    private boolean bThereWasACAMCredientialElement_;
    private boolean bPassportHasBeenSet_;
    private boolean bPassportIDHasChanged_ = false;
    private boolean bCAMIsValidate_;
    private boolean NoCAMRequired_;
    private final UserPreferences userPreferences_ = new UserPreferences();
    private final UserPreferences origUserPreferences_ = new UserPreferences();
    private boolean bSetCookiesAndPrefs_ = true;
    private boolean bInBody_;
    private String strSOAPURI_ = new String("x");
    private XMLDoc xmlRequestDoc_;
    private SOAPHeader biBusHeader = new SOAPHeader();
    private XMLElement origBiBusHeaderElem_;
    private int iLockWait_ = 0;
    protected ICMQueryUtils queryUtils = new CMQueryUtils();
    private static final long maxLockWaitSleep_ = 30000L;

    protected static Bridge getBridgeHandler() {
        return new BridgeImpl();
    }

    protected static void setBridgeHandler(Bridge bridgeHandler) {
        RequestManager.bridgeHandler = bridgeHandler;
    }

    public static void Initialize() {
        bridgeHandler = RequestManager.getBridgeHandler();
        RequestManager.loadConfig();
        RequestManager.initRequestLogging();
    }

    public Object clone() {
        try {
            RequestManager reqMgr = (RequestManager)super.clone();
            return reqMgr;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void GetInputStream(HttpServletRequest request) throws IOException {
        ServletInputStream inStream = request.getInputStream();
        int len = request.getContentLength();
        LimitedInputStream limitedInStream = new LimitedInputStream((InputStream)inStream, len > 0 ? Math.min(AdvancedSettings.MULTIPARTREQUESTMAXLENGTH, (long)(len + 100)) : AdvancedSettings.MULTIPARTREQUESTMAXLENGTH);
        this.inputBytesCounter = limitedInStream;
        this.inputStream_ = AdvancedSettings.HTTP_SERVLET_REQUEST_BUFFER > 0 ? new BufferedInputStream(limitedInStream, AdvancedSettings.HTTP_SERVLET_REQUEST_BUFFER) : limitedInStream;
    }

    private static final OutputStreamWriter getUTF8OutputStreamWriter(OutputStream outStream) {
        try {
            return new OutputStreamWriter(outStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private void setNewOutputStream() {
        this.baOutputStream_ = new ByteArrayOutputStream();
        this.baOutputStreamWriter_ = RequestManager.getUTF8OutputStreamWriter(this.baOutputStream_);
        this.baOutputStreamPrinter_ = new PrintWriter(this.baOutputStreamWriter_);
    }

    private void flushOutputStream() {
        try {
            this.baOutputStreamPrinter_.flush();
            this.baOutputStreamWriter_.flush();
            this.baOutputStream_.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeToPrinter(PrintWriter prt, String s) {
        prt.write(s);
        prt.flush();
    }

    public RequestManager(RequestHandlerFactory handlerFactory, IConfiguration config_2) {
        this.config_ = config_2;
        this.handlerFactory_ = handlerFactory;
    }

    public boolean successful() {
        return this.bRequestSuccessful_;
    }

    public boolean faulted() {
        return this.bHasFaulted_;
    }

    private boolean logLevel3StartStop() {
        boolean bRet = false;
        if (CMIndicationGlobals.bRequestManager_SomeAuditLevel3Enabled) {
            String sIPFCategory = CMExecutionContext.get().getIPFCategory();
            bRet = CMIndications.logEnabled(sIPFCategory, 30000) && !this.isInternalRequest();
        }
        return bRet;
    }

    private void warnIfLongRunningRequest(String op, long nTimeInMilliseconds) {
        if (nTimeInMilliseconds > (long)AdvancedSettings.CMREQUEST_PERFALARM_THRESHOLD) {
            CMExecutionContext exec = CMExecutionContext.get();
            if (exec.getExecutionTime() < 0L) {
                return;
            }
            if (exec.isThreadInfoLogged()) {
                return;
            }
            if (!AdvancedSettings.CMREQUEST_PERFALARM_ENABLE_ALL_REQUESTS && (op == null || op.equals("DELETE") || op.equals("EXPORT") || op.equals("IMPORT") || op.equals("WAIT") || op.equals("PING"))) {
                return;
            }
            CMException ex = new CMException("cmLongRunningRequest", new CMException.Parm("Value", new Long(nTimeInMilliseconds / 1000L).toString()));
            exec.getBreadcrumbs().dump(ex);
        }
    }

    private void initForNewRequest(OutputStream os) {
        this.bCurrentSOAPMessageAuthenticated = false;
        if (this.requestAttachments_ == null) {
            this.requestAttachments_ = new HashMap();
        } else {
            this.requestAttachments_.clear();
        }
        if (this.responseAttachments_ == null) {
            this.responseAttachments_ = new ArrayList();
        } else {
            this.responseAttachments_.clear();
        }
        this.responseos_ = new CountingOutputStream(os);
        this.setNewOutputStream();
        this.baInterimOutputStream_ = new ByteArrayOutputStream(8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest request, HttpServletResponse response, long startRequestSystemMillis) {
        block53: {
            this.startTime_ = System.currentTimeMillis();
            this.startRequestSystemMillis_ = startRequestSystemMillis;
            this.servletRequest_ = request;
            if (this.servletRequest_.getHeader("X-Cognos-ContentManager-ToolRequest") != null) {
                this.bRequestFromTool_ = true;
            }
            this.sProcessAxisValidation_ = this.servletRequest_.getHeader("X-Cognos-ContentManager-AxisValidation");
            CMExecutionContext cmexCtx = CMExecutionContext.get();
            CMBreadcrumbs breadcrumbs = CMExecutionContext.get().getBreadcrumbs();
            breadcrumbs.add(CMExecutionContext.class, cmexCtx);
            this.bRequestSuccessful_ = false;
            try {
                String sSoapAction;
                String type = null;
                String type1 = request.getHeader("Content-Type");
                String type2 = request.getContentType();
                this.requestSoapAction = sSoapAction = request.getHeader("SOAPAction");
                boolean bIsMulti = false;
                try {
                    this.initForNewRequest((OutputStream)response.getOutputStream());
                }
                catch (IOException e) {
                    response.setStatus(500);
                    this.updateRequestStatus();
                    cmexCtx.release();
                    this.fullSoapRequest_ = null;
                    breadcrumbs.remove(CMExecutionContext.class);
                    this.deleteTemporaryRequestAttachments();
                    this.updateResponseSizeCounter();
                    return;
                }
                try {
                    if (type1 == null && type2 != null) {
                        type = type2;
                    } else if (type2 == null && type1 != null) {
                        type = type1;
                    } else if (type1 != null && type2 != null) {
                        String string = type = type1.length() > type2.length() ? type1 : type2;
                    }
                    if (type == null) {
                        throw new CMException("cmIOMissingContentType");
                    }
                    bIsMulti = false;
                    if (type.toLowerCase().startsWith("multipart/related")) {
                        bIsMulti = true;
                    } else if (!type.toLowerCase().startsWith("text/xml")) {
                        CMIndications.CMTrace("cmErrBadContentType", new CMException.Parm("Type", type));
                    }
                    if (sSoapAction == null) {
                        CMIndications.CMTrace("cmErrMissingSoapAction");
                    }
                    this.GetInputStream(request);
                }
                catch (Throwable e) {
                    this.handleThrowable(e, response);
                    this.updateRequestStatus();
                    cmexCtx.release();
                    this.fullSoapRequest_ = null;
                    breadcrumbs.remove(CMExecutionContext.class);
                    this.deleteTemporaryRequestAttachments();
                    this.updateResponseSizeCounter();
                    return;
                }
                try {
                    if (!bIsMulti) {
                        int read;
                        int requestSize = request.getContentLength();
                        if (requestSize <= 0) {
                            requestSize = 32768;
                        }
                        ByteArrayOutputStream outBytes = new ByteArrayOutputStream(requestSize);
                        byte[] buf = new byte[32768];
                        while ((read = this.inputStream_.read(buf)) != -1) {
                            outBytes.write(buf, 0, read);
                        }
                        buf = null;
                        this.fullSoapRequest_ = outBytes.toByteArray();
                        if (this.fullSoapRequest_ == null || this.fullSoapRequest_.length < 2) {
                            CMIndications.CMTrace("cmEmptyRequest");
                            throw new SAXException("no request", new CMException("cmEmptyRequest"));
                        }
                        int theRequestSize = this.fullSoapRequest_.length;
                        if ((long)theRequestSize > nMaxRequestSize) {
                            nMaxRequestSize = theRequestSize;
                        }
                        outBytes = null;
                        this.requestEncoding_ = request.getCharacterEncoding();
                        if (this.requestEncoding_ == null) {
                            this.requestEncoding_ = "utf-8";
                        }
                        this.executeTheRequest(new ByteArrayInputStream(this.fullSoapRequest_));
                    } else {
                        this.handleMultiPart(request, response);
                    }
                    this.bRequestSuccessful_ = true;
                }
                catch (IOException e) {
                    this.writeFault(e);
                    response.setStatus(500);
                }
                catch (SAXException e) {
                    Exception saxE = e.getException();
                    if (saxE != null) {
                        if (saxE instanceof CMException) {
                            this.handleCMException((CMException)saxE, response);
                        } else {
                            this.writeFault(saxE);
                            response.setStatus(500);
                        }
                    } else {
                        this.writeFault(e);
                        response.setStatus(500);
                    }
                }
                catch (CMException cme) {
                    this.handleCMException(cme, response);
                }
                catch (Throwable e) {
                    Throwable ex;
                    if (e.getCause() instanceof CMException) {
                        ex = (CMException)e.getCause();
                        this.handleCMException((CMException)ex, response);
                    } else if (e.getCause() instanceof AAAException) {
                        ex = (AAAException)e.getCause();
                        CMException cmex = new CMException((Exception)ex, "cmNameSpaceQueryErr");
                        this.handleCMException(cmex, response);
                    } else {
                        this.writeFault(e);
                        response.setStatus(500);
                    }
                }
                finally {
                    String step;
                    this.updateRequestSizeCounter();
                    ZipiTimer zipiTimer = ZipiFactory.getCurrentTimer();
                    if (zipiTimer != null && (step = zipiTimer.getCurrentStep()) != null) {
                        response.addHeader("zipi.step", step);
                    }
                }
                this.writeSOAPRespEnd();
                try {
                    if (this.responseAttachments_.size() > 0) {
                        String boundary = new String();
                        StringBuffer s = new StringBuffer();
                        s.append(boundary.hashCode()).append('_').append(System.currentTimeMillis());
                        boundary = "COGNOS_CM_MIME_boundary" + ResponseAttachment.GenerateCID();
                        PrintWriter psout = new PrintWriter(new OutputStreamWriter((OutputStream)this.responseos_, "UTF-8"));
                        StringBuffer contenttype = new StringBuffer(2048);
                        contenttype.append("Multipart/Related; boundary=\"");
                        contenttype.append(boundary);
                        contenttype.append("\"; type=\"text/xml\"; start=\"<");
                        String soapcid = ResponseAttachment.GenerateCID();
                        contenttype.append(soapcid);
                        contenttype.append(">\"");
                        response.setContentType(contenttype.toString());
                        boundary = "--" + boundary;
                        psout.print(boundary);
                        psout.print(sEOL);
                        psout.flush();
                        this.writeSOAPResponse(response, soapcid, psout);
                        for (ResponseAttachment attachment : this.responseAttachments_) {
                            psout.print(sEOL);
                            psout.print(boundary);
                            psout.print(sEOL);
                            psout.flush();
                            attachment.write(this.responseos_);
                            if (CMIndicationGlobals.bRequestManager_TraceResponseSoap) {
                                StringWriter MIMEHeaderStringWriter = new StringWriter();
                                PrintWriter printWriter = new PrintWriter(MIMEHeaderStringWriter);
                                attachment.writeHeader(printWriter);
                                CMIndications.CMTrace("cmResponsetMIME", new CMException.Parm[]{new CMException.Parm("Part", attachment.getCID()), new CMException.Parm("ContentType", attachment.getContentType()), new CMException.Parm("ContentEncoding", attachment.getContentEncoding()), new CMException.Parm("ContentTransferEncoding", attachment.getContentTransferEncoding()), new CMException.Parm("Size", String.valueOf(attachment.getSize())), new CMException.Parm("Compressed", attachment.isGZipped() ? "true" : "false"), new CMException.Parm("Header", MIMEHeaderStringWriter.toString())});
                            }
                            attachment.release();
                        }
                        psout.print(sEOL);
                        psout.print(boundary + "--");
                        psout.print(sEOL);
                        psout.flush();
                        break block53;
                    }
                    this.writeSOAPResponse(response, null, null);
                }
                catch (Exception e) {
                    CMIndications.CMTrace("cmHTTPWrite", new CMException.Parm("ClientAddr", request.getRemoteAddr()));
                }
            }
            finally {
                this.updateRequestStatus();
                cmexCtx.release();
                this.fullSoapRequest_ = null;
                breadcrumbs.remove(CMExecutionContext.class);
                this.deleteTemporaryRequestAttachments();
                this.updateResponseSizeCounter();
            }
        }
    }

    protected void handleThrowable(Throwable e, HttpServletResponse response) {
        try {
            this.writeFault(e);
            this.writeSOAPRespEnd();
            response.setStatus(500);
            this.writeSOAPResponse(response, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateResponseSizeCounter();
    }

    private void updateResponseSizeCounter() {
        if (this.responseos_ != null) {
            responseSizeCounter.increment(this.responseos_.getBytesWritten());
        }
    }

    private void updateRequestSizeCounter() {
        if (this.inputBytesCounter != null) {
            requestSizeCounter.increment(this.inputBytesCounter.getBytesRead());
        }
    }

    private void updateRequestStatus() {
        if (this.startTime_ > 0L) {
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - this.startTime_;
            if (elapsedTime < 0L) {
                elapsedTime = 0L;
            }
            if (this.bHasFaulted_ && this.bFaultIsServer_) {
                ContentManager.reportRequestFailure(elapsedTime);
            } else {
                ContentManager.reportRequestSuccess(elapsedTime);
            }
        }
    }

    private boolean isCAMError(Throwable th) {
        if (!(th instanceof CMException)) {
            return false;
        }
        CMException cme = (CMException)th;
        if (cme.ex_ instanceof CMCacheCAMException && ((CMException)cme.ex_).getCode().equals("cmAuthenticateFailed")) {
            return true;
        }
        return cme.getCause() instanceof AAAException && cme.getCode().equals("cmNameSpaceQueryErr");
    }

    private boolean isErrorCodeInCAMSection(Throwable th) {
        if (!(th instanceof CMException)) {
            return false;
        }
        String strErrType = CMError.getSection(((CMException)th).getCode());
        return strErrType != null && strErrType.equalsIgnoreCase("CAM");
    }

    protected void handleCMException(CMException cme, HttpServletResponse response) {
        String strErrType = CMError.getSection(cme.getCode());
        this.strIndicationsStatus_ = cme.getCode();
        if (this.isCAMError(cme)) {
            CMIndications.logException(cme);
            this.writeCAMError(cme);
            return;
        }
        if (this.isErrorCodeInCAMSection(cme)) {
            this.writeCAMError(cme);
            if (response != null) {
                response.setStatus(500);
            }
        } else if (cme.getCode() == "cmEmptyRequest") {
            this.writeCannedRequestFault(cme);
            if (response != null) {
                response.setStatus(500);
            }
        } else if ("cmConfigurationRequired".equals(cme.getCode())) {
            this.writeConfigFault(cme);
            if (response != null) {
                response.setStatus(500);
            }
        } else if (strErrType != null && strErrType.equalsIgnoreCase("HDR")) {
            this.writeHeaderFault(cme);
            if (response != null) {
                response.setStatus(500);
            }
        } else {
            this.writeFault(cme);
            if (response != null) {
                response.setStatus(500);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleStaticRequest(InputStream is, OutputStream os) {
        CMExecutionContext ctx = CMExecutionContext.get();
        this.bRequestSuccessful_ = false;
        this.startTime_ = System.currentTimeMillis();
        ctx.setExecutingStaticRequest(true);
        boolean internalState = this.setInternalRequest(true);
        try {
            int read;
            this.inputStream_ = new LimitedInputStream(is, AdvancedSettings.MULTIPARTREQUESTMAXLENGTH);
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream(32768);
            byte[] buf = new byte[32768];
            while ((read = this.inputStream_.read(buf)) != -1) {
                outBytes.write(buf, 0, read);
            }
            buf = null;
            this.handleStaticRequest(outBytes.toByteArray(), os);
        }
        catch (IOException e) {
            this.strIndicationsStatus_ = "Failure";
            this.writeFault(e);
        }
        finally {
            this.fullSoapRequest_ = null;
            ctx.setExecutingStaticRequest(false);
            this.setInternalRequest(internalState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream handleStaticRequest(byte[] inputBytes, boolean useStaticContext) {
        this.bRequestSuccessful_ = false;
        this.startTime_ = System.currentTimeMillis();
        if (useStaticContext) {
            CMExecutionContext.get().setExecutingStaticRequest(true);
        }
        boolean internalState = this.setInternalRequest(true);
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            this.handleStaticRequest(inputBytes, (OutputStream)os);
        }
        finally {
            this.fullSoapRequest_ = null;
            CMExecutionContext.get().setExecutingStaticRequest(false);
            this.setInternalRequest(internalState);
        }
        return os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleStaticRequest(String passportID, XMLDoc requestDoc, XMLElement originalHeader, boolean useStaticContext, OutputStream os) throws SAXException, CMException {
        this.bRequestSuccessful_ = false;
        this.startTime_ = System.currentTimeMillis();
        CMExecutionContext.get().setExecutingStaticRequest(useStaticContext);
        boolean internalState = this.setInternalRequest(true);
        this.camParsingAction = new InternalCAMParsingAction(this, null, passportID);
        this.origBiBusHeaderElem_ = originalHeader;
        try {
            this.handleStaticRequest(requestDoc, os);
        }
        finally {
            this.fullSoapRequest_ = null;
            CMExecutionContext.get().setExecutingStaticRequest(false);
            this.setInternalRequest(internalState);
        }
    }

    public void handleStaticRequest(XMLDoc requestDoc, OutputStream os) throws SAXException, CMException {
        this.initForNewRequest(os);
        try {
            this.requestEncoding_ = "UTF-8";
            this.executeTheRequest(requestDoc);
            this.bRequestSuccessful_ = true;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (CMException cme) {
            throw cme;
        }
        catch (Exception e) {
            this.strIndicationsStatus_ = "Failure";
            this.writeFault(e);
            CMIndications.logException(e);
        }
        catch (Error e) {
            this.strIndicationsStatus_ = "Failure";
            this.writeFault(e);
            CMIndications.logException(e);
        }
        try {
            this.baInterimOutputStream_.writeTo(this.baOutputStream_);
            this.flushOutputStream();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            if (this.responseAttachments_.size() > 0) {
                StringBuffer s = new StringBuffer();
                s.append(s.hashCode()).append('_').append(System.currentTimeMillis());
                String boundary = "COGNOS_CM_MIME_boundary" + ResponseAttachment.GenerateCID();
                PrintWriter psout = new PrintWriter(new OutputStreamWriter((OutputStream)this.responseos_, "UTF-8"));
                StringBuffer contenttype = new StringBuffer("Multipart/Related; boundary=\"");
                contenttype.append(boundary);
                contenttype.append("\"; type=\"text/xml\"; start=\"<");
                String soapCID = ResponseAttachment.GenerateCID();
                contenttype.append(soapCID);
                contenttype.append(">\"");
                boundary = "--" + boundary;
                psout.print(boundary);
                psout.print(sEOL);
                psout.flush();
                this.writeSOAPResponse(null, soapCID, psout);
                for (ResponseAttachment attachment : this.responseAttachments_) {
                    psout.print(sEOL);
                    psout.print(boundary);
                    psout.print(sEOL);
                    attachment.write(this.responseos_);
                    attachment.release();
                }
                psout.print(sEOL);
                psout.print(boundary + "--");
                psout.print(sEOL);
                psout.flush();
            } else {
                this.writeSOAPResponse(null, null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleStaticRequest(byte[] inputBytes, OutputStream os) {
        this.initForNewRequest(os);
        try {
            this.fullSoapRequest_ = inputBytes;
            if (this.fullSoapRequest_ == null || this.fullSoapRequest_.length < 2) {
                CMIndications.CMTrace("cmEmptyRequest");
                throw new SAXException("no request", new CMException("cmEmptyRequest"));
            }
            inputBytes = null;
            this.requestEncoding_ = "UTF-8";
            this.executeTheRequest(new ByteArrayInputStream(this.fullSoapRequest_));
            this.bRequestSuccessful_ = true;
        }
        catch (SAXException e) {
            this.strIndicationsStatus_ = "Failure";
            Exception saxE = e.getException();
            if (saxE != null) {
                if (saxE instanceof CMException) {
                    this.handleCMException((CMException)saxE, null);
                } else {
                    this.writeFault(saxE);
                }
            } else {
                CMException cmex = new CMException(e, "cmBadXML");
                this.writeFault(cmex);
            }
        }
        catch (CMException cme) {
            this.strIndicationsStatus_ = "Failure";
            this.handleCMException(cme, null);
            CMIndications.logException(cme);
        }
        catch (Exception e) {
            this.strIndicationsStatus_ = "Failure";
            this.writeFault(e);
            CMIndications.logException(e);
        }
        catch (Error e) {
            this.strIndicationsStatus_ = "Failure";
            this.writeFault(e);
            CMIndications.logException(e);
        }
        this.writeSOAPRespEnd();
        try {
            if (this.responseAttachments_.size() > 0) {
                StringBuffer s = new StringBuffer();
                s.append(s.hashCode()).append('_').append(System.currentTimeMillis());
                String boundary = "COGNOS_CM_MIME_boundary" + ResponseAttachment.GenerateCID();
                PrintWriter psout = new PrintWriter(new OutputStreamWriter((OutputStream)this.responseos_, "UTF-8"));
                StringBuffer contenttype = new StringBuffer("Multipart/Related; boundary=\"");
                contenttype.append(boundary);
                contenttype.append("\"; type=\"text/xml\"; start=\"<");
                String soapCID = ResponseAttachment.GenerateCID();
                contenttype.append(soapCID);
                contenttype.append(">\"");
                boundary = "--" + boundary;
                psout.print(boundary);
                psout.print(sEOL);
                psout.flush();
                this.writeSOAPResponse(null, soapCID, psout);
                for (ResponseAttachment attachment : this.responseAttachments_) {
                    psout.print(sEOL);
                    psout.print(boundary);
                    psout.print(sEOL);
                    attachment.write(this.responseos_);
                    attachment.release();
                }
                psout.print(sEOL);
                psout.print(boundary + "--");
                psout.print(sEOL);
                psout.flush();
            } else {
                this.writeSOAPResponse(null, null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMultiPart(HttpServletRequest request, HttpServletResponse response) throws CMException, IOException, SAXException, CAMCryptoException {
        RequestFileAttachment part;
        MultipartParser parser = new MultipartParser(request, this.inputStream_, AdvancedSettings.MULTIPARTREQUESTMAXLENGTH);
        RequestByteArrayAttachment soappart = parser.readNextPartByteArray();
        this.fullSoapRequest_ = soappart.getBytes();
        while ((part = parser.readNextPartTempFile()) != null) {
            this.requestAttachments_.put(part.getName(), part);
        }
        if (CMIndicationGlobals.bRequestManager_TraceRequestSoap) {
            for (RequestAttachment item : this.requestAttachments_.values()) {
                RequestFileAttachment attachment = (RequestFileAttachment)item;
                CMIndications.CMTrace("cmRequestMIME", new CMException.Parm[]{new CMException.Parm("Part", attachment.getName()), new CMException.Parm("ContentType", attachment.getContentType()), new CMException.Parm("ContentEncoding", attachment.getContentEncoding()), new CMException.Parm("ContentTransferEncoding", attachment.getContentTransferEncoding()), new CMException.Parm("SavedSize", String.valueOf(attachment.getCompressedSize())), new CMException.Parm("DataSize", String.valueOf(attachment.getSize())), new CMException.Parm("Compressed", attachment.isCompressed() ? "true" : "false"), new CMException.Parm("CachedInFile", attachment.isFile() ? "true" : "false")});
            }
        }
        InputStream requestStream = null;
        try {
            String enc2;
            this.requestEncoding_ = "UTF-8";
            String contenttype = soappart.getContentType();
            int iType = contenttype.indexOf("encoding=");
            if (iType >= 0) {
                iType += 9;
            } else {
                iType = contenttype.indexOf("charset=");
                if (iType >= 0) {
                    iType += 8;
                }
            }
            if (iType >= 0 && (enc2 = contenttype.substring(iType, iType + 4)).equalsIgnoreCase("UTF-")) {
                int endEnc;
                enc2 = contenttype.substring(iType);
                for (endEnc = 4; endEnc < enc2.length() && enc2.charAt(endEnc) >= '0' && enc2.charAt(endEnc) <= '9'; ++endEnc) {
                }
                this.requestEncoding_ = enc2.substring(0, endEnc);
            }
            requestStream = soappart.getTempInputStream();
            this.executeTheRequest(requestStream);
            this.requestEncoding_ = "UTF-8";
        }
        finally {
            try {
                if (requestStream != null) {
                    requestStream.close();
                }
            }
            catch (IOException iOException) {}
            soappart.DeleteTheFileIfExists();
            this.deleteTemporaryRequestAttachments();
        }
    }

    private void executeTheRequest(InputStream inputStream) throws CMException, SAXException {
        RequestManagerStaxParser parser;
        if (this.fullSoapRequest_ == null || this.fullSoapRequest_.length < 2) {
            CMIndications.CMTrace("cmEmptyRequest");
            throw new CMException("cmEmptyRequest");
        }
        if (AdvancedSettings.PERFORMAXISVALIDATION != "client") {
            this.sProcessAxisValidation_ = AdvancedSettings.PERFORMAXISVALIDATION;
        }
        if (this.sProcessAxisValidation_ == null) {
            this.sProcessAxisValidation_ = this.bRequestFromTool_ ? "fault" : "log";
        }
        if ((this.sProcessAxisValidation_.equalsIgnoreCase("fault") || this.sProcessAxisValidation_.equalsIgnoreCase("log")) && !this.isInternalRequest()) {
            inputStream = new AxisRequestHandler(this.sProcessAxisValidation_).handle(inputStream);
        }
        this.sProcessAxisValidation_ = null;
        try {
            XMLStreamReader staxXmlReader = XMLStreamFactory.createXMLStreamReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
            this.camParsingAction = new CAMParsingPlugin(this, staxXmlReader);
            parser = new RequestManagerStaxParser(this.camParsingAction.getParsingDelegate(), this.internalRequest);
            parser.parse();
        }
        catch (XMLStreamException ex) {
            throw new CMException(ex, "cmBadXML");
        }
        catch (UnsupportedEncodingException e) {
            throw new CMRuntimeException(e);
        }
        this.xmlRequestDoc_ = parser.getRequestDoc();
        if (this.xmlRequestDoc_ == null) {
            CMIndications.CMTrace("cmEmptyRequest");
            throw new CMException("cmEmptyRequest");
        }
        this.handleRequest();
    }

    private void executeTheRequest(XMLDoc reqDoc) throws CMException, SAXException {
        this.xmlRequestDoc_ = reqDoc;
        if (this.xmlRequestDoc_ == null) {
            CMIndications.CMTrace("cmEmptyRequest");
            throw new SAXException("no request", new CMException("cmEmptyRequest"));
        }
        this.handleRequest();
    }

    private void writeSOAPResponse(HttpServletResponse response, String contentId, PrintWriter psout) throws IOException {
        int read;
        byte[] soapBytes = this.baOutputStream_.toByteArray();
        soapBytes = this.bridgeResponse(soapBytes);
        long lSoapSize = soapBytes.length;
        boolean b1 = CMIndicationGlobals.bRequestManager_LoggingSoap;
        boolean b2 = CMSessionLogging.isLoggingTRQ();
        if (b1 || b2) {
            if (!this.loggedRequest_) {
                this.logRequest();
            }
            String sEncodedResponse = new String(soapBytes, "UTF-8");
            if (b2) {
                CMSessionLogging.logResponse(sEncodedResponse);
            }
            if (b1) {
                if (!this.isInternalRequest()) {
                    if (this.isRelatedFriendRequest()) {
                        if (CMIndicationGlobals.bRequestManager_TraceAllResponses) {
                            CMIndications.CMTrace("cmResponseSoap", new CMException.Parm("response", CMXMLUtils.removeXMLTag(sEncodedResponse)));
                        }
                    } else if (CMIndicationGlobals.bRequestManager_TraceResponseSoap) {
                        CMIndications.CMTrace("cmResponseSoap", new CMException.Parm("response", CMXMLUtils.removeXMLTag(sEncodedResponse)));
                    }
                }
                if (CMIndications.logEnabled(CMExecutionContext.get().getIPFCategory(), 20000) && !this.isRelatedFriendRequest()) {
                    CMIndications.Audit_Response(sEncodedResponse);
                }
            }
        }
        if (this.logLevel3StartStop() && !this.isRelatedFriendRequest()) {
            boolean bl = this.bDoNotLogLevel3Audit_ = this.bDoNotLogLevel3Audit_ && this.currCommand_ == null;
            if (!this.bDoNotLogLevel3Audit_ && this.strIndicationsStatus_ == "Success") {
                CMIndications.Audit_Access();
            }
        }
        ByteArrayInputStream soapis = new ByteArrayInputStream(soapBytes);
        soapBytes = null;
        if (contentId != null) {
            psout.print("Content-Type: text/xml; charset=UTF-8\r\n");
            psout.print("Content-Transfer-Encoding: 8bit\r\n");
            psout.print("Content-ID: <" + contentId + ">\r\n");
            psout.print("Content-Length: " + lSoapSize);
            psout.print(sEOL);
            psout.print(sEOL);
            psout.flush();
        } else if (response != null) {
            response.setContentType("text/xml; charset=utf-8");
            response.setContentLength((int)lSoapSize);
        }
        byte[] buf = new byte[32768];
        long lWritten = 0L;
        while ((read = soapis.read(buf)) != -1) {
            this.responseos_.write(buf, 0, read);
            lWritten += (long)read;
        }
        this.responseos_.flush();
        if (lWritten != lSoapSize) {
            System.out.println("Error writing Soap part." + lWritten + " bytes written: Content Length = " + lSoapSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] bridgeResponse(byte[] buf) {
        CMExecutionContext ectx = CMExecutionContext.get();
        if (this.isInternalRequest() || ectx.executingStaticRequest()) {
            return buf;
        }
        inBridge.start();
        try {
            byte[] byArray = bridgeHandler.bridgeMessage(buf, this.requestSoapAction, ectx.getAccManPassportID());
            return byArray;
        }
        catch (Exception exception) {
        }
        finally {
            inBridge.stop();
        }
        return buf;
    }

    private void writeSOAPRespBegin() {
        if (this.baOutputStream_ == null || !this.bNeedToWriteSOAPRespBegin_) {
            return;
        }
        this.bNeedToWriteSOAPRespBegin_ = false;
        this.writeSOAPHeaderWithBIBUSBegin(this.baOutputStreamPrinter_, this.baOutputStream_, false);
        this.writeSOAPHeaderWithBIBUSEnd(this.baOutputStreamPrinter_, this.baOutputStream_);
        this.flushOutputStream();
    }

    private void writeSOAPHeaderWithBIBUSBegin(PrintWriter prt, OutputStream os, boolean bIncludeSoapFault) {
        block8: {
            try {
                this.bNeedToWriteSOAPRespBegin_ = false;
                if (this.strSOAPURI_.length() < 2) {
                    this.strSOAPURI_ = "http://schemas.xmlsoap.org/soap/envelope/";
                }
                os.write(baSOAPBIBusBegin_Seg1);
                this.writeToPrinter(prt, this.strSOAPURI_);
                os.write(baSOAPBIBusBegin_Seg2);
                if (bIncludeSoapFault) {
                    os.write(baSOAPBIBusBegin_Seg3);
                }
                os.write(baSOAPBIBusBegin_Seg4);
                if (this.isInternalRequest()) {
                    os.write(baSOAPBIBusEmpty);
                    break block8;
                }
                this.biBusHeader.removeElementFromBiBusHeader("providers");
                if (this.currHandler_ != null && this.currHandler_.isLimitedHeader()) {
                    this.biBusHeader.removeElementFromBiBusHeader("userPreferenceVars");
                    this.removeSetCRNCookieElement();
                }
                this.prepareFinalHeader();
                os.write(baSOAPBIBusBegin_Seg5);
                try {
                    String strBusHeader = this.makeBiBusHeader(false);
                    this.writeToPrinter(prt, strBusHeader);
                }
                catch (Exception ex) {
                    this.writeToPrinter(prt, "generating header failed:" + ex.getMessage());
                }
                os.write(baSOAPBIBusBegin_Seg6);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void removeSetCRNCookieElement() {
        this.biBusHeader.removeHeaderSessionSectionItemNamed("setCookieVars", "CRN");
    }

    private void writeSOAPHeaderWithBIBUSEnd(PrintWriter prt, OutputStream os) {
        try {
            os.write(baSOAPBIBusEnd_Seg1);
            if (this.bHasFaulted_) {
                if (this.bFaultIsServer_) {
                    os.write(baSOAPBIBusEnd_Seg2_Server);
                } else {
                    os.write(baSOAPBIBusEnd_Seg3_Client);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeSOAPRespEnd() {
        if (this.bNeedToWriteSOAPRespEnd_) {
            this.bNeedToWriteSOAPRespEnd_ = false;
            this.writeSOAPRespBegin();
            if (this.baInterimOutputStream_.size() > 0) {
                try {
                    this.baInterimOutputStream_.writeTo(this.baOutputStream_);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                if (this.bHasFaulted_) {
                    this.baOutputStream_.write(baSOAPRespEnd_Seg1);
                }
                this.baOutputStream_.write(baSOAPRespEnd_Seg2);
                this.flushOutputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void writeFault(Throwable ex) {
        this.logSOAPFault(ex);
        PrintWriter out = null;
        this.bHasFaulted_ = true;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)this.baInterimOutputStream_, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            CMIndications.logException(e);
        }
        this.bFaultIsServer_ = CMError.isServerFault(ex);
        String sErrorCode = null;
        if (ex instanceof CMException) {
            CMException cmex = (CMException)ex;
            sErrorCode = cmex.getCode();
        } else {
            sErrorCode = "cmCMError";
        }
        if (this.bFaultIsServer_ && sErrorCode != "cmVersionMismatch") {
            if (this.fullSoapRequest_ == null) {
                CMIndications.logException(ex);
            } else {
                try {
                    String sEncodedRequest = new String(this.fullSoapRequest_, "UTF-8");
                    sEncodedRequest = RequestPasswordRemover.filterOutPassword(sEncodedRequest);
                    CMIndications.logException(ex, sEncodedRequest);
                }
                catch (Exception exc) {
                    CMIndications.logException(ex);
                }
            }
        }
        this.strIndicationsStatus_ = sErrorCode;
        out.print("\t\t<bus:exception>\r\n");
        out.print("\t\t\t<severity>error</severity>\r\n");
        out.print("\t\t\t<errorCode>");
        out.print(sErrorCode);
        out.print("</errorCode>\r\n");
        out.flush();
        boolean nNesting = false;
        if (ex != null) {
            this.writeFaultMessage(ex, out, 0);
        }
        out.print("\t\t</bus:exception>\r\n");
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeFaultMessage(Throwable ex, PrintWriter out, int nNesting) {
        localizedMessage = ex.getLocalizedMessage();
        if (ex instanceof AAAException) {
            wroteSomething = false;
            try {
                parser = new XMLDocParser();
                xmlDoc = null;
                xmlDoc = parser.readXML(localizedMessage);
                messagesEL = xmlDoc.getRootXMLElement().getChildWithName("messages");
                if (!messagesEL.hasChildren()) ** GOTO lbl29
                for (XMLElement xmlEl : messagesEL.getChildren()) {
                    message = xmlEl.getOptionalChildValueWithName("messageString");
                    if (message == null) continue;
                    this.writeOutFaultMessage(message, ex, out, nNesting);
                    ++nNesting;
                    wroteSomething = true;
                }
            }
            catch (Exception parser) {
            }
            finally {
                if (!wroteSomething) {
                    this.writeOutFaultMessage(XMLUtils.escape((String)localizedMessage), ex, out, nNesting);
                }
            }
        } else if (localizedMessage != null) {
            this.writeOutFaultMessage(XMLUtils.escape((String)localizedMessage), ex, out, nNesting);
        } else {
            strMsg = new String("Exception occurred: " + ex.getClass().getName());
            this.writeOutFaultMessage(strMsg, ex, out, nNesting);
        }
lbl29:
        // 5 sources

        if (ex instanceof CMException) {
            cmex = (CMException)ex;
            ex1 = cmex.getException();
            ex2 = cmex.getException2();
            if (ex1 != null) {
                this.writeFaultMessage(ex1, out, nNesting + 1);
            }
            if (ex2 != null) {
                this.writeFaultMessage(ex2, out, nNesting + 1);
            }
        }
    }

    private void writeOutFaultMessage(String strMessage, Throwable ex, PrintWriter out, int nNesting) {
        if (strMessage == null) {
            return;
        }
        CMExecutionContext.get().addLevel3Message(strMessage);
        out.print("\t\t\t<bus:message>\r\n");
        if (nNesting > 0) {
            out.print("\t\t\t\t<nestingLevel>");
            out.print(nNesting);
            out.print("</nestingLevel>\r\n");
        }
        out.print("\t\t\t\t<messageString>");
        out.print(strMessage);
        if (ContentManager.startedSelf_ && ex != null && (ex instanceof RuntimeException || ex instanceof Error)) {
            this.bFaultIsServer_ = true;
            ByteArrayOutputStream traceBytes = new ByteArrayOutputStream();
            OutputStreamWriter wri = RequestManager.getUTF8OutputStreamWriter(traceBytes);
            PrintWriter ps = new PrintWriter(wri);
            ex.printStackTrace(ps);
            ps.flush();
            String strTrace = traceBytes.toString();
            out.print("\r\nRuntime Exception stack trace:\r\n");
            out.print(XMLUtils.escape((String)strTrace));
        }
        out.print("</messageString>\r\n");
        out.print("\t\t\t</bus:message>\r\n");
        out.flush();
    }

    private void writeHeaderFault(CMException ex) {
        String headerError = null;
        ArrayList<String> headerAdditionalErrors = new ArrayList<String>();
        this.logSOAPFault(ex);
        this.baOutputStream_.reset();
        PrintWriter out = this.baOutputStreamPrinter_;
        this.writeSOAPHeaderWithBIBUSBegin(out, this.baOutputStream_, true);
        out.print("\t<faults:Misunderstood qname=\"bus:CM\">\r\n");
        out.print("\t\t<errorDetailDocument xmlns=\"http://developer.cognos.com/schemas/bibus/3/\">\r\n");
        out.print("\t\t\t<errorCode>" + ex.getCode() + "</errorCode>\r\n");
        String exMsg = ex.getLocalizedMessage();
        out.print("\t\t\t<errorMessage>" + exMsg + "</errorMessage>\r\n");
        CMExecutionContext.get().addLevel3Message(exMsg);
        headerError = ex.getCode() + " " + exMsg;
        this.strIndicationsStatus_ = ex.getCode();
        Exception ex2 = ex.getException();
        boolean bContinue = true;
        while (ex2 != null && bContinue) {
            String strCode = "cmCMError";
            String strMessage = ex2.getLocalizedMessage();
            if (ex2 instanceof CMException) {
                ex = (CMException)ex2;
                strCode = ex.getCode();
                ex2 = ex.getException();
            } else {
                bContinue = false;
            }
            out.print("\t\t\t<errorStack>\r\n");
            out.print("\t\t\t\t<errorCode>");
            out.print(strCode);
            out.print("</errorCode>\r\n");
            out.print("\t\t\t\t<errorMessage>");
            out.print(strMessage);
            CMExecutionContext.get().addLevel3Message(strMessage);
            out.print("</errorMessage>\r\n");
            out.print("\t\t\t</errorStack>\r\n");
            headerAdditionalErrors.add(headerError);
            headerError = strCode + " " + strMessage;
        }
        String errorCode = null;
        String errorMessage = null;
        if (headerAdditionalErrors.isEmpty()) {
            errorCode = "cmHeaderFault";
            NameValuePair[] params = new CMException.Parm[]{new CMException.Parm("RootError", headerError)};
            errorMessage = CMError.getMessage("cmHeaderFault", params, CMExecutionContext.get().getRequestLocale("productLocale").toLocale());
        } else {
            errorCode = "cmHeaderMultipleFaults";
            NameValuePair[] params = new CMException.Parm[]{new CMException.Parm("RootError", headerError), new CMException.Parm("AdditionalErrors", headerAdditionalErrors)};
            errorMessage = CMError.getMessage("cmHeaderMultipleFaults", params, CMExecutionContext.get().getRequestLocale("productLocale").toLocale());
        }
        out.print("\t\t</errorDetailDocument>\r\n");
        out.print("\t</faults:Misunderstood>\r\n");
        out.print("  </SOAP-ENV:Header>\r\n");
        out.print("  <SOAP-ENV:Body>\r\n");
        out.print("\t<SOAP-ENV:Fault>\r\n");
        out.print("\t\t<faultcode>Client</faultcode>\r\n");
        out.print("\t\t<faultstring>" + CMError.getMessage("cmGeneralClientError", null, null) + "</faultstring>\r\n");
        out.print("\t\t<detail>\r\n");
        out.print("\t\t\t<bus:exception>\r\n");
        out.print("\t\t\t\t<severity>error</severity>\r\n");
        out.print("\t\t\t\t<errorCode>" + errorCode + "</errorCode>\r\n");
        out.print("\t\t\t\t<bus:message>\r\n");
        out.print("\t\t\t\t\t<messageString>" + errorMessage + "</messageString>\r\n");
        out.print("\t\t\t\t</bus:message>\r\n");
        out.print("\t\t\t</bus:exception>\r\n");
        out.print("\t\t</detail>\r\n");
        out.print("\t</SOAP-ENV:Fault>\r\n");
        out.print("  </SOAP-ENV:Body>\r\n");
        out.print("</SOAP-ENV:Envelope>\r\n");
        out.flush();
        this.bNeedToWriteSOAPRespEnd_ = false;
    }

    private void writeConfigFault(CMException ex) {
        String headerError = null;
        String headerAdditionalError = null;
        this.logSOAPFault(ex);
        this.baOutputStream_.reset();
        PrintWriter out = this.baOutputStreamPrinter_;
        this.writeSOAPHeaderWithBIBUSBegin(out, this.baOutputStream_, true);
        out.print("\t\t<faults:Misunderstood qname=\"bus:CM\">\r\n");
        out.print("\t\t\t<errorDetailDocument xmlns=\"http://developer.cognos.com/schemas/bibus/3/\">\r\n");
        out.print("\t\t\t\t<errorCode>" + ex.getCode() + "</errorCode>\r\n");
        out.print("\t\t\t\t<errorMessage>" + ex.getLocalizedMessage() + "</errorMessage>\r\n");
        CMExecutionContext.get().addLevel3Message(ex.getLocalizedMessage());
        this.strIndicationsStatus_ = ex.getCode();
        headerAdditionalError = ex.getCode() + " " + ex.getLocalizedMessage();
        List<DatabaseConfigInfo> configInfoList = this.config_.getDatabaseConfigInfo();
        if (this.isDBTypeMissing(configInfoList)) {
            out.print("\t\t\t\t<errorDetail>\r\n");
            DatabaseConfigInfo dbCInfo = configInfoList.get(0);
            out.print("\t\t\t\t\t<" + dbCInfo.name_ + " name=\"" + "h_CM_" + dbCInfo.name_ + "\" type=\"singleselect\">\r\n");
            List<String> databaseList = this.config_.getDatabaseTypeList();
            for (int i = 0; i < databaseList.size(); ++i) {
                String sType = databaseList.get(i);
                out.print("\t\t\t\t\t\t<option id=\"" + sType + "\">" + sType + "</option>\r\n");
            }
            out.print("\t\t\t\t\t</" + dbCInfo.name_ + ">\r\n");
            out.print("\t\t\t\t</errorDetail>\r\n");
            out.print("\t\t\t\t<errorStack>\r\n");
            out.print("\t\t\t\t\t<errorCode>cmNoDBType</errorCode>\r\n");
            String msg = CMError.getMessage("cmNoDBType", null, CMExecutionContext.get().getRequestLocale("productLocale").toLocale());
            out.print("\t\t\t\t\t<errorMessage>" + msg + "</errorMessage>\r\n");
            CMExecutionContext.get().addLevel3Message(msg);
            out.print("\t\t\t\t</errorStack>\r\n");
            headerError = "cmNoDBType " + msg;
        } else {
            out.print("\t\t\t\t<errorDetail>\r\n");
            out.print("\t\t\t\t\t<action type=\"hidden\" name=\"h_CM_action\" xmlns=\"http://developer.cognos.com/schemas/bibus/3/\">connect</action>\r\n");
            for (int i = 0; i < configInfoList.size(); ++i) {
                String strType;
                DatabaseConfigInfo dbCInfo = configInfoList.get(i);
                String strValue = dbCInfo.value_;
                if (strValue.equals("?")) {
                    strValue = "";
                }
                if ((strType = dbCInfo.getStrType()) == "textnoecho") {
                    strValue = "";
                }
                out.print("\t\t\t\t\t<" + dbCInfo.name_ + " name=\"h_CM_" + dbCInfo.name_ + "\" type=\"" + strType + "\">" + strValue + "</" + dbCInfo.name_ + ">\r\n");
            }
            out.print("\t\t\t\t</errorDetail>\r\n");
            out.print("\t\t\t\t<errorStack>\r\n");
            out.print("\t\t\t\t\t<errorCode>cmNoDBInfo</errorCode>\r\n");
            String msg = CMError.getMessage("cmNoDBInfo", null, CMExecutionContext.get().getRequestLocale("productLocale").toLocale());
            out.print("\t\t\t\t\t<errorMessage>" + msg + "</errorMessage>\r\n");
            CMExecutionContext.get().addLevel3Message(msg);
            out.print("\t\t\t\t</errorStack>\r\n");
            headerError = "cmNoDBInfo " + msg;
        }
        NameValuePair[] params = new CMException.Parm[]{new CMException.Parm("RootError", headerError), new CMException.Parm("AdditionalErrors", headerAdditionalError)};
        out.print("\t\t\t</errorDetailDocument>\r\n");
        out.print("\t\t</faults:Misunderstood>\r\n");
        out.print("\t\t</SOAP-ENV:Header>\r\n");
        out.print("\t<SOAP-ENV:Body>\r\n");
        out.print("\t<SOAP-ENV:Fault>\r\n");
        out.print("\t\t<faultcode>Client</faultcode>\r\n");
        out.print("\t\t<faultstring>" + CMError.getMessage("cmGeneralClientError", null, null) + "</faultstring>\r\n");
        out.print("\t\t<detail>\r\n");
        out.print("\t\t\t<bus:exception>\r\n");
        out.print("\t\t\t\t<severity>error</severity>\r\n");
        out.print("\t\t\t\t<errorCode>cmHeaderFault</errorCode>\r\n");
        out.print("\t\t\t\t<bus:message>\r\n");
        out.print("\t\t\t\t\t<messageString>" + CMError.getMessage("cmHeaderMultipleFaults", params, CMExecutionContext.get().getRequestLocale("productLocale").toLocale()) + "</messageString>\r\n");
        out.print("\t\t\t\t</bus:message>\r\n");
        out.print("\t\t\t</bus:exception>\r\n");
        out.print("\t\t</detail>\r\n");
        out.print("\t</SOAP-ENV:Fault>\r\n");
        out.print("\t</SOAP-ENV:Body>\r\n");
        out.print("</SOAP-ENV:Envelope>\r\n");
        out.flush();
        this.bNeedToWriteSOAPRespEnd_ = false;
    }

    private boolean isDBTypeMissing(List<DatabaseConfigInfo> configInfoList) {
        return configInfoList.size() == 1;
    }

    private void writeCannedRequestFault(CMException cme) {
        this.logSOAPFault(cme);
        String requestCode = cme.getCode();
        this.baOutputStream_.reset();
        PrintWriter out = this.baOutputStreamPrinter_;
        out.print("<SOAP-ENV:Envelope\t\txmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        out.print("\t\t\txmlns:faults=\"http://www.w3.org/2001/09/soap-faults\"");
        out.print("\t\t\txmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">\r\n");
        out.print("\t<SOAP-ENV:Header>\r\n");
        out.print("\t</SOAP-ENV:Header>\r\n");
        out.print("\t<SOAP-ENV:Body>\r\n");
        out.print("\t\t<SOAP-ENV:Fault>\r\n");
        out.print("\t\t\t<faultcode>Client</faultcode>\r\n");
        out.print("\t\t\t<faultstring>" + CMError.getMessage("cmGeneralClientError", null, null) + "</faultstring>\r\n");
        out.print("\t\t\t<detail>\r\n");
        out.print("\t\t\t\t<exception>\r\n");
        out.print("\t\t\t\t\t<severity>error</severity>\r\n");
        out.print("\t\t\t\t\t<errorCode>" + requestCode + "</errorCode>\r\n");
        out.print("\t\t\t\t\t<message>\r\n");
        String msg = CMError.getMessage(requestCode, null, ConfigurationFactory.getConfig().getServerLocale().toLocale());
        out.print("\t\t\t\t\t\t<messageString>" + msg + "</messageString>");
        CMExecutionContext.get().addLevel3Message(msg);
        out.print("\t\t\t\t\t</message>\r\n");
        out.print("\t\t\t\t</exception>\r\n");
        out.print("\t\t\t</detail>\r\n");
        out.print("\t\t</SOAP-ENV:Fault>\r\n");
        out.print("\t</SOAP-ENV:Body>\r\n");
        out.print("</SOAP-ENV:Envelope>\r\n");
        out.flush();
        this.bNeedToWriteSOAPRespEnd_ = false;
    }

    private void writeCAMError(CMException ex) {
        this.logSOAPFault(ex);
        this.baOutputStream_.reset();
        PrintWriter out = this.baOutputStreamPrinter_;
        String errCode = "cmHeaderFault";
        XMLElement exceptionElement = null;
        Exception exex = ex.getException();
        if (ex.getCode().equals("cmAuthenticateFailed") && exex != null && exex instanceof AAAException) {
            String strFault = exex.getMessage();
            try {
                if (this.bWSDLCAMRequest_) {
                    errCode = ex.getCode();
                    XMLDocParser parser = new XMLDocParser();
                    XMLDoc doc = parser.readXML(strFault);
                    XMLElement rootElement = doc.getRootXMLElement();
                    XMLElement el = rootElement.getChildWithName("Header");
                    el = el.getChildWithName("biBusHeader");
                    el = el.getChildWithName("CAM");
                    exceptionElement = el.getChildWithName("exception");
                    el.deleteChildWithName("exception");
                    strFault = rootElement.makeXML(null, true, true);
                }
                this.updateSecurityValuesInBiBusHeader(strFault);
            }
            catch (Exception cmCAMex) {
                CMException camInvalidResult = new CMException(cmCAMex, "cmBadCAMResultWithDoc", new CMException.Parm("doc", strFault));
                CMIndications.logException(camInvalidResult);
            }
            this.writeSOAPHeaderWithBIBUSBegin(out, this.baOutputStream_, true);
            out.print(sEOL);
        } else {
            this.writeSOAPHeaderWithBIBUSBegin(out, this.baOutputStream_, true);
            out.print("\t\t<faults:Misunderstood qname=\"bus:CM\">\r\n");
            out.print("\t\t\t<errorDetailDocument>\r\n");
            out.print("\t\t\t\t<errorCode>" + ex.getCode() + "</errorCode>\r\n");
            out.print("\t\t\t\t<errorMessage>" + ex.getLocalizedMessage() + "</errorMessage>\r\n");
            if (exex != null) {
                out.print("\t\t\t\t<errorStack>\r\n");
                out.print("\t\t\t\t\t<errorMessage>");
                out.print(exex.getLocalizedMessage());
                out.print(sEOL);
                if (exex instanceof RuntimeException) {
                    out.print("Runtime Exception stack trace:\r\n");
                    ByteArrayOutputStream traceBytes = new ByteArrayOutputStream();
                    OutputStreamWriter wriTrace = RequestManager.getUTF8OutputStreamWriter(traceBytes);
                    PrintWriter prtTrace = new PrintWriter(wriTrace);
                    exex.printStackTrace(prtTrace);
                    prtTrace.flush();
                    String strTrace = traceBytes.toString();
                    out.print(XMLUtils.escape((String)strTrace));
                    CMExecutionContext.get().addLevel3Message(strTrace);
                    out.print("\r\n\t\t\t\t\t");
                }
                out.print("</errorMessage>\r\n");
                out.print("\t\t\t\t</errorStack>\r\n");
            }
            out.print("\t\t\t</errorDetailDocument>\r\n");
            out.print("\t\t</faults:Misunderstood>\r\n");
        }
        CMException.Parm[] params = null;
        if ("cmHeaderFault".equals(errCode)) {
            String rootError = ex.getCode() + " " + ex.getLocalizedMessage();
            params = new CMException.Parm[]{new CMException.Parm("RootError", rootError)};
        }
        String errMsg = CMError.getMessage(errCode, params, CMExecutionContext.get().getRequestLocale("productLocale").toLocale());
        CMExecutionContext.get().addLevel3Message(errMsg);
        out.print("\t</SOAP-ENV:Header>\r\n");
        out.print("\t<SOAP-ENV:Body>\r\n");
        out.print("\t\t<SOAP-ENV:Fault>\r\n");
        out.print("\t\t\t<faultcode>Client</faultcode>\r\n");
        out.print("\t\t\t<faultstring>" + CMError.getMessage("cmGeneralClientError", null, null) + "</faultstring>\r\n");
        out.print("\t\t\t<detail>\r\n");
        out.print("\t\t\t\t<bus:exception>\r\n");
        out.print("\t\t\t\t\t<severity>error</severity>\r\n");
        out.print("\t\t\t\t\t<errorCode>" + errCode + "</errorCode>\r\n");
        out.print("\t\t\t\t\t<bus:message>\r\n");
        out.print("\t\t\t\t\t\t<messageString>" + errMsg + "</messageString>\r\n");
        if (exceptionElement != null) {
            out.print("\t\t\t\t\t<detail>\n");
            out.print(exceptionElement.makeXML("\t\t\t\t\t", true, true));
            out.print("\t\t\t\t\t</detail>\r\n");
        }
        out.print("\t\t\t\t\t</bus:message>\r\n");
        out.print("\t\t\t\t</bus:exception>\r\n");
        out.print("\t\t\t</detail>\r\n");
        out.print("\t\t</SOAP-ENV:Fault>\r\n");
        out.print("\t</SOAP-ENV:Body>\r\n");
        out.print("</SOAP-ENV:Envelope>\r\n");
        out.flush();
        this.bNeedToWriteSOAPRespEnd_ = false;
    }

    private void logSOAPFault(Throwable ex) {
        int logLevel;
        boolean isCAMCategory = this.isCAMError(ex) || this.isErrorCodeInCAMSection(ex);
        int n = logLevel = isCAMCategory ? CMIndicationGlobals.iRequestManager_TraceCAMFaultLevel : CMIndicationGlobals.iRequestManager_TraceSoapFaultLevel;
        if (logLevel > 40000) {
            return;
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        CMIndications.printCDATABegin(out);
        ex = CMIndications.printThrowableMessage(ex, out);
        if (logLevel <= 30000) {
            CMIndications.printStackTrace(ex, out);
        }
        if (logLevel <= 20000) {
            out.print("\r\nREQUEST:\r\n");
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((InputStream)new ByteArrayInputStream(this.fullSoapRequest_));
                XMLWriter xmlwriter = new XMLWriter((Writer)out, OutputFormat.createPrettyPrint());
                Element el = doc.getRootElement();
                if (logLevel > 10000) {
                    List l;
                    Element el2;
                    if (el.getName().equals("Envelope") && (el2 = el.element("Body")) != null && (l = el2.elements()).size() != 0) {
                        el = (Element)l.get(0);
                    }
                    el = doc.getRootElement();
                }
                RequestPasswordRemover.filterOutPassword(doc);
                xmlwriter.write(el);
            }
            catch (Exception e) {
                try {
                    String sEncodedRequest = new String(this.fullSoapRequest_, this.requestEncoding_);
                    sEncodedRequest = RequestPasswordRemover.filterOutPassword(sEncodedRequest);
                    out.print(sEncodedRequest);
                }
                catch (UnsupportedEncodingException uee) {
                    out.print("Unable to log original request, encoding failed with error:\r\n");
                    out.print(uee.getMessage());
                }
            }
            out.print(sEOL);
        }
        CMIndications.printCDATAEnd(out);
        String msg = writer.toString();
        String sCategory = isCAMCategory ? "Trace.CM.CAM" : "Trace.CM.ERR";
        CMIndications.CMTraceText(sCategory, logLevel, msg);
    }

    private boolean isRelatedFriendRequest() {
        if (this.isInternalRequest()) {
            return true;
        }
        trustedService currService = CMExecutionContext.get().getTrustedService();
        if (currService != null) {
            return currService.getInternal();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRequest() throws CMException {
        if (this.currCommand_ == null) {
            return;
        }
        if (this.currHandler_ == null) {
            throw new CMException("cmNoRequestHandlerSys");
        }
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStore store = ctx.getStore();
        ICMLockManager lockMgr = store.getLockManager();
        String accManPassportID = ctx.getAccManPassportID();
        if (CMIndicationGlobals.bDebugLogEnabled) {
            if (accManPassportID == null) {
                CMIndications.CMDebugTrace("performRequest: bUseAccMan=" + bUseAccMan_ + " passportID=null rRequiresHandle=" + this.currHandler_.requiresAuthenticatedHandle());
            } else {
                CMIndications.CMDebugTrace("performRequest: bUseAccMan=" + bUseAccMan_ + " passportID=" + accManPassportID + " handlerRequiresHandle=" + this.currHandler_.requiresAuthenticatedHandle());
            }
        }
        if (bUseAccMan_ && accManPassportID == null && this.currHandler_.requiresAuthenticatedHandle()) {
            this.currHandler_.accManPassportID = null;
            this.currHandler_.bUseAccMan = false;
            this.currHandler_.bCheckPolicies = false;
            this.currHandler_.sExtraPermission_ = null;
        } else {
            this.currHandler_.accManPassportID = accManPassportID;
            this.currHandler_.bUseAccMan = bUseAccMan_;
            this.currHandler_.bCheckPolicies = bCheckPolicies_;
        }
        if (CMIndicationGlobals.bDebugLogEnabled) {
            CMIndications.CMDebugTrace("======== Starting request=" + this.currCommand_ + " useAccMan=" + this.currHandler_.bUseAccMan + " passportID=" + this.currHandler_.accManPassportID + " checkPolicies=" + this.currHandler_.bCheckPolicies);
        }
        this.currHandler_.validate(this.config_, this.currRequest_);
        CMExecutionContext cmex = CMExecutionContext.get();
        CMBreadcrumbs breadcrumbs = cmex.getBreadcrumbs();
        cmex.setIPFOperation(this.currCommand_.toUpperCase());
        breadcrumbs.add(RequestHandler.class, this.currHandler_);
        String sRequestEntry = "com.cognos.cm.request." + this.currRequest_.command;
        String sRequestEntryDescription = "The count and the time spent in \"" + this.currRequest_.command + "\" request.";
        PerfTimer timer = PerfMonitor.getTimer((String)sRequestEntry, (String)sRequestEntryDescription, (int)1);
        timer.start();
        ZipiTimer zipiTimer = ZipiFactory.getCurrentTimer();
        String objPath = CMExecutionContext.get().getIPFObjectPath();
        if (zipiTimer != null && objPath != null && objPath.length() > 0) {
            zipiTimer.setObjectPath(objPath);
        }
        try {
            this.bInBody_ = true;
            lockMgr.releaseLocks();
            this.currHandler_.handle(this.config_, this.currRequest_);
        }
        finally {
            this.releaseLocks(lockMgr);
            this.cleanUpBreadCrumbs(cmex, breadcrumbs, timer);
            this.bInBody_ = false;
        }
        InputStream isRsp = this.currHandler_.getInputSOAPStream();
        if (isRsp != null) {
            try {
                int nBytesRead = 0;
                byte[] baBuff = new byte[32768];
                while ((nBytesRead = isRsp.read(baBuff)) != -1) {
                    this.baInterimOutputStream_.write(baBuff, 0, nBytesRead);
                }
                this.baInterimOutputStream_.write(13);
                this.baInterimOutputStream_.write(10);
            }
            catch (IOException e) {
                CMException newEx = new CMException((Exception)e, "cmHTTPWrite", new CMException.Parm("ClientAddr", this.servletRequest_.getRemoteAddr()));
                newEx.ErrorLevel = 10000;
                throw newEx;
            }
        }
        int numAttachments = this.currHandler_.numAttachements();
        for (int i = 0; i < numAttachments; ++i) {
            this.responseAttachments_.add(this.currHandler_.getAttachment(i));
        }
        if (this.currHandler_.getResponseDelay() > 0L) {
            this.delayResponse();
        }
    }

    private void cleanUpBreadCrumbs(CMExecutionContext cmex, CMBreadcrumbs breadcrumbs, PerfTimer timer) {
        long nTimeInMilliseconds = -1L;
        cmex.setIPFOperation(this.currCommand_.toUpperCase());
        nTimeInMilliseconds = timer.stop();
        this.warnIfLongRunningRequest(this.currRequest_.command.toUpperCase(), nTimeInMilliseconds);
        breadcrumbs.remove(RequestHandler.class);
    }

    private void releaseLocks(ICMLockManager lockMgr) throws CMException {
        if (this.iLockWait_ > 0) {
            this.lockWaitSleep(this.iLockWait_);
        }
        lockMgr.releaseLocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayResponse() throws CMException {
        if (CMServlet.CMRunningMode_ == 2) {
            CMStore store = CMExecutionContext.get().getStore();
            String activeContentStore = store.getRunningContentStoreName();
            throw new CMException("cmInStandByMode", new CMException.Parm("URL", activeContentStore));
        }
        PerfTimer timer = ContentManager.PERF_TIMER_IN_CM;
        boolean restartTimer = false;
        if (timer.isStarted()) {
            timer.stop();
            restartTimer = true;
        }
        Thread currentThread = Thread.currentThread();
        CMServlet.addSleepingThread(currentThread);
        long sleepTime = System.currentTimeMillis();
        Thread thread = currentThread;
        synchronized (thread) {
            try {
                currentThread.wait(this.currHandler_.getResponseDelay());
            }
            catch (InterruptedException e) {
                CMIndications.logException(e);
            }
            finally {
                CMServlet.removeSleepingThread(currentThread);
                if (restartTimer) {
                    timer.start();
                }
            }
        }
        sleepTime = System.currentTimeMillis() - sleepTime;
        this.startTime_ += sleepTime;
        if (CMServlet.CMRunningMode_ == 2) {
            CMStore store = CMExecutionContext.get().getStore();
            String activeContentStore = store.getRunningContentStoreName();
            throw new CMException("cmInStandByMode", new CMException.Parm("URL", activeContentStore));
        }
    }

    protected void setQueryUtils(ICMQueryUtils utils) {
        this.queryUtils = utils;
    }

    public void addRequestAttachment(String name, RequestAttachment attach) {
        HashMap<String, RequestAttachment> attachments = this.currRequest_.RequestAttachments;
        if (attachments == null) {
            attachments = this.requestAttachments_;
        }
        name = name.toLowerCase();
        if (attachments == null) {
            this.currRequest_.addRequestAttachment(name, attach);
        } else {
            attachments.put(name, attach);
        }
    }

    public boolean deleteAttachment(String name) {
        RequestAttachment ra;
        HashMap<String, RequestAttachment> attachments = this.currRequest_.RequestAttachments;
        if (attachments == null) {
            attachments = this.requestAttachments_;
        }
        name = name.toLowerCase();
        if (attachments != null && (ra = attachments.remove(name)) != null) {
            ra.DeleteTheFileIfExists();
            return true;
        }
        return false;
    }

    public String getFullSOAPRequest() {
        return this.fullSoapRequest_ != null ? new String(this.fullSoapRequest_) : null;
    }

    public boolean isToolRequest() {
        return this.bRequestFromTool_;
    }

    public Object getRequestAttachments(String dataID) {
        HashMap<String, RequestAttachment> attachments = this.currRequest_.RequestAttachments;
        if (attachments == null) {
            attachments = this.requestAttachments_;
        }
        if (attachments == null) {
            return null;
        }
        return attachments.get(dataID.toLowerCase());
    }

    public void deleteTemporaryRequestAttachments() {
        for (RequestAttachment attachment : this.requestAttachments_.values()) {
            if (!attachment.isFile() || attachment.isDeploymentFile()) continue;
            attachment.DeleteTheFileIfExists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest() throws CMException {
        XMLElement xmlEl;
        XMLElement xmlElSOAPBody;
        if (CMServlet.CMRunningMode_ == 0 && !CMServlet.CMisComingUp_ && CMServlet.CMRunningMode_ == 0) {
            throw new CMException("cmConfigurationRequired");
        }
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStore store = ctx.getStore();
        if (!this.isInternalRequest()) {
            this.verifyBiBusHeaderExists();
            this.processBiBusHeader();
            this.setSessionVarsForCam();
            if (this.providerName_ != null && this.providerName_.length() > 0) {
                boolean bProviderError = false;
                if (this.providerPatch_ != null && this.providerPatch_.length() > 0) {
                    try {
                        Float fPatch = new Float(this.providerPatch_);
                        if (fPatch.floatValue() > 99.99f) {
                            bProviderError = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        bProviderError = true;
                    }
                }
                if (bProviderError) {
                    throw new CMException("cmBadProvider", new CMException.Parm("provider", "cm/1/"), new CMException.Parm("patch", "1"));
                }
            }
        }
        if ((xmlElSOAPBody = (xmlEl = this.xmlRequestDoc_.getRootXMLElement()).getOptionalChildWithName(CMSOAPConstants.NS_SOAP_ENV, "Body")) != null) {
            String lockWait = xmlElSOAPBody.getAttribute("LockWait");
            this.iLockWait_ = 0;
            try {
                if (lockWait != null) {
                    this.iLockWait_ = Integer.parseInt(lockWait);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String sNamespace = "http://developer.cognos.com/schemas/bibus/3/";
            XMLElement xmlELCommand = xmlElSOAPBody.getOptionalChildWithNamespace(CMSOAPConstants.NS_BIBUS);
            if (xmlELCommand == null) {
                sNamespace = "http://developer.cognos.com/schemas/contentManagerService/1";
                xmlELCommand = xmlElSOAPBody.getOptionalChildWithNamespace(CMSOAPConstants.NS_CM_1);
            }
            if (xmlELCommand != null) {
                int idx;
                if (this.isLogoff()) {
                    throw new CMException("cmBodyInLogoff");
                }
                this.currCommand_ = xmlELCommand.name_;
                DiagnosticsContext.get().setCommand(this.currCommand_);
                if (this.currCommand_.equals("add") || this.currCommand_.equals("update")) {
                    this.handleBuriedAttachments();
                }
                if (CMServlet.CMRunningMode_ == 2) {
                    if (!RequestHandler.canBeProcessedByStandbyCM(this.currCommand_)) {
                        String activeContentStore = store.getRunningContentStoreName();
                        throw new CMException("cmInStandByMode", new CMException.Parm("URL", activeContentStore));
                    }
                    if (!AdvancedSettings.PROTOTYPE_ENABLESTANDBYREADERS) {
                        this.setInternalRequest(true);
                    }
                }
                ctx.setIPFOperation(this.currCommand_.toUpperCase());
                this.currHandler_ = this.handlerFactory_.getNewHandler(store, sNamespace, this.currCommand_);
                if (this.currHandler_ == null) {
                    throw new CMException("cmNoRequestHandler", new CMException.Parm("Name", this.currCommand_));
                }
                this.currHandler_.manager = this;
                this.currHandler_.InitXML(xmlELCommand);
                this.currHandler_.sExtraPermission_ = null;
                if (xmlELCommand.attributes_ != null && (idx = xmlELCommand.attributes_.getIndex("permission")) > -1) {
                    this.currHandler_.sExtraPermission_ = xmlELCommand.attributes_.getValue(idx);
                }
                this.currRequest_ = new Request();
                this.currRequest_.command = this.currCommand_;
                this.currRequest_.RequestAttachments = this.requestAttachments_;
                this.currHandler_.prepareRequest(this.config_, this.currRequest_);
            } else {
                ctx.setIPFOperation("");
            }
        }
        ctx.setBIBUSheader(this);
        if (CMServlet.CMRunningMode_ != 2 || AdvancedSettings.PROTOTYPE_ENABLESTANDBYREADERS) {
            ctx.setCAMAdditionalInfo(this);
        }
        if ((CMServlet.CMRunningMode_ != 2 || AdvancedSettings.PROTOTYPE_ENABLESTANDBYREADERS) && !this.isInternalRequest()) {
            this.NoCAMRequired_ = this.isCAMElementNotRequired(this.currHandler_);
            if (!(this.isInternalRequest() || this.bThereWasACAMElement_ || this.fullyTrusted() || this.bThisIsATrustedProcess_)) {
                throw new CMException("cmCAMRequired");
            }
            if (this.isClonePassportAction() && !this.bThisIsATrustedProcess_) {
                throw new CMException("cmRequestNotTrusted");
            }
            if (this.bThereWasACAMElement_ || this.bThereWasACAMCredientialElement_ || this.hasCamAction()) {
                this.AuthenticateCAMHeader();
            }
            if (!(!CMServlet.CMisSuspended_ || this.isInternalRequest() || this.isLogoff() || this.fullyTrusted() || ctx.hasCapability("canUseAdministrationPortal"))) {
                this.forceCAMFaultWithAnonymousIn();
                try {
                    this.logoff();
                }
                catch (CMException e) {
                    CMIndications.logException(e, "cmSuspended");
                }
                throw new CMException("cmSuspended");
            }
            this.setSessionVarsForRequest();
            if (AdvancedSettings.ENABLEGLOABALUSERCAPABILITIES) {
                if (this.isLogoff()) {
                    this.removeGlobalCapabilitiesCacheFromHeader();
                } else {
                    this.updateGlobalUserCapabilitiesCacheInHeader();
                }
            }
            store.getLockManager().releaseLocks();
            this.updateUserLicenseLevel();
        }
        this.logRequest();
        DiagnosticsContext.get().setUser(CMExecutionContext.get().getCurrentUser());
        try {
            this.performRequest();
        }
        finally {
            if (this.currHandler_ != null) {
                this.currHandler_.clearAttachments();
                this.currHandler_.reset();
            }
        }
    }

    private void updateUserLicenseLevel() {
        if (!this.isInternalRequest() && this.isLogon()) {
            LicenseManager.getInstance().updateUserLicenseLevel();
        }
    }

    private void handleBuriedAttachments() throws CMException {
        if (this.xmlRequestDoc_.hrefList_ == null) {
            return;
        }
        for (XMLDoc.HRefObj href : this.xmlRequestDoc_.hrefList_) {
            XMLElement el = href.element_;
            if (el.name_.equals("value")) {
                CMStore store = CMExecutionContext.get().getStore();
                CMPropertySets propSets = store.getPropertySets();
                CMPropertySet propSet = propSets.getPropertySet();
                if (el.parent_ != null && propSet.getProperties(el.parent_.name_) != null) {
                    el = el.parent_;
                    if (el.parent_ != null && el.parent_.xsiType_ != null && store.getObjectClasses().getClassByName(el.parent_.xsiType_, false) != null) continue;
                }
            }
            throw new CMException("cmAttachmentsNotSupported1", new CMException.Parm("element", el.name_));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRequest() {
        block23: {
            this.loggedRequest_ = true;
            if (this.fullSoapRequest_ == null) {
                return;
            }
            boolean passwordRemoved = false;
            String sEncodedRequest = null;
            String sIPFCategory = CMExecutionContext.get().getIPFCategory();
            if (CMIndicationGlobals.bRequestManager_AuditRequests && CMIndications.logEnabled(sIPFCategory, 20000) && !this.isRelatedFriendRequest()) {
                try {
                    sEncodedRequest = new String(this.fullSoapRequest_, this.requestEncoding_);
                    sEncodedRequest = RequestPasswordRemover.filterOutPassword(sEncodedRequest);
                    passwordRemoved = true;
                    CMExecutionContext.get().setIPFTimestamp(this.startRequestSystemMillis_);
                    CMIndications.Audit_Request(sEncodedRequest);
                    CMExecutionContext.get().resetIPFTimestamp();
                }
                catch (UnsupportedEncodingException e) {
                    CMIndications.Audit_Request("Unable to output request - encoding request failed with error: " + e.getMessage());
                }
            }
            boolean b1 = CMIndicationGlobals.bRequestManager_LoggingSoap | g_bFileLogRequestSoap_;
            boolean b2 = CMSessionLogging.isLoggingTRQ();
            if ((b1 || b2) && !this.isInternalRequest()) {
                try {
                    if (sEncodedRequest == null) {
                        sEncodedRequest = new String(this.fullSoapRequest_, this.requestEncoding_);
                        passwordRemoved = false;
                    }
                    if (!passwordRemoved) {
                        sEncodedRequest = RequestPasswordRemover.filterOutPassword(sEncodedRequest);
                    }
                    if (b2) {
                        CMSessionLogging.logRequest(this.requestSoapAction, sEncodedRequest);
                    }
                    if (!b1) break block23;
                    CMExecutionContext.get().setIPFTimestamp(this.startRequestSystemMillis_);
                    if (this.isRelatedFriendRequest()) {
                        if (CMIndicationGlobals.bRequestManager_TraceInternalRequestSoap) {
                            CMIndications.CMTrace("cmRequestSoap", new CMException.Parm("request", CMXMLUtils.removeXMLTag(sEncodedRequest)));
                        }
                    } else if (CMIndicationGlobals.bRequestManager_TraceResponseSoap) {
                        CMIndications.CMTrace("cmRequestSoap", new CMException.Parm("request", CMXMLUtils.removeXMLTag(sEncodedRequest)));
                    }
                    CMExecutionContext.get().resetIPFTimestamp();
                    if (!g_bFileLogRequestSoap_) break block23;
                    OutputStreamWriter outputStreamWriter = g_fwLogRequestSoap_;
                    synchronized (outputStreamWriter) {
                        try {
                            String sRequest = sEncodedRequest;
                            int nIdx = sRequest.indexOf("<SOAP-ENV:Envelope");
                            if (nIdx > -1) {
                                sRequest = sRequest.substring(nIdx);
                            }
                            if (!g_bFileLogRequestSoap_UserOnly_ || !this.isInternalRequest()) {
                                try {
                                    g_fwLogRequestSoap_.write(sRequest);
                                    g_fwLogRequestSoap_.flush();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        catch (Exception e) {
                            g_fwLogRequestSoap_.write("Logging request SOAP message failed giving error: " + e.getMessage());
                            g_fwLogRequestSoap_.flush();
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean fullyTrusted() {
        if (this.NoCAMRequired_) {
            return true;
        }
        if (!this.bThisIsATrustedProcess_) {
            return false;
        }
        trustedService currService = CMExecutionContext.get().getTrustedService();
        if (currService != null) {
            return currService.getFullyTrusted();
        }
        return false;
    }

    private void prepareFinalHeader() {
        this.ensureBiBusHeaderExists();
        if (this.userPreferences_.get(CMPreference.CONTENTLOCALE) == null) {
            this.setSessionVarsForCam();
        }
        CMExecutionContext thisExecutionContext = CMExecutionContext.get();
        XMLElement xmlElProviders = null;
        XMLElement xmlEl = this.getSOAPHeader().getOptionalChildWithNameEvenIfNil("tracking");
        if (xmlEl == null) {
            xmlEl = this.getSOAPHeader().addChild((CMSOAPConstants.XMLNamespace)null, "tracking", CMSOAPConstants.NS_BIBUS, "tracking");
        }
        this.resetXsiType(xmlEl, CMSOAPConstants.NS_BIBUS, "tracking");
        xmlEl.isNil_ = false;
        xmlEl.setChildValueWithName("sessionContext", CMSOAPConstants.NS_XMLSCHEMA, CMPropertyTypes.XML_STRING.getName(), thisExecutionContext.getSessionContext());
        int hopCount = thisExecutionContext.getHopCount();
        xmlEl.setChildValueWithName("hopCount", CMSOAPConstants.NS_XMLSCHEMA, CMPropertyTypes.XML_INTEGER.getName(), Integer.toString(++hopCount));
        XMLElement conversationContext = thisExecutionContext.getConversationContext();
        if (conversationContext != null) {
            xmlEl.replaceChild(conversationContext);
        }
        if ((xmlElProviders = xmlEl.getOptionalChildWithNameEvenIfNil("providers")) != null) {
            xmlElProviders.deleteChildren();
        } else {
            xmlElProviders = xmlEl.addChild((CMSOAPConstants.XMLNamespace)null, "providers", CMSOAPConstants.NS_BIBUS, "provider");
        }
        if (xmlElProviders != null) {
            xmlElProviders.xsiType_ = "provider";
            xmlElProviders.isNil_ = false;
            xmlElProviders.isArray_ = true;
            XMLElement xmlElProvider = xmlElProviders.addChild((CMSOAPConstants.XMLNamespace)null, "provider", CMSOAPConstants.NS_BIBUS, "provider");
            XMLElement xmlEl2 = xmlElProvider.addChild((CMSOAPConstants.XMLNamespace)null, "name", CMSOAPConstants.NS_XMLSCHEMA, CMPropertyTypes.XML_STRING.getName());
            xmlEl2.value_ = "cm";
            xmlEl2 = xmlElProvider.addChild((CMSOAPConstants.XMLNamespace)null, "patch", CMSOAPConstants.NS_XMLSCHEMA, CMPropertyTypes.XML_INT.getName());
            xmlEl2.value_ = "1";
            xmlEl2 = xmlElProvider.addChild((CMSOAPConstants.XMLNamespace)null, "build", CMSOAPConstants.NS_XMLSCHEMA, CMPropertyTypes.XML_STRING.getName());
            CMBuildVersion cmBuildVersion = new CMBuildVersion(0, 0, 0, 0);
            try {
                cmBuildVersion.setTo(cmInfo.getVersion());
            }
            catch (Exception exception) {
                // empty catch block
            }
            xmlEl2.value_ = cmBuildVersion.getReleaseVersion();
        }
        this.biBusHeader.removeElementFromBiBusHeader("CAMProtect");
    }

    private void processBiBusHeader() throws CMException {
        String name;
        this.camAction = null;
        this.bThereWasACAMElement_ = false;
        this.bThereWasACAMCredientialElement_ = false;
        this.bThisIsATrustedProcess_ = false;
        this.bPassportHasBeenSet_ = false;
        this.bCAMIsValidate_ = false;
        this.ensureBiBusHeaderExists();
        CMExecutionContext thisExecutionContext = CMExecutionContext.get();
        boolean bHeaderContentPresent = false;
        if (AdvancedSettings.HEADERCONTENT != null) {
            bHeaderContentPresent = true;
        }
        boolean bContentLocaleSet = false;
        boolean bProductLocaleSet = false;
        XMLElement xmlEl = this.biBusHeader.getSection("providers");
        if (xmlEl != null && xmlEl.hasChildren()) {
            for (XMLElement xmlElChild : xmlEl.getChildren()) {
                name = xmlElChild.getOptionalChildValueWithName("name");
                if (name == null || !name.startsWith("cm")) continue;
                this.providerName_ = name;
                this.providerPatch_ = xmlElChild.getOptionalChildValueWithName("patch");
                break;
            }
        }
        if ((xmlEl = this.biBusHeader.getSection("userPreferenceVars")) != null && xmlEl.hasChildren()) {
            this.origUserPreferences_.clear();
            for (XMLElement xmlElChild : xmlEl.getChildren()) {
                CMPreference pref;
                String value;
                name = xmlElChild.getOptionalChildValueWithName("name");
                if (name == null || (value = xmlElChild.getOptionalChildValueWithName("value")) == null || value.length() <= 0 || (pref = CMPreference.find(name)) == null) continue;
                thisExecutionContext.setPreference(pref, value);
                this.origUserPreferences_.set(pref, value);
                if (!bHeaderContentPresent) continue;
                if (!bContentLocaleSet) {
                    boolean bl = bContentLocaleSet = pref == CMPreference.CONTENTLOCALE;
                }
                if (bProductLocaleSet) continue;
                bProductLocaleSet = pref == CMPreference.PRODUCTLOCALE;
            }
        }
        if ((xmlEl = this.biBusHeader.getSection("tracking")) != null) {
            thisExecutionContext.setSessionContext(xmlEl.getOptionalChildValueWithName("sessionContext"));
            thisExecutionContext.setRequestContext(xmlEl.getOptionalChildValueWithName("requestContext"));
            thisExecutionContext.setStepContext(xmlEl.getOptionalChildValueWithName("stepContext"));
            thisExecutionContext.setHopCount(xmlEl.getOptionalChildValueWithName("hopCount"));
            thisExecutionContext.setConversationContext(xmlEl.getOptionalChildWithName("conversationContext"));
        }
        this.setRequesterInfoInDiagnosticsContext();
        xmlEl = this.biBusHeader.getSection("CAMProtect");
        if (xmlEl != null) {
            XMLElement xmlEl2 = xmlEl.getOptionalChildWithName("serviceId");
            String serviceId = null;
            if (xmlEl2 == null || xmlEl2.value_ == null) {
                throw new CMException("cmCAMProtectNoServiceId");
            }
            serviceId = xmlEl2.value_;
            thisExecutionContext.setServiceId(serviceId);
            if (serviceId != null && serviceId.equalsIgnoreCase("DISP")) {
                this.bSetCookiesAndPrefs_ = false;
            }
            thisExecutionContext.setTrustedValue(xmlEl.getOptionalChildValueWithName("trustedValue"));
            this.bThisIsATrustedProcess_ = true;
            if (CMServlet.CAMFactory_ == null) {
                throw new CMException("cmErrorTrusted");
            }
            if (CMServlet.CAMtrustedRequestSession_ == null) {
                throw new CMException("cmErrorTrusted");
            }
            if (serviceId == null || !serviceId.equalsIgnoreCase("CAMconfig")) {
                try {
                    if (!CMServlet.CAMisTrusted(this.fullSoapRequest_)) {
                        throw new CMException("cmFailedTrusted");
                    }
                }
                catch (CMException ex) {
                    throw ex;
                }
                catch (CAMCryptoException camCex) {
                    throw new CMException((Exception)((Object)camCex), "cmFailedTrusted");
                }
                catch (Exception err) {
                    throw new CMException(err, "cmErrorTrusted");
                }
            }
        }
        this.camParsingAction.parseComplete();
        if (bHeaderContentPresent && !this.isLogon() && this.bPassportHasBeenSet_) {
            StringBuffer sMissingContent = new StringBuffer("");
            if (thisExecutionContext.getRequestContext().equals("")) {
                sMissingContent.append("requestContext");
                sMissingContent.append(" ");
            }
            if (thisExecutionContext.getRequestContext().equals("")) {
                sMissingContent.append("sessionContext");
                sMissingContent.append(" ");
            }
            if (!bContentLocaleSet) {
                sMissingContent.append(CMPreference.CONTENTLOCALE.getName());
                sMissingContent.append(" ");
            }
            if (!bProductLocaleSet) {
                sMissingContent.append(CMPreference.PRODUCTLOCALE.getName());
                sMissingContent.append(" ");
            }
            if (sMissingContent.length() != 0) {
                this.enhancedLog(AdvancedSettings.HEADERCONTENT, sMissingContent.toString());
            }
        }
    }

    private void setRequesterInfoInDiagnosticsContext() {
        XMLElement xmlEl = this.biBusHeader.getSection("dispatcherTransportVars");
        if (xmlEl != null && xmlEl.hasChildren()) {
            String requesterValue = null;
            for (XMLElement child : xmlEl.getChildren()) {
                String name = child.getOptionalChildValueWithName("name");
                if (name == null || !name.equals("requester")) continue;
                requesterValue = child.getOptionalChildValueWithName("value");
                break;
            }
            String compID = null;
            String reqID = null;
            DiagnosticsContext diagnosticsCtx = DiagnosticsContext.get();
            if (requesterValue == null || requesterValue.length() == 0) {
                compID = "";
                reqID = "";
            } else {
                diagnosticsCtx.setRequester(requesterValue);
                int pos = requesterValue.lastIndexOf(59);
                if (pos != -1) {
                    requesterValue = requesterValue.substring(pos + 1);
                }
                if ((pos = requesterValue.indexOf(58)) == -1) {
                    compID = requesterValue;
                    reqID = "";
                } else {
                    compID = requesterValue.substring(0, pos);
                    reqID = requesterValue.substring(pos + 1);
                }
            }
            diagnosticsCtx.setComponent(compID);
            diagnosticsCtx.setRequest(reqID);
        }
    }

    public void processCAMAction(String action) {
        if (action != null) {
            this.camAction = CamAction.fromString(action);
            this.bCAMIsValidate_ = false;
        }
    }

    private void AuthenticateCAMHeader() throws CMException {
        this.ensureBiBusHeaderExists();
        CMExecutionContext currContext = CMExecutionContext.get();
        CMStore store = currContext.getStore();
        ICMLockManager lockMgr = store.getLockManager();
        String sCAMheaderDoc = null;
        boolean bCreateUserAccount = !this.isInternalRequest() && (this.hasCamAction() && !this.isLogoff() || !this.bPassportHasBeenSet_);
        try {
            int sessionObjID = currContext.getCurrentUserSessionObjectID();
            if (0 < sessionObjID && !this.isInternalRequest() && this.isLogoff()) {
                lockMgr.requestLocksToObjects(new int[]{sessionObjID}, 15);
            }
            String sOldPassport = currContext.getAccManPassportID();
            sCAMheaderDoc = AccMan.Authenticate(this.getSOAPHeader(), this.camAction, bCreateUserAccount, this.bCAMIsValidate_, this.bThereWasACAMCredientialElement_);
            String sNewPassport = currContext.getAccManPassportID();
            if (sCAMheaderDoc != null && sNewPassport != null) {
                this.bPassportIDHasChanged_ = !sNewPassport.equalsIgnoreCase(sOldPassport);
            }
        }
        catch (CMException cme) {
            this.removeCAMFromBiBusHeader();
            Exception exex = cme.getException();
            if (exex != null && exex instanceof AAAException) {
                this.bDoNotLogLevel3Audit_ = true;
            }
            throw cme;
        }
        finally {
            lockMgr.releaseLocks();
        }
        if (sCAMheaderDoc == null) {
            if (!this.wasValidate(bCreateUserAccount)) {
                this.removeCAMFromBiBusHeader();
                throw new CMException("cmNoCAMLogin");
            }
        } else {
            this.updateSecurityValuesInBiBusHeader(sCAMheaderDoc);
            currContext.setBIBUSheader(this);
            currContext.setCAMAdditionalInfo(this);
        }
    }

    private boolean wasValidate(boolean bCreateUserAccount) {
        return this.bCAMIsValidate_ && !bCreateUserAccount && !this.isLogoff() && !this.bThereWasACAMCredientialElement_;
    }

    private void setSessionVarsForCam() {
        if (this.isInternalRequest()) {
            this.setSessionFromSessionVars();
            this.setSessionFromExecutionContextPrefs();
            this.setSessionFromDefaults();
        } else {
            this.setSessionFromSessionVars();
            this.setSessionFromBrowserSettings();
            this.setSessionFromDefaults();
        }
        this.saveSessionPreferenceValues();
    }

    private void setSessionVarsForRequest() {
        this.userPreferences_.clear();
        if (this.isInternalRequest()) {
            this.setSessionFromSessionVars();
            this.setSessionFromExecutionContextPrefs();
            this.setSessionFromDefaults();
        } else if (this.isLogon()) {
            boolean isAnonymous;
            CMExecutionContext context = CMExecutionContext.get();
            String userId = context.getCurrentUser();
            boolean bl = isAnonymous = userId != null && userId.equals("::Anonymous");
            if (isAnonymous) {
                this.setSessionFromSessionVars();
                this.setSessionFromUserAccount();
            } else {
                this.setSessionFromUserAccount();
                if (context.getTrustedService() != null || context.getCurrentUserIsMultipleNamespaceSession()) {
                    this.setSessionFromSessionVars();
                }
            }
            this.setSessionFromBrowserSettings();
            this.setSessionFromDefaults();
            if (AdvancedSettings.LIMIT_ACCOUNT_TEMPLATE_NAMES) {
                this.updateAccountTemplatesName();
            }
        } else {
            this.setSessionFromSessionVars();
            this.setSessionFromUserAccount();
            this.setSessionFromBrowserSettings();
            this.setSessionFromDefaults();
        }
        this.saveSessionPreferenceValues();
    }

    private void saveSessionPreferenceValues() {
        if (this.bSetCookiesAndPrefs_) {
            CMExecutionContext thisExecutionContext = CMExecutionContext.get();
            UserPreferences.Iterator it = this.userPreferences_.iterator();
            while (it.hasNext()) {
                CMPreference pref = it.next();
                String value = it.getValue();
                this.biBusHeader.setUserPreferenceValue(pref.getName(), value);
                thisExecutionContext.setPreference(pref, value);
            }
            if (!this.isInternalRequest()) {
                if (this.isLogoff()) {
                    this.CRNCookieMaxAge = "-1";
                    this.biBusHeader.setMaxAgeForCookie("CRN", this.CRNCookieMaxAge);
                }
                if (this.didPrefsChange()) {
                    StringBuffer strBuf = new StringBuffer();
                    it = this.userPreferences_.iterator();
                    while (it.hasNext()) {
                        CMPreference pref = it.next();
                        if (!pref.isIncludedInCookie()) continue;
                        strBuf.append(CMURLEncoder.encode((String)pref.getName()));
                        strBuf.append(CMURLEncoder.encode((String)"="));
                        String value = it.getValue();
                        if (value != null && value.length() != 0) {
                            value = CMURLEncoder.encode((String)value);
                            strBuf.append(CMURLEncoder.encode((String)value));
                        }
                        strBuf.append(CMConstants.ueCOOKIE_DELIMITER);
                    }
                    String strCookie = strBuf.toString();
                    this.biBusHeader.setCookie("CRN", strCookie, this.CRNCookieMaxAge, true);
                    thisExecutionContext.setCurrentUserDirectoryName(null);
                }
            }
        }
    }

    public void setCurrentUserSessionValues(UserPreferences prefs) throws CMException {
        UserPreferences sessionPrefs;
        CMExecutionContext currentContext = CMExecutionContext.get();
        if (this.bInBody_ && !this.isInternalRequest() && !this.isLogoff() && currentContext.getCurrentUserIsSharedAnonymous()) {
            this.CRNCookieMaxAge = "31536000";
            this.biBusHeader.setMaxAgeForCookie("CRN", this.CRNCookieMaxAge);
        }
        if ((sessionPrefs = currentContext.getCurrentUserSessionVars()) == null) {
            sessionPrefs = new UserPreferences();
        }
        UserPreferences.Iterator it = prefs.iterator();
        while (it.hasNext()) {
            CMPreference pref = it.next();
            String value = it.getValue();
            if (value == null) continue;
            if (value.length() == 0) {
                if (pref == CMPreference.CONTENTLOCALE || pref == CMPreference.PRODUCTLOCALE) {
                    this.userPreferences_.set(pref, null);
                    this.setSessionFromBrowserSettings();
                    this.setSessionFromDefaults();
                    sessionPrefs.set(pref, this.userPreferences_.get(pref));
                    continue;
                }
                value = pref.getDefaultValue();
            } else if (pref == CMPreference.SKIN) {
                value = this.mapSessionSkin(value);
            }
            value = pref.mapValue(value);
            this.userPreferences_.set(pref, value);
            sessionPrefs.set(pref, value);
        }
        this.saveSessionPreferenceValues();
        currentContext.setBIBUSheader(this);
        currentContext.setCAMAdditionalInfo(this);
    }

    private void setSessionFromSessionVars() {
        UserPreferences.Iterator it = this.origUserPreferences_.iterator();
        while (it.hasNext()) {
            String value;
            CMPreference pref = it.next();
            String oldValue = it.getValue();
            if (oldValue == null || (value = this.userPreferences_.get(pref)) != null) continue;
            this.userPreferences_.set(pref, pref.mapValue(oldValue));
        }
    }

    private boolean didPrefsChange() {
        UserPreferences.Iterator it = this.userPreferences_.iterator();
        while (it.hasNext()) {
            String requestValue;
            CMPreference pref = it.next();
            String value = it.getValue();
            if (value == null || (requestValue = this.origUserPreferences_.get(pref)) != null && value.equals(requestValue)) continue;
            return true;
        }
        return false;
    }

    private void setSessionFromExecutionContextPrefs() {
        if (!this.isInternalRequest()) {
            return;
        }
        CMExecutionContext eCtx = CMExecutionContext.get();
        UserPreferences.Iterator it = this.userPreferences_.iterator();
        while (it.hasNext()) {
            CMPreference pref = it.next();
            String value = eCtx.getPreference(pref);
            if (value == null) continue;
            it.setValue(pref.mapValue(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSessionFromUserAccount() {
        if (this.userPreferences_.isAllSet()) {
            return;
        }
        CMExecutionContext currentContext = CMExecutionContext.get();
        UserPreferences sessionPrefs = currentContext.getCurrentUserSessionVars();
        if (sessionPrefs == null || currentContext.getCurrentUser() == null) {
            return;
        }
        if (!sessionPrefs.isClear()) {
            UserPreferences.Iterator it = this.userPreferences_.iterator();
            while (it.hasNext()) {
                String value;
                CMPreference pref = it.next();
                if (it.getValue() != null || (value = sessionPrefs.get(pref)) == null) continue;
                it.setValue(value);
            }
            return;
        } else {
            CMStore store = null;
            CMStoreQueryResults results = null;
            ArrayList<CMPreference> aPrefs = new ArrayList<CMPreference>(24);
            ArrayList<CMProperty> aProps = new ArrayList<CMProperty>(24);
            UserPreferences.Iterator it = this.userPreferences_.iterator();
            while (it.hasNext()) {
                CMPreference pref = it.next();
                CMProperty prop = pref.getMappedProperty();
                if (prop == null || prop == CMProperty.OPTIONS) continue;
                aPrefs.add(pref);
                aProps.add(prop);
            }
            aProps.add(CMProperty.OPTIONS);
            try {
                store = currentContext.getStore();
                CMPreference[] prefs = new CMPreference[aPrefs.size()];
                aPrefs.toArray(prefs);
                CMProperty[] props = new CMProperty[aProps.size()];
                aProps.toArray(props);
                results = store.executeQuery(new CMStoreXPath("~"), props, null, 0, 8704, null);
                if (!results.next()) return;
                for (int i = 0; i < prefs.length; ++i) {
                    String str;
                    Object obj = results.getValue(i);
                    if (obj == null || (str = obj.toString()) == null || str.length() <= 0) continue;
                    CMPreference pref = prefs[i];
                    str = pref.mapValue(str);
                    if (this.userPreferences_.get(pref) == null) {
                        this.userPreferences_.set(pref, str);
                    }
                    sessionPrefs.set(pref, str);
                }
                Object obj = results.getValue(props.length - 1);
                if (obj == null) return;
                CMDbStoreTypedNameValuePairArray optionArray = (CMDbStoreTypedNameValuePairArray)obj;
                for (int i = 0; i < optionArray.getSize(); ++i) {
                    CMPreference pref;
                    String typeName;
                    CMTypedNameValuePair item = optionArray.getPair(i);
                    String name = item.getName();
                    PortalOptionEnum option = PortalOptionEnum.find(name, typeName = item.getTypeName());
                    if (option == null || (pref = option.getMappedUserPreference()) == null) continue;
                    String value = PortalOptionEnum.extractUserPreferenceValueFromCMDbStoreStringNameValuePair((CMStringNameValuePair)item);
                    if (pref.isOptional()) {
                        this.userPreferences_.set(pref, value);
                        sessionPrefs.set(pref, value);
                        continue;
                    }
                    if (value == null || value.length() == 0) continue;
                    if (pref == CMPreference.SKIN) {
                        value = this.mapSessionSkin(value);
                    }
                    if (this.userPreferences_.get(pref) == null) {
                        this.userPreferences_.set(pref, value);
                    }
                    sessionPrefs.set(pref, value);
                }
                return;
            }
            catch (CMException cMException) {
                return;
            }
            finally {
                if (results != null) {
                    results.release();
                }
                CMQueryUtils.safeReleaseLocks(currentContext);
            }
        }
    }

    private void setSessionFromBrowserSettings() {
        String contentLocale = this.userPreferences_.get(CMPreference.CONTENTLOCALE);
        String productLocale = this.userPreferences_.get(CMPreference.PRODUCTLOCALE);
        if (contentLocale != null && productLocale != null) {
            return;
        }
        String acceptLanguage = this.biBusHeader.getValueWithName("hdrSession", "environmentVars", "HTTP_ACCEPT_LANGUAGE");
        if (acceptLanguage != null && acceptLanguage.length() > 1) {
            try {
                IConfiguration config = ConfigurationFactory.getConfig();
                StringTokenizer tokenizer = new StringTokenizer(acceptLanguage, ",;", false);
                while (tokenizer.hasMoreTokens()) {
                    String mappedLocale2;
                    String token = tokenizer.nextToken();
                    if (token.startsWith("q=")) continue;
                    token = config.normalizeLocale(token);
                    if (contentLocale == null) {
                        if (config.validateContentLocale(token)) {
                            contentLocale = token;
                        } else {
                            try {
                                mappedLocale2 = config.mapContentLocale(token, false);
                                if (config.validateContentLocale(mappedLocale2)) {
                                    contentLocale = mappedLocale2;
                                }
                            }
                            catch (CMConfigurationException mappedLocale2) {
                                // empty catch block
                            }
                        }
                    }
                    if (productLocale == null) {
                        if (config.validateProductLocale(token)) {
                            productLocale = token;
                        } else {
                            try {
                                mappedLocale2 = config.mapProductLocale(token, false);
                                if (config.validateProductLocale(mappedLocale2)) {
                                    productLocale = mappedLocale2;
                                }
                            }
                            catch (CMConfigurationException cMConfigurationException) {
                                // empty catch block
                            }
                        }
                    }
                    if (contentLocale == null || productLocale == null) continue;
                    break;
                }
                this.userPreferences_.set(CMPreference.CONTENTLOCALE, contentLocale);
                this.userPreferences_.set(CMPreference.PRODUCTLOCALE, productLocale);
            }
            catch (CMConfigurationException cMConfigurationException) {
                // empty catch block
            }
        }
    }

    private void setSessionFromDefaults() {
        if (this.userPreferences_.isAllSet()) {
            return;
        }
        CMPreference pref = CMPreference.CONTENTLOCALE;
        if (this.userPreferences_.get(pref) == null) {
            this.userPreferences_.set(pref, pref.mapValue(pref.getDefaultValue()));
        }
        if (this.userPreferences_.get(pref = CMPreference.PRODUCTLOCALE) == null) {
            this.userPreferences_.set(pref, pref.mapValue(pref.getDefaultValue()));
        }
        this.userPreferences_.setDefaultValues();
    }

    private void updateAccountTemplatesName() {
        String searchPath = CMExecutionContext.get().getCurrentUserSearchPath();
        CMStringLocale contentLocale = CMDbStoreStringLocales.findLocale(this.userPreferences_.get(CMPreference.CONTENTLOCALE));
        try {
            AccountTemplates accountTemplates = new AccountTemplates();
            accountTemplates.addAccountSearchPath(new CMStoreXPath(searchPath));
            accountTemplates.update(contentLocale);
        }
        catch (CMStoreParseException e) {
            CMIndications.logException(e);
        }
    }

    private String mapSessionSkin(String portalSkinSearchPath) {
        String skin = CMPreference.SKIN.getDefaultValue();
        if (portalSkinSearchPath != null && portalSkinSearchPath.length() != 0) {
            String skinFolder = null;
            StringBuffer buf = new StringBuffer(portalSkinSearchPath).append("[").append("permission").append("('").append("execute").append("')]");
            CMExecutionContext eCtx = CMExecutionContext.get();
            try {
                CMStorePath portalSkinPath = CMStoreXPath.parse(buf.toString());
                Object obj = this.queryUtils.getObjectProp(eCtx.getStore(), portalSkinPath, CMProperty.RESOURCELOCATION, 16384);
                if (obj != null && (skinFolder = obj.toString()) != null && skinFolder.length() > 0) {
                    skin = skinFolder;
                }
            }
            catch (CMException cMException) {
                // empty catch block
            }
        }
        return skin;
    }

    void setPassport(String sPassportId) throws CMException {
        if (CMServlet.CMRunningMode_ != 1) {
            return;
        }
        if (sPassportId == null || sPassportId.length() <= 0) {
            throw new CMException("cmInvalidPassport");
        }
        CMExecutionContext ctx = CMExecutionContext.get();
        ctx.setAccManPassportID(sPassportId);
        if (ctx.getCurrentUserAccountObjectID() > 0) {
            this.bCAMIsValidate_ = true;
        }
        this.bPassportHasBeenSet_ = true;
    }

    public static boolean doCheckPolicies() {
        return bCheckPolicies_;
    }

    public static boolean doUseAccMan() {
        return bUseAccMan_;
    }

    private static void loadConfig() {
        if (!bConfigLoaded_) {
            bConfigLoaded_ = true;
            IConfiguration config = ConfigurationFactory.getConfig();
            String s = config.getInternalProp("CMUseAccMan");
            if (s != null) {
                if (s.equals("1")) {
                    bUseAccMan_ = true;
                } else if (s.equals("0")) {
                    bUseAccMan_ = false;
                }
            }
            if ((s = config.getInternalProp("CMCheckPolicies")) != null) {
                if (s.equals("1")) {
                    bCheckPolicies_ = true;
                } else if (s.equals("0")) {
                    bCheckPolicies_ = false;
                }
            }
            if (!bUseAccMan_ && bCheckPolicies_) {
                bCheckPolicies_ = false;
                config.setInternalProp("CMCheckPolicies", "0");
            }
        }
    }

    public String makeBiBusHeader(boolean includeHeaderTags) {
        this.ensureBiBusHeaderExists();
        String xmlStr = this.getSOAPHeader().makeXML("\t", includeHeaderTags, includeHeaderTags);
        return xmlStr;
    }

    private void verifyBiBusHeaderExists() throws CMException {
        if (this.xmlRequestDoc_ == null) {
            throw new CMException("cmEmptyRequest");
        }
        XMLElement xmlEl = this.xmlRequestDoc_.getRootXMLElement();
        if ((xmlEl = xmlEl.getOptionalChildWithName(CMSOAPConstants.NS_SOAP_ENV, "Header")) == null) {
            throw new CMException("cmSOAPHeaderRequired");
        }
        if ((xmlEl = xmlEl.getOptionalChildWithName(CMSOAPConstants.NS_BIBUS, "biBusHeader")) == null) {
            throw new CMException("cmBiBusHeaderRequired");
        }
        this.origBiBusHeaderElem_ = XMLElement.copyFrom(xmlEl);
        this.ensureBiBusHeaderExists();
    }

    private void ensureBiBusHeaderExists() {
        this.verifyRequestXMLIsNotNull();
        this.biBusHeader.ensureBiBusHeaderExists(this.xmlRequestDoc_);
    }

    private void verifyRequestXMLIsNotNull() {
        if (this.xmlRequestDoc_ == null) {
            this.xmlRequestDoc_ = new XMLDoc(this.nsPrefixes, CMSOAPConstants.NS_SOAP_ENV.getUri(), "Envelope", new SAXAttributes(new AttributesImpl()));
        }
    }

    private void removeCAMFromBiBusHeader() {
        this.biBusHeader.removeElementFromBiBusHeader("CAM");
        this.biBusHeader.removeElementFromBiBusHeader("CAMCredential");
        this.removeGlobalCapabilitiesCacheFromHeader();
    }

    private void resetXsiType(XMLElement el, CMSOAPConstants.XMLNamespace typeNs, String type) {
        el.xmlNamespace_ = null;
        el.attributes_ = null;
        el.xsiTypeNs_ = typeNs;
        el.xsiType_ = type;
    }

    private void updateSecurityValuesInBiBusHeader(String sCAMheaderDoc) throws CMException {
        this.getSOAPHeader().deleteChildWithName("CAMCredential");
        XMLElement elCAM = this.getSOAPHeader().getOptionalChildWithName("CAM");
        if (elCAM == null) {
            elCAM = this.getSOAPHeader().addChild((CMSOAPConstants.XMLNamespace)null, "CAM", CMSOAPConstants.NS_BIBUS, "CAM");
        }
        this.resetXsiType(elCAM, CMSOAPConstants.NS_BIBUS, "CAM");
        elCAM.children_ = null;
        try {
            XMLElement camCAFEl;
            XMLDocParser parseXML = new XMLDocParser();
            XMLDoc CAMheaderdoc = parseXML.readXML(sCAMheaderDoc);
            XMLElement xmlHeader = CAMheaderdoc.getRootXMLElement().getChildWithName("Header");
            xmlHeader = xmlHeader.getChildWithName("biBusHeader");
            XMLElement xmlParsedEl = xmlHeader.getChildWithName("CAM");
            if (xmlParsedEl != null) {
                elCAM.children_ = xmlParsedEl.children_;
            }
            if ((xmlParsedEl = xmlHeader.getOptionalChildWithName("hdrSession")) != null) {
                XMLElement elHdrSession = this.getSOAPHeader().getOptionalChildWithName("hdrSession");
                if (elHdrSession == null) {
                    elHdrSession = this.getSOAPHeader().addChild((CMSOAPConstants.XMLNamespace)null, "hdrSession", CMSOAPConstants.NS_BIBUS, "hdrSession");
                }
                this.resetXsiType(elHdrSession, CMSOAPConstants.NS_BIBUS, "hdrSession");
                elHdrSession.children_ = xmlParsedEl.children_;
                Integer maxAge = this.biBusHeader.getCookieMaxAge("cam_passport");
                if (maxAge != null && maxAge < 0) {
                    this.removeGlobalCapabilitiesCacheFromHeader();
                }
            } else {
                this.getSOAPHeader().deleteChildWithName("hdrSession");
            }
            XMLElement origCAFEl = this.getSOAPHeader().getOptionalChildWithName("CAF");
            if (origCAFEl != null && (camCAFEl = xmlHeader.getOptionalChildWithName("CAF")) != null) {
                origCAFEl.children_ = camCAFEl.children_;
            }
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmBadCAMResultWithDoc", new CMException.Parm("doc", sCAMheaderDoc));
        }
    }

    private void updateGlobalUserCapabilitiesCacheInHeader() throws CMException {
        boolean setCookie;
        this.biBusHeader.removeElementFromBiBusHeader("userCapabilityCache");
        ExtendedUserCapabilities euc = CMExecutionContext.get().getUserCapabilities();
        if (euc == null) {
            return;
        }
        XMLElement globalCapabilitiesCache = this.getSOAPHeader().addChild((CMSOAPConstants.XMLNamespace)null, "userCapabilityCache", CMSOAPConstants.NS_XMLSCHEMAINSTANCE, "userCapabilityCache");
        globalCapabilitiesCache.xsiTypeNs_ = CMSOAPConstants.NS_BIBUS;
        globalCapabilitiesCache.xsiType_ = "userCapabilityCache";
        globalCapabilitiesCache.value_ = euc.getUserCapabilityCacheValue();
        globalCapabilitiesCache.doXMLEncodeOnValue_ = false;
        boolean bl = setCookie = this.isLogon() || this.bPassportIDHasChanged_;
        if (!setCookie) {
            boolean oldCookieFound = false;
            boolean newCookieFound = false;
            XMLElement cookieVars = this.getSOAPHeader().getChild("hdrSession", "cookieVars");
            if (cookieVars != null && cookieVars.hasChildren()) {
                for (XMLElement elCookieVar : cookieVars.getChildren()) {
                    String name = elCookieVar.getChildValueWithName("name");
                    if ("userCapabilities".equals(name)) {
                        oldCookieFound = true;
                        continue;
                    }
                    if (!USERCAPABILITIESEX_COOKIE.equals(name)) continue;
                    newCookieFound = true;
                }
            }
            boolean bl2 = setCookie = !oldCookieFound || !newCookieFound;
        }
        if (setCookie) {
            this.addGlobalCapabilitiesToCookies();
        }
    }

    private void removeGlobalCapabilitiesCacheFromHeader() {
        XMLElement globalCapabilitiesCache = this.getSOAPHeader().getOptionalChildWithName("userCapabilityCache");
        if (globalCapabilitiesCache != null) {
            this.biBusHeader.removeElementFromBiBusHeader("userCapabilityCache");
        }
        this.biBusHeader.setCookie("userCapabilities", "", "-1");
        this.biBusHeader.setCookie(USERCAPABILITIESEX_COOKIE, "", "-1");
    }

    private void addGlobalCapabilitiesToCookies() throws CMException {
        ExtendedUserCapabilities uc = CMExecutionContext.get().getUserCapabilities();
        if (uc != null) {
            this.biBusHeader.setCookie("userCapabilities", uc.getLegacyCookieValue(), "0");
            this.biBusHeader.setCookie(USERCAPABILITIESEX_COOKIE, uc.getCookieValue(), "0");
        }
    }

    public void replaceCAMElementInBiBusHeader(XMLElement el) {
        XMLElement elCAM = this.getSOAPHeader().getOptionalChildWithName("CAM");
        if (elCAM == null) {
            elCAM = this.getSOAPHeader().addChild((CMSOAPConstants.XMLNamespace)null, "CAM", CMSOAPConstants.NS_BIBUS, "CAM");
        }
        elCAM.deleteChildWithName(el.name_);
        if (elCAM.children_ == null) {
            elCAM.children_ = new ArrayList();
        }
        elCAM.children_.add(el);
    }

    private static void initRequestLogging() {
        String sRecordFilePath = "./cm_requests.xml";
        Properties sysProps = System.getProperties();
        boolean bRecordRequests = false;
        String sProp = "CM.recordRequests";
        if (sysProps.containsKey("CM.recordRequests")) {
            bRecordRequests = true;
            String sPath = sysProps.getProperty("CM.recordRequests");
            if (sPath != null && sPath.length() > 0) {
                sRecordFilePath = sPath;
            }
        }
        if (bRecordRequests) {
            try {
                System.out.println("*** Using property 'CM.recordRequests' to write incoming CM requests to file '" + sRecordFilePath + "'...");
                g_fwLogRequestSoap_ = new OutputStreamWriter((OutputStream)new FileOutputStream(sRecordFilePath), "UTF-8");
                g_bFileLogRequestSoap_ = true;
            }
            catch (Exception ex) {
                System.out.println("\n*** Unable to open file output stream on file " + sRecordFilePath);
                System.out.println("   Exception='" + ex.toString() + "'.");
                System.out.println("   Execution continues without request logging.");
                ex.printStackTrace(System.out);
            }
        }
    }

    public String makeCAMAdditionalInfo() {
        CMExecutionContext currentContext = CMExecutionContext.get();
        StringBuffer buf = new StringBuffer();
        String directoryClassName = CMObjectClass.DIRECTORY.getName();
        String directoryPath = "/" + directoryClassName;
        String directoryTitle = currentContext.getCurrentUserDirectoryName();
        if (directoryTitle == null) {
            try {
                CMStorePath dirStorePath = CMStoreXPath.parse(directoryPath);
                Object obj = this.queryUtils.getObjectProp(currentContext.getStore(), dirStorePath, CMProperty.DEFAULTNAME, 512);
                if (obj != null) {
                    directoryTitle = obj.toString();
                    currentContext.setCurrentUserDirectoryName(directoryTitle);
                }
            }
            catch (CMException ex) {
                CMIndications.logException(ex);
            }
        }
        if (directoryTitle == null) {
            directoryTitle = directoryClassName;
        }
        String hopCount = Integer.toString(currentContext.getHopCount());
        String ipfCategory = currentContext.getIPFCategory();
        int dotPosition = ipfCategory.indexOf(46);
        if (dotPosition > 0 && (dotPosition = ipfCategory.indexOf(46, dotPosition + 1)) > 0) {
            ipfCategory = ipfCategory.substring(0, dotPosition);
        }
        buf.append("<addInfo:additionalInfo ");
        buf.append("xmlns:addInfo=\"");
        buf.append(CMSOAPConstants.NS_BIBUS.getUri());
        buf.append("\">");
        buf.append("<typedLogger>");
        buf.append(ipfCategory);
        buf.append("</typedLogger>");
        buf.append("<ancestors>");
        buf.append("<value>");
        buf.append("<item>");
        buf.append("<objectClass>");
        buf.append(directoryClassName);
        buf.append("</objectClass>");
        buf.append("<searchPath>");
        buf.append(directoryPath);
        buf.append("</searchPath>");
        buf.append("<title>");
        buf.append(directoryTitle);
        buf.append("</title>");
        buf.append("</item>");
        buf.append("</value>");
        buf.append("</ancestors>");
        buf.append("<productLocale>");
        buf.append(currentContext.getPreference(CMPreference.PRODUCTLOCALE));
        buf.append("</productLocale>");
        buf.append("<contentLocale>");
        buf.append(currentContext.getPreference(CMPreference.CONTENTLOCALE));
        buf.append("</contentLocale>");
        buf.append("<tracking>");
        buf.append("<hopCount>");
        buf.append(hopCount);
        buf.append("</hopCount>");
        buf.append("<requestContext>");
        buf.append(currentContext.getRequestContext());
        buf.append("</requestContext>");
        buf.append("<sessionContext>");
        buf.append(currentContext.getSessionContext());
        buf.append("</sessionContext>");
        buf.append("<stepContext>");
        buf.append(currentContext.getStepContext());
        buf.append("</stepContext>");
        buf.append("</tracking>");
        buf.append("</addInfo:additionalInfo>");
        String str = buf.toString();
        return str;
    }

    public void setWSDLCAMRequest(boolean isWSDLCAMRequest) {
        this.bWSDLCAMRequest_ = isWSDLCAMRequest;
    }

    private void logoff() throws CMException {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append("action");
        sb.append(" xmlns:");
        sb.append("xsi");
        sb.append("=\"");
        sb.append("http://www.w3.org/2001/XMLSchema-instance");
        sb.append("\" xmlns:");
        sb.append("xsd");
        sb.append("=\"");
        sb.append("http://www.w3.org/2001/XMLSchema");
        sb.append("\" ");
        sb.append("xsi");
        sb.append(":");
        sb.append("type");
        sb.append("=\"");
        sb.append("xsd");
        sb.append(":");
        sb.append("string");
        sb.append("\">");
        sb.append("logoff");
        sb.append("</");
        sb.append("action");
        sb.append(">");
        String actionMessage = sb.toString();
        XMLDocParser parser = new XMLDocParser();
        XMLDoc doc = null;
        try {
            doc = parser.readXML(actionMessage);
        }
        catch (Exception e) {
            throw new CMException(e, "cmErrParse");
        }
        XMLElement actionElement = doc.getRootXMLElement();
        this.replaceCAMElementInBiBusHeader(actionElement);
        this.processCAMAction(actionElement.value_);
        this.AuthenticateCAMHeader();
    }

    private void enhancedLog(String sAdvancedSettings, String sMissingContent) throws CMException {
        CMException ex = new CMException("cmHeaderContentRequired", new CMException.Parm("ECname", sMissingContent));
        if (sAdvancedSettings.equalsIgnoreCase("required")) {
            throw ex;
        }
        if (sAdvancedSettings.equalsIgnoreCase("log")) {
            System.out.println(ex.getFullMessage() + "\nCheck the log for more information.");
            CMIndications.logException(ex);
        }
    }

    private void forceCAMFaultWithAnonymousIn() throws CMException {
        CMExecutionContext currentContext = CMExecutionContext.get();
        if (currentContext.getCurrentUser().equals("::Anonymous") && this.isLogon()) {
            XMLElement camSection = this.biBusHeader.getSection("CAM");
            if (camSection != null) {
                camSection.addChild(null, "action", null, null, "logon");
            }
            String sHeader = this.getSOAPHeader().makeXML("", true, true, true, true, currentContext.getCAMAdditionalInfo(), this.biBusHeader.getSection("tracking"));
            try {
                CMServlet.AAA.invoke(sHeader, AAAProvider.Action.LOGON);
            }
            catch (AAAException ae) {
                this.bDoNotLogLevel3Audit_ = true;
                throw new CMException((Exception)((Object)ae), "cmAuthenticateFailed");
            }
        }
    }

    private void lockWaitSleep(long millis) {
        CMExecutionContext ctx = CMExecutionContext.get();
        if (!AdvancedSettings.ENABLELOCKWAIT || !ctx.getCurrentUserIsAdministrator()) {
            return;
        }
        try {
            if (millis >= 30000L) {
                millis = 30000L;
            }
            Thread.sleep(millis);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public XMLElement getOriginalBiBusHeader() {
        return this.origBiBusHeaderElem_;
    }

    public XMLElement getSOAPHeader() {
        return this.biBusHeader.getHeader();
    }

    public Header getHeader() {
        return this.biBusHeader;
    }

    public boolean setInternalRequest(boolean internalRequest) {
        boolean prevState = this.internalRequest;
        this.internalRequest = internalRequest;
        return prevState;
    }

    public boolean isInternalRequest() {
        return this.internalRequest;
    }

    public void setCAMElementPresent(boolean camElementPresent) {
        this.bThereWasACAMElement_ = camElementPresent;
    }

    public boolean camElementPresent() {
        return this.bThereWasACAMElement_;
    }

    public void setCAMTrustedElementPresent(boolean trustedElementPresent) {
        this.bThereWasACAMCredientialElement_ = trustedElementPresent;
    }

    public boolean camTrustedElementPresent() {
        return this.bThereWasACAMCredientialElement_;
    }

    public boolean isCAMElementNotRequired(RequestHandler handler) {
        if (handler == null) {
            return false;
        }
        if (handler.onlyRunHistoryClass_ && (handler instanceof update || handler instanceof add)) {
            return true;
        }
        return handler instanceof logon || handler instanceof logoff;
    }

    public boolean isClonePassportAction() {
        return this.camAction == CamAction.clonePassport;
    }

    private final boolean hasCamAction() {
        return this.camAction != null;
    }

    private final boolean isLogoff() {
        return this.camAction == CamAction.logoff;
    }

    private final boolean isLogon() {
        return this.camAction == CamAction.logon || this.camAction == CamAction.logonAs;
    }

    static {
        g_bFileLogRequestSoap_ = false;
        g_bFileLogRequestSoap_UserOnly_ = true;
        g_fwLogRequestSoap_ = null;
        nMaxRequestSize = 0L;
        nAvgRequestSize = 0L;
        nNumRequests = 0L;
        sSOAPBIBusEmpty = "  \t<bus:biBusHeader " + CMSOAPConstants.NS_XMLSCHEMAINSTANCE.getPrefix() + ":" + "type" + "=\"" + CMSOAPConstants.NS_BIBUS.getPrefix() + ":" + "biBusHeader" + "\"/>" + sEOL;
        baSOAPBIBusEmpty = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusEmpty);
        sSOAPBIBusBegin_Seg1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<SOAP-ENV:Envelope\r\n\t\txmlns:" + CMSOAPConstants.NS_SOAP_ENV.getPrefix() + "=\"";
        baSOAPBIBusBegin_Seg1 = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusBegin_Seg1);
        baSOAPBIBusBegin_Seg2 = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusBegin_Seg2);
        sSOAPBIBusBegin_Seg3 = "\t\txmlns:" + CMSOAPConstants.NS_SOAP_FAULTS.getPrefix() + "=\"" + CMSOAPConstants.NS_SOAP_FAULTS.getUri() + "\"" + sEOL;
        baSOAPBIBusBegin_Seg3 = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusBegin_Seg3);
        sSOAPBIBusBegin_Seg4 = "\t\txmlns:" + CMSOAPConstants.NS_BIBUS.getPrefix() + "=\"" + CMSOAPConstants.NS_BIBUS.getUri() + "\"" + sEOL + "\t\txmlns:" + CMSOAPConstants.NS_SOAP_ENC.getPrefix() + "=\"" + CMSOAPConstants.NS_SOAP_ENC.getUri() + "\"" + sEOL + "\t\txmlns:" + CMSOAPConstants.NS_XMLSCHEMA.getPrefix() + "=\"" + CMSOAPConstants.NS_XMLSCHEMA.getUri() + "\"" + sEOL + "\t\txmlns:" + CMSOAPConstants.NS_XMLSCHEMAINSTANCE.getPrefix() + "=\"" + CMSOAPConstants.NS_XMLSCHEMAINSTANCE.getUri() + "\">" + sEOL + "  <SOAP-ENV:Header>" + sEOL;
        baSOAPBIBusBegin_Seg4 = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusBegin_Seg4);
        sSOAPBIBusBegin_Seg5 = "  \t<bus:biBusHeader " + CMSOAPConstants.NS_XMLSCHEMAINSTANCE.getPrefix() + ":" + "type" + "=\"" + CMSOAPConstants.NS_BIBUS.getPrefix() + ":" + "biBusHeader" + "\">" + sEOL;
        baSOAPBIBusBegin_Seg5 = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusBegin_Seg5);
        baSOAPBIBusBegin_Seg6 = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusBegin_Seg6);
        baSOAPBIBusEnd_Seg1 = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusEnd_Seg1);
        sSOAPBIBusEnd_Seg2_Server = "  <SOAP-ENV:Fault>\r\n\t<faultcode>Server</faultcode>\r\n\t<faultstring>" + CMError.getMessage("cmGeneralCMError", null, null) + "</faultstring>" + sEOL + "\t<detail>" + sEOL;
        baSOAPBIBusEnd_Seg2_Server = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusEnd_Seg2_Server);
        sSOAPBIBusEnd_Seg3_Client = "  <SOAP-ENV:Fault>\r\n\t<faultcode>Client</faultcode>\r\n\t<faultstring>" + CMError.getMessage("cmGeneralClientError", null, null) + "</faultstring>" + sEOL + "\t<detail>" + sEOL;
        baSOAPBIBusEnd_Seg3_Client = CMStringUtils.getUTF8BytesFromString(sSOAPBIBusEnd_Seg3_Client);
        baSOAPRespEnd_Seg1 = CMStringUtils.getUTF8BytesFromString(sSOAPRespEnd_Seg1);
        baSOAPRespEnd_Seg2 = CMStringUtils.getUTF8BytesFromString(sSOAPRespEnd_Seg2);
    }

    public class InternalCAMParsingAction
    extends ParsingPlugin {
        private String passportID;

        public InternalCAMParsingAction(RequestManager requestManager, XMLStreamReader reader, String passportID) {
            super(requestManager, reader);
            this.passportID = passportID;
        }

        @Override
        public XMLStreamReader getParsingDelegate() {
            throw new IllegalStateException("this is internal and has no parsing functionality");
        }

        @Override
        public void parseComplete() throws CMException {
            if (this.passportID != null) {
                RequestManager.this.setPassport(this.passportID);
                RequestManager.this.setCAMElementPresent(true);
            }
        }
    }
}

