/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMNamespacePrefixes;
import java.io.IOException;
import java.util.ListIterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RequestManagerParser
implements EntityResolver,
DTDHandler,
ContentHandler,
ErrorHandler {
    private StringBuffer sLastCharacters_;
    private XMLElement currXMLElement_;
    private boolean bInternalRequest_;
    private int newNSs_;
    private CMNamespacePrefixes nsPrefixes = new CMNamespacePrefixes();
    private XMLDoc xmlRequestDoc_;

    RequestManagerParser(boolean internalRequest) {
        this.bInternalRequest_ = internalRequest;
    }

    public XMLDoc getRequestDoc() {
        return this.xmlRequestDoc_;
    }

    public CMNamespacePrefixes getNamespacePrefixes() {
        return this.nsPrefixes;
    }

    private void writeSAXDebugLog(String sMsg) {
        if (CMIndicationGlobals.bRequestManager_TraceRequestSoap) {
            CMIndications.CMTraceText("Trace.CM.DBG.SAX", 10000, "SAX DEBUG: " + sMsg);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.writeSAXDebugLog("resolveEntity: publicId=" + publicId + " systemId=" + systemId);
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.writeSAXDebugLog("notationDecl: publicId=" + publicId + " systemId=" + systemId);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.writeSAXDebugLog("unparseEntityDecl: name=" + name + " publicId=" + publicId + " systemId=" + systemId + " notationName=" + notationName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.sLastCharacters_ == null) {
            this.sLastCharacters_ = new StringBuffer(length);
            this.sLastCharacters_.append(ch, start, length);
        } else {
            this.sLastCharacters_.append(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.writeSAXDebugLog("endDocument");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currXMLElement_ != null) {
            if (this.currXMLElement_.children_ == null && this.sLastCharacters_ != null) {
                this.currXMLElement_.value_ = this.sLastCharacters_.toString();
            }
            if (this.currXMLElement_.children_ != null && this.bInternalRequest_) {
                ListIterator<XMLElement> iter = this.currXMLElement_.children_.listIterator();
                while (iter.hasNext()) {
                    XMLElement xmlEl = iter.next();
                    if (!xmlEl.nameIs("mlValue")) continue;
                    this.currXMLElement_.value_ = this.currXMLElement_.value_ == null ? xmlEl.value_ : this.currXMLElement_.value_ + xmlEl.value_;
                    iter.remove();
                }
                iter = null;
                if (this.currXMLElement_.children_.size() == 0) {
                    this.currXMLElement_.children_ = null;
                }
            }
            this.currXMLElement_ = this.currXMLElement_.GetBuildParent();
        }
        this.sLastCharacters_ = null;
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.writeSAXDebugLog("endPrefixMapping: prefix=" + prefix);
        if (this.newNSs_ > 0) {
            --this.newNSs_;
        }
        this.nsPrefixes.remove(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.writeSAXDebugLog("ignorableWhitespace: '" + new String(ch, start, length) + "'");
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.writeSAXDebugLog("processingInstruction: target=" + target + " data=" + data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.writeSAXDebugLog("setDocumentLocator: locator={lineNum=" + locator.getLineNumber() + " colNum=" + locator.getColumnNumber() + " publicId=" + locator.getPublicId() + " systemId=" + locator.getSystemId() + "}");
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.writeSAXDebugLog("skippedEntity: name=" + name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.writeSAXDebugLog("startDocument");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.xmlRequestDoc_ == null) {
            this.xmlRequestDoc_ = new XMLDoc(this.nsPrefixes, uri, localName, attributes);
            this.currXMLElement_ = this.xmlRequestDoc_.getRootXMLElement();
        } else if (this.currXMLElement_ != null) {
            this.currXMLElement_ = this.currXMLElement_.addChild(this.nsPrefixes, uri, localName, attributes);
        }
        this.sLastCharacters_ = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.writeSAXDebugLog("startPrefixMapping: prefix=" + prefix + " uri=" + uri);
        ++this.newNSs_;
        this.nsPrefixes.add(prefix, uri);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.writeSAXDebugLog("error: e=" + e.toString());
        throw new SAXException(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.writeSAXDebugLog("fatalError: e=" + e.toString());
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.writeSAXDebugLog("warning: e=" + e.toString());
    }
}

