/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.STAXAttributes;
import com.cognos.cm.server.XMLAttributes;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMNamespacePrefixes;
import java.util.ListIterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RequestManagerStaxParser {
    private StringBuffer sLastCharacters_;
    private XMLElement currXMLElement_;
    private boolean bInternalRequest_;
    private int newNSs_;
    private CMNamespacePrefixes nsPrefixes = new CMNamespacePrefixes();
    private XMLDoc xmlRequestDoc_;
    private XMLStreamReader xmlStreamReader;

    RequestManagerStaxParser(XMLStreamReader reader, boolean internalRequest) {
        this.bInternalRequest_ = internalRequest;
        this.xmlStreamReader = reader;
    }

    public void parse() throws XMLStreamException {
        try {
            while (this.xmlStreamReader.hasNext()) {
                int event = this.xmlStreamReader.next();
                switch (event) {
                    case 1: {
                        this.startPrefixes();
                        STAXAttributes attr = this.getAttributes();
                        String namespaceURI = this.xmlStreamReader.getNamespaceURI() == null ? "" : this.xmlStreamReader.getNamespaceURI();
                        this.startElement(namespaceURI, this.xmlStreamReader.getLocalName(), attr);
                        break;
                    }
                    case 4: 
                    case 12: {
                        String text = this.xmlStreamReader.getText();
                        this.characters(text);
                        break;
                    }
                    case 2: {
                        this.endElement();
                    }
                }
            }
        }
        catch (RuntimeException e) {
            XMLStreamException xmlException = new XMLStreamException(e.getMessage());
            StackTraceElement[] stack = xmlException.getStackTrace();
            if (stack != null) {
                xmlException.setStackTrace(stack);
            }
            throw xmlException;
        }
    }

    private void startPrefixes() {
        int prefixes = this.xmlStreamReader.getNamespaceCount();
        for (int p = 0; p < prefixes; ++p) {
            this.startPrefixMapping(this.xmlStreamReader.getNamespacePrefix(p), this.xmlStreamReader.getNamespaceURI(p));
        }
    }

    private STAXAttributes getAttributes() {
        int num_attributes = this.xmlStreamReader.getAttributeCount();
        STAXAttributes attr = new STAXAttributes(num_attributes);
        for (int a = 0; a < num_attributes; ++a) {
            attr.addAttribute(this.xmlStreamReader.getAttributeLocalName(a), this.xmlStreamReader.getAttributeName(a), this.xmlStreamReader.getAttributeType(a), this.xmlStreamReader.getAttributeNamespace(a), this.xmlStreamReader.getAttributeValue(a));
        }
        return attr;
    }

    public XMLDoc getRequestDoc() {
        return this.xmlRequestDoc_;
    }

    public CMNamespacePrefixes getNamespacePrefixes() {
        return this.nsPrefixes;
    }

    private void writeSAXDebugLog(String sMsg) {
        if (CMIndicationGlobals.bRequestManager_TraceRequestSoap) {
            CMIndications.CMTraceText("Trace.CM.DBG.SAX", 10000, "SAX DEBUG: " + sMsg);
        }
    }

    private void characters(String text) {
        if (this.sLastCharacters_ == null) {
            this.sLastCharacters_ = new StringBuffer(text.length());
            this.sLastCharacters_.append(text);
        } else {
            this.sLastCharacters_.append(text);
        }
    }

    private void endDocument() {
        this.writeSAXDebugLog("endDocument");
    }

    private void endElement() {
        if (this.currXMLElement_ != null) {
            if (this.currXMLElement_.children_ == null && this.sLastCharacters_ != null) {
                this.currXMLElement_.value_ = this.sLastCharacters_.toString();
            }
            if (this.currXMLElement_.children_ != null && this.bInternalRequest_) {
                ListIterator<XMLElement> iter = this.currXMLElement_.children_.listIterator();
                while (iter.hasNext()) {
                    XMLElement xmlEl = iter.next();
                    if (!xmlEl.nameIs("mlValue")) continue;
                    this.currXMLElement_.value_ = this.currXMLElement_.value_ == null ? xmlEl.value_ : this.currXMLElement_.value_ + xmlEl.value_;
                    iter.remove();
                }
                iter = null;
                if (this.currXMLElement_.children_.size() == 0) {
                    this.currXMLElement_.children_ = null;
                }
            }
            this.currXMLElement_ = this.currXMLElement_.GetBuildParent();
        }
        this.sLastCharacters_ = null;
    }

    private void endPrefixMapping(String prefix) {
        this.writeSAXDebugLog("endPrefixMapping: prefix=" + prefix);
        if (this.newNSs_ > 0) {
            --this.newNSs_;
        }
        this.nsPrefixes.remove(prefix);
    }

    private void startDocument() {
        this.writeSAXDebugLog("startDocument");
    }

    private void startElement(String uri, String localName, XMLAttributes attributes) {
        if (this.xmlRequestDoc_ == null) {
            this.xmlRequestDoc_ = new XMLDoc(this.nsPrefixes, uri, localName, attributes);
            this.currXMLElement_ = this.xmlRequestDoc_.getRootXMLElement();
        } else if (this.currXMLElement_ != null) {
            this.currXMLElement_ = this.currXMLElement_.addChild(this.nsPrefixes, uri, localName, attributes);
        }
        this.sLastCharacters_ = null;
    }

    private void startPrefixMapping(String prefix, String uri) {
        this.writeSAXDebugLog("startPrefixMapping: prefix=" + prefix + " uri=" + uri);
        ++this.newNSs_;
        this.nsPrefixes.add(prefix, uri);
    }
}

