/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.request.delete;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IRequestTransactionManager;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathFactory;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cmutils.date.DateUtils;
import com.cognos.cmutils.date.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class RetentionRulesExecutor {
    private CMStore store;
    private IRequestTransactionManager transactionManager;
    private CMStorePathFactory storePathFactory;

    public RetentionRulesExecutor(CMStore store, CMStorePathFactory storePathFactory, IRequestTransactionManager transactionManager) {
        this.store = store;
        this.storePathFactory = storePathFactory;
        this.transactionManager = transactionManager;
    }

    protected CMStore getStore() {
        return this.store;
    }

    protected IRequestTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected CMStorePathFactory getCMStorePathFactory() {
        return this.storePathFactory;
    }

    public boolean executeRetentionRules(CMRetentionRule rule, String path, int obj_id) throws CMException {
        return this.executeRetentionRules(rule, path, obj_id, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeRetentionRules(CMRetentionRule rule, String path, int obj_id, int tenantIDFilter) throws CMException {
        boolean deleted = false;
        CMStoreQueryResults results = null;
        try {
            this.getTransactionManager().beginExecutingRetentionRule();
            results = this.getRetentionRuleResults(this.store, rule, path, tenantIDFilter);
            this.getTransactionManager().commitExecutingRetentionRule();
            if (results == null) {
                boolean bl = false;
                return bl;
            }
            while (results.next()) {
                if (obj_id > 0 && obj_id == results.getObjectID()) {
                    deleted = true;
                }
                this.deleteRetentionRuleResultInTransaction(this.store, results);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
        }
        return deleted;
    }

    private void deleteRetentionRuleResultInTransaction(CMStore store, CMStoreQueryResults results) throws CMException {
        this.getTransactionManager().beginExecutingRetentionRule();
        this.deleteRetentionRuleResult(store, this.getStoreIdBasedPath(results));
        this.getTransactionManager().commitExecutingRetentionRule();
    }

    protected void deleteRetentionRuleResult(CMStore store, String path) throws CMException {
        delete.deleteDescendants(store, path, 512, true);
    }

    public CMStoreQueryResults getRetentionRuleResults(CMStore store, CMRetentionRule rule, String path) throws CMException {
        return this.getRetentionRuleResults(store, rule, path, -1);
    }

    public CMStoreQueryResults getRetentionRuleResults(CMStore store, CMRetentionRule rule, String path, int tenantIDFilter) throws CMException {
        return this.getRetentionRuleResults(false, store, rule, path, tenantIDFilter);
    }

    private CMStoreQueryResults getRetentionRuleResults(boolean returnRetainableObjects, CMStore store, CMRetentionRule rule, String path, int tenantIDFilter) throws CMException, CMStoreParseException {
        CMStoreQueryResults results = null;
        int maxNumber = rule.getMaxObjects();
        String duration = rule.getMaxDuration();
        Date cutOffDate = null;
        Date now = null;
        if (duration != null && duration.length() > 0) {
            now = new Date();
            try {
                Duration durationObj = new Duration(duration);
                cutOffDate = durationObj.subtractFrom(now);
            }
            catch (NumberFormatException e) {
                throw new CMException("cmBadDurationProp", new CMException.Parm("Value", duration));
            }
        }
        if (maxNumber < 1 && cutOffDate == null) {
            return null;
        }
        String basePath = this.getBaseObjectPath(path);
        if (basePath == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(256).append(basePath).append((CharSequence)this.getClassFilter(rule));
        if (maxNumber < 1) {
            String propertyComparator = returnRetainableObjects ? " >= '" : " < '";
            buf.append("[@").append(rule.getProperty().getName()).append(propertyComparator).append(CMDateUtils.getIsoDate(cutOffDate)).append("']");
            CMStoreXPath affectedObjectsPath = this.getCMStorePathFactory().createCMStoreXPath(buf.toString());
            results = store.executeQuery(affectedObjectsPath, null, null, 2, 512, null);
            while (results.next()) {
            }
            results.reset();
        } else {
            CMStoreXPath affectedObjectsPath = this.getCMStorePathFactory().createCMStoreXPath(buf.toString());
            results = store.executeQuery(affectedObjectsPath, new CMProperty[]{rule.getProperty()}, new OrderByField[]{new OrderByField(true, rule.getProperty())}, 2, 512, null);
            HashMap<Integer, Integer> tenantMaxNumMap = new HashMap<Integer, Integer>();
            while (results.next()) {
                Object value;
                Integer tenantID = results.getTenantID();
                if (tenantIDFilter >= 0 && tenantIDFilter != tenantID) {
                    results.exclude();
                    continue;
                }
                int tenantMaxnumber = maxNumber;
                if (!tenantMaxNumMap.containsKey(tenantID)) {
                    tenantMaxNumMap.put(tenantID, tenantMaxnumber);
                } else {
                    tenantMaxnumber = (Integer)tenantMaxNumMap.get(tenantID);
                }
                boolean keep = true;
                if (cutOffDate != null && (value = results.getValue(0)) != null) {
                    Date objDate = DateUtils.parse((String)value.toString());
                    keep = objDate.after(cutOffDate);
                }
                if (returnRetainableObjects) {
                    if (tenantMaxnumber-- <= 0 || !keep) {
                        results.exclude();
                    }
                } else if (tenantMaxnumber-- > 0 && keep) {
                    results.exclude();
                }
                tenantMaxNumMap.put(tenantID, tenantMaxnumber);
            }
            results.reset();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBaseObjectPath(String path) throws CMException {
        if (!ConfigurationFactory.getConfig().namesHaveTenantScope()) {
            return path;
        }
        CMStoreXPath xpath = this.getCMStorePathFactory().createCMStoreXPath(path);
        CMStoreQueryResults results = this.store.executeQuery(xpath, null, null, 0, 0, null);
        try {
            if (results.next()) {
                String string = this.getStoreIdBasedPath(results);
                return string;
            }
        }
        finally {
            results.release();
        }
        return null;
    }

    protected String getStoreIdBasedPath(CMStoreQueryResults results) throws CMException {
        int id = results.getObjectID();
        return CMStoreXPath.encodeStoreIdToPathString(this.store.getObjectStoreID(id));
    }

    private StringBuilder getClassFilter(CMRetentionRule rule) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("/*[");
        ArrayList<CMObjectClass> classes = rule.getObjectClass().getDerivedClasses();
        for (int i = 0; i < classes.size(); ++i) {
            CMObjectClass cls = classes.get(i);
            if (i != 0) {
                buf.append(" or ");
            }
            buf.append("@objectClass='").append(cls.getName()).append('\'');
        }
        buf.append(']');
        return buf;
    }

    public CMStoreQueryResults getKeepRetentionRuleResults(CMStore store, CMRetentionRule rule, String path) throws CMException {
        return this.getRetentionRuleResults(true, store, rule, path, -1);
    }
}

