/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.server.Header;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLElement;
import java.util.ArrayList;
import java.util.ListIterator;

public class SOAPHeader
implements Header {
    private XMLElement xmlBiBusHeader;
    public static final String BIBUS_TYPE_HDRSESSION = "hdrSession";
    public static final String BIBUS_TYPE_SETCOOKIEVAR = "setCookieVar";
    public static final String BIBUS_ELEM_SETCOOKIEVARS = "setCookieVars";
    public static final String BIBUS_TYPE_USERPREFERENCEVAR = "userPreferenceVar";
    public static final String BIBUS_ELEM_CAMPROTECT = "CAMProtect";
    public static final String BIBUS_ELEM_PROVIDERS = "providers";
    public static final String BIBUS_ELEM_USERPREFERENCE = "userPreferenceVars";

    public void setHeader(XMLElement header) {
        this.xmlBiBusHeader = header;
    }

    public XMLElement getHeader() {
        return this.xmlBiBusHeader;
    }

    void removeElementFromBiBusHeader(String elementName) {
        if (this.xmlBiBusHeader == null) {
            return;
        }
        this.xmlBiBusHeader.deleteChildWithName(elementName);
    }

    void removeHeaderSessionSectionItemNamed(String sectionName, String itemName) {
        XMLElement hdrSessionElem = this.getSection(BIBUS_TYPE_HDRSESSION);
        if (null != hdrSessionElem) {
            XMLElement sectionElement = hdrSessionElem.getOptionalChildWithName(sectionName);
            this.removeElementFromSection(itemName, sectionElement);
        }
    }

    private void removeElementFromSection(String itemName, XMLElement sectionElement) {
        if (sectionElement != null && sectionElement.children_ != null) {
            for (XMLElement itemElement : sectionElement.children_) {
                XMLElement itemNameElement = itemElement.getOptionalChildWithName("name");
                if (null == itemNameElement || itemNameElement.value_ == null || !itemNameElement.value_.equals(itemName)) continue;
                sectionElement.children_.remove(itemElement);
                return;
            }
        }
    }

    XMLElement getSection(String sectionName) {
        return this.xmlBiBusHeader.getOptionalChildWithName(sectionName);
    }

    String getValueWithName(String section, String subSection, String nameToFind) {
        XMLElement valueEl;
        XMLElement xmlEl = this.getItemWithName(section, subSection, nameToFind);
        if (xmlEl != null && (valueEl = xmlEl.getOptionalChildWithName("value")) != null) {
            return valueEl.value_ == null ? "" : valueEl.value_;
        }
        return null;
    }

    XMLElement getItemWithName(String section, String subSection, String name) {
        if (this.xmlBiBusHeader == null) {
            return null;
        }
        XMLElement xmlEl = this.xmlBiBusHeader.getOptionalChildWithName(section);
        if (xmlEl == null) {
            return null;
        }
        if (subSection != null && (xmlEl = xmlEl.getOptionalChildWithName(subSection)) == null) {
            return null;
        }
        if (!xmlEl.hasChildren()) {
            return null;
        }
        for (XMLElement child : xmlEl.children_) {
            String childName = child.getOptionalChildValueWithName("name");
            if (childName == null || !childName.equals(name)) continue;
            return child;
        }
        return null;
    }

    private void setOtherValueInHeaderValue(String headerSection, String sessionSection, String valueName, String otherTagType, String otherTagName, String theValue, boolean onlySetIfEmpty) {
        XMLElement xmlEl = this.getItemWithName(headerSection, sessionSection, valueName);
        if (xmlEl == null) {
            return;
        }
        XMLElement elValue = xmlEl.getOptionalChildWithName(otherTagName);
        if (elValue != null) {
            if (!onlySetIfEmpty) {
                elValue.value_ = theValue;
            }
        } else {
            xmlEl.addChild(null, otherTagName, CMSOAPConstants.NS_XMLSCHEMA, otherTagType, theValue);
        }
    }

    @Override
    public void setUserPreferenceValue(String valueName, String theValue) {
        this.setHeaderValue(BIBUS_ELEM_USERPREFERENCE, BIBUS_TYPE_USERPREFERENCEVAR, null, null, valueName, theValue);
    }

    private void setHeaderValue(String headerSection, String headerSectionType, String sessionSection, String sessionSectionType, String valueName, String theValue) {
        if (this.xmlBiBusHeader == null) {
            return;
        }
        String arrayItemType = headerSectionType;
        XMLElement varContainerEL = this.xmlBiBusHeader.getOptionalChildWithNameEvenIfNil(headerSection);
        if (varContainerEL != null && varContainerEL.isNil_) {
            this.xmlBiBusHeader.deleteChildWithName(headerSection);
            varContainerEL = null;
        }
        if (varContainerEL == null) {
            varContainerEL = this.xmlBiBusHeader.addChild((CMSOAPConstants.XMLNamespace)null, headerSection, CMSOAPConstants.NS_BIBUS, headerSectionType);
            if (sessionSection == null) {
                varContainerEL.isArray_ = true;
            }
        }
        if (sessionSection != null) {
            arrayItemType = sessionSectionType;
            XMLElement headerSectionEl = varContainerEL;
            if ((varContainerEL = headerSectionEl.getOptionalChildWithNameEvenIfNil(sessionSection)) != null && varContainerEL.isNil_) {
                headerSectionEl.deleteChildWithName(sessionSection);
                varContainerEL = null;
            }
            if (varContainerEL == null) {
                varContainerEL = headerSectionEl.addChild((CMSOAPConstants.XMLNamespace)null, sessionSection, CMSOAPConstants.NS_BIBUS, arrayItemType);
                varContainerEL.isArray_ = true;
            }
        }
        ArrayList<XMLElement> childList = varContainerEL.getChildren();
        XMLElement xmlElChild = null;
        if (childList != null) {
            ListIterator iter = childList.listIterator();
            while (iter.hasNext()) {
                xmlElChild = (XMLElement)iter.next();
                String name = xmlElChild.getOptionalChildValueWithName("name");
                if (name == null || !name.equalsIgnoreCase(valueName)) continue;
                XMLElement elValue = xmlElChild.getOptionalChildWithName("value");
                if (elValue != null) {
                    elValue.value_ = theValue;
                }
                return;
            }
        }
        this.createCookieItem(valueName, theValue, arrayItemType, varContainerEL);
    }

    @Override
    public void setCookie(String name, String value, String maxAge) {
        this.setHeaderValue(BIBUS_TYPE_HDRSESSION, BIBUS_TYPE_HDRSESSION, BIBUS_ELEM_SETCOOKIEVARS, BIBUS_TYPE_SETCOOKIEVAR, name, value);
        this.setMaxAgeForCookie(name, maxAge);
    }

    @Override
    public void setCookie(String name, String value, String maxAge, boolean onlySetMaxAgeIfEmpty) {
        this.setHeaderValue(BIBUS_TYPE_HDRSESSION, BIBUS_TYPE_HDRSESSION, BIBUS_ELEM_SETCOOKIEVARS, BIBUS_TYPE_SETCOOKIEVAR, name, value);
        this.setMaxAgeForCookie(name, maxAge, onlySetMaxAgeIfEmpty);
    }

    @Override
    public void setMaxAgeForCookie(String cookieName, String maxAge) {
        this.setMaxAgeForCookie(cookieName, maxAge, false);
    }

    @Override
    public String getCookie(String name) {
        return this.getValueWithName(BIBUS_TYPE_HDRSESSION, BIBUS_ELEM_SETCOOKIEVARS, name);
    }

    public Integer getCookieMaxAge(String name) {
        XMLElement elCookie = this.getItemWithName(BIBUS_TYPE_HDRSESSION, BIBUS_ELEM_SETCOOKIEVARS, name);
        if (elCookie == null) {
            return null;
        }
        XMLElement elMaxAge = elCookie.getOptionalChildWithName("maxAge");
        if (elMaxAge == null || elMaxAge.value_ == null) {
            return null;
        }
        try {
            return new Integer(elMaxAge.value_);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void setMaxAgeForCookie(String cookieName, String maxAge, boolean onlySetIfEmpty) {
        this.setOtherValueInHeaderValue(BIBUS_TYPE_HDRSESSION, BIBUS_ELEM_SETCOOKIEVARS, cookieName, "int", "maxAge", maxAge, onlySetIfEmpty);
    }

    private void createCookieItem(String valueName, String theValue, String arrayItemType, XMLElement varContainerEL) {
        XMLElement xmlElChild = varContainerEL.addChild((CMSOAPConstants.XMLNamespace)null, "item", CMSOAPConstants.NS_BIBUS, arrayItemType);
        xmlElChild.addChild(null, "name", CMSOAPConstants.NS_XMLSCHEMA, "string", valueName);
        xmlElChild.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, "string", theValue);
    }

    void ensureBiBusHeaderExists(XMLDoc requestDoc) {
        XMLElement xmlEl = requestDoc.getRootXMLElement();
        XMLElement xmlElSOAPHeader = xmlEl.getOptionalChildWithName(CMSOAPConstants.NS_SOAP_ENV, "Header");
        if (xmlElSOAPHeader == null) {
            xmlElSOAPHeader = xmlEl.addChild(CMSOAPConstants.NS_SOAP_ENV, "Header", null, null);
        }
        this.setHeader(xmlElSOAPHeader.getOptionalChildWithName(CMSOAPConstants.NS_BIBUS, "biBusHeader"));
        if (this.xmlBiBusHeader == null) {
            this.setHeader(xmlElSOAPHeader.addChild(CMSOAPConstants.NS_BIBUS, "biBusHeader", CMSOAPConstants.NS_BIBUS, "biBusHeader"));
        }
        this.xmlBiBusHeader.name_ = "biBusHeader";
        this.xmlBiBusHeader.xmlNamespace_ = CMSOAPConstants.NS_BIBUS;
        this.xmlBiBusHeader.attributes_ = null;
        this.xmlBiBusHeader.xsiTypeNs_ = CMSOAPConstants.NS_BIBUS;
        this.xmlBiBusHeader.xsiType_ = "biBusHeader";
    }
}

