/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMLocalizedString;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMLocaleUtils;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cmutils.path.SearchPathEncoder;
import com.cognos.cmutils.resource.CMResourceLoader;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class UpdateInitialContentNames {
    private static final String[] INIT_SCRIPTS = new String[]{"CMCreateBaseObjectsScript.xml", "initialContent/001.CMCreateWSRPObjects.xml", "initialContent/002.CMCreatePageletObjects.xml", "initialContent/004.CMCreateUserInterfaceProfiles.xml"};
    private static final String CONFIG_SCRIPT = "updateInitialContentNames.xml";
    private Locale defaultLocale;
    private ArrayList<CMStringLocale> cmLocales;
    private ArrayList<Locale> jdkLocales;
    private ArrayList<Locale> initLocales;
    private ArrayList<CMException> errors;
    private CMStore store;
    private ICMLockManager lockMgr;

    public static CMException execute(CMStore store, String advSetting) {
        UpdateInitialContentNames update2 = new UpdateInitialContentNames();
        List<String> locales = update2.loadLocales(advSetting);
        return update2.update(store, locales);
    }

    public static CMException execute(CMStore store) {
        UpdateInitialContentNames update2 = new UpdateInitialContentNames();
        List<String> locales = update2.loadLocales(ConfigurationFactory.getConfig());
        return update2.update(store, locales);
    }

    public CMException formatMessages() {
        if (this.errors == null) {
            CMException e = new CMException("cmUpdateInitialContentNamesSucceeded");
            e.ErrorLevel = 20000;
            return e;
        }
        StringBuilder buf = new StringBuilder();
        for (CMException e : this.errors) {
            buf.append(" ");
            buf.append(e.getMessage(null));
        }
        return new CMException("cmUpdateInitialContentNamesMessages", new CMException.Parm("messages", buf.toString()));
    }

    public List<String> loadLocales(IConfiguration config) {
        String fileName = config.getConfigurationDirectory() + File.separator + CONFIG_SCRIPT;
        File file = new File(fileName);
        if (!file.exists()) {
            return Collections.emptyList();
        }
        List<String> locales = Collections.emptyList();
        try {
            FileInputStream is = new FileInputStream(file);
            locales = this.loadConfigFromStream(is);
            is.close();
            file.delete();
        }
        catch (Exception e) {
            this.addError("cmBadConfigFile", new CMException.Parm("File", CONFIG_SCRIPT));
        }
        return locales;
    }

    public List<String> loadLocales(String advSetting) {
        if (advSetting == null) {
            return Collections.emptyList();
        }
        return CMStringUtils.split(advSetting, ',', true);
    }

    public CMException update(CMStore store, List<String> locales) {
        if (locales.size() == 0) {
            return null;
        }
        this.store = store;
        this.lockMgr = store.getLockManager();
        this.defaultLocale = ConfigurationFactory.getConfig().getServerLocale().toLocale();
        if (this.mapLocales(locales)) {
            ArrayList<AddRequest> requests = this.getInitialObjects();
            this.updateObjects(requests);
        }
        return this.formatMessages();
    }

    protected ArrayList<String> loadConfigFromStream(InputStream is) throws DocumentException {
        SAXReader reader = new SAXReader();
        Element root = reader.read(is).getRootElement().element("locales");
        ArrayList<String> result = new ArrayList<String>();
        if (root != null) {
            for (Element el : root.elements()) {
                result.add(el.getText().trim());
            }
        }
        return result;
    }

    protected boolean mapLocales(List<String> locales) {
        ArrayList<String> initLocales = CMLocaleUtils.getInitLocales();
        this.cmLocales = new ArrayList();
        this.jdkLocales = new ArrayList();
        IConfiguration config = ConfigurationFactory.getConfig();
        for (String localeName : locales) {
            CMStringLocale cmLocale = null;
            try {
                String localeID = config.normalizeLocale(localeName);
                if (config.validateContentLocale(localeID)) {
                    cmLocale = CMDbStoreStringLocales.findLocale(localeID);
                }
            }
            catch (Exception localeID) {
                // empty catch block
            }
            if (cmLocale == null) {
                this.addError("cmBadContentLocale", new CMException.Parm("Locale", localeName));
                continue;
            }
            if (!initLocales.contains(cmLocale.getLocaleID())) {
                this.addError("cmErrMissingResourceFiles", new CMException.Parm("Locale", localeName));
                continue;
            }
            Locale locale = CMLocaleUtils.parseLocale(cmLocale.getLocaleID());
            this.cmLocales.add(cmLocale);
            this.jdkLocales.add(locale);
        }
        if (this.errors != null) {
            this.cmLocales.clear();
            this.jdkLocales.clear();
            return false;
        }
        this.initLocales = new ArrayList(initLocales.size());
        for (String locale : initLocales) {
            this.initLocales.add(CMLocaleUtils.parseLocale(locale));
        }
        return true;
    }

    private void updateObjects(ArrayList<AddRequest> requests) {
        for (AddRequest request : requests) {
            CMStoreXPath parentPath = null;
            if (request.children.size() > 1) {
                parentPath = this.resolveParent(request.parentPath);
            } else {
                try {
                    parentPath = new CMStoreXPath(request.parentPath);
                }
                catch (CMStoreParseException cMStoreParseException) {
                    // empty catch block
                }
            }
            if (parentPath == null) {
                this.addError("cmExportObjectNotFound", new CMException.Parm("Path", request.parentPath));
                continue;
            }
            for (Entry object : request.children) {
                if (this.updateObject(parentPath, object)) continue;
                this.addError("cmUpdateFailed1", new CMException.Parm("path", this.buildObjectPath(request.parentPath, object)));
            }
        }
    }

    private String buildObjectPath(String parent, Entry object) {
        String name = this.mapResourceId(object.nameID, this.defaultLocale);
        StringBuilder buf = new StringBuilder(64);
        buf.append(parent);
        if (!parent.equals("/")) {
            buf.append("/");
        }
        buf.append(object.className);
        buf.append("[@name='");
        buf.append(SearchPathEncoder.signleQuoteString((String)name));
        buf.append("']");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateObject(CMStoreXPath parentPath, Entry object) {
        CMStoreQueryResults rs;
        block24: {
            boolean bl;
            block23: {
                rs = null;
                ArrayList<CMProperty> lprops = new ArrayList<CMProperty>(2);
                ArrayList<Object> lvalues = new ArrayList<Object>(2);
                lprops.add(CMProperty.NAME);
                if (object.descriptionID != null) {
                    lprops.add(CMProperty.DESCRIPTION);
                }
                CMProperty[] props = lprops.toArray(new CMProperty[lprops.size()]);
                CMStoreXPath path = null;
                try {
                    path = this.buildUpdatePath(parentPath, object);
                    if (path == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    this.lockMgr.requestLocks(path);
                    rs = this.store.executeQuery(path, props, null, 7, 512, null);
                    if (rs.next()) {
                        CMDbStoreLocalizedStringArray value = (CMDbStoreLocalizedStringArray)rs.getValue(0);
                        this.addLocales(value, object.nameID);
                        lvalues.add(value);
                        if (object.descriptionID != null) {
                            value = (CMDbStoreLocalizedStringArray)rs.getValue(1);
                            if (value != null) {
                                this.addLocales(value, object.descriptionID);
                            }
                            lvalues.add(value);
                        }
                        if (rs.next()) {
                            bl = false;
                            CMQueryUtils.safeQueryResultsRelease(rs);
                            break block23;
                        }
                        rs.reset();
                        this.store.beginTransaction();
                        this.store.update(rs, lprops, lvalues);
                        this.store.commitTransaction();
                    }
                    CMQueryUtils.safeQueryResultsRelease(rs);
                    break block24;
                }
                catch (CMException e) {
                    boolean bl3 = false;
                    return bl3;
                }
            }
            try {
                this.store.rollbackOpenTransaction();
            }
            catch (CMException cMException) {
                // empty catch block
            }
            this.releaseLocks();
            return bl;
        }
        try {
            this.store.rollbackOpenTransaction();
        }
        catch (CMException value) {
            // empty catch block
        }
        this.releaseLocks();
        return true;
        finally {
            CMQueryUtils.safeQueryResultsRelease(rs);
            try {
                this.store.rollbackOpenTransaction();
            }
            catch (CMException cMException) {}
            this.releaseLocks();
        }
    }

    private void addLocales(CMDbStoreLocalizedStringArray value, String resourceID) {
        for (int i = 0; i < this.cmLocales.size(); ++i) {
            CMLocalizedString lstring = value.get(this.cmLocales.get(i));
            if (lstring != null) continue;
            String newString = this.mapResourceId(resourceID, this.jdkLocales.get(i));
            lstring = new CMDbStoreLocalizedString(this.cmLocales.get(i), newString);
            value.add(lstring);
        }
    }

    protected CMStoreXPath buildUpdatePath(CMStoreXPath parentPath, Entry object) {
        StringBuilder buf = new StringBuilder();
        buf.append(object.className);
        String sep = "[";
        for (Locale locale : this.initLocales) {
            String name = this.mapResourceId(object.nameID, locale);
            buf.append(sep);
            buf.append("@name='");
            buf.append(SearchPathEncoder.signleQuoteString((String)name));
            buf.append("'");
            sep = " or ";
        }
        buf.append("]");
        try {
            CMStoreXPath path = new CMStoreXPath(parentPath, buf.toString(), false);
            path.setLockManagerUsageFlag(13);
            return path;
        }
        catch (CMStoreParseException cMStoreParseException) {
            return null;
        }
    }

    private void releaseLocks() {
        try {
            this.lockMgr.releaseLocks();
        }
        catch (CMException cMException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMStoreXPath resolveParent(String path) {
        CMStoreQueryResults rs;
        block3: {
            CMStoreXPath cMStoreXPath;
            rs = null;
            try {
                rs = this.store.executeQuery(path, null, null, 0, 8704, null);
                if (!rs.next()) break block3;
                int cmid = rs.getObjectID();
                InternalStoreId storeID = this.store.getInternalStoreId(cmid);
                if (rs.next()) break block3;
                cMStoreXPath = CMStoreXPath.fromStoreID(storeID.stringValue());
            }
            catch (CMException cMException) {
                CMQueryUtils.safeQueryResultsRelease(rs);
                this.releaseLocks();
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(rs);
                this.releaseLocks();
                throw throwable;
            }
            CMQueryUtils.safeQueryResultsRelease(rs);
            this.releaseLocks();
            return cMStoreXPath;
        }
        CMQueryUtils.safeQueryResultsRelease(rs);
        this.releaseLocks();
        return null;
    }

    protected ArrayList<AddRequest> getInitialObjects() {
        ArrayList<AddRequest> result = new ArrayList<AddRequest>();
        SAXReader reader = new SAXReader();
        CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
        for (String script : INIT_SCRIPTS) {
            InputStream is = resourceLoader.getResourceInputStream("/WEB-INF/cm/" + script);
            Element root = null;
            if (is != null) {
                try {
                    root = reader.read(is).getRootElement();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (root == null) {
                this.addError("cmNoConfigScript", new CMException.Parm("Resource", script));
                continue;
            }
            result.addAll(this.getInitialObjectsFromDocument(root));
        }
        return result;
    }

    private void addError(CMException e) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        this.errors.add(e);
    }

    private void addError(String id, CMException.Parm param) {
        this.addError(new CMException(id, param));
    }

    protected ArrayList<AddRequest> getInitialObjectsFromDocument(Element root) {
        ArrayList<AddRequest> result = new ArrayList<AddRequest>();
        List addRequests = XMLUtils.selectNodes((Element)root, (String)"/*/*[local-name()=\"Body\"]/*[local-name()=\"add\"]/requests/*");
        for (Element addRequest : addRequests) {
            String parent = this.getParentPath(addRequest);
            if (parent == null) continue;
            AddRequest request = new AddRequest(parent);
            for (Element object : this.elements(addRequest.element("objects"), null)) {
                String nameID = this.getProperty(object, "nameID");
                if (nameID == null) continue;
                String descriptionId = this.getProperty(object, "descriptionID");
                String cls = this.getEntryType(object);
                if (cls == null) continue;
                request.children.add(new Entry(cls, nameID, descriptionId));
            }
            if (request.children.isEmpty()) continue;
            result.add(request);
        }
        return result;
    }

    private String getEntryType(Element el) {
        int idx;
        String type = el.attributeValue("type");
        if (type != null && (idx = type.indexOf(58)) != -1) {
            type = type.substring(idx + 1);
        }
        return type;
    }

    private String getParentPath(Element addRequest) {
        Element search = addRequest.element("search");
        if (search == null) {
            return null;
        }
        if (search.isTextOnly()) {
            return search.getText();
        }
        StringBuilder buf = new StringBuilder();
        for (Element mlValue : this.elements(search, "mlValue")) {
            String msgId = mlValue.attributeValue("msgId");
            if (msgId != null) {
                buf.append(this.mapResourceId(msgId, this.defaultLocale));
                continue;
            }
            buf.append(mlValue.getText());
        }
        return buf.toString();
    }

    private String getProperty(Element el, String name) {
        Element prop = el.element(name);
        if (prop != null) {
            return prop.element("value").getText();
        }
        return null;
    }

    private List<Element> elements(Element el, String name) {
        return name == null ? el.elements() : el.elements(name);
    }

    protected String mapResourceId(String id, Locale locale) {
        return CMError.getRLMessage(id, locale);
    }

    static class AddRequest {
        String parentPath;
        ArrayList<Entry> children;

        AddRequest(String parent) {
            this.parentPath = parent;
            this.children = new ArrayList();
        }
    }

    static class Entry {
        String className;
        String nameID;
        String descriptionID;

        public Entry(String cls, String name, String descr) {
            this.className = cls;
            this.nameID = name;
            this.descriptionID = descr;
        }
    }
}

