/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.CMPreference;
import java.util.HashMap;
import java.util.Map;

public class UserPreferences {
    private HashMap preferences_;

    public UserPreferences() {
        this.preferences_ = new HashMap();
        for (CMPreference pref : CMPreference.allPreferences.values()) {
            if (pref.isOptional()) continue;
            this.preferences_.put(pref, null);
        }
    }

    public UserPreferences(UserPreferences src) {
        this.preferences_ = (HashMap)src.preferences_.clone();
    }

    public Iterator iterator() {
        return new Iterator(this.preferences_);
    }

    public void clear() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            CMPreference pref = it.next();
            if (pref.isOptional()) {
                it.remove();
                continue;
            }
            it.setValue(null);
        }
    }

    public boolean isClear() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            CMPreference pref = it.next();
            if (it.getValue() == null && !pref.isOptional()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllSet() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            CMPreference pref = it.next();
            if (it.getValue() != null || pref.isOptional()) continue;
            return false;
        }
        return true;
    }

    public void setDefaultValues() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            CMPreference pref = it.next();
            String value = it.getValue();
            if (value != null) continue;
            it.setValue(pref.getDefaultValue());
        }
    }

    public String get(CMPreference pref) {
        return (String)this.preferences_.get(pref);
    }

    public void set(CMPreference pref, String value) {
        this.preferences_.put(pref, value);
    }

    public static class Iterator {
        private java.util.Iterator it_;
        private Map.Entry currentEntry_ = null;

        private Iterator(HashMap map) {
            this.it_ = map.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.it_.hasNext();
        }

        public CMPreference next() {
            this.currentEntry_ = (Map.Entry)this.it_.next();
            return this.getKey();
        }

        public String getValue() {
            return (String)this.currentEntry_.getValue();
        }

        public CMPreference getKey() {
            return (CMPreference)this.currentEntry_.getKey();
        }

        public void setValue(String value) {
            this.currentEntry_.setValue(value);
        }

        public void remove() {
            this.it_.remove();
        }
    }
}

