/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.CAM.AAAException;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.UserSessionCacheEntry;
import com.cognos.cm.server.UserSessionsVisitor;
import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfMonitor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.SortedSet;
import java.util.TreeSet;

public class UserSessionCache {
    public static final PerfCounter PERF_COUNTER_SESSIONS_TOTAL = PerfMonitor.getCounter((String)"com.cognos.cm.server.sessions.total", (String)"The number of currently active user sessions.", (int)6);
    protected static final PerfCounter PERF_COUNTER_SESSIONS_ANONYM = PerfMonitor.getCounter((String)"com.cognos.cm.sessions.anonymous", (String)"The number of current anonymous sessions", (int)6);
    protected static final PerfCounter PERF_COUNTER_SESSIONS_AUTHOR = PerfMonitor.getCounter((String)"com.cognos.cm.sessions.authorized", (String)"The number of current authorized sessions", (int)6);
    protected static final PerfCounter PERF_COUNTER_SESSIONS_SYS_ADMIN = PerfMonitor.getCounter((String)"com.cognos.cm.sessions.sysadmin", (String)"The number of current sysadmin sessions", (int)6);
    protected static final PerfCounter PERF_COUNTER_SESSIONS_TENANT_ADMIN = PerfMonitor.getCounter((String)"com.cognos.cm.sessions.tenantadmin", (String)"The number of current tenant admin sessions", (int)6);
    protected Hashtable<String, UserSessionCacheEntry> passportIds_ = null;
    private Hashtable<Integer, SortedSet<String>> accountIds_ = null;
    private Hashtable<Integer, Integer> sessionIds_ = null;

    UserSessionCache(int initialCapacity) {
        this.passportIds_ = new Hashtable(initialCapacity);
        this.accountIds_ = new Hashtable(initialCapacity);
        this.sessionIds_ = new Hashtable(initialCapacity);
    }

    int size() {
        return this.passportIds_.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateOverPassports(UserSessionsVisitor action) {
        Hashtable<String, UserSessionCacheEntry> hashtable = this.passportIds_;
        synchronized (hashtable) {
            for (String passportId : this.passportIds_.keySet()) {
                UserSessionCacheEntry entry = this.passportIds_.get(passportId);
                action.visit(passportId, entry);
            }
        }
    }

    public void removePassport(String passport) {
        if (passport == null) {
            return;
        }
        UserSessionCacheEntry entry = this.passportIds_.remove(passport);
        if (entry != null) {
            entry.delete();
        }
        this.removeAccountPassport(entry);
    }

    public UserSessionCacheEntry lookupPassport(String passport) {
        UserSessionCacheEntry entry = null;
        if (passport != null) {
            entry = this.passportIds_.get(passport);
        }
        return entry;
    }

    public String lookupSessionContextByPassport(String passport) {
        String sessionContext = null;
        UserSessionCacheEntry entry = this.lookupPassport(passport);
        if (entry != null) {
            sessionContext = entry.getSessionContext();
        }
        return sessionContext;
    }

    public UserSessionCacheEntry addEntry(UserSessionCacheEntry entry) throws CMException {
        String passportID = entry.accManPassportID_;
        UserSessionCacheEntry existingEntry = this.passportIds_.get(passportID);
        if (existingEntry == null) {
            if (!entry.isValid()) {
                this.logoffAndThrowInvalidPassport(passportID);
            }
            this.passportIds_.put(entry.accManPassportID_, entry);
            this.addAccountPassport(entry, entry.getCurrentUserAccountObjectID());
            return entry;
        }
        return existingEntry;
    }

    public SortedSet<String> getPassportIds(int nAccountId) {
        return this.accountIds_.get(new Integer(nAccountId));
    }

    public boolean containsPassport(String passport) {
        return this.passportIds_.containsKey(passport);
    }

    public boolean containsAccount(int id) {
        return this.accountIds_.containsKey(new Integer(id));
    }

    public void addSessionObjectID(int id) {
        Integer sid = new Integer(id);
        this.sessionIds_.put(sid, sid);
    }

    public boolean containsSession(int id) {
        return this.sessionIds_.containsKey(new Integer(id));
    }

    protected void updateAccount(UserSessionCacheEntry entry, int newId) {
        int oldId = entry.getCurrentUserAccountObjectID();
        if (oldId > 0) {
            this.removeAccountPassport(entry);
        }
        if (newId > 0) {
            this.addAccountPassport(entry, newId);
        }
    }

    private void removeAccountPassport(UserSessionCacheEntry entry) {
        if (entry != null && entry.getCurrentUserAccountObjectID() > 0) {
            Integer uid;
            SortedSet<String> accountPassportIds;
            if (entry.getCurrentSessionObjectID() > 0) {
                Integer sid = new Integer(entry.getCurrentSessionObjectID());
                this.sessionIds_.remove(sid);
            }
            if ((accountPassportIds = this.accountIds_.get(uid = new Integer(entry.getCurrentUserAccountObjectID()))) == null) {
                return;
            }
            accountPassportIds.remove(entry.accManPassportID_);
            if (accountPassportIds.size() == 0) {
                this.accountIds_.remove(uid);
            }
        }
    }

    private void addAccountPassport(UserSessionCacheEntry entry, int id) {
        if (id == 0) {
            return;
        }
        Integer uid = new Integer(id);
        SortedSet<String> accountPassportIds = this.accountIds_.get(uid);
        if (accountPassportIds == null) {
            accountPassportIds = Collections.synchronizedSortedSet(new TreeSet());
            this.accountIds_.put(uid, accountPassportIds);
        }
        accountPassportIds.add(entry.accManPassportID_);
    }

    private void logoffAndThrowInvalidPassport(String passportID) throws CMException {
        try {
            if (passportID != null) {
                AccMan.logoffPassport(passportID);
            }
        }
        catch (AAAException aAAException) {
            // empty catch block
        }
        throw new CMException("cmInvalidPassport");
    }

    public void printCache() {
        Object value;
        Object key;
        System.out.println("CACHE CONTENTS");
        System.out.println("Passports (" + this.passportIds_.size() + "):");
        Enumeration<Object> keys = this.passportIds_.keys();
        int i = 1;
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            value = this.passportIds_.get(key);
            System.out.println(i + ": " + (String)key + " -> " + value);
            ++i;
        }
        System.out.println("Accounts (" + this.accountIds_.size() + "):");
        keys = this.accountIds_.keys();
        i = 1;
        while (keys.hasMoreElements()) {
            key = (Integer)keys.nextElement();
            value = this.accountIds_.get(key);
            System.out.println(i + ": " + key + " -> " + value);
            ++i;
        }
    }
}

