/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.cam.AAAProvider_OpenIDProxy;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AccManAuthResponse;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ExtendedUserCapabilities;
import com.cognos.cm.server.RequestManager;
import com.cognos.cm.server.UserPreferences;
import com.cognos.cm.server.UserSessionCache;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.profileSettings.ProfilesManager;
import com.cognos.cm.server.profileSettings.SessionProfileSettings;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreDuplicateObject;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMAAAObjectPropertiesDoc;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMQueryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class UserSessionCacheEntry
implements Cloneable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public String accManPassportID_;
    public String sessionContext_;
    private String currentUser_;
    private Boolean isAnonymousUser_;
    private boolean isMultipleNamespaceSession_;
    public String currentUserDisplayName_;
    public String currentUserAncestorsLocale_;
    public List<String> currentUserAncestors_;
    public ArrayList<String> currentUserAncestorsNames_;
    public ArrayList<String> currentUserAncestorsClasses_;
    public ArrayList<String> currentUserAncestorsPaths_;
    public ArrayList<String> currentUserAncestorsStoreIDs_;
    public String currentUserSearchPath_;
    public ArrayList<CMObjectReference> currentUserIdentity_;
    public String currentUserPath_;
    public String currentUserInternalPath_;
    private String[] currentUserNamespaces_ = EMPTY_STRING_ARRAY;
    public String currentUserDirectoryName_;
    public UserPreferences userPreferences_ = new UserPreferences();
    private boolean isSystemAdministrator_;
    private boolean isTenantAdministrator_;
    private ExtendedUserCapabilities capabilities;
    public Date creationTime_;
    public HashMap<String, HashSet<String>> currentUserRoutingHints_;
    public SessionProfileSettings profileSettings;
    public long lastAuthenticateTimeMillis_ = 1L;
    private int currentUserAccountObjectID_;
    private int currentSessionObjectID_;
    private int tenantId_;
    private int[] readTenantIds_;
    private int[] boundedTenantIds_;

    public UserSessionCacheEntry(String passport) {
        this.init(passport);
        this.Authenticated();
    }

    public UserSessionCacheEntry(AccManAuthResponse authRsp, boolean createProxy) throws CMException {
        this.processUserInfo(authRsp, createProxy);
        this.init(this.accManPassportID_);
        this.Authenticated();
    }

    public Object clone() {
        UserSessionCacheEntry result = null;
        try {
            result = (UserSessionCacheEntry)super.clone();
            result.userPreferences_ = new UserPreferences(this.userPreferences_);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return result;
    }

    public boolean isValid() {
        return this.accManPassportID_ != null && this.currentUser_ != null && this.currentUserAccountObjectID_ > 0;
    }

    private void init(String passport) {
        this.creationTime_ = CMDateUtils.getTime();
        this.accManPassportID_ = passport;
    }

    public int getCurrentUserAccountObjectID() {
        return this.currentUserAccountObjectID_;
    }

    public void setCurrentUserAccountObjectID(int id) {
        this.currentUserAccountObjectID_ = id;
    }

    public String toString() {
        return "passportID=" + this.accManPassportID_ + ",creationTime=" + this.creationTime_ + ",accountID=" + this.currentUserAccountObjectID_ + ",currentUser=" + this.currentUser_ + ",currentUserName=" + this.currentUserDisplayName_ + ",lastAuthTime=" + this.lastAuthenticateTimeMillis_;
    }

    public String getSessionContext() {
        return this.sessionContext_;
    }

    public void setSessionContext(String sessionContext) {
        this.sessionContext_ = sessionContext;
    }

    public int getTenantId() {
        return this.tenantId_;
    }

    public void setTenantId(int tenantId) {
        this.tenantId_ = tenantId;
    }

    public int[] getReadTenantIds() {
        return this.readTenantIds_;
    }

    public void setReadTenantIds(int[] tenantIds) {
        this.readTenantIds_ = tenantIds;
    }

    public int[] getBoundedTenantIds() {
        return this.boundedTenantIds_;
    }

    public boolean hasBoundedTenantIds() {
        return this.boundedTenantIds_ != null;
    }

    public String getCurrentUser() {
        return this.currentUser_;
    }

    public boolean isSystemAdministrator() {
        return this.isSystemAdministrator_;
    }

    public boolean isTenantAdministrator() {
        return this.isTenantAdministrator_;
    }

    public boolean isAnonymousUser() {
        if (null != this.isAnonymousUser_) {
            return this.isAnonymousUser_;
        }
        return false;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser_ = currentUser;
    }

    public void setIsSystemAdministrator(boolean b) {
        boolean previousValue = this.isSystemAdministrator_;
        this.isSystemAdministrator_ = b;
        if (b && !previousValue) {
            UserSessionCache.PERF_COUNTER_SESSIONS_SYS_ADMIN.incr();
        }
    }

    private void setIsTenantAdministrator(boolean b) {
        boolean previousValue = this.isTenantAdministrator_;
        this.isTenantAdministrator_ = b;
        if (b && !previousValue) {
            UserSessionCache.PERF_COUNTER_SESSIONS_TENANT_ADMIN.incr();
        }
    }

    private void setIsAnonymousUser(boolean b) {
        if (null == this.isAnonymousUser_) {
            UserSessionCache.PERF_COUNTER_SESSIONS_TOTAL.incr();
        } else if (this.isAnonymousUser_ == Boolean.TRUE) {
            UserSessionCache.PERF_COUNTER_SESSIONS_ANONYM.decr();
        } else if (this.isAnonymousUser_ == Boolean.FALSE) {
            UserSessionCache.PERF_COUNTER_SESSIONS_AUTHOR.decr();
        }
        this.isAnonymousUser_ = b;
        if (this.isAnonymousUser_ == Boolean.TRUE) {
            UserSessionCache.PERF_COUNTER_SESSIONS_ANONYM.incr();
        } else if (this.isAnonymousUser_ == Boolean.FALSE) {
            UserSessionCache.PERF_COUNTER_SESSIONS_AUTHOR.incr();
        }
    }

    private void decrementPerfCounters() {
        if (this.isSystemAdministrator_) {
            UserSessionCache.PERF_COUNTER_SESSIONS_SYS_ADMIN.decr();
        }
        this.isSystemAdministrator_ = false;
        if (this.isTenantAdministrator_) {
            UserSessionCache.PERF_COUNTER_SESSIONS_TENANT_ADMIN.decr();
        }
        this.isTenantAdministrator_ = false;
        if (null != this.isAnonymousUser_) {
            UserSessionCache.PERF_COUNTER_SESSIONS_TOTAL.decr();
        }
        if (this.isAnonymousUser_ == Boolean.TRUE) {
            UserSessionCache.PERF_COUNTER_SESSIONS_ANONYM.decr();
        } else if (this.isAnonymousUser_ == Boolean.FALSE) {
            UserSessionCache.PERF_COUNTER_SESSIONS_AUTHOR.decr();
        }
        this.isAnonymousUser_ = null;
    }

    public int getCurrentSessionObjectID() {
        return this.currentSessionObjectID_;
    }

    public void setCurrentSessionObjectID(int currentSessionObjectID) {
        this.currentSessionObjectID_ = currentSessionObjectID;
    }

    public void delete() {
        if (this.profileSettings != null) {
            this.profileSettings.delete();
            this.profileSettings = null;
        }
        this.decrementPerfCounters();
    }

    public void Authenticated() {
        this.lastAuthenticateTimeMillis_ = System.currentTimeMillis();
    }

    public void processUserInfo(AccManAuthResponse authRsp, boolean createProxy) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        this.accManPassportID_ = authRsp.getPassportID();
        this.sessionContext_ = authRsp.getSessionContext();
        ctx.getContext().setCurrentUserSession(this);
        String trustedCredential = authRsp.getTrustedCredential();
        if (trustedCredential != null) {
            ctx.setTrustedCredential(trustedCredential);
        }
        if (this.setIdentity(authRsp.getQueryResult(), createProxy)) {
            this.resetIdentityDependentProps();
            this.profileSettings = ProfilesManager.getInstance().createSessionProfileSettings(ctx);
            this.initCapabilities();
        }
    }

    protected void initCapabilities() throws CMException {
        this.capabilities = ExtendedUserCapabilities.create(this.getUserCapabilitiesRequiresAccessCheck());
    }

    private boolean getUserCapabilitiesRequiresAccessCheck() {
        if (this.isSystemAdministrator()) {
            return false;
        }
        CMExecutionContext ctx = CMExecutionContext.get();
        RequestManager reqMgr = ctx.getContext().getRequestManager();
        return reqMgr != null && reqMgr.isClonePassportAction();
    }

    private boolean setIdentity(List<XMLElement> items, boolean bCreateProxy) throws CMException {
        if (items == null) {
            return false;
        }
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStore store = ctx.getStore();
        TenantRegistry tenantRegistry = store.getTenantRegistry();
        HashSet<String> namespaces = new HashSet<String>(Arrays.asList(this.currentUserNamespaces_));
        ArrayList<CMObjectReference> members = new ArrayList<CMObjectReference>();
        for (XMLElement el : items) {
            if (el == null) continue;
            CMObjectClass identityClass = AccMan.getObjectClassFromTypeAttr(el.xsiType_);
            String sPath = el.getChildValue("searchPath", "value");
            String sUserID = sPath.startsWith("CAMID") ? CMCAMIDHelper.CAMIDFromSearchPath(sPath) : sPath;
            CMObjectReference ref = null;
            if (this.isAccountObjectClass(identityClass)) {
                if (this.currentUserPath_ == null) {
                    this.currentUserAncestorsLocale_ = CMExecutionContext.get().getCurrentUserContentLocale().getLocaleID();
                    this.currentUserSearchPath_ = sPath;
                    this.setCurrentUser(sUserID);
                    boolean isAnonymous = sUserID.equals("::Anonymous");
                    this.setIsAnonymousUser(isAnonymous);
                    this.setCurrentUserPath(isAnonymous);
                    this.currentUserDisplayName_ = el.getChildValue("defaultName", "value");
                    XMLElement elAncestors = el.getChild("ancestors", "value");
                    if (elAncestors != null) {
                        ArrayList<Ancestor> ancestorsList = this.extractAncestors(elAncestors, sPath);
                        this.setCurrentUserAncestors(ancestorsList);
                    }
                    if (this.currentUserAncestors_ != null) {
                        this.buildInternalUserPath();
                    }
                    this.extractTenancy(tenantRegistry, el);
                }
                ref = this.createAccountObjectReference(ctx, sPath, bCreateProxy);
                if (CMCAMIDHelper.isOpenIDNamespaceObject(sUserID)) {
                    this.saveOpenIdAccountProperties(ref.getSearchPath());
                }
            } else {
                if (sPath.indexOf("::System Administrators") >= 0) {
                    this.setIsSystemAdministrator(true);
                }
                if (sPath.indexOf("::Tenant Administrators") >= 0) {
                    this.setIsTenantAdministrator(true);
                }
                if (sUserID.startsWith(":")) {
                    CMStoreXPath path = (CMStoreXPath)CMStoreXPath.parse(sPath);
                    ref = this.normalizeSecurityReference(store, path, true, false, false, false);
                } else {
                    ref = new CMDbStoreObjectReference(identityClass, sPath, sPath);
                    if (identityClass == CMObjectClass.NAMESPACE) {
                        namespaces.add(sUserID);
                    } else if (identityClass == CMObjectClass.GROUP && CMCAMIDHelper.isOpenIDNamespaceObject(sUserID)) {
                        this.saveOpenIDGroupProperties(ref.getSearchPath(), sUserID);
                    }
                }
            }
            if (ref.getStoreID() == null) {
                try {
                    String storeID = CMCAMIDHelper.normalizeStoreID(ref.getSearchPath());
                    ((CMDbStoreObjectReference)ref).setStoreID(storeID);
                }
                catch (CMException cMException) {
                    // empty catch block
                }
            }
            members.add(ref);
        }
        this.currentUserNamespaces_ = namespaces.toArray(EMPTY_STRING_ARRAY);
        this.currentUserIdentity_ = CMExecutionContext.mergeMembers(this.currentUserIdentity_, members);
        return true;
    }

    private CMObjectReference createAccountObjectReference(CMExecutionContext ctx, String sPath, boolean bCreateProxy) throws CMException {
        CMStore store = ctx.getStore();
        int userID = this.getCurrentUserAccountObjectID();
        if (userID > 0) {
            CMStoreXPath path = (CMStoreXPath)CMStoreXPath.parse(sPath);
            return this.normalizeSecurityReference(store, path, true, bCreateProxy, false, false);
        }
        try {
            userID = store.getUserAccountObjectID(CMCAMIDHelper.CAMIDFromSearchPath(sPath), this.currentUserAncestors_, ctx.getTrustedCredential(), bCreateProxy ? this.tenantId_ : -1);
            this.setCurrentUserAccountObjectID(userID);
        }
        catch (CMException e) {
            if (e.getCode().equals("cmSearchErrCreateProxy")) {
                throw e;
            }
            e.ErrorLevel = 40000;
            CMIndications.logException(e);
        }
        this.getAncestorsStoreIDs();
        return new CMDbStoreObjectReference(userID, CMObjectClass.ACCOUNT, sPath, sPath);
    }

    private void setCurrentUserAncestors(List<Ancestor> ancestors) {
        int size = ancestors.size();
        this.currentUserAncestors_ = new ArrayList<String>(size);
        this.currentUserAncestorsClasses_ = new ArrayList(size);
        this.currentUserAncestorsNames_ = new ArrayList(size);
        this.currentUserAncestorsPaths_ = new ArrayList(size);
        this.currentUserAncestorsStoreIDs_ = new ArrayList(size);
        for (Ancestor ancestor : ancestors) {
            this.currentUserAncestors_.add(ancestor.m_key);
            this.currentUserAncestorsClasses_.add(ancestor.m_objectClass);
            this.currentUserAncestorsNames_.add(ancestor.m_title);
            this.currentUserAncestorsPaths_.add(ancestor.m_searchPath);
            this.currentUserAncestorsStoreIDs_.add(ancestor.m_storeID);
        }
    }

    private void setCurrentUserPath(boolean isAnonymous) {
        this.currentUserPath_ = isAnonymous ? "/directory/namespace[@id=':']/account[@id=\"::Anonymous\"]" : "/directory//*[@id=" + CMStoreXPath.attributeQuoteString(this.getCurrentUser()) + "]";
    }

    private void buildInternalUserPath() {
        int n = this.currentUserAncestors_.size();
        this.currentUserPath_ = this.currentUserInternalPath_ = this.currentUserAncestors_.get(n - 1) + "/*[@id=" + CMStoreXPath.attributeQuoteString(this.getCurrentUser()) + "]";
        this.currentUserAncestors_.add(this.currentUserInternalPath_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOpenIDGroupProperties(String searchPath, String sID) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStore store = ctx.getStore();
        CMStoreQueryResults rs = null;
        try {
            CMStoreXPath path = new CMStoreXPath(searchPath, 10);
            store.getLockManager().requestLocks(path);
            rs = store.executeQuery(path, null, null, 0, 33280, null);
            if (rs.next()) {
                return;
            }
        }
        finally {
            if (rs != null) {
                rs.release();
            }
            store.getLockManager().releaseLocks();
        }
        this.createGroupProxy(sID);
        this.updateGroupProxy(searchPath, sID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroupProxy(String searchPath, String sID) throws CMException {
        ArrayList<CMProperty> props = new ArrayList<CMProperty>();
        ArrayList<Object> propValues = new ArrayList<Object>();
        this.getGroupPropsFromAAA(searchPath, props, propValues);
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStore store = ctx.getStore();
        CMStoreQueryResults rs = null;
        String sProxyPath = "/directory/namespace[@id='" + CMCAMIDHelper.getNamespaceIDFromCAMID(sID) + "']/" + "/group[@id='" + sID + "']";
        CMStoreXPath path = new CMStoreXPath(sProxyPath, 13);
        store.getLockManager().requestLocks(path);
        boolean useTransaction = !store.inTransaction();
        try {
            if (useTransaction) {
                store.beginTransaction();
            }
            if (!props.isEmpty()) {
                rs = store.executeQuery(path, null, null, 7, 512, null);
                store.update(rs, props, propValues);
                rs.release();
                rs = null;
            }
            if (useTransaction) {
                store.commitTransaction();
                useTransaction = false;
            }
        }
        finally {
            CMQueryUtils.safeQueryResultsRelease(rs);
            if (useTransaction) {
                store.rollbackOpenTransaction();
            }
            store.getLockManager().releaseLocks();
        }
    }

    private void createGroupProxy(String sID) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStore store = ctx.getStore();
        ArrayList<String> ancestors = CMCAMIDHelper.getOpenIDNSAncestors(sID);
        store.createSecurityProxyObject(sID, ancestors, CMObjectClass.GROUP, -1, false);
    }

    private void getGroupPropsFromAAA(String searchPath, ArrayList<CMProperty> props, ArrayList<Object> propValues) throws CMException {
        ArrayList<CMProperty> grpProps = new ArrayList<CMProperty>();
        grpProps.add(CMProperty.DEFAULTNAME);
        CMAAAObjectPropertiesDoc aaaQuery = new CMAAAObjectPropertiesDoc(searchPath, AAAProvider_OpenIDProxy.AAA_PASSTHROUGH_TAG, CMObjectClass.GROUP, grpProps.toArray(new CMProperty[0]));
        for (int i = 0; i < grpProps.size(); ++i) {
            Object value = aaaQuery.getValue(i);
            if (value == null) continue;
            props.add((CMProperty)grpProps.get(i));
            propValues.add(value.toString());
        }
    }

    private void saveOpenIdAccountProperties(String spath) throws CMException {
        block7: {
            ArrayList<CMProperty> accountProps = new ArrayList<CMProperty>();
            for (CMProperty prop : CMObjectClass.ACCOUNT.getProperties()) {
                if (!prop.isExternal()) continue;
                accountProps.add(prop);
            }
            accountProps.add(CMProperty.DEFAULTNAME);
            accountProps.add(CMProperty.CONTENTLOCALE);
            accountProps.add(CMProperty.PRODUCTLOCALE);
            CMAAAObjectPropertiesDoc aaaQuery = new CMAAAObjectPropertiesDoc(spath, AAAProvider_OpenIDProxy.AAA_PASSTHROUGH_TAG, CMObjectClass.ACCOUNT, accountProps.toArray(new CMProperty[0]));
            ArrayList<CMProperty> props = new ArrayList<CMProperty>();
            ArrayList<Object> propValues = new ArrayList<Object>();
            String defaultName = null;
            for (int i = 0; i < accountProps.size(); ++i) {
                Object value = aaaQuery.getValue(i);
                if (value == null) continue;
                CMProperty prop = (CMProperty)accountProps.get(i);
                if (prop == CMProperty.DEFAULTNAME) {
                    defaultName = value.toString();
                    if (!defaultName.isEmpty()) continue;
                    defaultName = null;
                    continue;
                }
                props.add(prop);
                propValues.add(value);
            }
            if (defaultName != null) {
                props.add(CMProperty.DEFAULTNAME);
                propValues.add(defaultName);
            }
            if (props.isEmpty()) {
                return;
            }
            CMExecutionContext ctx = CMExecutionContext.get();
            CMStore store = ctx.getStore();
            CMStoreXPath path = new CMStoreXPath(spath, 13);
            try {
                this.updateAccountProxy(store, path, props, propValues);
            }
            catch (CMStoreDuplicateObject e) {
                if (defaultName == null) break block7;
                int n = props.size() - 1;
                props.remove(n);
                propValues.remove(n);
                this.updateAccountProxy(store, path, props, propValues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccountProxy(CMStore store, CMStoreXPath path, ArrayList<CMProperty> props, ArrayList<Object> propValues) throws CMException {
        CMStoreQueryResults rs;
        boolean useTransaction;
        block9: {
            block8: {
                useTransaction = !store.inTransaction();
                rs = null;
                CMProperty[] qprops = null;
                if (props.contains(CMProperty.PRODUCTLOCALE) || props.contains(CMProperty.CONTENTLOCALE)) {
                    qprops = new CMProperty[]{CMProperty.CONTENTLOCALE, CMProperty.PRODUCTLOCALE};
                }
                try {
                    store.getLockManager().requestLocks(path);
                    if (useTransaction) {
                        store.beginTransaction();
                    }
                    if ((rs = store.executeQuery(path, qprops, null, 7, 512, null)).next()) break block8;
                }
                catch (Throwable throwable) {
                    CMQueryUtils.safeQueryResultsRelease(rs);
                    if (useTransaction) {
                        store.rollbackOpenTransaction();
                    }
                    store.getLockManager().releaseLocks();
                    throw throwable;
                }
                CMQueryUtils.safeQueryResultsRelease(rs);
                if (useTransaction) {
                    store.rollbackOpenTransaction();
                }
                store.getLockManager().releaseLocks();
                return;
            }
            this.removePropertyIfAlreadySet(CMProperty.CONTENTLOCALE, rs, props, propValues);
            this.removePropertyIfAlreadySet(CMProperty.PRODUCTLOCALE, rs, props, propValues);
            rs.reset();
            store.update(rs, props, propValues);
            if (!useTransaction) break block9;
            store.commitTransaction();
            useTransaction = false;
        }
        CMQueryUtils.safeQueryResultsRelease(rs);
        if (useTransaction) {
            store.rollbackOpenTransaction();
        }
        store.getLockManager().releaseLocks();
    }

    private void removePropertyIfAlreadySet(CMProperty prop, CMStoreQueryResults rs, ArrayList<CMProperty> props, ArrayList<Object> values) throws CMException {
        int pos = props.indexOf(prop);
        if (pos != -1 && rs.getValue(prop) != null) {
            props.remove(pos);
            values.remove(pos);
        }
    }

    private void extractTenancy(TenantRegistry registry, XMLElement el) throws CMException {
        ArrayList<XMLElement> readTenantIdChildren;
        XMLElement readTenantIds;
        String tenantIdString = el.getChildValue("tenantID", "value");
        this.tenantId_ = registry.getTenantIdIntFromString(tenantIdString, false);
        XMLElement writeTenantID = el.getChild("writeTenantID", "value");
        if (null != writeTenantID) {
            String impersonatedTenantIDString = writeTenantID.value_;
            if (null == impersonatedTenantIDString) {
                impersonatedTenantIDString = "";
            }
            this.tenantId_ = registry.getTenantIdIntFromString(impersonatedTenantIDString, false);
        }
        if ((readTenantIds = el.getOptionalChildWithName("readTenantIDs")) != null && (readTenantIdChildren = readTenantIds.getChildren()) != null) {
            HashSet<String> readTenants = new HashSet<String>(readTenantIdChildren.size() + 1);
            readTenants.add("");
            for (XMLElement idEl : readTenantIdChildren) {
                if (idEl.value_ == null) continue;
                readTenants.add(idEl.value_);
            }
            this.boundedTenantIds_ = registry.getTenantIdsAsIntArray(readTenants, true);
            this.setReadTenantIds(this.boundedTenantIds_);
        }
    }

    protected boolean isAccountObjectClass(CMObjectClass identityClass) {
        return identityClass == CMObjectClass.ACCOUNT;
    }

    protected CMObjectReference normalizeSecurityReference(CMStore store, CMStoreXPath objectContext, boolean normalizeCAMIDs, boolean createProxy, boolean mustExist, boolean bAcquireLocks) throws CMException {
        return CMCAMIDHelper.normalizeSecurityReference(store, objectContext, normalizeCAMIDs, createProxy, mustExist, bAcquireLocks);
    }

    private ArrayList<Ancestor> extractAncestors(XMLElement valueEl, String camObject) throws CMException {
        ArrayList<XMLElement> items = valueEl.getChildren();
        String previousAncestor = "";
        int numNodes = items.size();
        if (numNodes < 2) {
            throw new CMException("cmBadCAMPropValue", new CMException.Parm("Property", CMProperty.ANCESTORS.getName()), new CMException.Parm("Object", camObject));
        }
        ArrayList<Ancestor> retArray = new ArrayList<Ancestor>(numNodes);
        for (XMLElement itemEl : items) {
            Ancestor ancestor = new Ancestor();
            retArray.add(ancestor);
            for (XMLElement el : itemEl.getChildren()) {
                String valueName = el.name_;
                String value = el.value_;
                if (valueName.equals("objectClass")) {
                    ancestor.m_objectClass = value;
                    continue;
                }
                if (valueName.equals("title")) {
                    ancestor.m_title = value;
                    continue;
                }
                if (valueName.equals("storeID")) {
                    ancestor.m_storeID = value;
                    continue;
                }
                if (!valueName.equals("searchPath")) continue;
                ancestor.m_searchPath = value;
                String sNodePath = value;
                if (sNodePath == null) continue;
                if (sNodePath.startsWith("/")) {
                    ancestor.m_key = sNodePath;
                    previousAncestor = sNodePath;
                    continue;
                }
                if (sNodePath.startsWith("CAMID('")) {
                    sNodePath = sNodePath.substring(sNodePath.indexOf(39) + 1, sNodePath.lastIndexOf(39));
                } else if (sNodePath.startsWith("CAMID(\"")) {
                    sNodePath = sNodePath.substring(sNodePath.indexOf(34) + 1, sNodePath.lastIndexOf(34));
                }
                previousAncestor = previousAncestor + "/" + "*[@id=" + CMStoreXPath.attributeQuoteString(sNodePath) + "]";
                ancestor.m_key = previousAncestor;
            }
            if (ancestor.m_searchPath != null) continue;
            throw new CMException("cmBadCAMPropValue", new CMException.Parm("Property", CMProperty.ANCESTORS.getName()), new CMException.Parm("Object", camObject));
        }
        return retArray;
    }

    private void getAncestorsStoreIDs() throws CMException {
        if (null != this.currentUserAncestorsPaths_ && null != this.currentUserAncestorsStoreIDs_) {
            CMExecutionContext ctx = CMExecutionContext.get();
            int pathListSize = this.currentUserAncestorsPaths_.size();
            for (int i = 0; i < this.currentUserAncestorsStoreIDs_.size(); ++i) {
                String searchPath = pathListSize > i ? this.currentUserAncestorsPaths_.get(i) : null;
                String storeID = this.currentUserAncestorsStoreIDs_.get(i);
                if (null != storeID || null == searchPath) continue;
                storeID = searchPath.equals("/directory") ? ctx.getStore().getDirectoryStoreID() : CMCAMIDHelper.normalizeStoreID(searchPath);
                this.currentUserAncestorsStoreIDs_.set(i, storeID);
            }
        }
    }

    private void resetIdentityDependentProps() {
        this.currentUserRoutingHints_ = null;
    }

    public ExtendedUserCapabilities getUserCapabilities() {
        return this.capabilities;
    }

    public void setIsMultipleNamespaceSession(boolean isMultipleNamespaceSession) {
        this.isMultipleNamespaceSession_ = isMultipleNamespaceSession;
    }

    public boolean getIsMultipleNamespaceSession() {
        return this.isMultipleNamespaceSession_;
    }

    public String[] getAuthenticatedNamespaces() {
        return this.currentUserNamespaces_;
    }

    public List<Integer> getIdentityAccounts() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.currentUserIdentity_.size(); ++i) {
            CMObjectReference objRef = this.currentUserIdentity_.get(i);
            if (!this.isAccountObjectClass(objRef.getObjectClass())) continue;
            result.add(new Integer(objRef.getObjectID()));
        }
        return result;
    }

    private class Ancestor {
        private String m_objectClass;
        private String m_searchPath;
        private String m_title;
        private String m_storeID;
        private String m_key;

        private Ancestor() {
        }

        public String toString() {
            return this.m_searchPath;
        }
    }
}

