/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.SAXAttributes;
import com.cognos.cm.server.XMLAttributes;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMNamespacePrefixes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.xml.sax.Attributes;

public class XMLDoc {
    public XMLElement baseElement_;
    public ArrayList<HRefObj> hrefList_;
    public HashMap<String, XMLElement> idRefMap_;

    public XMLDoc(CMNamespacePrefixes nsPrefixes, String uri, String qName, Attributes attributes) {
        this(nsPrefixes, uri, qName, new SAXAttributes(attributes));
    }

    public XMLDoc(CMNamespacePrefixes nsPrefixes, String uri, String qName, XMLAttributes attributes) {
        this.baseElement_ = new XMLElement(nsPrefixes, uri, qName, attributes, this);
    }

    public XMLElement getRootXMLElement() {
        this.resolveReferences();
        return this.baseElement_;
    }

    public void addHRef(XMLElement hrefEl, String hrefStr) {
        if (this.hrefList_ == null) {
            this.hrefList_ = new ArrayList();
        }
        this.hrefList_.add(new HRefObj(hrefEl, this.removePoundSign(hrefStr)));
    }

    public void addIdRef(XMLElement hrefEl, String hrefStr) {
        if (this.idRefMap_ == null) {
            this.idRefMap_ = new HashMap();
        }
        this.idRefMap_.put(this.removePoundSign(hrefStr), hrefEl);
    }

    public String removePoundSign(String str) {
        if (str.startsWith("#")) {
            return str.substring(1);
        }
        return str;
    }

    public void resolveReferences() {
        if (this.hrefList_ == null || this.idRefMap_ == null) {
            return;
        }
        ListIterator<HRefObj> iter = this.hrefList_.listIterator();
        while (iter.hasNext()) {
            HRefObj href = iter.next();
            XMLElement idElem = this.idRefMap_.get(href.href_);
            if (idElem == null) continue;
            href.element_.makeMeTheIdElement(idElem);
            iter.remove();
        }
        if (this.hrefList_.isEmpty()) {
            this.hrefList_ = null;
        }
    }

    public static class HRefObj {
        public XMLElement element_;
        public String href_;

        public HRefObj(XMLElement element, String href) {
            this.element_ = element;
            this.href_ = href;
        }
    }
}

