/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMNamespacePrefixes;
import com.cognos.cm.util.CMXMLUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLDocParser
implements ContentHandler,
ErrorHandler {
    private XMLDoc xmlDocHeader_;
    private XMLElement currXMLElement_;
    private CMNamespacePrefixes nsPrefixes;
    private StringBuffer sLastCharacters_;

    public static XMLElement parseXml(String xml) throws CMException {
        XMLDocParser parser = new XMLDocParser();
        try {
            return parser.readXML(xml).getRootXMLElement();
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedToParseXMLString", new CMException.Parm("String", xml));
        }
    }

    public XMLDocParser() {
        this.nsPrefixes = new CMNamespacePrefixes();
    }

    public XMLDocParser(boolean bDoingImport) {
        this.nsPrefixes = new CMNamespacePrefixes(bDoingImport);
    }

    public XMLDoc readXML(String s) throws Exception {
        return this.readXML(new InputSource(new StringReader(s)));
    }

    public XMLDoc readXML(InputStream is) throws Exception {
        return this.readXML(new InputSource(is));
    }

    public XMLDoc readXML(Reader reader) throws Exception {
        return this.readXML(new InputSource(reader));
    }

    public XMLDoc readXML(InputSource inputSource) throws Exception {
        XMLReader saxParser = null;
        try {
            this.nsPrefixes.clear();
            saxParser = CMXMLUtils.getSAXParserFromPool();
            saxParser.setContentHandler(this);
            saxParser.setErrorHandler(this);
            saxParser.parse(inputSource);
        }
        catch (SAXException saxE) {
            try {
                Exception ex = saxE.getException();
                if (ex != null) {
                    throw ex;
                }
                throw saxE;
            }
            catch (Throwable throwable) {
                CMXMLUtils.returnSAXParserToPool(saxParser);
                throw throwable;
            }
        }
        CMXMLUtils.returnSAXParserToPool(saxParser);
        return this.xmlDocHeader_;
    }

    public XMLDoc readXMLFragment(String XMLfragment) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<item xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        sb.append(XMLfragment);
        sb.append("</item>\r\n");
        return this.readXML(sb.toString());
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.xmlDocHeader_ == null) {
            this.xmlDocHeader_ = new XMLDoc(this.nsPrefixes, uri, localName, attributes);
            this.currXMLElement_ = this.xmlDocHeader_.getRootXMLElement();
        } else if (this.currXMLElement_ != null) {
            this.currXMLElement_ = this.currXMLElement_.addChild(this.nsPrefixes, uri, localName, attributes);
        }
        this.sLastCharacters_ = null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currXMLElement_ != null) {
            if (this.currXMLElement_.children_ == null && this.sLastCharacters_ != null) {
                this.currXMLElement_.value_ = this.sLastCharacters_.toString();
            }
            this.currXMLElement_ = this.currXMLElement_.GetBuildParent();
        }
        this.sLastCharacters_ = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.sLastCharacters_ == null) {
            this.sLastCharacters_ = new StringBuffer(length);
            this.sLastCharacters_.append(ch, start, length);
        } else {
            this.sLastCharacters_.append(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.nsPrefixes.remove(prefix);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nsPrefixes.add(prefix, uri);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }
}

