/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.SAXAttributes;
import com.cognos.cm.server.XMLAttributes;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMLocaleUtils;
import com.cognos.cm.util.CMNamespacePrefixes;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class XMLElement {
    public CMSOAPConstants.XMLNamespace xmlNamespace_;
    public String name_;
    public String value_;
    public String xsiType_;
    public CMSOAPConstants.XMLNamespace xsiTypeNs_;
    public boolean isNil_;
    public boolean isArray_;
    public ArrayList<XMLElement> children_;
    public XMLElement parent_;
    public XMLElement idParent_;
    public AttributesImpl attributes_;
    public boolean doXMLEncodeOnValue_ = true;
    public XMLDoc XMLDoc_;
    public boolean isIdElement_;
    private static String g_sCompleteCMPrefixes = null;
    private static String g_sStartElemSeg1 = null;
    private static String g_sStartElemSeg2 = null;
    private static String g_sStartElemNil = null;

    public XMLElement() {
    }

    public XMLElement(String qName, boolean isNil) {
        this.name_ = qName;
        this.isNil_ = isNil;
    }

    public XMLElement(String qName, XMLDoc XMLDoc2) {
        this.name_ = qName;
        this.XMLDoc_ = XMLDoc2;
    }

    public XMLElement(String name, CMSOAPConstants.XMLNamespace xsiTypeNs, String xsiType) {
        this.name_ = name;
        this.xsiTypeNs_ = xsiTypeNs;
        this.xsiType_ = xsiType;
    }

    public void makeMeTheIdElement(XMLElement copyFromElem) {
        this.value_ = copyFromElem.value_;
        this.xsiType_ = copyFromElem.xsiType_;
        this.xsiTypeNs_ = copyFromElem.xsiTypeNs_;
        this.isNil_ = copyFromElem.isNil_;
        this.isArray_ = copyFromElem.isArray_;
        this.children_ = copyFromElem.children_;
        this.attributes_ = copyFromElem.attributes_;
        this.doXMLEncodeOnValue_ = copyFromElem.doXMLEncodeOnValue_;
        int index = this.attributes_.getIndex("", "id");
        if (index >= 0) {
            this.attributes_.removeAttribute(index);
        }
    }

    public static XMLElement copyFrom(XMLElement sourceElem) {
        XMLElement retElem = new XMLElement();
        retElem.doXMLEncodeOnValue_ = sourceElem.doXMLEncodeOnValue_;
        retElem.isArray_ = sourceElem.isArray_;
        retElem.isIdElement_ = sourceElem.isIdElement_;
        retElem.isNil_ = sourceElem.isNil_;
        retElem.name_ = sourceElem.name_;
        retElem.value_ = sourceElem.value_;
        retElem.xmlNamespace_ = sourceElem.xmlNamespace_;
        retElem.xsiType_ = sourceElem.xsiType_;
        retElem.xsiTypeNs_ = sourceElem.xsiTypeNs_;
        if (sourceElem.attributes_ != null) {
            AttributesImpl sourceAttr = sourceElem.attributes_;
            int length = sourceElem.attributes_.getLength();
            retElem.attributes_ = new AttributesImpl();
            for (int i = 0; i < length; ++i) {
                retElem.attributes_.addAttribute(sourceAttr.getURI(i), sourceAttr.getLocalName(i), sourceAttr.getQName(i), sourceAttr.getType(i), sourceAttr.getValue(i));
            }
        }
        if (sourceElem.children_ != null) {
            retElem.children_ = new ArrayList();
            for (XMLElement child : sourceElem.children_) {
                if (child.getClass() != XMLElement.class) continue;
                XMLElement elem = child;
                retElem.children_.add(XMLElement.copyFrom(elem));
            }
        }
        return retElem;
    }

    public XMLElement(CMNamespacePrefixes nsPrefixes, String uri, String qName, XMLAttributes attributes, XMLDoc XMLDoc2) {
        this.XMLDoc_ = XMLDoc2;
        this.name_ = qName;
        this.xmlNamespace_ = null;
        if (uri.length() > 0) {
            this.xmlNamespace_ = CMSOAPConstants.findXMLNamespace(uri);
        }
        int attributes_getLength = attributes.getLength();
        this.parseAttributes(nsPrefixes, attributes, attributes_getLength);
    }

    private void parseAttributes(CMNamespacePrefixes nsPrefixes, XMLAttributes attributes, int attributes_getLength) {
        for (int i = 0; i < attributes_getLength; ++i) {
            int nIdxEnd;
            int nIdxStart;
            String xsiType_Suffix;
            String xsiType_Prefix;
            boolean bUriAttr_equals_XMLSCHEMAINSTANCE;
            String localNameAttr = attributes.getLocalName(i);
            String uriAttr = attributes.getURI(i);
            String valueAttr = attributes.getValue(i);
            if (uriAttr != null && uriAttr.equalsIgnoreCase("http://www.w3.org/2000/xmlns/")) continue;
            if (uriAttr.length() < 1) {
                if (localNameAttr.equalsIgnoreCase("href")) {
                    this.XMLDoc_.addHRef(this, valueAttr);
                } else if (localNameAttr.equalsIgnoreCase("id")) {
                    this.XMLDoc_.addIdRef(this, valueAttr);
                    this.isIdElement_ = true;
                }
            }
            if ((bUriAttr_equals_XMLSCHEMAINSTANCE = uriAttr.equals("http://www.w3.org/2001/XMLSchema-instance")) && localNameAttr.equals("type")) {
                CMSOAPConstants.XMLNamespace xsiTypeNs;
                String xsiType = valueAttr;
                xsiType_Prefix = null;
                xsiType_Suffix = null;
                int nLen = xsiType.length();
                nIdxStart = xsiType.indexOf(58);
                if (nIdxStart < 0) {
                    nIdxStart = 0;
                } else {
                    xsiType_Prefix = xsiType.substring(0, nIdxStart);
                    ++nIdxStart;
                }
                nIdxEnd = xsiType.indexOf(91, nIdxStart);
                if (nIdxEnd < 0) {
                    nIdxEnd = nLen;
                }
                if (nIdxStart > 0 || nIdxEnd < nLen - 1) {
                    xsiType_Suffix = xsiType.substring(nIdxStart, nIdxEnd);
                }
                if ((xsiTypeNs = nsPrefixes.findNS(xsiType_Prefix)) != null) {
                    xsiType = xsiType_Suffix;
                }
                if (xsiTypeNs == CMSOAPConstants.NS_SOAP_ENC && xsiType.equals("Array")) continue;
                this.xsiType_ = xsiType;
                this.xsiTypeNs_ = xsiTypeNs;
                continue;
            }
            if (bUriAttr_equals_XMLSCHEMAINSTANCE && localNameAttr.equals("nil") && CMXMLUtils.isBooleanAttrTrue(valueAttr)) {
                this.isNil_ = true;
                continue;
            }
            if (bUriAttr_equals_XMLSCHEMAINSTANCE && localNameAttr.equals("null") && CMXMLUtils.isBooleanAttrTrue(valueAttr)) {
                this.isNil_ = true;
                continue;
            }
            if (localNameAttr.equals("arrayType") && uriAttr.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                String xsiType = valueAttr;
                xsiType_Prefix = null;
                xsiType_Suffix = null;
                int nLen = xsiType.length();
                nIdxStart = xsiType.indexOf(58);
                if (nIdxStart < 0) {
                    nIdxStart = 0;
                } else {
                    xsiType_Prefix = xsiType.substring(0, nIdxStart);
                    ++nIdxStart;
                }
                nIdxEnd = xsiType.indexOf(91, nIdxStart);
                if (nIdxEnd < 0) {
                    nIdxEnd = nLen;
                }
                if (nIdxStart > 0 || nIdxEnd < nLen - 1) {
                    xsiType_Suffix = xsiType.substring(nIdxStart, nIdxEnd);
                }
                this.xsiType_ = xsiType_Suffix;
                this.xsiTypeNs_ = nsPrefixes.findNS(xsiType_Prefix);
                this.isArray_ = true;
                continue;
            }
            if (localNameAttr.equals("msgId")) {
                String valueId;
                int pos = valueAttr.lastIndexOf(58);
                Locale valueIdLocale = null;
                if (pos > 0) {
                    valueId = valueAttr.substring(0, pos);
                    String localeStr = valueAttr.substring(pos + 1);
                    valueIdLocale = CMLocaleUtils.parseLocale(localeStr);
                } else {
                    valueId = valueAttr;
                }
                this.value_ = CMError.getMessage(valueId, null, valueIdLocale);
                continue;
            }
            if (this.attributes_ == null) {
                this.attributes_ = new AttributesImpl();
            }
            this.attributes_.addAttribute(uriAttr, localNameAttr, attributes.getQName(i), attributes.getType(i), valueAttr);
        }
    }

    public void addAttribute(String attrName, String attrValue) {
        if (this.attributes_ == null) {
            this.attributes_ = new AttributesImpl();
        }
        this.attributes_.addAttribute("", attrName, attrName, "CDATA", attrValue);
    }

    public void replaceAttribute(String attrName, String attrValue) {
        if (this.attributes_ == null) {
            this.attributes_ = new AttributesImpl();
        } else {
            int index = this.attributes_.getIndex("", attrName);
            if (index != -1) {
                this.attributes_.removeAttribute(index);
            }
        }
        this.addAttribute(attrName, attrValue);
    }

    public XMLElement addChild(CMSOAPConstants.XMLNamespace elementNs, String name, CMSOAPConstants.XMLNamespace xsiTypeNs, String xsiType, String value) {
        XMLElement xl = this.addChild(elementNs, name, xsiTypeNs, xsiType);
        xl.value_ = value;
        return xl;
    }

    public XMLElement addChild(CMSOAPConstants.XMLNamespace elementNs, String name, CMSOAPConstants.XMLNamespace xsiTypeNs, String xsiType) {
        if (this.children_ == null) {
            this.children_ = new ArrayList();
        }
        XMLElement newEl = new XMLElement(name, this.XMLDoc_);
        newEl.parent_ = this;
        this.children_.add(newEl);
        newEl.xmlNamespace_ = elementNs;
        newEl.xsiTypeNs_ = xsiTypeNs;
        newEl.xsiType_ = xsiType;
        newEl.XMLDoc_ = this.XMLDoc_;
        return newEl;
    }

    public XMLElement addChild(CMNamespacePrefixes nsPrefixes, String uri, String qName, Attributes attributes) {
        return this.addChild(nsPrefixes, uri, qName, new SAXAttributes(attributes));
    }

    public XMLElement addChild(CMNamespacePrefixes nsPrefixes, String uri, String qName, XMLAttributes attributes) {
        if (this.children_ == null) {
            this.children_ = new ArrayList();
        }
        XMLElement newEl = new XMLElement(nsPrefixes, uri, qName, attributes, this.XMLDoc_);
        if (this.isIdElement_) {
            newEl.idParent_ = this;
        } else {
            newEl.parent_ = this;
        }
        this.children_.add(newEl);
        return newEl;
    }

    public XMLElement addChild(int index, CMSOAPConstants.XMLNamespace elementNs, String name, CMSOAPConstants.XMLNamespace xsiTypeNs, String xsiType, String value) {
        XMLElement xl = this.addChild(index, elementNs, name, xsiTypeNs, xsiType);
        xl.value_ = value;
        return xl;
    }

    public XMLElement addChild(int index, CMSOAPConstants.XMLNamespace elementNs, String name, CMSOAPConstants.XMLNamespace xsiTypeNs, String xsiType) {
        if (this.children_ == null) {
            this.children_ = new ArrayList();
        }
        XMLElement newEl = new XMLElement(name, this.XMLDoc_);
        newEl.parent_ = this;
        this.children_.add(index, newEl);
        newEl.xmlNamespace_ = elementNs;
        newEl.xsiTypeNs_ = xsiTypeNs;
        newEl.xsiType_ = xsiType;
        newEl.XMLDoc_ = this.XMLDoc_;
        return newEl;
    }

    public XMLElement GetBuildParent() {
        if (this.parent_ == null) {
            return this.idParent_;
        }
        return this.parent_;
    }

    public boolean hasChildren() {
        return this.children_ != null;
    }

    public String getAttribute(String attrName) {
        if (this.attributes_ == null) {
            return null;
        }
        String attrValue = this.attributes_.getValue(attrName);
        return attrValue;
    }

    public boolean nameIs(String name) {
        if (name == null) {
            return false;
        }
        return name.equals(this.name_);
    }

    public String getOptionalChildValueWithName(String name) {
        XMLElement xmlEl = this.getOptionalChildWithName(name);
        if (xmlEl != null) {
            return xmlEl.value_;
        }
        return null;
    }

    public boolean getOptionalChildBooleanValueWithName(String name, boolean defaultValue) throws CMException {
        String value = this.getOptionalChildValueWithName(name);
        if (value != null && value.length() > 0) {
            return CMXMLUtils.parseBooleanAttribute(value);
        }
        return defaultValue;
    }

    public int getOptionalChildIntValueWithName(String name, int defaultValue) throws CMException {
        String value = this.getOptionalChildValueWithName(name);
        if (value != null && value.length() > 0) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception ex) {
                throw new CMException("cmExpectedIntElement", new CMException.Parm("Name", name), new CMException.Parm("Value", value));
            }
        }
        return defaultValue;
    }

    public long getOptionalChildLongValueWithName(String name, long defaultValue) throws CMException {
        String value = this.getOptionalChildValueWithName(name);
        if (value != null && value.length() > 0) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception ex) {
                throw new CMException("cmExpectedLongElement", new CMException.Parm("Name", name), new CMException.Parm("Value", value));
            }
        }
        return defaultValue;
    }

    public int getChildIntValueWithName(String name) throws CMException {
        String value = this.getChildValueWithName(name);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            throw new CMException("cmExpectedIntElement", new CMException.Parm("Name", name), new CMException.Parm("Value", value));
        }
    }

    public long getChildLongValueWithName(String name) throws CMException {
        String value = this.getChildValueWithName(name);
        try {
            return Long.parseLong(value);
        }
        catch (Exception ex) {
            throw new CMException("cmExpectedLongElement", new CMException.Parm("Name", name), new CMException.Parm("Value", value));
        }
    }

    public String getChildValueWithName(String name) throws CMException {
        XMLElement xmlEl = this.getChildWithName(name);
        if (xmlEl != null) {
            return xmlEl.value_;
        }
        return null;
    }

    public String getChildNonNullValueWithName(String name) throws CMException {
        XMLElement xmlEl = this.getChildWithName(name);
        if (xmlEl.value_ == null) {
            throw new CMException("cmExpectedElementEmpty", new CMException.Parm("Name", name));
        }
        return xmlEl.value_;
    }

    public XMLElement getSingleChildWithName(String name) throws CMException {
        if (this.children_ == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", name), new CMException.Parm("Parent", this.name_));
        }
        return this.getOptionalChildWithName(name);
    }

    public ArrayList<XMLElement> getChildren() {
        if (this.children_ == null) {
            return null;
        }
        return this.children_;
    }

    public ArrayList<XMLElement> getChildrenAllShouldBe(String name) throws CMException {
        if (this.children_ == null) {
            return null;
        }
        ListIterator<XMLElement> iter = this.children_.listIterator();
        while (iter.hasNext()) {
            XMLElement xmlEl = iter.next();
            if (xmlEl.nameIs(name)) continue;
            throw new CMException("cmExpectedArrayElement", new CMException.Parm("Name", name), new CMException.Parm("Found", xmlEl.name_));
        }
        return this.children_;
    }

    public XMLElement getOptionalChildWithPath(String[] names) {
        XMLElement el = this;
        for (int i = 0; i < names.length && el != null; el = el.getOptionalChildWithName(names[i]), ++i) {
        }
        return el;
    }

    public XMLElement getOptionalChildWithName(String name) {
        XMLElement xmlEl = this.getOptionalChildWithNameEvenIfNil(name);
        if (xmlEl != null && xmlEl.isNil_) {
            return null;
        }
        return xmlEl;
    }

    public String getOptionalValueFromChildWithNameWithinChildWithName(String nameOuter, String nameInner) {
        XMLElement el = this.getOptionalChildWithName(nameOuter);
        if (el != null) {
            return el.getOptionalChildValueWithName(nameInner);
        }
        return null;
    }

    public XMLElement getOptionalChildWithNameEvenIfNil(String name) {
        if (this.children_ == null) {
            return null;
        }
        XMLElement ret_OLD = null;
        ListIterator<XMLElement> iter = this.children_.listIterator();
        while (iter.hasNext()) {
            XMLElement xmlEl = iter.next();
            if (!xmlEl.nameIs(name)) continue;
            ret_OLD = xmlEl;
        }
        return ret_OLD;
    }

    public XMLElement getOptionalChildWithName(CMSOAPConstants.XMLNamespace ns, String name) {
        if (this.children_ == null) {
            return null;
        }
        XMLElement ret_OLD = null;
        ListIterator<XMLElement> iter = this.children_.listIterator();
        while (iter.hasNext()) {
            XMLElement xmlEl = iter.next();
            if (!xmlEl.nameIs(name) || xmlEl.xmlNamespace_ != ns) continue;
            if (xmlEl.isNil_) {
                ret_OLD = null;
            }
            ret_OLD = xmlEl;
        }
        return ret_OLD;
    }

    public XMLElement getOptionalChildWithNamespace(CMSOAPConstants.XMLNamespace ns) {
        if (this.children_ == null) {
            return null;
        }
        ListIterator<XMLElement> iter = this.children_.listIterator();
        while (iter.hasNext()) {
            XMLElement xmlEl = iter.next();
            if (xmlEl.xmlNamespace_ != ns) continue;
            if (xmlEl.isNil_) {
                return null;
            }
            return xmlEl;
        }
        return null;
    }

    public XMLElement getChild(int number) {
        if (this.children_ == null || this.children_.size() <= number) {
            return null;
        }
        return this.children_.get(number);
    }

    public XMLElement getChild(String ... elementNames) {
        XMLElement el = this;
        for (String name : elementNames) {
            if ((el = el.getOptionalChildWithName(name)) != null) continue;
            return null;
        }
        return el;
    }

    public String getChildValue(String ... elementNames) {
        XMLElement el = this.getChild(elementNames);
        return el == null || el.isNil_ ? null : el.value_;
    }

    public XMLElement getChildWithName(String name) throws CMException {
        if (this.children_ == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", name), new CMException.Parm("Parent", this.name_));
        }
        XMLElement xmlEl = this.getOptionalChildWithName(name);
        if (xmlEl == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", name), new CMException.Parm("Parent", this.name_));
        }
        return xmlEl;
    }

    public XMLElement getChildWithName(CMSOAPConstants.XMLNamespace ns, String name) throws CMException {
        if (this.children_ == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", name), new CMException.Parm("Parent", this.name_));
        }
        XMLElement xmlEl = this.getOptionalChildWithName(ns, name);
        if (xmlEl == null) {
            throw new CMException("cmExpectedElementMissing", new CMException.Parm("Name", name), new CMException.Parm("Parent", this.name_));
        }
        return xmlEl;
    }

    public XMLElement getChildWithNameAndAttribute(String name, String attrName, String attrValue) throws CMException {
        if (this.children_ == null) {
            throw new CMException("cmExpectedElementAttrMissing", new CMException.Parm("Name", name), new CMException.Parm("Attribute", attrName), new CMException.Parm("Value", attrValue));
        }
        XMLElement xmlEl = this.getOptionalChildWithNameAndAttribute(name, attrName, attrValue);
        if (xmlEl == null) {
            throw new CMException("cmExpectedElementAttrMissing", new CMException.Parm("Name", name), new CMException.Parm("Attribute", attrName), new CMException.Parm("Value", attrValue));
        }
        return xmlEl;
    }

    public XMLElement getOptionalChildWithNameAndAttribute(String name, String attrName, String attrValue) {
        XMLElement xmlEl = this.getOptionalChildWithNameAndAttributeEvenIfNil(name, attrName, attrValue);
        if (xmlEl != null && xmlEl.isNil_) {
            return null;
        }
        return xmlEl;
    }

    public XMLElement getOptionalChildWithNameAndAttributeEvenIfNil(String name, String attrName, String attrValue) {
        if (this.children_ == null) {
            return null;
        }
        ListIterator<XMLElement> iter = this.children_.listIterator();
        while (iter.hasNext()) {
            String attr;
            XMLElement xmlEl = iter.next();
            if (!xmlEl.nameIs(name) || xmlEl.attributes_ == null || (attr = xmlEl.attributes_.getValue(attrName)) == null || !attr.equals(attrValue)) continue;
            return xmlEl;
        }
        return null;
    }

    public void setChildValueWithName(String name, CMSOAPConstants.XMLNamespace xsiTypeNs, String xsiType, String value) {
        XMLElement xmlEl = this.getOptionalChildWithNameEvenIfNil(name);
        if (xmlEl == null) {
            xmlEl = this.addChild(null, name, xsiTypeNs, xsiType);
        }
        xmlEl.isNil_ = false;
        xmlEl.xmlNamespace_ = null;
        xmlEl.xsiTypeNs_ = xsiTypeNs;
        xmlEl.xsiType_ = xsiType;
        xmlEl.value_ = value;
    }

    public boolean isRequestsChild() {
        if (this.children_ == null) {
            return false;
        }
        XMLElement xmlEl = this.children_.get(0);
        return xmlEl.nameIs("requests");
    }

    public boolean deleteChildren() {
        if (this.children_ == null) {
            return false;
        }
        this.children_ = null;
        return true;
    }

    public boolean deleteChildWithName(String name) {
        try {
            if (this.children_ != null) {
                ListIterator<XMLElement> iter = this.children_.listIterator();
                while (iter.hasNext()) {
                    XMLElement xmlEl = iter.next();
                    if (!xmlEl.nameIs(name)) continue;
                    iter.remove();
                }
                if (this.children_.size() == 0) {
                    this.children_ = null;
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Exception in delete child");
        }
        return false;
    }

    public boolean replaceChild(XMLElement el) {
        if (this.children_ == null) {
            this.children_ = new ArrayList();
        }
        boolean replaced = false;
        ListIterator<XMLElement> iter = this.children_.listIterator();
        while (iter.hasNext() && !replaced) {
            XMLElement element = iter.next();
            if (!element.nameIs(el.name_)) continue;
            iter.set(el);
            replaced = true;
        }
        if (!replaced) {
            this.children_.add(el);
        }
        return replaced;
    }

    public String makeXML(String tabs, boolean includeBaseElement, boolean includePrefixesOnBase) {
        return this.makeXML(tabs, includeBaseElement, includePrefixesOnBase, true, false, null, null);
    }

    public String makeXML(String tabs, boolean includeBaseElement, boolean includePrefixesOnBase, boolean useBIBUSPrefix) {
        return this.makeXML(tabs, includeBaseElement, includePrefixesOnBase, useBIBUSPrefix, false, null, null);
    }

    public String makeXML(String tabs, boolean includeBaseElement, boolean includePrefixesOnBase, boolean useBIBUSPrefix, boolean includeXMLStart, String addXMLtoBase, XMLElement doNotIncludeElement) {
        StringBuffer strBuf = new StringBuffer(4096);
        if (includeXMLStart) {
            strBuf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        }
        if (tabs == null) {
            tabs = "";
        }
        if (includeBaseElement) {
            this.makeStartElement(this, strBuf, tabs, includePrefixesOnBase, useBIBUSPrefix);
        }
        if (addXMLtoBase != null) {
            strBuf.append(addXMLtoBase);
        }
        this.makeChildren(this, strBuf, tabs, useBIBUSPrefix, doNotIncludeElement);
        if (includeBaseElement) {
            this.makeEndElement(this, strBuf, tabs, useBIBUSPrefix);
        }
        String str = strBuf.toString();
        return str;
    }

    public static String getCMPrefixes() {
        return g_sCompleteCMPrefixes;
    }

    private void makeStartElement(XMLElement xmlEl, StringBuffer strBuf, String tabs, boolean includePrefixes, boolean useBIBUSPrefix) {
        AttributesImpl xmlEl_attributes_ = xmlEl.attributes_;
        if (xmlEl.name_ != null) {
            strBuf.append(tabs);
            strBuf.append("<");
            if (xmlEl.xmlNamespace_ != null && (useBIBUSPrefix || xmlEl.xmlNamespace_ != CMSOAPConstants.NS_BIBUS)) {
                strBuf.append(xmlEl.xmlNamespace_.getPrefix());
                strBuf.append(":");
            }
            strBuf.append(xmlEl.name_);
            if (includePrefixes) {
                strBuf.append(g_sCompleteCMPrefixes);
            }
            if (xmlEl.isNil_) {
                strBuf.append(g_sStartElemNil);
                return;
            }
            if (xmlEl.xsiType_ != null) {
                strBuf.append(g_sStartElemSeg1);
                if (xmlEl.isArray_) {
                    strBuf.append(g_sStartElemSeg2);
                    if (xmlEl.xsiTypeNs_ != null) {
                        strBuf.append(xmlEl.xsiTypeNs_.getPrefix());
                        strBuf.append(":");
                    }
                    strBuf.append(xmlEl.xsiType_);
                    strBuf.append("[");
                    if (xmlEl.children_ != null) {
                        strBuf.append(Integer.toString(xmlEl.children_.size()));
                    } else {
                        strBuf.append("0");
                    }
                    strBuf.append("]");
                } else {
                    if (xmlEl.xsiTypeNs_ != null) {
                        strBuf.append(xmlEl.xsiTypeNs_.getPrefix());
                        strBuf.append(":");
                    }
                    strBuf.append(xmlEl.xsiType_);
                }
                strBuf.append("\"");
            }
            if (xmlEl_attributes_ != null) {
                int xmlEl_attributes_getLength = xmlEl_attributes_.getLength();
                for (int i = 0; i < xmlEl_attributes_getLength; ++i) {
                    CMSOAPConstants.XMLNamespace xmlNamespace;
                    String localName = xmlEl_attributes_.getLocalName(i);
                    String uri = xmlEl_attributes_.getURI(i);
                    String value = xmlEl_attributes_.getValue(i);
                    strBuf.append(" ");
                    if (uri != null && uri.length() > 0 && (xmlNamespace = CMSOAPConstants.findXMLNamespace(uri)) != null) {
                        strBuf.append(xmlNamespace.getPrefix());
                        strBuf.append(":");
                    }
                    strBuf.append(localName);
                    strBuf.append("=\"");
                    strBuf.append(value);
                    strBuf.append("\"");
                }
            }
            if (xmlEl.value_ == null && xmlEl.children_ == null) {
                strBuf.append("/>\r\n");
            } else if (xmlEl.value_ != null) {
                strBuf.append(">");
                if (xmlEl.doXMLEncodeOnValue_) {
                    String sValue = xmlEl.value_;
                    String sValue_Encoded = XMLUtils.escape((String)sValue);
                    strBuf.append(sValue_Encoded);
                } else {
                    strBuf.append(xmlEl.value_);
                }
            } else {
                strBuf.append(">\r\n");
            }
        } else if (xmlEl.value_ != null) {
            if (xmlEl.doXMLEncodeOnValue_) {
                strBuf.append(XMLUtils.escape((String)xmlEl.value_));
            } else {
                strBuf.append(tabs);
                strBuf.append(xmlEl.value_);
                strBuf.append("\r\n");
            }
        }
    }

    private void makeChildren(XMLElement xmlEl, StringBuffer strBuf, String tabs, boolean useBIBUSPrefix, XMLElement doNotIncludeElement) {
        if (xmlEl.children_ == null || xmlEl.isNil_) {
            return;
        }
        tabs = tabs + "\t";
        ListIterator<XMLElement> iter = xmlEl.children_.listIterator();
        while (iter.hasNext()) {
            XMLElement xmlElChild = iter.next();
            if (doNotIncludeElement == xmlElChild) continue;
            this.makeStartElement(xmlElChild, strBuf, tabs, false, useBIBUSPrefix);
            this.makeChildren(xmlElChild, strBuf, tabs, useBIBUSPrefix, doNotIncludeElement);
            this.makeEndElement(xmlElChild, strBuf, tabs, useBIBUSPrefix);
        }
    }

    private void makeEndElement(XMLElement xmlEl, StringBuffer strBuf, String tabs, boolean useBIBUSPrefix) {
        String sName = xmlEl.name_;
        String sValue = xmlEl.value_;
        if (!(sName == null || xmlEl.isNil_ || sValue == null && xmlEl.children_ == null)) {
            if (sValue == null) {
                strBuf.append(tabs);
            }
            strBuf.append("</");
            CMSOAPConstants.XMLNamespace ns = xmlEl.xmlNamespace_;
            if (ns != null && (useBIBUSPrefix || ns != CMSOAPConstants.NS_BIBUS)) {
                strBuf.append(ns.getPrefix());
                strBuf.append(":");
            }
            strBuf.append(sName);
            strBuf.append(">\r\n");
        }
    }

    public void normalize() {
        if (this.children_ != null) {
            this.normalizeArray();
            ListIterator<XMLElement> iter = this.children_.listIterator();
            while (iter.hasNext()) {
                XMLElement xmlEl = iter.next();
                if (xmlEl.children_ == null) continue;
                xmlEl.normalize();
            }
        }
    }

    public void normalizeArray() {
        if (this.children_ != null && this.isArray_ && this.xsiType_ != null) {
            ListIterator<XMLElement> iter = this.children_.listIterator();
            while (iter.hasNext()) {
                XMLElement xmlEl = iter.next();
                xmlEl.name_ = "item";
                if (xmlEl.xsiType_ != null) continue;
                xmlEl.xsiType_ = this.xsiType_;
                xmlEl.xsiTypeNs_ = this.xsiTypeNs_;
            }
        }
    }

    public String toString() {
        String s = "<" + this.name_ + ">";
        if (this.children_ == null) {
            s = this.value_ != null ? s + this.value_ : s + "\r\n";
        } else {
            for (int i = 0; i < this.children_.size(); ++i) {
                s = s + "\r\n" + this.getChild(i).toString();
                if (i != this.children_.size() - 1) continue;
                s = s + "\r\n";
            }
        }
        s = s + "</" + this.name_ + ">";
        return s;
    }

    public Iterator<XMLElement> treeIterator() {
        return new ElementIterator(this);
    }

    public void addChild(XMLElement childElem) {
        if (this.children_ == null) {
            this.children_ = new ArrayList();
        }
        if (this.isIdElement_) {
            childElem.idParent_ = this;
        } else {
            childElem.parent_ = this;
        }
        this.children_.add(childElem);
    }

    static {
        StringBuffer strBuf = new StringBuffer(2048);
        strBuf.append(" xmlns:");
        strBuf.append(CMSOAPConstants.NS_SOAP_ENV.getPrefix());
        strBuf.append("=\"");
        strBuf.append(CMSOAPConstants.NS_SOAP_ENV.getUri());
        strBuf.append("\" xmlns:");
        strBuf.append(CMSOAPConstants.NS_SOAP_ENC.getPrefix());
        strBuf.append("=\"");
        strBuf.append(CMSOAPConstants.NS_SOAP_ENC.getUri());
        strBuf.append("\" xmlns:");
        strBuf.append(CMSOAPConstants.NS_XMLSCHEMA.getPrefix());
        strBuf.append("=\"");
        strBuf.append(CMSOAPConstants.NS_XMLSCHEMA.getUri());
        strBuf.append("\" xmlns:");
        strBuf.append(CMSOAPConstants.NS_XMLSCHEMAINSTANCE.getPrefix());
        strBuf.append("=\"");
        strBuf.append(CMSOAPConstants.NS_XMLSCHEMAINSTANCE.getUri());
        strBuf.append("\" xmlns:");
        strBuf.append(CMSOAPConstants.NS_BIBUS.getPrefix());
        strBuf.append("=\"");
        strBuf.append(CMSOAPConstants.NS_BIBUS.getUri());
        strBuf.append("\" xmlns:");
        strBuf.append(CMSOAPConstants.NS_CM.getPrefix());
        strBuf.append("=\"");
        strBuf.append(CMSOAPConstants.NS_CM.getUri());
        strBuf.append("\"");
        g_sCompleteCMPrefixes = strBuf.toString();
        strBuf = new StringBuffer(2048);
        strBuf.append(" ");
        strBuf.append("xsi");
        strBuf.append(":");
        strBuf.append("type");
        strBuf.append("=\"");
        g_sStartElemSeg1 = strBuf.toString();
        strBuf = new StringBuffer(2048);
        strBuf.append("SOAP-ENC");
        strBuf.append(":");
        strBuf.append("Array");
        strBuf.append("\" ");
        strBuf.append("SOAP-ENC");
        strBuf.append(":");
        strBuf.append("arrayType");
        strBuf.append("=\"");
        g_sStartElemSeg2 = strBuf.toString();
        strBuf = new StringBuffer(2048);
        strBuf.append(" ");
        strBuf.append("xsi");
        strBuf.append(":");
        strBuf.append("nil");
        strBuf.append("=\"");
        strBuf.append("true");
        strBuf.append("\"/>\r\n");
        g_sStartElemNil = strBuf.toString();
    }

    private class ElementIterator
    implements Iterator<XMLElement> {
        private XMLElement next_;
        CMIntList stack_ = new CMIntList(32);

        private ElementIterator(XMLElement root) {
            this.next_ = root;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.next_ != null;
        }

        @Override
        public XMLElement next() {
            if (this.next_ == null) {
                throw new NoSuchElementException();
            }
            XMLElement result = this.next_;
            if (this.next_.children_ != null) {
                this.stack_.add(0);
                this.next_ = this.next_.children_.get(0);
            } else {
                int stack_size = this.stack_.size();
                while (stack_size != 0) {
                    int idx = 1 + this.stack_.get(stack_size - 1);
                    if (idx < this.next_.parent_.children_.size()) {
                        this.next_ = this.next_.parent_.children_.get(idx);
                        this.stack_.set(stack_size - 1, idx);
                        break;
                    }
                    this.next_ = this.next_.parent_;
                    this.stack_.setSize(--stack_size);
                }
                if (stack_size == 0) {
                    this.next_ = null;
                }
            }
            return result;
        }
    }
}

