/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLTransformer;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import org.xml.sax.SAXException;

public class XMLPolicyTransformer
extends XMLTransformer {
    private static final String[] isSearchPath = new String[]{"securityObject", "searchPath", "value"};
    private static final String[] itemPath = new String[]{"item", "securityObject", "searchPath", "value"};

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("value") && this.testCurrentPath(isSearchPath)) {
            String value = this.getCurrentValue();
            String translated = XMLPolicyTransformer.translatePath(value);
            if (translated != null) {
                if (translated != value) {
                    this.setCurrentValue(translated);
                }
            } else {
                this.disableOutput(itemPath);
            }
        }
        super.endElement(uri, localName, qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translatePath(String path) {
        char c;
        if (path == null) {
            return null;
        }
        int iIndex = 0;
        iIndex = path.indexOf("::", 6);
        if (iIndex > 0 && (c = path.charAt(iIndex + 2)) >= '0' && c <= '9') {
            CMStoreQueryResults results = null;
            try {
                CMStore store = CMExecutionContext.get().getStore();
                results = store.executeQuery(new CMStoreXPath(path), null, null, 0, 512, null);
                if (!results.next()) {
                    String string = null;
                    return string;
                }
                path = results.getSearchPath();
            }
            catch (CMException ex) {
                System.out.println(ex);
            }
            catch (Exception ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
            finally {
                if (results != null) {
                    results.release();
                }
            }
        }
        return path;
    }
}

