/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server;

import com.cognos.cm.server.XMLTransformerElement;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLTransformer
implements ContentHandler,
ErrorHandler {
    protected HashMap<String, String> prefixes_;
    protected StringBuffer output_;
    protected String tabs_ = "";
    protected XMLTransformerElement currElement_;
    protected boolean outputPrefixes_ = false;
    protected boolean disableOutput_;
    protected StringBuffer sLastCharacters_;
    public boolean bWriteDocTag_ = false;

    public String transformXML(String s) throws Exception {
        return this.transformXML(new InputSource(new StringReader(s)));
    }

    public String transformXML(InputStream is) throws Exception {
        return this.transformXML(new InputSource(is));
    }

    public String transformXML(Reader reader) throws Exception {
        return this.transformXML(new InputSource(reader));
    }

    public String transformXML(InputSource inputSource) throws Exception {
        XMLReader saxParser = null;
        this.output_ = new StringBuffer();
        this.prefixes_ = new HashMap();
        try {
            saxParser = CMXMLUtils.getSAXParserFromPool();
            saxParser.setContentHandler(this);
            saxParser.setErrorHandler(this);
            saxParser.parse(inputSource);
        }
        catch (SAXException saxE) {
            Exception ex = saxE.getException();
            if (ex != null) {
                throw ex;
            }
            throw saxE;
        }
        finally {
            CMXMLUtils.returnSAXParserToPool(saxParser);
        }
        return this.output_.toString();
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.bWriteDocTag_) {
            this.output_.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.sLastCharacters_ = null;
        this.currElement_ = new XMLTransformerElement(this.currElement_, this.tabs_, this.output_.length(), localName);
        if (this.disableOutput_) {
            return;
        }
        this.tabs_ = this.tabs_ + "\t";
        this.output_.append("<");
        this.output_.append(qName);
        if (this.outputPrefixes_) {
            Iterator<String> i;
            Set<String> s = this.prefixes_.keySet();
            if (s != null && (i = s.iterator()) != null) {
                while (i.hasNext()) {
                    String key = i.next();
                    this.output_.append(" xmlns:");
                    this.output_.append(key);
                    this.output_.append("=\"");
                    this.output_.append(XMLUtils.encode((String)this.prefixes_.get(key)));
                    this.output_.append("\"");
                }
            }
            this.outputPrefixes_ = false;
        }
        if (attributes != null) {
            int attrLen = attributes.getLength();
            for (int i = 0; i < attrLen; ++i) {
                this.output_.append(" ");
                this.output_.append(attributes.getQName(i));
                this.output_.append("=\"");
                this.output_.append(XMLUtils.encode((String)attributes.getValue(i)));
                this.output_.append("\"");
            }
        }
        this.output_.append(">");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.disableOutput_) {
            if (this.sLastCharacters_ != null) {
                String value = this.sLastCharacters_.toString();
                value.trim();
                if (value.length() > 0) {
                    this.output_.append(XMLUtils.encode((String)this.sLastCharacters_.toString()));
                }
            }
            this.output_.append("</");
            this.output_.append(qName);
            this.output_.append(">");
        }
        if (this.disableOutput_ && this.currElement_.donotOutputThisElement_) {
            this.output_.setLength(this.currElement_.iLocation_);
            this.disableOutput_ = false;
        }
        this.tabs_ = this.currElement_.tabs_;
        this.currElement_ = this.currElement_.parent_;
        this.sLastCharacters_ = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.disableOutput_) {
            return;
        }
        if (this.sLastCharacters_ == null) {
            this.sLastCharacters_ = new StringBuffer(length);
            this.sLastCharacters_.append(ch, start, length);
        } else {
            this.sLastCharacters_.append(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.prefixes_.remove(prefix);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixes_.put(prefix, uri);
        if (!this.disableOutput_) {
            this.outputPrefixes_ = true;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    protected boolean testCurrentPath(String[] path) {
        int idx;
        XMLTransformerElement elem = this.currElement_;
        for (idx = path.length - 1; idx >= 0 && elem != null; --idx) {
            if (!elem.name_.equals(path[idx])) {
                return false;
            }
            elem = elem.parent_;
        }
        return idx < 0;
    }

    protected String getCurrentValue() {
        String value = null;
        if (this.sLastCharacters_ != null) {
            value = this.sLastCharacters_.toString();
            value.trim();
        }
        return value;
    }

    protected void setCurrentValue(String value) {
        this.sLastCharacters_ = new StringBuffer(value);
    }

    protected void disableOutput(String[] itemPath) {
        XMLTransformerElement elem = this.currElement_;
        for (int idx = itemPath.length - 1; idx >= 0 && elem != null; --idx) {
            if (!elem.name_.equals(itemPath[idx])) {
                throw new IllegalStateException("Could not find path to disable");
            }
            if (idx == 0) {
                elem.donotOutputThisElement_ = true;
            }
            elem = elem.parent_;
        }
        this.disableOutput_ = true;
    }
}

