/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.parameterValues;

import com.cognos.cm.indications.CMIndications;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class GlobalParametersResolver {
    private GlobalParametersResolver() {
    }

    public static JSONObject resolveParameterValues(JSONObject parametersDictionary, List<JSONObject> systemOrTenantParameterValues, JSONObject roleParameterValues, JSONObject accountParameterValues) {
        JSONObject effectiveGlobalParameters = new JSONObject();
        Set parameterNames = roleParameterValues.keySet();
        for (String parameterName : parameterNames) {
            if (!parametersDictionary.containsKey((Object)parameterName)) continue;
            JSONObject globalParameter = (JSONObject)parametersDictionary.get((Object)parameterName);
            JSONObject roleParameterValue = (JSONObject)roleParameterValues.get((Object)parameterName);
            if (roleParameterValue == null || !GlobalParametersResolver.isGlobalParameterEnabled(globalParameter)) continue;
            JSONObject accountOverride = (JSONObject)accountParameterValues.remove((Object)parameterName);
            if (accountOverride != null) {
                boolean enabled = roleParameterValue.containsKey((Object)"enabled") ? (Boolean)roleParameterValue.get((Object)"enabled") : true;
                accountOverride.put((Object)"enabled", (Object)enabled);
                effectiveGlobalParameters.put((Object)parameterName, (Object)accountOverride);
                continue;
            }
            effectiveGlobalParameters.put((Object)parameterName, (Object)roleParameterValue);
        }
        for (JSONObject systemOrTenantParameterValue : systemOrTenantParameterValues) {
            if (!GlobalParametersResolver.isGlobalParameterEnabled(systemOrTenantParameterValue)) continue;
            String parameterName = (String)systemOrTenantParameterValue.get((Object)"name");
            JSONObject effectiveParameter = (JSONObject)effectiveGlobalParameters.get((Object)parameterName);
            if (effectiveParameter == null) {
                JSONObject value = new JSONObject();
                value.put((Object)"name", (Object)parameterName);
                value.put((Object)"enabled", (Object)true);
                JSONObject accountOverride = (JSONObject)accountParameterValues.get((Object)parameterName);
                if (accountOverride != null) {
                    value.put((Object)"values", accountOverride.get((Object)"values"));
                } else {
                    value.put((Object)"values", (Object)new JSONArray());
                }
                effectiveGlobalParameters.put((Object)parameterName, (Object)value);
                continue;
            }
            effectiveParameter.put((Object)"enabled", (Object)true);
        }
        return effectiveGlobalParameters;
    }

    public static JSONObject resolveParameters(JSONObject systemParameters, JSONObject tenantParameters) {
        JSONObject resolvedParameters = new JSONObject();
        GlobalParametersResolver.addToResolvedParameters(resolvedParameters, tenantParameters);
        GlobalParametersResolver.addToResolvedParameters(resolvedParameters, systemParameters);
        return resolvedParameters;
    }

    public static List<JSONObject> getSystemOrTenantParameterValues(JSONObject parametersDictionary) {
        ArrayList<JSONObject> systemAndTenantLevelParameters = new ArrayList<JSONObject>();
        Set parameterNames = parametersDictionary.keySet();
        for (String parameterName : parameterNames) {
            JSONObject parameter = (JSONObject)parametersDictionary.get((Object)parameterName);
            Boolean systemOrTenantParameter = (Boolean)parameter.get((Object)"accessibleAtSystemOrTenantLevel");
            if (systemOrTenantParameter == null || !systemOrTenantParameter.booleanValue()) continue;
            systemAndTenantLevelParameters.add(parameter);
        }
        return systemAndTenantLevelParameters;
    }

    private static void addToResolvedParameters(JSONObject resolvedParameters, JSONObject roleParameters) {
        if (roleParameters != null) {
            Set parameterNames = roleParameters.keySet();
            for (String parameterName : parameterNames) {
                JSONObject roleParameter;
                if (resolvedParameters.containsKey((Object)parameterName) || !GlobalParametersResolver.isGlobalParameterEnabled(roleParameter = (JSONObject)roleParameters.get((Object)parameterName))) continue;
                resolvedParameters.put((Object)parameterName, (Object)roleParameter);
            }
        }
    }

    private static boolean isGlobalParameterEnabled(JSONObject parameter) {
        Boolean parameterEnabled = true;
        if (parameter.containsKey((Object)"disabled")) {
            try {
                parameterEnabled = (Boolean)parameter.get((Object)"disabled") == false;
            }
            catch (Exception e) {
                CMIndications.logException(e);
            }
        }
        return parameterEnabled;
    }
}

