/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.parameterValues;

import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.parameterValues.BoundRangeParmValueItem;
import com.cognos.cm.server.parameterValues.HierarchicalParmValueItem;
import com.cognos.cm.server.parameterValues.ParmValueItem;
import com.cognos.cm.server.parameterValues.SimpleParmValueItem;
import com.cognos.cm.server.parameterValues.UnboundedEndRangeParmValueItem;
import com.cognos.cm.server.parameterValues.UnboundedStartRangeParmValueItem;
import com.cognos.cm.util.CMSOAPWriter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;

public class ParameterValue {
    private String name;
    private ArrayList<ParmValueItem> parmValueItems = new ArrayList();

    public String getName() {
        return this.name;
    }

    public void fromJSON(JSONObject jsonParameter) {
        this.name = (String)jsonParameter.get((Object)"name");
        JSONArray jsonParmValueItems = (JSONArray)jsonParameter.get((Object)"values");
        int numberOfParmValueItems = jsonParmValueItems.size();
        for (int parmValueItemIndex = 0; parmValueItemIndex < numberOfParmValueItems; ++parmValueItemIndex) {
            JSONObject jsonParmValueItem = (JSONObject)jsonParmValueItems.get(parmValueItemIndex);
            ParmValueItem parmValueItem = this.loadParmValueItemFromJSON(jsonParmValueItem);
            this.parmValueItems.add(parmValueItem);
        }
    }

    private ParmValueItem loadParmValueItemFromJSON(JSONObject jsonParmValueItem) {
        ParmValueItem parmValueItem = jsonParmValueItem.containsKey((Object)"start") && jsonParmValueItem.containsKey((Object)"end") ? new BoundRangeParmValueItem() : (jsonParmValueItem.containsKey((Object)"start") ? new UnboundedEndRangeParmValueItem() : (jsonParmValueItem.containsKey((Object)"end") ? new UnboundedStartRangeParmValueItem() : (jsonParmValueItem.containsKey((Object)"subNodes") ? new HierarchicalParmValueItem() : new SimpleParmValueItem())));
        parmValueItem.fromJSON(jsonParmValueItem);
        return parmValueItem;
    }

    public void toXMLBlob(CMSOAPWriter parent) {
        CMSOAPWriter itemWriter = (CMSOAPWriter)parent.element("item");
        itemWriter.type(CMPropertyTypes.BIBUS_PARAMETERVALUE);
        ((CMSOAPWriter)((CMSOAPWriter)itemWriter.element("name")).type(CMPropertyTypes.XML_STRING).text(this.name)).end();
        CMSOAPWriter parmValueItemsWriter = (CMSOAPWriter)itemWriter.element("value");
        parmValueItemsWriter.arrayType(CMPropertyTypes.BIBUS_PARMVALUEITEM, -1);
        for (ParmValueItem parmValueItem : this.parmValueItems) {
            parmValueItem.toXMLBlob(parmValueItemsWriter, "item");
        }
        parmValueItemsWriter.end();
        itemWriter.end();
    }
}

