/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.parameterValues;

import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.parameterValues.ParameterValue;
import com.cognos.cm.util.CMSOAPWriter;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ParameterValues {
    public static String JSONToXMLBlob(String rootNodeName, JSONObject jsonParameterValues) {
        List<ParameterValue> values = ParameterValues.fromJSON(jsonParameterValues);
        return ParameterValues.toXMLBlob(rootNodeName, values);
    }

    private static List<ParameterValue> fromJSON(JSONObject jsonParameterValues) {
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        Set parameterNames = jsonParameterValues.keySet();
        for (String parameterName : parameterNames) {
            try {
                JSONObject jsonParameter = (JSONObject)jsonParameterValues.get((Object)parameterName);
                Boolean enabled = (Boolean)jsonParameter.get((Object)"enabled");
                if (enabled != null && !enabled.booleanValue()) continue;
                ParameterValue parameterValue = new ParameterValue();
                parameterValue.fromJSON(jsonParameter);
                values.add(parameterValue);
            }
            catch (Exception exception) {}
        }
        return values;
    }

    private static String toXMLBlob(String rootNodeName, List<ParameterValue> values) {
        StringBuilder buffer = new StringBuilder();
        CMSOAPWriter xml = new CMSOAPWriter(buffer);
        xml.setTrackNamespaces(false);
        CMSOAPWriter parameterValuesWriter = (CMSOAPWriter)xml.element(rootNodeName);
        parameterValuesWriter.namespace(CMSOAPConstants.NS_CM);
        parameterValuesWriter.arrayType(CMPropertyTypes.BIBUS_PARAMETERVALUE, -1);
        for (ParameterValue parameterValue : values) {
            parameterValue.toXMLBlob(parameterValuesWriter);
        }
        ((CMSOAPWriter)parameterValuesWriter.end()).close();
        return buffer.toString();
    }
}

