/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.profileSettings;

import com.cognos.cm.server.profileSettings.ProfileCacheEntry;
import com.cognos.cm.store.InternalStoreId;
import java.util.Arrays;

public class ProfileCache {
    private static final int INITIAL_SIZE = 32;
    private int size = 32;
    private int mask = 31;
    private int count = 0;
    private ProfileCacheEntry[] entries = new ProfileCacheEntry[this.size];
    private ProfileCacheEntry[] tenanted = new ProfileCacheEntry[1];

    public synchronized ProfileCacheEntry get(int tenantId) {
        if (tenantId >= this.tenanted.length) {
            return null;
        }
        return this.tenanted[tenantId];
    }

    public synchronized ProfileCacheEntry get(InternalStoreId storeID) {
        if (storeID == null) {
            return null;
        }
        int idx = this.getIndex(storeID);
        for (ProfileCacheEntry entry = this.entries[idx]; entry != null; entry = entry.getNext()) {
            if (!entry.getStoreId().equals((Object)storeID)) continue;
            entry.updateReferenceCount(1);
            return entry;
        }
        return null;
    }

    private int getIndex(InternalStoreId id) {
        return id.hashCode() & this.mask;
    }

    public synchronized ProfileCacheEntry put(ProfileCacheEntry entry) {
        InternalStoreId storeId = entry.getStoreId();
        if (storeId == null) {
            return null;
        }
        int idx = this.getIndex(storeId);
        for (ProfileCacheEntry item = this.entries[idx]; item != null; item = item.getNext()) {
            if (!item.getStoreId().equals((Object)storeId)) continue;
            item.updateReferenceCount(1);
            return item;
        }
        ++this.count;
        if (this.count > this.size) {
            this.rehash();
            idx = this.getIndex(storeId);
        }
        entry.setNext(this.entries[idx]);
        this.entries[idx] = entry;
        entry.updateReferenceCount(1);
        this.addToTenants(entry);
        return entry;
    }

    private void addToTenants(ProfileCacheEntry entry) {
        int tenantId = entry.getTenantId();
        if (tenantId < 0) {
            return;
        }
        if (tenantId >= this.tenanted.length) {
            this.tenanted = Arrays.copyOf(this.tenanted, tenantId + 1);
        }
        this.tenanted[tenantId] = entry;
    }

    private void rehash() {
        int oldSize = this.size;
        this.size <<= 1;
        this.mask = this.size - 1;
        ProfileCacheEntry[] tmp = new ProfileCacheEntry[this.size];
        for (int i = 0; i < oldSize; ++i) {
            ProfileCacheEntry entry = this.entries[i];
            while (entry != null) {
                ProfileCacheEntry next = entry.getNext();
                int idx = this.getIndex(entry.getStoreId());
                entry.setNext(tmp[idx]);
                tmp[idx] = entry;
                entry = next;
            }
        }
        this.entries = tmp;
    }

    public void remove(ProfileCacheEntry entry) {
        this.removeInternal(entry.getStoreId(), false);
    }

    public void remove(InternalStoreId storeId) {
        this.removeInternal(storeId, false);
    }

    public void discard(InternalStoreId storeId) {
        this.removeInternal(storeId, true);
    }

    private synchronized void removeInternal(InternalStoreId storeId, boolean discard) {
        if (storeId == null) {
            return;
        }
        int idx = this.getIndex(storeId);
        ProfileCacheEntry prev = null;
        for (ProfileCacheEntry item = this.entries[idx]; item != null; item = item.getNext()) {
            if (item.getStoreId().equals((Object)storeId)) {
                int tenantId;
                if (discard || item.updateReferenceCount(-1) == 0) {
                    if (prev == null) {
                        this.entries[idx] = item.getNext();
                    } else {
                        prev.setNext(item.getNext());
                    }
                    --this.count;
                }
                if ((tenantId = item.getTenantId()) < 0 || tenantId >= this.tenanted.length) break;
                this.tenanted[tenantId] = null;
                break;
            }
            prev = item;
        }
    }
}

