/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.profileSettings;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.profileSettings.ProfileDescriptionEntry;
import com.cognos.cm.server.profileSettings.ProfileDescriptions;
import com.cognos.cm.store.InternalStoreId;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

class ProfileCacheEntry {
    private static final int[] EMPTY_IDS = new int[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    public static final ProfileCacheEntry NULL_ENTRY = new ProfileCacheEntry(null, -9999, null);
    private InternalStoreId storeId;
    private int tenantId;
    private int[] ids;
    private Object[] values;
    private int refCount;
    private ProfileCacheEntry next;
    private JSONObject parametersDictionary;

    ProfileCacheEntry(InternalStoreId storeId, int tenantId, JSONObject json) {
        this.storeId = storeId;
        this.tenantId = tenantId;
        if (json == null || json.isEmpty()) {
            this.ids = EMPTY_IDS;
            this.values = EMPTY_VALUES;
            return;
        }
        this.ids = new int[json.size()];
        this.values = new Object[json.size()];
        ProfileDescriptions descriptions = ProfileDescriptions.getInstance();
        ProfileDescriptionEntry parametersDescription = descriptions.get("parameters");
        int n = 0;
        for (Map.Entry entry : json.entrySet()) {
            ProfileDescriptionEntry description = descriptions.get((String)entry.getKey());
            if (description == null || entry.getValue() == null) continue;
            this.ids[n] = description.getId();
            this.values[n] = description.castValue(entry.getValue());
            if (tenantId != -9999 && parametersDescription == description) {
                try {
                    this.parametersDictionary = JSONObject.parse((String)((String)this.values[n]));
                }
                catch (IOException ioException) {
                    CMIndications.logException(ioException);
                }
            }
            ++n;
        }
        if (n == 0) {
            this.ids = EMPTY_IDS;
            this.values = EMPTY_VALUES;
        } else if (n != json.size()) {
            this.ids = Arrays.copyOf(this.ids, n);
            this.values = Arrays.copyOf(this.values, n);
        }
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public JSONObject getParametersDictionary() {
        return this.parametersDictionary;
    }

    public InternalStoreId getStoreId() {
        return this.storeId;
    }

    public int getReferenceCount() {
        return this.refCount;
    }

    void removeEntries(Collection<Integer> invalid) {
        int[] new_ids = new int[this.ids.length - invalid.size()];
        Object[] new_values = new Object[this.ids.length - invalid.size()];
        int dstIdx = 0;
        for (int srcIdx = 0; srcIdx < this.ids.length; ++srcIdx) {
            if (invalid.contains(this.ids[srcIdx])) continue;
            new_ids[dstIdx] = this.ids[srcIdx];
            new_values[dstIdx] = this.values[srcIdx];
            ++dstIdx;
        }
        this.ids = new_ids;
        this.values = new_values;
    }

    public Object getValue(Integer id) {
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] != id) continue;
            return this.values[i];
        }
        return null;
    }

    public void setValue(Integer id, Object newValue) {
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] != id) continue;
            this.values[i] = newValue;
            return;
        }
        int[] new_ids = new int[this.ids.length + 1];
        Object[] new_values = new Object[this.values.length + 1];
        for (int i = 0; i < this.ids.length; ++i) {
            new_ids[i] = this.ids[i];
            new_values[i] = this.values[i];
        }
        new_ids[new_ids.length - 1] = id;
        new_values[new_values.length - 1] = newValue;
        this.ids = new_ids;
        this.values = new_values;
    }

    int updateReferenceCount(int increment) {
        this.refCount += increment;
        return this.refCount;
    }

    ProfileCacheEntry getNext() {
        return this.next;
    }

    void setNext(ProfileCacheEntry entry) {
        this.next = entry;
    }

    public boolean isEmpty() {
        return this.ids.length == 0;
    }

    public Iterable<Setting> settings() {
        return new Iterable<Setting>(){

            @Override
            public Iterator<Setting> iterator() {
                return new Iterator<Setting>(){
                    int i = 0;
                    Setting sv = new Setting();

                    @Override
                    public boolean hasNext() {
                        return this.i != ProfileCacheEntry.this.ids.length;
                    }

                    @Override
                    public Setting next() {
                        this.sv.id = ProfileCacheEntry.this.ids[this.i];
                        this.sv.value = ProfileCacheEntry.this.values[this.i];
                        ++this.i;
                        return this.sv;
                    }
                };
            }
        };
    }

    public static final class Setting {
        private int id;
        private Object value;

        public int getId() {
            return this.id;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

