/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.profileSettings;

import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.profileSettings.ProfileDescriptionEntry;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.JsonWriter;
import com.cognos.cmutils.resource.CMResourceLoader;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ProfileDescriptions
extends AbstractCollection<ProfileDescriptionEntry> {
    private static final String USER_PROFILE_SETTINGS = "userProfileSettings";
    private static ProfileDescriptions instance;
    private ProfileDescriptionEntry[] byId;
    private HashMap<String, ProfileDescriptionEntry> byName;

    private static <E> Iterable<E> iterable(final Iterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return iterator;
            }
        };
    }

    ProfileDescriptions(OrderedJSONObject defs) {
        this.byId = new ProfileDescriptionEntry[defs.size()];
        this.byName = new HashMap(defs.size());
        int i = 0;
        for (Object name : ProfileDescriptions.iterable(defs.getOrder())) {
            ProfileDescriptionEntry entry;
            JSONObject def = (JSONObject)defs.get(name);
            this.byId[i] = entry = new ProfileDescriptionEntry((String)name, i, (String)def.get((Object)"type"), def.get((Object)"value"));
            this.byName.put(entry.getName(), entry);
            ++i;
        }
    }

    public static ProfileDescriptions load() throws CMConfigurationException {
        OrderedJSONObject descJson = ProfileDescriptions.loadDescriptions();
        instance = new ProfileDescriptions(descJson);
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OrderedJSONObject loadDescriptions() throws CMConfigurationException {
        CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
        String fileName = "/WEB-INF/cm/userProfileSettings.json";
        try (InputStream is = resourceLoader.getResourceInputStream(fileName);){
            OrderedJSONObject orderedJSONObject = (OrderedJSONObject)OrderedJSONObject.parse((InputStream)is);
            return orderedJSONObject;
        }
        catch (IOException e) {
            throw new CMConfigurationException("cmNoConfigFile", new CMException.Parm("File", fileName));
        }
    }

    public static ProfileDescriptions getInstance() {
        return instance;
    }

    public ProfileDescriptionEntry get(int id) {
        return this.byId[id];
    }

    public ProfileDescriptionEntry get(String name) {
        return this.byName.get(name);
    }

    public boolean contains(String name) {
        return this.byName.get(name) != null;
    }

    @Override
    public int size() {
        return this.byId.length;
    }

    @Override
    public Iterator<ProfileDescriptionEntry> iterator() {
        return new Iterator<ProfileDescriptionEntry>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ProfileDescriptions.this.byId.length;
            }

            @Override
            public ProfileDescriptionEntry next() {
                return ProfileDescriptions.this.byId[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    ResourceBundle getDescriptionsBundle() {
        Locale locale = CMExecutionContext.get().getRequestLocale("contentLocale").toLocale();
        try {
            return ResourceBundle.getBundle(USER_PROFILE_SETTINGS, locale, this.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            try {
                locale = ConfigurationFactory.getConfig().getServerLocale().toLocale();
                return ResourceBundle.getBundle(USER_PROFILE_SETTINGS, locale, this.getClass().getClassLoader());
            }
            catch (MissingResourceException ee) {
                return null;
            }
        }
    }

    public void writeTo(Writer wrt) throws IOException {
        ResourceBundle bundle = this.getDescriptionsBundle();
        JsonWriter jw = new JsonWriter(wrt);
        wrt.write("{\n");
        try {
            String separator = "";
            for (ProfileDescriptionEntry entry : this.byId) {
                wrt.write(separator);
                jw.write(entry.getName());
                wrt.write(":{\"type\":\"");
                wrt.write(entry.getType().name().toLowerCase());
                wrt.write("\",\"value\":");
                if (entry.getType() == ProfileDescriptionEntry.EntryType.JSON) {
                    wrt.write((String)entry.getDefaultValue());
                } else {
                    jw.write(entry.getDefaultValue());
                }
                wrt.write(",\"description\":");
                String description = "";
                if (bundle != null) {
                    try {
                        description = bundle.getString(entry.getName());
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                jw.write(description);
                wrt.write("}");
                separator = ",\n";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        wrt.write("\n}");
        wrt.flush();
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeTo(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

