/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.profileSettings;

import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.server.profileSettings.ProfileCache;
import com.cognos.cm.server.profileSettings.ProfileCacheEntry;
import com.cognos.cm.server.profileSettings.ProfileDescriptionEntry;
import com.cognos.cm.server.profileSettings.ProfileDescriptions;
import com.cognos.cm.server.profileSettings.SessionProfileSettings;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cmutils.path.SearchPathEncoder;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ProfilesManager {
    private static ProfilesManager instance = new ProfilesManager();
    ProfileCache profilesCache = new ProfileCache();

    public static ProfilesManager getInstance() {
        return instance;
    }

    ProfilesManager() {
    }

    public boolean isEnabled() {
        return true;
    }

    ProfileCache getProfilesCache() {
        return this.profilesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSystemDefaultSettings(CMStore store, boolean loadDescriptions) {
        try {
            if (loadDescriptions) {
                ProfileDescriptions.load();
            }
            CMStorePath path = CMStoreXPath.parse("/configuration/role[@tenantID='']");
            store.getLockManager().requestLocks(path);
            CMStoreQueryResults rs = null;
            CMProperty[] props = new CMProperty[]{CMProperty.USERPROFILESETTINGS};
            try {
                store.beginTransaction();
                rs = store.executeQuery(path, props, null, 7, 512, null);
                if (rs.next()) {
                    int cmid = rs.getObjectID();
                    InternalStoreId storeId = store.getInternalStoreId(cmid);
                    JSONObject systemSettings = ProfilesManager.readPropfileSettings(rs);
                    if (this.applyDefaultSettings(systemSettings)) {
                        rs.reset();
                        this.updateRoleSettings(store, rs, systemSettings);
                    }
                    this.profilesCache.put(new ProfileCacheEntry(storeId, 0, systemSettings));
                }
                rs.release();
                rs = null;
                store.commitTransaction();
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(rs);
                try {
                    store.rollbackOpenTransaction();
                }
                catch (CMException cMException) {
                    // empty catch block
                }
                this.releaseLocks(store);
                throw throwable;
            }
            CMQueryUtils.safeQueryResultsRelease(rs);
            try {
                store.rollbackOpenTransaction();
            }
            catch (CMException cMException) {
                // empty catch block
            }
            this.releaseLocks(store);
        }
        catch (CMException e) {
            CMIndications.logException(e);
            return false;
        }
        return true;
    }

    private void updateRoleSettings(CMStore store, CMStoreQueryResults rs, JSONObject json) throws CMException {
        List<CMProperty> props = Collections.singletonList(CMProperty.USERPROFILESETTINGS);
        String value = json.toString();
        ArrayList<Object> values = new ArrayList<Object>(1);
        values.add(value);
        store.update(rs, props, values);
    }

    /*
     * Unable to fully structure code
     */
    boolean applyDefaultSettings(JSONObject settings) throws CMException {
        updated = this.removeObsoleteEntries(settings);
        descriptions = ProfileDescriptions.getInstance();
        for (ProfileDescriptionEntry entry : descriptions) {
            value = settings.get((Object)entry.getName());
            if (value != null) continue;
            value = entry.getDefaultValue();
            if (value != null && entry.getType() == ProfileDescriptionEntry.EntryType.JSON) {
                s = (String)value;
                if (!s.isEmpty()) {
                    ch = s.charAt(0);
                    try {
                        if (ch == '[') {
                            value = JSONArray.parse((String)s);
                        }
                        if (ch != '{') ** GOTO lbl21
                        value = JSONObject.parse((String)s);
                    }
                    catch (IOException ie) {
                        throw new CMException((Exception)ie, "cmPropReadFail", new CMException.Parm[]{new CMException.Parm("Prop", CMProperty.USERPROFILESETTINGS.getName())});
                    }
                } else {
                    value = null;
                }
            }
lbl21:
            // 6 sources

            settings.put((Object)entry.getName(), value);
            updated = true;
        }
        return updated;
    }

    private boolean removeObsoleteEntries(JSONObject settings) {
        boolean updated = false;
        ProfileDescriptions descriptions = ProfileDescriptions.getInstance();
        Iterator it = settings.keySet().iterator();
        while (it.hasNext()) {
            if (descriptions.contains((String)it.next())) continue;
            it.remove();
            updated = true;
        }
        return updated;
    }

    private void releaseLocks(CMStore store) {
        try {
            store.getLockManager().releaseLocks();
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
    }

    static JSONObject readPropfileSettings(CMStoreQueryResults qresults) throws CMException {
        JSONObject result;
        Object valueObj = qresults.getValue(0);
        if (valueObj != null) {
            Reader reader = null;
            if (valueObj instanceof Reader) {
                reader = (Reader)valueObj;
            } else {
                String strValue = valueObj.toString();
                reader = new StringReader(strValue);
            }
            try {
                result = JSONObject.parse((Reader)reader);
            }
            catch (IOException ie) {
                throw new CMException((Exception)ie, "cmPropReadFail", new CMException.Parm("Prop", CMProperty.USERPROFILESETTINGS.getName()));
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        } else {
            result = new JSONObject();
        }
        return result;
    }

    public SessionProfileSettings createSessionProfileSettings(CMExecutionContext ctx) {
        try {
            SessionBuilder builder = new SessionBuilder(ctx);
            return builder.build();
        }
        catch (CMException e) {
            CMIndications.logException(e);
            return null;
        }
    }

    private static class SessionBuilder {
        private CMExecutionContext ctx;
        private CMStore store;
        private ProfileCache cache;
        private CMProperty[] props = new CMProperty[]{CMProperty.USERPROFILESETTINGS};
        private CMLockManager lockMgr;
        private boolean useLocks;
        private CMObjectReference profileRole;

        SessionBuilder(CMExecutionContext ctx) throws CMException {
            this.ctx = ctx;
            this.store = ctx.getStore();
            this.cache = ProfilesManager.getInstance().getProfilesCache();
            this.lockMgr = (CMLockManager)this.store.getLockManager();
            this.useLocks = !this.lockMgr.hasLocks();
        }

        SessionProfileSettings build() {
            ProfileCacheEntry system = this.createTenantedEntry(0);
            int tenantId = this.ctx.getCurrentUserTenantId();
            ProfileCacheEntry tenant = null;
            if (tenantId > 0) {
                tenant = this.createTenantedEntry(tenantId);
            }
            ProfileCacheEntry role = this.initRoleSettings();
            ProfileCacheEntry account = this.initAccountSettings();
            return new SessionProfileSettings(this.profileRole, system, tenant, role, account);
        }

        private void lock(CMStorePath path) throws CMException {
            if (this.useLocks) {
                this.lockMgr.requestLocks(path);
            }
        }

        private void releaseLocks() {
            if (this.useLocks) {
                try {
                    this.lockMgr.releaseLocks();
                }
                catch (CMException cMException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProfileCacheEntry createTenantedEntry(int tenantId) {
            ProfileCacheEntry result = this.cache.get(tenantId);
            if (result == null) {
                CMStoreQueryResults rs = null;
                CMProperty[] props = new CMProperty[]{CMProperty.USERPROFILESETTINGS};
                try {
                    CMStoreXPath path = this.buildTenantedProfilesPath(this.store, tenantId);
                    this.lock(path);
                    rs = this.store.executeQuery(path, props, null, 0, 512, null);
                    if (rs.next()) {
                        result = this.createCacheEntry(rs, tenantId);
                    }
                    CMQueryUtils.safeQueryResultsRelease(rs);
                    this.releaseLocks();
                }
                catch (CMException e) {
                    CMIndications.logException(e);
                }
                finally {
                    CMQueryUtils.safeQueryResultsRelease(rs);
                    this.releaseLocks();
                }
            }
            return result;
        }

        private ProfileCacheEntry createCacheEntry(CMStoreQueryResults rs, int tenantId) throws CMException {
            int cmid = rs.getObjectID();
            InternalStoreId storeId = this.store.getInternalStoreId(cmid);
            ProfileCacheEntry entry = this.cache.get(storeId);
            if (entry == null) {
                JSONObject json = ProfilesManager.readPropfileSettings(rs);
                entry = this.cache.put(new ProfileCacheEntry(storeId, tenantId, json));
            }
            return entry;
        }

        private CMStoreXPath buildTenantedProfilesPath(CMStore store, int tenantId) throws CMStoreParseException {
            String tenant = tenantId == 0 ? "" : store.getTenantRegistry().getTenantIdStringFromInt(tenantId);
            StringBuilder buf = new StringBuilder();
            buf.append("/configuration/role[@tenantID=").append(SearchPathEncoder.quoteString((String)tenant)).append(']');
            return new CMStoreXPath(buf.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProfileCacheEntry initRoleSettings() {
            block7: {
                ArrayList<CMObjectReference> roles = this.getCognosRoles();
                if (roles.isEmpty()) {
                    return null;
                }
                OrderByField[] orderBy = new OrderByField[]{new OrderByField(true, CMObjectClass.ROLE.getProperty("profileRank")), new OrderByField(false, CMProperty.CREATIONTIME)};
                CMStoreQueryResults rs = null;
                try {
                    CMStoreXPath path = this.createUnionPath(roles);
                    this.lock(path);
                    rs = this.store.executeQuery(path, this.props, orderBy, 0, 512, null);
                    if (rs.next()) {
                        this.profileRole = this.createObjectReference(rs);
                        ProfileCacheEntry profileCacheEntry = this.createCacheEntry(rs, -9999);
                        CMQueryUtils.safeQueryResultsRelease(rs);
                        this.releaseLocks();
                        return profileCacheEntry;
                    }
                    CMQueryUtils.safeQueryResultsRelease(rs);
                }
                catch (CMException e) {
                    CMIndications.logException(e);
                    break block7;
                }
                finally {
                    CMQueryUtils.safeQueryResultsRelease(rs);
                    this.releaseLocks();
                }
                this.releaseLocks();
            }
            return null;
        }

        private CMObjectReference createObjectReference(CMStoreQueryResults rs) throws CMException {
            String secRef = rs.getSecurityReference();
            String path = rs.getSearchPath();
            CMDbStoreObjectReference result = new CMDbStoreObjectReference(CMObjectClass.ROLE, path, secRef);
            String storeId = CMCAMIDHelper.normalizeStoreID(path);
            result.setStoreID(storeId);
            return result;
        }

        private ArrayList<CMObjectReference> getCognosRoles() {
            ArrayList<CMObjectReference> result = new ArrayList<CMObjectReference>();
            if (this.ctx.getCurrentUserIdentity() != null) {
                for (CMObjectReference ref : this.ctx.getCurrentUserIdentity()) {
                    if (!this.isCognosRole(ref)) continue;
                    result.add(ref);
                }
            }
            return result;
        }

        private boolean isCognosRole(CMObjectReference ref) {
            if (ref.getObjectClass() != CMObjectClass.ROLE) {
                return false;
            }
            String path = ref.getSecurityReference();
            return path != null && CMCAMIDHelper.isCognosNamespace(path);
        }

        private CMStoreXPath createUnionPath(ArrayList<CMObjectReference> roles) throws CMException {
            StringBuilder buf = new StringBuilder();
            String sep = "";
            for (CMObjectReference ref : roles) {
                buf.append(sep);
                sep = "|";
                buf.append(ref.getSearchPath());
            }
            return new CMStoreXPath(buf.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ProfileCacheEntry initAccountSettings() {
            block7: {
                String spath = this.ctx.getCurrentUserSearchPath();
                if (spath == null) {
                    return null;
                }
                CMStoreQueryResults rs = null;
                try {
                    CMStoreXPath path = new CMStoreXPath(spath);
                    this.lock(path);
                    rs = this.store.executeQuery(path, this.props, null, 0, 512, null);
                    if (rs.next()) {
                        int cmid = rs.getObjectID();
                        InternalStoreId storeId = this.store.getInternalStoreId(cmid);
                        JSONObject json = ProfilesManager.readPropfileSettings(rs);
                        ProfileCacheEntry profileCacheEntry = new ProfileCacheEntry(storeId, -9999, json);
                        CMQueryUtils.safeQueryResultsRelease(rs);
                        this.releaseLocks();
                        return profileCacheEntry;
                    }
                    CMQueryUtils.safeQueryResultsRelease(rs);
                }
                catch (CMException e) {
                    CMIndications.logException(e);
                    break block7;
                }
                finally {
                    CMQueryUtils.safeQueryResultsRelease(rs);
                    this.releaseLocks();
                }
                this.releaseLocks();
            }
            return null;
        }
    }
}

