/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.profileSettings;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.notification.NotificationObserver;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.server.profileSettings.ProfileCache;
import com.cognos.cm.server.profileSettings.ProfilesManager;
import com.cognos.cm.store.InternalStoreId;
import java.util.ArrayList;

public class ProfilesNotificationsObserver
implements NotificationObserver {
    private ProfileCache cache;
    private boolean enabled;

    public ProfilesNotificationsObserver() {
        ProfilesManager pm = ProfilesManager.getInstance();
        this.enabled = pm.isEnabled();
        this.cache = pm.getProfilesCache();
    }

    @Override
    public void addNotification(Notification notification) {
        if (!this.enabled) {
            return;
        }
        try {
            String storeId = notification.getStoreID();
            this.cache.discard(new InternalStoreId(storeId));
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
    }

    @Override
    public void addNotifications(ArrayList<Notification> notifications) {
        for (Notification n : notifications) {
            this.addNotification(n);
        }
    }

    @Override
    public void initialize(Subscription subscription) {
    }

    @Override
    public void enable(boolean enable) {
    }
}

