/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.profileSettings;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.server.parameterValues.GlobalParametersResolver;
import com.cognos.cm.server.parameterValues.ParameterValues;
import com.cognos.cm.server.profileSettings.ProfileCache;
import com.cognos.cm.server.profileSettings.ProfileCacheEntry;
import com.cognos.cm.server.profileSettings.ProfileDescriptionEntry;
import com.cognos.cm.server.profileSettings.ProfileDescriptions;
import com.cognos.cm.server.profileSettings.ProfilesManager;
import com.cognos.cm.util.JsonWriter;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;

public class SessionProfileSettings {
    private static final String USER_CAN_OVERRIDE = "_userCanOverride";
    private static final int IDX_ACCOUNT = 0;
    private static final int IDX_ROLE = 1;
    private static final int IDX_TENANT = 2;
    private static final int IDX_SYSTEM = 3;
    private CMObjectReference profileRole;
    private ProfileCacheEntry[] entries;
    private volatile int hashValue;

    public SessionProfileSettings(CMObjectReference profileRole, ProfileCacheEntry system, ProfileCacheEntry tenant, ProfileCacheEntry role, ProfileCacheEntry account) {
        this.profileRole = profileRole;
        this.entries = new ProfileCacheEntry[]{account, role, tenant, system};
        this.updateGlobalParameters(system, tenant, role, account);
        this.validateAccountSettings(this.entries[0]);
    }

    private JSONObject getEntryValue(ProfileCacheEntry profileCacheEntry, ProfileDescriptionEntry description) {
        String value;
        if (profileCacheEntry != null && description != null && (value = (String)profileCacheEntry.getValue(description.getId())) != null) {
            try {
                return JSONObject.parse((String)value);
            }
            catch (IOException ioException) {
                CMIndications.logException(ioException);
            }
        }
        return new JSONObject();
    }

    public void updateGlobalParameters(ProfileCacheEntry systemEntry, ProfileCacheEntry tenantEntry, ProfileCacheEntry roleEntry, ProfileCacheEntry accountEntry) {
        ProfileDescriptions descriptions = ProfileDescriptions.getInstance();
        JSONObject parametersDictionary = systemEntry.getParametersDictionary();
        if (tenantEntry != null) {
            parametersDictionary = GlobalParametersResolver.resolveParameters(parametersDictionary, tenantEntry.getParametersDictionary());
        }
        ProfileDescriptionEntry parameterValuesDescription = descriptions.get("parameter_values");
        if (parametersDictionary != null && !parametersDictionary.isEmpty()) {
            ProfileDescriptionEntry parametersDescription = descriptions.get("parameters");
            List<JSONObject> systemOrTenantParametersValues = GlobalParametersResolver.getSystemOrTenantParameterValues(parametersDictionary);
            JSONObject roleParameterValues = this.getEntryValue(roleEntry, parameterValuesDescription);
            if (!roleParameterValues.isEmpty() || !systemOrTenantParametersValues.isEmpty()) {
                JSONObject resolvedParameterValues = GlobalParametersResolver.resolveParameterValues(parametersDictionary, systemOrTenantParametersValues, roleParameterValues, this.getEntryValue(accountEntry, parameterValuesDescription));
                accountEntry.setValue(parameterValuesDescription.getId(), resolvedParameterValues.toString());
            } else if (accountEntry.getValue(parameterValuesDescription.getId()) != null) {
                accountEntry.setValue(parameterValuesDescription.getId(), "{}");
            }
            accountEntry.setValue(parametersDescription.getId(), parametersDictionary.toString());
        } else {
            accountEntry.setValue(parameterValuesDescription.getId(), "{}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccountSettings(String propValue) {
        ProfileCacheEntry newEntry = ProfileCacheEntry.NULL_ENTRY;
        try {
            Object json;
            if (propValue != null) {
                json = JSONObject.parse((String)propValue);
                newEntry = new ProfileCacheEntry(null, -9999, (JSONObject)json);
            }
            json = this;
            synchronized (json) {
                ProfileCacheEntry systemEntry = ProfilesManager.getInstance().getProfilesCache().get(0);
                this.updateGlobalParameters(systemEntry, this.entries[2], this.entries[1], newEntry);
                this.validateAccountSettings(newEntry);
                this.entries[0] = newEntry;
                this.hashValue = 0;
            }
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
    }

    public void delete() {
        ProfileCacheEntry entry = this.entries[1];
        if (entry != null) {
            ProfileCache cache = ProfilesManager.getInstance().getProfilesCache();
            cache.remove(entry);
            this.entries[1] = null;
        }
    }

    public CMObjectReference getProfileRole() {
        return this.profileRole;
    }

    private void validateAccountSettings(ProfileCacheEntry entry) {
        if (entry == null || entry.isEmpty()) {
            return;
        }
        HashSet<Integer> invalid = null;
        ProfileDescriptions descriptions = ProfileDescriptions.getInstance();
        for (ProfileCacheEntry.Setting setting : entry.settings()) {
            if (this.isAccountSettingValid(descriptions, setting)) continue;
            if (invalid == null) {
                invalid = new HashSet<Integer>();
            }
            invalid.add(setting.getId());
        }
        if (invalid != null) {
            entry.removeEntries(invalid);
        }
    }

    private boolean isAccountSettingValid(ProfileDescriptions descriptions, ProfileCacheEntry.Setting setting) {
        ProfileDescriptionEntry parameterValuesDescription = descriptions.get("parameter_values");
        ProfileDescriptionEntry parametersDescription = descriptions.get("parameters");
        if (setting.getId() == parameterValuesDescription.getId() || setting.getId() == parametersDescription.getId()) {
            return true;
        }
        ProfileDescriptionEntry pde = descriptions.get(setting.getId());
        ProfileDescriptionEntry pdeOv = descriptions.get(pde.getName() + USER_CAN_OVERRIDE);
        if (pdeOv == null) {
            return false;
        }
        for (int i = 1; i <= 3; ++i) {
            ProfileCacheEntry entry = this.entries[i];
            if (entry == null || entry.isEmpty()) continue;
            for (ProfileCacheEntry.Setting s : entry.settings()) {
                if (s.getId() != pdeOv.getId()) continue;
                return Boolean.TRUE.equals(s.getValue());
            }
        }
        return false;
    }

    public void writeTo(Writer wrt) throws IOException {
        JsonWriter jw = new JsonWriter(wrt);
        ProfileDescriptions descriptions = ProfileDescriptions.getInstance();
        BitSet serialized = new BitSet(descriptions.size());
        wrt.write("{\n");
        String separator = "";
        for (ProfileCacheEntry entry : this.entries) {
            if (entry == null || entry.isEmpty()) continue;
            for (ProfileCacheEntry.Setting setting : entry.settings()) {
                int id = setting.getId();
                if (serialized.get(id)) continue;
                serialized.set(id);
                wrt.write(separator);
                separator = ",\n";
                jw.write(descriptions.get(id).getName());
                wrt.write(58);
                if (descriptions.get(id).getType() == ProfileDescriptionEntry.EntryType.JSON) {
                    wrt.write((String)setting.getValue());
                    continue;
                }
                jw.write(setting.getValue());
            }
        }
        wrt.write("\n}");
        wrt.flush();
    }

    public String getEffectiveGlobalParameters() {
        try {
            String resolvedParameterValuesStr;
            ProfileDescriptions descriptions = ProfileDescriptions.getInstance();
            ProfileDescriptionEntry description = descriptions.get("parameter_values");
            if (this.entries[0] != null && (resolvedParameterValuesStr = (String)this.entries[0].getValue(description.getId())) != null) {
                return ParameterValues.JSONToXMLBlob("value", JSONObject.parse((String)resolvedParameterValuesStr));
            }
        }
        catch (IOException ioException) {
            CMIndications.logException(ioException);
        }
        return ParameterValues.JSONToXMLBlob("item", new JSONObject());
    }

    public String toString() {
        StringWriter wrt = new StringWriter();
        try {
            this.writeTo(wrt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wrt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int result = this.hashValue;
        if (result == 0) {
            SessionProfileSettings sessionProfileSettings = this;
            synchronized (sessionProfileSettings) {
                result = this.hashValue;
                if (result == 0) {
                    result = this.hashValue = this.calculateHash();
                }
            }
        }
        return result;
    }

    private int calculateHash() {
        int result = 0;
        ProfileDescriptions descriptions = ProfileDescriptions.getInstance();
        BitSet serialized = new BitSet(descriptions.size());
        for (ProfileCacheEntry entry : this.entries) {
            if (entry == null || entry.isEmpty()) continue;
            for (ProfileCacheEntry.Setting setting : entry.settings()) {
                int id = setting.getId();
                if (serialized.get(id)) continue;
                serialized.set(id);
                result += descriptions.get(id).getName().hashCode() ^ setting.getValue().hashCode();
            }
        }
        return result;
    }
}

