/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.routing;

import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMDescendantModifiedProperty;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMStringArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.routing.RoutingTable;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RoutingManager {
    public static Set<String> DATA_CLASSES = new HashSet<String>();
    public static final int ROUTE_BY_OBJECT = 1;
    static RoutingManager instance_;
    private RoutingTable routingTable_ = null;
    private Date lastModifiedTime_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoutingManager getInstance() throws CMException {
        RoutingManager routingManager = instance_;
        synchronized (routingManager) {
            if (instance_.configurationChanged()) {
                instance_ = new RoutingManager();
                instance_.initialize();
            }
            return instance_;
        }
    }

    public boolean enabled() {
        return this.routingTable_ != null && this.routingTable_.hasEntries();
    }

    public String determineRouting(ArrayList<CMStorePath> routeByObjects, boolean indirectQuery) throws CMException {
        if (!this.enabled()) {
            return null;
        }
        HashMap<String, HashSet<Object>> contentHints = this.getContentRoutingHints(routeByObjects, indirectQuery);
        HashMap<String, HashSet<String>> userHints = CMExecutionContext.get().getCurrentUserRoutingHints();
        HashMap overallHints = this.mergeHints(contentHints, userHints);
        return this.routingTable_.evaluate(overallHints, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String determineRouting(int objectId) throws CMException {
        if (!this.enabled()) {
            return null;
        }
        routeByObjects = null;
        ctx = CMExecutionContext.get();
        store = ctx.getStore();
        objectClass = store.getObjectClass(objectId);
        if (null != objectClass.getProperty("routingServerGroup")) {
            if (RoutingManager.DATA_CLASSES.contains(objectClass.getName())) {
                routeByObjects = new ArrayList<CMStoreXPath>();
                routeByObjects.add(new CMStoreXPath(store.getObjectSearchPath(objectId)));
            } else {
                results = null;
                try {
                    permissions = ctx.requireAccessCheck() != false ? 1 : 512;
                    results = store.executeQuery(new int[]{objectId}, new CMProperty[]{CMProperty.BASE, CMProperty.METADATAMODELPACKAGE, CMProperty.MODULE}, null, 0, permissions, null);
                    if (results != null && results.next()) {
                        referenceValue = null;
                        baseValue = results.getValue(0);
                        metadataModelPackageValue = results.getValue(1);
                        if (baseValue != null) {
                            baseRefs = (CMBaseClassArray)baseValue;
                            if (baseRefs.getSize() > 0) {
                                baseRef = baseRefs.getReference(0);
                                baseResults = null;
                                try {
                                    baseResults = store.executeQuery(new int[]{baseRef.getObjectID()}, new CMProperty[]{CMProperty.METADATAMODELPACKAGE}, null, 0, permissions, null);
                                    if (baseResults == null || !baseResults.next()) ** GOTO lbl37
                                    referenceValue = baseResults.getValue(0);
                                }
                                finally {
                                    if (baseResults != null) {
                                        baseResults.release();
                                    }
                                }
                            }
                        } else {
                            referenceValue = metadataModelPackageValue != null ? metadataModelPackageValue : results.getValue(2);
                        }
lbl37:
                        // 4 sources

                        if (referenceValue != null && (refs = (CMBaseClassArray)referenceValue).getSize() > 0 && (ref = refs.getReference(0)) != null) {
                            path = new CMStoreXPath(ref.getSearchPath());
                            routeByObjects = new ArrayList<E>();
                            routeByObjects.add(path);
                        }
                    }
                }
                finally {
                    if (results != null) {
                        results.release();
                    }
                }
            }
        }
        return this.determineRouting(routeByObjects, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, HashSet<Object>> getContentRoutingHints(ArrayList<CMStorePath> routeByObjects, boolean indirectQuery) throws CMException {
        if (routeByObjects == null || routeByObjects.size() == 0) {
            return null;
        }
        HashMap<String, HashSet<Object>> contentHints = new HashMap<String, HashSet<Object>>();
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStore store = ctx.getStore();
        for (CMStorePath path : routeByObjects) {
            CMStoreQueryResults results = null;
            try {
                HashSet<Object> hintSet;
                Object value;
                int permissions = ctx.requireAccessCheck() && !indirectQuery ? 1 : 512;
                results = store.executeQuery(path, new CMProperty[]{CMProperty.ROUTINGHINTS}, null, 0, permissions, null);
                if (results == null || !results.next() || (value = results.getValue(0)) == null) continue;
                CMStringArray hints = (CMStringArray)value;
                String className = results.getObjectClass().getName();
                if (DATA_CLASSES.contains(className)) {
                    className = CMObjectClass.PACKAGE.getName();
                }
                if ((hintSet = contentHints.get(className)) == null) {
                    hintSet = new HashSet();
                    contentHints.put(className, hintSet);
                }
                for (int i = 0; i < hints.getSize(); ++i) {
                    hintSet.add(hints.getItem(i));
                }
            }
            finally {
                if (results == null) continue;
                results.release();
            }
        }
        return contentHints;
    }

    private HashMap mergeHints(HashMap contentHints, HashMap userHints) {
        if (contentHints == null && userHints == null) {
            return null;
        }
        if (contentHints == null) {
            return (HashMap)userHints.clone();
        }
        if (userHints == null) {
            return (HashMap)contentHints.clone();
        }
        HashMap mergedHints = (HashMap)contentHints.clone();
        Set securityClasses = userHints.keySet();
        for (String securityClass : securityClasses) {
            HashSet securityHintSet = (HashSet)userHints.get(securityClass);
            HashSet mergedHintSet = (HashSet)mergedHints.get(securityClass);
            if (mergedHintSet == null) {
                mergedHints.put(securityClass, securityHintSet);
                continue;
            }
            mergedHintSet.addAll(securityHintSet);
        }
        return mergedHints;
    }

    private boolean configurationChanged() {
        return this.lastModifiedTime_ == null || this.lastModifiedTime_.before(CMDescendantModifiedProperty.get().getValue());
    }

    private void initialize() throws CMException {
        this.lastModifiedTime_ = CMDescendantModifiedProperty.get().getValue();
        RoutingTable routingTable = new RoutingTable();
        routingTable.initialize();
        if (routingTable.hasEntries()) {
            this.routingTable_ = routingTable;
        }
    }

    static {
        DATA_CLASSES.add(CMObjectClass.PACKAGE.getName());
        DATA_CLASSES.add(CMObjectClass.MODULE.getName());
        DATA_CLASSES.add(CMObjectClass.UPLOADEDFILE.getName());
        instance_ = new RoutingManager();
    }
}

