/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.routing;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.routing.BaseRoutingRule;
import com.cognos.cm.server.routing.RoutingManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RoutingRuleObject
extends BaseRoutingRule {
    private HashMap classMap_;

    public RoutingRuleObject(XMLElement ruleEl) {
        XMLElement hintsEl = ruleEl.getOptionalChildWithName("hints");
        if (hintsEl != null && hintsEl.hasChildren()) {
            this.classMap_ = new HashMap();
            for (XMLElement hintEl : hintsEl.children_) {
                HashSet<String> hintSet;
                XMLElement valueEl;
                if (hintEl == null) continue;
                String objectClass = null;
                String value = null;
                XMLElement objectClassEl = hintEl.getOptionalChildWithName("objectClass");
                if (objectClassEl != null && objectClassEl.value_ != null && objectClassEl.value_.length() > 0) {
                    objectClass = objectClassEl.value_;
                }
                if ((valueEl = hintEl.getOptionalChildWithName("value")) != null && valueEl.value_ != null && valueEl.value_.length() > 0) {
                    value = valueEl.value_;
                }
                if (objectClass == null || value == null) {
                    throw new IllegalArgumentException("Invalid routing rule; unspecified objectClass or hint value");
                }
                if (RoutingManager.DATA_CLASSES.contains(objectClass)) {
                    objectClass = CMObjectClass.PACKAGE.getName();
                }
                if ((hintSet = (HashSet<String>)this.classMap_.get(objectClass)) == null) {
                    hintSet = new HashSet<String>();
                    this.classMap_.put(objectClass, hintSet);
                }
                hintSet.add(value);
            }
        }
    }

    @Override
    public boolean evaluate(Object input, int routingType) {
        if (routingType != 1) {
            return false;
        }
        if (this.classMap_ != null) {
            HashMap inputClassMap = (HashMap)input;
            Set ruleClasses = this.classMap_.keySet();
            for (String ruleClass : ruleClasses) {
                HashSet inputHintSet = (HashSet)inputClassMap.get(ruleClass);
                if (inputHintSet == null) {
                    return false;
                }
                HashSet ruleHintSet = (HashSet)this.classMap_.get(ruleClass);
                for (String ruleHint : ruleHintSet) {
                    if (inputHintSet.contains(ruleHint)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

