/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.routing;

import com.cognos.cm.dbstore.properties.CMDbStoreUncheckedArray;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.routing.RoutingTableEntry;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RoutingTable {
    private List<RoutingTableEntry> entries_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws CMException {
        block11: {
            CMStoreQueryResults results = null;
            try {
                Object value;
                CMExecutionContext ctx = CMExecutionContext.get();
                CMStore store = ctx.getStore();
                results = store.executeQuery(new CMStoreXPath("/configuration"), new CMProperty[]{CMProperty.ROUTINGTABLE}, null, 0, 512, null);
                if (results == null || !results.next() || (value = results.getValue(0)) == null) break block11;
                CMDbStoreUncheckedArray routingTable = (CMDbStoreUncheckedArray)value;
                XMLDocParser parser = new XMLDocParser();
                XMLDoc doc = null;
                try {
                    doc = parser.readXMLFragment(routingTable.getXMLContent());
                }
                catch (Exception e) {
                    CMIndications.logException(new CMException("cmErrRoutingTableBadTable"));
                }
                if (doc != null) {
                    this.entries_ = new ArrayList<RoutingTableEntry>();
                    XMLElement routingTableEl = doc.getRootXMLElement();
                    if (routingTableEl.hasChildren()) {
                        ArrayList<XMLElement> entries = routingTableEl.children_;
                        for (int i = 0; i < entries.size(); ++i) {
                            XMLElement entryEl = (XMLElement)entries.get(i);
                            try {
                                RoutingTableEntry entry = new RoutingTableEntry(entryEl);
                                this.entries_.add(entry);
                                continue;
                            }
                            catch (Exception e) {
                                CMIndications.logException(new CMException("cmErrRoutingTableBadEntry", new CMException.Parm("Entry", Integer.toString(i))));
                            }
                        }
                    }
                }
            }
            finally {
                if (results != null) {
                    results.release();
                }
            }
        }
    }

    public String evaluate(Object criteria, int routingType) {
        if (criteria == null) {
            return null;
        }
        String serverGroupName = null;
        if (this.hasEntries()) {
            Iterator<RoutingTableEntry> i = this.entries_.iterator();
            while (i.hasNext() && serverGroupName == null) {
                RoutingTableEntry entry = i.next();
                serverGroupName = entry.evaluate(criteria, routingType);
            }
        }
        return serverGroupName;
    }

    public boolean hasEntries() {
        return this.entries_ != null && this.entries_.size() > 0;
    }
}

