/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.testing;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Properties;

public class CMRegressionRunner
extends Thread {
    private static final String PROPSFILE_KEY = "com.cognos.cm.server.CMRegressionRunner.propsFile";
    private static final String REGRESSION_HOME_PROP_NAME = "com.cognos.cm.regressionHome";
    private static final String REGRESSION_OUTPUT_DIR_PROP_NAME = "com.cognos.cm.regressionOutputDir";
    private static final int millisToWaitForCAM;

    public CMRegressionRunner() {
        super("CM Regression Test Suite Thread");
    }

    private static void loadPropertiesFile(String propsFileStr) {
        try {
            File propsFile = new File(propsFileStr);
            FileInputStream fileIn = new FileInputStream(propsFile);
            Properties sysProps = System.getProperties();
            sysProps.load(fileIn);
            fileIn.close();
            System.err.println("CMRegressionRunner loaded properties from " + propsFileStr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Integer getMillisToWaitForCAM() {
        return Integer.valueOf(System.getProperty("com.cognos.cm.server.regression.CMRegressionRunner.millisToWaitForCAM", "90000"));
    }

    @Override
    public void run() {
        try {
            CMRegressionRunner.sleep(millisToWaitForCAM);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String regressionHome = System.getProperty(REGRESSION_HOME_PROP_NAME);
        String outputDirPathName = this.getOutputDirPathName(regressionHome);
        File outputDirPath = new File(outputDirPathName);
        this.cleanOutputDir(outputDirPath);
        String[] args = this.createArgumentsArray(regressionHome, outputDirPath.getPath());
        try {
            Class<?> cmtClass = Class.forName("com.cognos.cm.cmt1.CMBatchTestMain");
            Method mainMethod = cmtClass.getMethod("main", args.getClass());
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception ex) {
            System.err.println("CM Regression Mode FAILED");
            System.err.println("Exception Class: " + ex.getClass().getName());
            System.err.println("Exception Message: " + ex.getMessage());
            System.err.println("Stack Trace:");
            ex.printStackTrace();
            if (null != ex.getCause()) {
                System.err.println("Root Exception: " + ex.getCause().getClass().getName());
                System.err.println("Root Message: " + ex.getCause().getMessage());
                System.err.println("Root Stack Trace:");
                ex.getCause().printStackTrace();
            }
            System.exit(1);
        }
        System.exit(0);
    }

    private String getOutputDirPathName(String regressionHome) {
        String outputDirPathName = System.getProperty(REGRESSION_OUTPUT_DIR_PROP_NAME);
        if (outputDirPathName == null) {
            outputDirPathName = regressionHome + "_output";
        }
        return outputDirPathName;
    }

    private String[] createArgumentsArray(String regressionHome, String outputDirPath) {
        String cmtPropertiesFile = System.getProperty("cmt.propertiesFilename", "cmt.properties");
        String[] args = new String[]{"-r", regressionHome, "--props", regressionHome + "/" + cmtPropertiesFile, "--outputDir", outputDirPath, "--level", "warn"};
        return args;
    }

    private void cleanOutputDir(File path) {
        if (path.exists()) {
            this.cleanExistingOutputDir(path);
        } else {
            path.mkdirs();
        }
    }

    private void cleanExistingOutputDir(File path) {
        if (path.isDirectory()) {
            this.deleteOutputDirContents(path);
        } else {
            this.replaceFileNamedAsOutputDir(path);
        }
    }

    private void deleteOutputDirContents(File path) {
        File[] children = path.listFiles();
        for (int i = 0; i < children.length; ++i) {
            this.recursivelyDeletePath(children[i]);
        }
    }

    private void recursivelyDeletePath(File path) {
        if (path.isDirectory()) {
            File[] children = path.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.recursivelyDeletePath(children[i]);
            }
        }
        path.delete();
    }

    private void replaceFileNamedAsOutputDir(File path) {
        path.delete();
        path.mkdir();
    }

    static {
        String propsFileStr = System.getProperty(PROPSFILE_KEY);
        if (propsFileStr != null) {
            CMRegressionRunner.loadPropertiesFile(propsFileStr);
        }
        millisToWaitForCAM = CMRegressionRunner.getMillisToWaitForCAM();
    }
}

