/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.testing;

import com.cognos.cm.server.testing.ProcessOutputEater;
import java.io.IOException;

public abstract class ProcessRunner
extends Thread {
    private static final int millisToWait = ProcessRunner.getMillisToWait();

    private static Integer getMillisToWait() {
        return Integer.valueOf(System.getProperty("com.cognos.cm.server.regression.ProcessRunner.millisToWait", "0"));
    }

    public ProcessRunner() {
        super("CM JMeter Benchmark Test Suite Thread");
    }

    @Override
    public void run() {
        try {
            ProcessRunner.sleep(millisToWait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int returnCode = 0;
        try {
            returnCode = this.startProcess();
        }
        catch (Exception ex) {
            this.onError(ex);
        }
        System.exit(returnCode);
    }

    private int startProcess() throws IOException, InterruptedException {
        String[] cmdArray = this.getCommands();
        ProcessBuilder pb = new ProcessBuilder(cmdArray);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        ProcessOutputEater t = new ProcessOutputEater(p);
        t.start();
        int code = p.waitFor();
        return code;
    }

    protected abstract String[] getCommands();

    private void onError(Exception ex) {
        System.err.println("CM Benchmark Mode FAILED");
        System.err.println("Exception Class: " + ex.getClass().getName());
        System.err.println("Exception Message: " + ex.getMessage());
        System.err.println("Stack Trace:");
        ex.printStackTrace();
        if (null != ex.getCause()) {
            System.err.println("Root Exception: " + ex.getCause().getClass().getName());
            System.err.println("Root Message: " + ex.getCause().getMessage());
            System.err.println("Root Stack Trace:");
            ex.getCause().printStackTrace();
        }
        System.exit(1);
    }
}

