/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.server.testing;

public class TestSuiteFactory {
    private static final String TEST_SUITE = "com.cognos.cm.testSuite";
    private static Thread runner;

    public static boolean isTestMode() {
        return System.getProperty(TEST_SUITE) != null;
    }

    public static String getTestSuite_test() {
        return System.getProperty(TEST_SUITE);
    }

    public static void setTestSuite_test(String ts) {
        if (ts == null) {
            System.getProperties().remove(TEST_SUITE);
        } else {
            System.setProperty(TEST_SUITE, ts);
        }
    }

    public static synchronized Thread getTestRunner() {
        block3: {
            if (runner == null) {
                String testRunnerClass = System.getProperty(TEST_SUITE);
                try {
                    Class<?> cls = Class.forName(testRunnerClass);
                    runner = (Thread)cls.newInstance();
                }
                catch (Throwable e) {
                    System.err.println("Unable to initialize Test Runner: " + testRunnerClass);
                    TestSuiteFactory.dumpInitializationError(e);
                    if (e.getCause() == null) break block3;
                    TestSuiteFactory.dumpInitializationError(e.getCause());
                }
            }
        }
        return runner;
    }

    private static void dumpInitializationError(Throwable e) {
        System.err.println("Test runner initialization error msg: " + e.getMessage());
        System.err.println("Exception Class: " + e.getClass().getName());
        e.printStackTrace();
    }
}

