/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store;

import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreLockUtil;
import com.cognos.cm.dbstore.properties.CMDbStoreAncestors;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.CMLockHandlerDenied;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.properties.CMRetentionRuleArray;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMIPFData;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractCache
implements CMCache {
    private final CMStore store_;
    private static String[] CACHE_ACTIONS = new String[]{"Query", "Add", "Delete", "CopySrc", "MoveSrc", "CopyTarget", "MoveTarget", "Update", "DeleteForce"};

    public AbstractCache(CMStore store) {
        this.store_ = store;
    }

    protected abstract CMCacheQueryInstance getCacheQueryInstance(int var1);

    @Override
    public boolean ObjectHasChildren(int obj_id) {
        try {
            return this.CMCacheGetHasChildren(obj_id);
        }
        catch (CMCacheException e) {
            CMIndications.logException(e);
            return false;
        }
    }

    @Override
    public CMCacheQueryInstance executeAdminQuery(ICMStorePath qPath, int for_action) throws CMCacheException, CMCacheAccessDenied, CMException {
        return this.executeQuery(qPath, for_action, this.newAdminAccessMan());
    }

    @Override
    public CMCacheQueryInstance executeAdminQuery(int[] start_objects, int numStartObjects, ICMStorePath queryPath, int for_action) throws CMCacheException, CMCacheAccessDenied, CMException {
        return this.executeQuery(start_objects, numStartObjects, queryPath, for_action, this.newAdminAccessMan());
    }

    @Override
    public CMCacheQueryInstance executeAdminQuery(int[] start_objects, int numStartObjects, String queryPath, int for_action, int usage, boolean locksHaveBeenAcquired) throws CMCacheException, CMCacheAccessDenied, CMException {
        return this.executeQuery(start_objects, numStartObjects, queryPath, for_action, usage, locksHaveBeenAcquired, this.newAdminAccessMan());
    }

    @Override
    public CMCacheQueryInstance executeQuery(ICMStorePath qPath, int for_action) throws CMCacheException, CMCacheAccessDenied, CMException {
        String passportId = CMExecutionContext.get().getAccManPassportID();
        ICacheAccessMan accMan = this.newAccessMan(passportId);
        return this.executeQuery(qPath, for_action, accMan);
    }

    @Override
    public CMCacheQueryInstance executeQuery(ICMStorePath queryPath, int for_action, ICacheAccessMan accMan) throws CMCacheException, CMCacheAccessDenied, CMException {
        String accmanPassportID = accMan.getPassportId();
        List<String> appActions = Arrays.asList(accMan.getPermissions());
        if (CMIndicationGlobals.bTCH_Error_isEnabled) {
            CMIndications.CMTrace("cmExecuteQuery", new CMException.Parm("SearchPath", queryPath.getOriginalPath()), new CMException.Parm("Options", new CMCacheOptionString(for_action, accmanPassportID, appActions)));
        }
        int queryHandle = -1;
        boolean locksDenied = true;
        int lockType = CMLockManager.LockHandlerTypeFromSearchPath(queryPath);
        if (!queryPath.getLocksHaveBeenObtained() && CMLockManager.lockTypeIsExclusive(lockType)) {
            throw new IllegalStateException("Cannot acquire exclusive locks in a query. They must be acquired using CMLockManager.acquireLocks");
        }
        while (locksDenied) {
            try {
                CMExecutionContext.checkCancelOrTimeOut();
                queryHandle = this.CMCacheQuery(null, 0, queryPath.getCacheQueryPath(), for_action, accmanPassportID, CMExecutionContext.get().getCAMAdditionalInfo(), appActions, CMExecutionContext.get().getTrustedService(), lockType);
                queryPath.setLocksHaveBeenObtained();
                locksDenied = false;
            }
            catch (CMLockHandlerDenied e) {
                this.getLockManager().handleLocksDenied(e);
            }
        }
        return this.getCacheQueryInstance(queryHandle);
    }

    @Override
    public CMCacheQueryInstance executeQuery(int[] start_objects, int numStartObjects, ICMStorePath queryPath, int for_action, ICacheAccessMan accMan) throws CMCacheException, CMCacheAccessDenied, CMException {
        return this.executeQuery(start_objects, numStartObjects, queryPath.getCacheQueryPath(), for_action, CMDbStoreLockUtil.getLockUsageFromAction(for_action), queryPath.getLocksHaveBeenObtained(), accMan);
    }

    @Override
    public CMCacheQueryInstance executeQuery(int[] start_objects, int numStartObjects, String queryPath, int for_action, int usage, boolean locksHaveBeenAcquired, ICacheAccessMan accMan) throws CMCacheException, CMCacheAccessDenied, CMException {
        String accmanPassportID = accMan.getPassportId();
        List<String> appActions = Arrays.asList(accMan.getPermissions());
        if (CMIndicationGlobals.bTCH_Error_isEnabled) {
            StringBuffer starts = new StringBuffer(numStartObjects * 3);
            for (int i = 0; i < numStartObjects; ++i) {
                starts.append(Integer.toString(start_objects[i]));
                starts.append(" ");
            }
            if (null != start_objects && start_objects.length > numStartObjects) {
                starts.append("(" + Integer.toString(start_objects.length) + ")");
            }
            if (queryPath.startsWith("/8")) {
                starts.append("!!descendant from root!!");
            }
            CMIndications.CMTrace("cmExecuteQueryWithStartObjects", new CMException.Parm[]{new CMException.Parm("SearchPath", queryPath), new CMException.Parm("StartObjects", starts.toString()), new CMException.Parm("Options", new CMCacheOptionString(for_action, accmanPassportID, appActions))});
        }
        int queryHandle = -1;
        boolean locksDenied = true;
        int lockType = CMLockManager.LockHandlerTypeFromPathUsage(usage);
        if (!locksHaveBeenAcquired && CMLockManager.lockTypeIsExclusive(lockType)) {
            throw new IllegalStateException("Cannot acquire exclusive locks in a query. They must be acquired using CMLockManager.acquireLocks");
        }
        while (locksDenied) {
            try {
                CMExecutionContext.checkCancelOrTimeOut();
                queryHandle = this.CMCacheQuery(start_objects, numStartObjects, queryPath, for_action, accmanPassportID, CMExecutionContext.get().getCAMAdditionalInfo(), appActions, CMExecutionContext.get().getTrustedService(), lockType);
                locksDenied = false;
            }
            catch (CMLockHandlerDenied e) {
                this.getLockManager().handleLocksDenied(e);
            }
        }
        return this.getCacheQueryInstance(queryHandle);
    }

    @Override
    public CMAncestors getAncestors(int obj_id) throws CMException {
        return this.getAncestors(obj_id, CMDbStoreCacheUtil.getCacheSearchLocales());
    }

    @Override
    public CMAncestors getAncestors(int obj_id, int[] prefered_locales) throws CMException {
        CMDbStoreAncestors ancestors = new CMDbStoreAncestors();
        this.CMCacheGetAncestors(obj_id, prefered_locales, ancestors.titles_, ancestors.searchPaths_, ancestors.classes_, ancestors.storeIDs_);
        ListIterator<String> it = ancestors.storeIDs_.listIterator();
        while (it.hasNext()) {
            String storeID = it.next();
            if (null == storeID) continue;
            it.set(CMCAMIDHelper.normalizeStoreID(storeID));
        }
        return ancestors;
    }

    @Override
    public ResultSet getChildObjects(int obj_idParent) throws CMStoreNotAvailable, CMException, CMConfigurationException {
        CMStore store = this.getDatastore();
        if (store != null) {
            return store.getCacheObjectChildren(obj_idParent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CMIPFData getIPFDataFromSearchPath(CMStorePath qPath, int[] prefered_locales) throws CMCacheException, CMCacheAccessDenied, CMException {
        if (qPath == null) {
            return null;
        }
        CMCacheQueryInstance qResults = null;
        try {
            CMStorePathStep firstStep = qPath.size() > 0 ? qPath.stepAt(0) : null;
            CMConstants.FunctionDef function = null;
            if (firstStep != null && (function = firstStep.getNodeSetFunction()) != null && (qPath = function.getCacheQueryForIPF(qPath)) == null) {
                CMIPFData cMIPFData = null;
                return cMIPFData;
            }
            qResults = this.executeAdminQuery(qPath, 0);
            int numObjects = qResults.count();
            if (numObjects < 1) {
                CMIPFData cMIPFData = null;
                return cMIPFData;
            }
            int id = qResults.resultObjects()[0];
            CMObjectClass objectClass = this.getDatastore().getObjectClass(id);
            CMIPFData cMIPFData = new CMIPFData(this.CMCacheGetNameOnlyPath(id, prefered_locales), objectClass.getName());
            return cMIPFData;
        }
        catch (CMCacheException e) {
            CMIndications.logException(e);
            return null;
        }
        catch (CMCacheAccessDenied e) {
            CMIndications.logException(e);
            return null;
        }
        finally {
            try {
                if (qResults != null) {
                    qResults.release();
                }
            }
            catch (CMCacheException e) {}
        }
    }

    private CMStore getDatastore() {
        CMStore store = this.store_;
        try {
            CMExecutionContext ctx = CMExecutionContext.get();
            if (ctx != null) {
                store = ctx.getStore();
            }
        }
        catch (Exception ex) {
            CMIndications.logException(ex);
        }
        return store;
    }

    @Override
    public ResultSet getObjects(int obj_idFirst, int obj_idLast) throws CMStoreNotAvailable, CMException, CMConfigurationException {
        CMStore store = this.getDatastore();
        if (store != null) {
            return store.getCacheObjects(obj_idFirst, obj_idLast);
        }
        return null;
    }

    @Override
    public boolean useDBFiltering(int[] objIds) throws CMCacheException {
        for (int i = 0; i < objIds.length; ++i) {
            int type = this.CMCacheGetTypeOfChildren(objIds[i]);
            if (type == 4) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean CurrentUserIsObjectOwner(int object_id) throws CMException {
        if (CMIndicationGlobals.bTCH_Error_isEnabled) {
            CMIndications.CMTrace("cmIsCurrentUserOwner", new CMException.Parm("ID", Integer.toString(object_id)));
        }
        CMExecutionContext curContext = CMExecutionContext.get();
        CMStore store = curContext.getStore();
        int ownerID = store.getOwnerObjectID(object_id);
        return curContext.getCurrentUserIdentityIncludesObject(ownerID);
    }

    @Override
    public void DebugTrace(String message) {
        CMIndications.CMDebugTrace(message);
    }

    @Override
    public void Log(String code, List<String> paramNames, List<String> paramValues) {
        CMException.Parm[] parms = null;
        if (paramNames != null && paramValues != null) {
            int numParms = paramNames.size();
            parms = new CMException.Parm[numParms];
            for (int ip = 0; ip < numParms; ++ip) {
                String paramValue = null;
                if (paramValues.get(ip) != null) {
                    paramValue = paramValues.get(ip).toString();
                }
                parms[ip] = new CMException.Parm(paramNames.get(ip), paramValue);
            }
        }
        CMIndications.CMTrace(code, parms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeLastFunction(int parentId, int retentionClassId) throws CMException {
        int lastObjectId = -1;
        Object retention = null;
        CMExecutionContext curContext = CMExecutionContext.get();
        CMStore store = curContext.getStore();
        CMProperty[] props = new CMProperty[]{CMProperty.RETENTIONS};
        CMExecutionContext.checkCancelOrTimeOut();
        CMStoreQueryResults parentQuery = store.executeQuery(new int[]{parentId}, props, null, 0, 512, null);
        CMStoreXPath parentPath = null;
        try {
            if (parentQuery.next()) {
                retention = parentQuery.getValue(0);
                parentPath = new CMStoreXPath(parentQuery.getSearchPath());
            }
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
        finally {
            parentQuery.release();
        }
        CMRetentionRule rule = null;
        if (retention != null) {
            CMRetentionRuleArray rules = (CMRetentionRuleArray)retention;
            rule = rules.getRule(store.getObjectClasses().getClassByID(retentionClassId));
        }
        lastObjectId = rule != null ? this.findLastObject(store, rule.getObjectClass(), rule.getProperty(), parentPath) : this.findLastObject(store, store.getObjectClasses().getClassByID(retentionClassId), CMProperty.CREATIONTIME, parentPath);
        return lastObjectId;
    }

    @Override
    public void getAccmanInfo(List<String> passportAndAdditionalInfo) {
        if (CMIndicationGlobals.bTCH_Error_isEnabled) {
            CMIndications.CMTrace("cmGetAccmanInfo");
        }
        passportAndAdditionalInfo.add(CMExecutionContext.get().getAccManPassportID());
        passportAndAdditionalInfo.add(CMExecutionContext.get().getCAMAdditionalInfo());
    }

    @Override
    public ResultSet getPolicies(int[] obj_ids) throws Exception {
        CMStore store;
        String ids = "";
        for (int i = 0; i < obj_ids.length; ++i) {
            ids = ids + Integer.toString(obj_ids[i]) + " ";
        }
        if (CMIndicationGlobals.bTCH_Error_isEnabled) {
            CMIndications.CMTrace("cmGetPolicies", new CMException.Parm("IDs", ids));
        }
        if ((store = this.getDatastore()) != null) {
            return store.getPolicies(obj_ids);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findLastObject(CMStore store, CMObjectClass classRestriction, CMProperty orderingProperty, CMStoreXPath path) throws CMException {
        int obj_last = -1;
        CMStoreXPath affectedObjectsPath = new CMStoreXPath(path + "/*[@objectClass='" + classRestriction.getName() + "']");
        CMStoreQueryResults results = null;
        try {
            CMExecutionContext.checkCancelOrTimeOut();
            results = store.executeQuery(affectedObjectsPath, new CMProperty[]{orderingProperty}, new OrderByField[]{new OrderByField(true, orderingProperty)}, 0, 512, null);
            if (results.next()) {
                obj_last = results.getObjectID();
            }
        }
        catch (Exception e) {
            CMIndications.logException(e);
        }
        finally {
            if (results != null) {
                results.release();
            }
        }
        return obj_last;
    }

    private static class CMCacheOptionString {
        private final int action_;
        private final boolean accessChecking_;
        private final List<String> permissions_;

        CMCacheOptionString(int for_action, String accmanPassportID, List<String> appActions) {
            this.action_ = for_action;
            this.accessChecking_ = accmanPassportID != null;
            this.permissions_ = appActions;
        }

        public String toString() {
            StringBuffer x = new StringBuffer(200);
            if (this.action_ >= 0 && this.action_ < CACHE_ACTIONS.length) {
                x.append(CACHE_ACTIONS[this.action_]);
            } else {
                x.append(String.valueOf(this.action_));
            }
            x.append(" ");
            x.append(this.accessChecking_ ? "AccessChecking" : "NoAccessChecking");
            if (this.permissions_ != null && this.permissions_.size() > 0) {
                x.append(" perms: ");
                x.append(this.permissions_.toString());
            }
            return x.toString();
        }
    }
}

