/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.CMCADataStoreException;
import java.util.Vector;

public abstract class CMCADataStore {
    private static volatile CMCADataStore store_;

    public abstract byte[] getData(String var1) throws CMCADataStoreException;

    public abstract void addData(String var1, byte[] var2) throws CMCADataStoreException;

    public abstract boolean updateData(String var1, byte[] var2) throws CMCADataStoreException;

    public abstract boolean deleteData(String var1) throws CMCADataStoreException, CMException;

    public abstract String[] getAllDataKeys() throws CMCADataStoreException;

    public abstract void setData(String var1, byte[] var2) throws CMCADataStoreException;

    public abstract boolean isInitialized();

    public static CMCADataStore get() throws CMCADataStoreException {
        if (store_ == null) {
            CMCADataStore.loadStore();
        }
        return store_;
    }

    private static synchronized void loadStore() throws CMCADataStoreException {
        if (store_ != null) {
            return;
        }
        String storeClassName = ConfigurationFactory.getConfig().getInternalProp("CMCAStoreClass");
        if (storeClassName == null || storeClassName.trim().length() == 0) {
            throw new CMCADataStoreException(5);
        }
        try {
            Class<?> storeClass = Class.forName(storeClassName);
            store_ = (CMCADataStore)storeClass.newInstance();
        }
        catch (Exception ex) {
            throw new CMCADataStoreException(6, ex);
        }
    }

    public abstract Vector<Object> getAllData() throws CMCADataStoreException;

    public abstract Integer freshness() throws CMCADataStoreException;

    protected CMCADataStore() {
    }
}

