/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class CMCacheAbstractQueryInstance
implements CMCacheQueryInstance {
    int CacheInstanceHandle_;
    int[] resultObjects_;
    int[] resultClassIds_;
    CMObjectClass[] resultDistinctClasses_;
    boolean selectionHasPolicies = false;
    boolean selectionIsBurstOutput = false;

    CMCacheAbstractQueryInstance(int queryHandle) {
        this.CacheInstanceHandle_ = queryHandle;
    }

    @Override
    public abstract int[] CMCacheQueryCheckAccess(int var1, int var2, int var3) throws CMCacheException, CMCacheAccessDenied;

    @Override
    public abstract int CMCacheQueryCount(int var1) throws CMCacheException;

    @Override
    public abstract byte[] CMCacheQueryGetPolicy(int var1, int var2, int var3) throws CMCacheException;

    @Override
    public abstract int[] CMCacheQueryInheritancePath(int var1, int var2) throws CMCacheException;

    @Override
    public abstract int CMCacheQueryIntProperty(int var1, int var2, int var3) throws CMCacheException;

    @Override
    public abstract String CMCacheQueryPath(int var1, int var2, int[] var3) throws CMCacheException;

    @Override
    public abstract int CMCacheQueryPolicyInheritanceObject(int var1, int var2) throws CMCacheException;

    @Override
    public abstract void CMCacheQueryRelease(int var1) throws CMCacheException;

    @Override
    public abstract int[] CMCacheQueryResultClasses(int var1) throws CMCacheException;

    @Override
    public abstract int[] CMCacheQueryResultInfo(int var1) throws CMCacheException;

    @Override
    public abstract int[] CMCacheQueryResults(int var1, int var2) throws CMCacheException;

    @Override
    public abstract String CMCacheQueryStringProperty(int var1, int var2, int var3, int[] var4) throws CMCacheException;

    @Override
    public abstract void CMCacheQueryTrim(int var1, int var2, int var3) throws CMCacheException;

    public abstract int CMCacheQueryGetDefaultOutput(int var1, int var2, int var3, int[] var4, int var5, int[] var6) throws CMCacheException;

    @Override
    public int[] checkAccess(int object_num, int forDelete) throws CMCacheException, CMCacheAccessDenied {
        int[] returnVal = null;
        returnVal = this.CMCacheQueryCheckAccess(this.CacheInstanceHandle_, object_num, forDelete);
        return returnVal;
    }

    @Override
    public int count() throws CMCacheException {
        return this.CMCacheQueryCount(this.CacheInstanceHandle_);
    }

    @Override
    public byte[] getAcquiredPolicy(int object_num, int shortcut_or_endobject) throws CMCacheException, CMStoreNotAvailable, CMStoreUnexpected, CMException {
        byte[] policy = this.CMCacheQueryGetPolicy(this.CacheInstanceHandle_, object_num, shortcut_or_endobject);
        ResultSet rs = null;
        try {
            Blob blob;
            CMStore store;
            int policyObj;
            if (policy == null && (policyObj = this.CMCacheQueryPolicyInheritanceObject(this.CacheInstanceHandle_, object_num)) > -1 && (rs = (store = CMExecutionContext.get().getStore()).getPolicies(new int[]{policyObj})) != null && rs.next() && (blob = rs.getBlob(2)) != null) {
                policy = blob.getBytes(1L, (int)blob.length());
            }
        }
        catch (CMConfigurationException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedCacheQuery");
        }
        catch (SQLException e) {
            CMIndications.logException(e);
        }
        catch (Exception e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedCacheQuery");
        }
        return policy;
    }

    @Override
    public int[] getAncestorObjects(int object_num) throws CMCacheException {
        return this.CMCacheQueryInheritancePath(this.CacheInstanceHandle_, object_num);
    }

    @Override
    public int getDefaultOutput(int object_num, int grantedAccess, int[] preferred_locales, int preferredFormat, int[] supportedFormats) throws CMCacheException {
        return this.CMCacheQueryGetDefaultOutput(this.CacheInstanceHandle_, object_num, grantedAccess, preferred_locales, preferredFormat, supportedFormats);
    }

    @Override
    public CMObjectClass[] getDistinctSelectedClasses() throws CMCacheException, CMException {
        if (this.resultDistinctClasses_ == null) {
            this.getSelectionInfo();
        }
        return this.resultDistinctClasses_;
    }

    @Override
    public int getPolicyObject(int obj_num) throws CMCacheException {
        return this.CMCacheQueryPolicyInheritanceObject(this.CacheInstanceHandle_, obj_num);
    }

    @Override
    public boolean getSelectionHasPolicies() throws CMCacheException, CMException {
        if (this.resultDistinctClasses_ == null) {
            this.getSelectionInfo();
        }
        return this.selectionHasPolicies;
    }

    @Override
    public boolean getSelectionIsBurstOutput() throws CMCacheException, CMException {
        if (this.resultDistinctClasses_ == null) {
            this.getSelectionInfo();
        }
        return this.selectionIsBurstOutput;
    }

    @Override
    public boolean isValid() {
        return this.CacheInstanceHandle_ >= 0;
    }

    @Override
    public boolean objectHasCredentialNamespaces(int object_num) throws CMCacheException {
        return this.CMCacheQueryIntProperty(this.CacheInstanceHandle_, object_num, 9) > 0;
    }

    @Override
    public int objectIsBurstOutput(int object_num) throws CMCacheException {
        return this.CMCacheQueryIntProperty(this.CacheInstanceHandle_, object_num, 1);
    }

    @Override
    public String objectName(int object_num, int[] prefered_locales) throws CMCacheException {
        return this.CMCacheQueryStringProperty(this.CacheInstanceHandle_, object_num, 0, prefered_locales);
    }

    @Override
    public int objectParent(int object_num) throws CMCacheException {
        return this.CMCacheQueryIntProperty(this.CacheInstanceHandle_, object_num, 5);
    }

    @Override
    public String objectPath(int object_num, int[] prefered_locales) throws CMCacheException {
        return this.CMCacheQueryPath(this.CacheInstanceHandle_, object_num, prefered_locales);
    }

    @Override
    public String objectSearchPath(int object_num, int[] prefered_locales) throws CMCacheException {
        return this.CMCacheQueryStringProperty(this.CacheInstanceHandle_, object_num, 7, prefered_locales);
    }

    @Override
    public void release() throws CMCacheException {
        try {
            if (this.isValid()) {
                this.CMCacheQueryRelease(this.CacheInstanceHandle_);
            }
        }
        catch (Throwable e) {
            CMIndications.logException(e);
        }
        finally {
            this.CacheInstanceHandle_ = -1;
            this.resultObjects_ = null;
        }
    }

    @Override
    public int[] resultClassIds() throws CMCacheException {
        if (this.resultClassIds_ == null) {
            this.resultClassIds_ = this.CMCacheQueryResultClasses(this.CacheInstanceHandle_);
        }
        return this.resultClassIds_;
    }

    @Override
    public int[] resultObjects() throws CMCacheException {
        if (this.resultObjects_ == null) {
            this.resultObjects_ = this.CMCacheQueryResults(this.CacheInstanceHandle_, 0);
        }
        return this.resultObjects_;
    }

    @Override
    public void trimObjects(int object_first, int object_last) throws CMCacheException {
        this.resultObjects_ = null;
        this.resultClassIds_ = null;
        this.resultDistinctClasses_ = null;
        this.CMCacheQueryTrim(this.CacheInstanceHandle_, object_first, object_last);
    }

    public void finalize() throws Throwable {
        this.release();
    }

    private void getSelectionInfo() throws CMCacheException, CMException {
        int[] info = this.CMCacheQueryResultInfo(this.CacheInstanceHandle_);
        CMStore store = CMExecutionContext.get().getStore();
        CMObjectClasses classes = store.getObjectClasses();
        if (info != null && info.length > 0) {
            if (info.length > 1) {
                this.resultDistinctClasses_ = new CMObjectClass[info.length - 1];
                for (int i = 1; i < info.length; ++i) {
                    this.resultDistinctClasses_[i - 1] = classes.getClassByID(info[i]);
                }
            }
            if ((info[0] & 1) != 0) {
                this.selectionHasPolicies = true;
            }
            if ((info[0] & 2) != 0) {
                this.selectionIsBurstOutput = true;
            }
        }
    }
}

