/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store;

import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.CMCryptoDataStoreException;

public abstract class CMCryptoDataStore {
    private static volatile CMCryptoDataStore store_;

    public abstract byte[] getData(String var1) throws CMCryptoDataStoreException;

    public abstract void addData(String var1, byte[] var2) throws CMCryptoDataStoreException;

    public abstract boolean updateData(String var1, byte[] var2) throws CMCryptoDataStoreException;

    public abstract boolean deleteData(String var1) throws CMCryptoDataStoreException, CMException;

    public abstract String[] getAllDataKeys() throws CMCryptoDataStoreException;

    public abstract void setData(String var1, byte[] var2) throws CMCryptoDataStoreException;

    public abstract boolean isInitialized();

    public static CMCryptoDataStore get() throws CMCryptoDataStoreException {
        if (store_ == null) {
            CMCryptoDataStore.loadStore();
        }
        return store_;
    }

    private static synchronized void loadStore() throws CMCryptoDataStoreException {
        if (store_ != null) {
            return;
        }
        String storeClassName = ConfigurationFactory.getConfig().getInternalProp("CMCryptoStoreClass");
        if (storeClassName == null || storeClassName.trim().length() == 0) {
            throw new CMCryptoDataStoreException(5);
        }
        try {
            Class<?> storeClass = Class.forName(storeClassName);
            store_ = (CMCryptoDataStore)storeClass.newInstance();
        }
        catch (Exception ex) {
            throw new CMCryptoDataStoreException(6, ex);
        }
    }

    protected CMCryptoDataStore() {
    }
}

