/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store;

import com.cognos.cm.server.CMRuntimeException;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMStore;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;

public class CMFactory {
    IConfiguration config;
    ConcurrentHashMap<String, Method> cachedStaticMethods;
    ConcurrentHashMap<String, Constructor> cachedConstructors;

    public CMFactory(IConfiguration configuration) {
        this.config = configuration;
        this.cachedStaticMethods = new ConcurrentHashMap();
        this.cachedConstructors = new ConcurrentHashMap();
    }

    public CMCache newCache(CMStore store) throws CMRuntimeException {
        String className = this.lookupImpl("com.cognos.cm.cache.CMCacheImpl");
        Class[] types = new Class[]{CMStore.class};
        Object[] args = new Object[]{store};
        CMCache cache = (CMCache)this.invokeStaticMethod(className, "newCache", types, args);
        return cache;
    }

    public CMCache newCacheProxy(CMCache realCMCache) {
        String className = this.lookupImpl("com.cognos.cm.cache.CMCacheProxyImpl");
        Class[] types = new Class[]{CMCache.class};
        Object[] args = new Object[]{realCMCache};
        InvocationHandler handler = (InvocationHandler)this.invokeConstructor(className, types, args);
        ClassLoader classLoader = CMCache.class.getClassLoader();
        CMCache proxyCMCache = (CMCache)Proxy.newProxyInstance(classLoader, new Class[]{CMCache.class}, handler);
        return proxyCMCache;
    }

    String lookupImpl(String key) {
        String className = this.config.getInternalProp(key);
        if (className == null || className.equals("")) {
            IllegalStateException ise = new IllegalStateException("Missing configuration: " + key);
            throw new CMRuntimeException(ise, "cmErrConfig");
        }
        return className;
    }

    Object invokeStaticMethod(String className, String methodName, Class[] types, Object[] args) throws CMRuntimeException {
        Object ret;
        try {
            Method method = this.lookupStaticMethod(className, methodName, types);
            ret = method.invoke(null, args);
        }
        catch (InvocationTargetException remoteException) {
            throw new CMRuntimeException(remoteException.getTargetException(), "cmErrConfig");
        }
        catch (Exception e) {
            throw new CMRuntimeException(e, "cmErrConfig");
        }
        return ret;
    }

    Method lookupStaticMethod(String className, String methodName, Class[] types) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class<?> clazz;
        String key = className + "." + methodName;
        Method method = this.cachedStaticMethods.get(key);
        if (method == null && (method = (clazz = Class.forName(className)).getMethod(methodName, types)) != null) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                this.cachedStaticMethods.put(key, method);
            } else {
                method = null;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("Missing static method: " + key);
        }
        return method;
    }

    Object invokeConstructor(String className, Class[] types, Object[] args) throws CMRuntimeException {
        Object ret;
        try {
            Constructor constructor = this.lookupConstructor(className, types);
            ret = constructor.newInstance(args);
        }
        catch (InvocationTargetException remoteException) {
            throw new CMRuntimeException(remoteException.getTargetException(), "cmErrConfig");
        }
        catch (Exception e) {
            throw new CMRuntimeException(e, "cmErrConfig");
        }
        return ret;
    }

    Constructor lookupConstructor(String className, Class[] types) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        String key = className;
        Constructor<?> constructor = this.cachedConstructors.get(key);
        if (constructor == null) {
            Class<?> clazz = Class.forName(className);
            constructor = clazz.getConstructor(types);
        }
        return constructor;
    }
}

