/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store;

import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMWhileDeadlockExecutor;
import com.cognos.cm.store.path.CMStoreXPath;
import java.util.List;

public class CMStoreHelper {
    private static CMStoreHelper instance = new CMStoreHelper();

    protected CMStoreHelper() {
    }

    public static boolean updateObject(CMStore store, String path, List<CMProperty> properties, List<Object> values, int permissions) throws CMException {
        return CMWhileDeadlockExecutor.execute(() -> instance.updateObjectInDeadockLoop(store, path, properties, values, permissions), CMStoreHelper.getConnection(store), "cmUnexpectedError");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateObjectInDeadockLoop(CMStore store, String path, List<CMProperty> properties, List<Object> values, int permissions) throws CMException {
        ICMLockManager lockMananger = store.getLockManager();
        CMStoreXPath xpath = new CMStoreXPath(path, 13);
        lockMananger.requestLocks(xpath);
        CMStoreQueryResults results = null;
        store.beginTransaction();
        try {
            results = store.executeQuery(xpath, null, null, 7, permissions, null);
            if (!results.next()) {
                boolean bl = false;
                return bl;
            }
            store.update(results, properties, values);
            store.commitTransaction();
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.rollbackOpenTransaction(store);
            lockMananger.releaseLocks();
        }
        return true;
    }

    private void rollbackOpenTransaction(CMStore store) {
        try {
            store.rollbackOpenTransaction();
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
    }

    private static ICMDbConnection getConnection(CMStore store) throws CMException {
        return ((ICMDbStore)store).getICMDbConnection();
    }
}

