/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreSizeUtil;
import com.cognos.cm.dbstore.OutputTotalSizeExecutable;
import com.cognos.cm.dbstore.PropertyArray;
import com.cognos.cm.dbstore.TotalSizeExecutable;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMCountInfo;
import com.cognos.cm.properties.CMCountSizeInfo;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMOutputCountSizeInfo;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMSizeInfoArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMQueryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CMStoreQuerySizeResults
implements CMStoreQueryResults {
    static final int SORT_ORDER_DESC = 0;
    static final int SORT_ORDER_ASC = 1;
    static final int SORT_BY_SIZE = 0;
    static final int SORT_BY_COUNT = 1;
    private ArrayList<ObjectSizeInfoArray> objectSizeInfoList_ = new ArrayList();
    private int currentIdx_ = -1;
    private String currentStoreID_;
    private CMObjectClass objectClass_;
    private String searchpath_;
    private String defaultName_;
    private CMSizeInfoArray sizeInfoArray_;
    private Map<String, Set<String>> objectClassesMap_;
    private PropertyArray properties;
    private CMProperty[] props_;
    private boolean bIncludeSize_;
    private CMDbStoreSizeUtil.OrderByColumn[] orderBy_;
    private RequestHandler requestHandler_;
    CMProperty sizeInfoArrayProperty_;

    public CMStoreQuerySizeResults(RequestHandler requestHandler, CMProperty sizeInfoArrayProperty) {
        this.requestHandler_ = requestHandler;
        this.sizeInfoArrayProperty_ = sizeInfoArrayProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(CMStoreQueryResults rs, CMProperty[] props, CMDbStoreSizeUtil.OrderByColumn[] orderBy, boolean bIncludeSize, boolean bAllClassesInEntireCS, Map<String, Set<String>> objectClassesMap) throws CMException {
        this.objectClassesMap_ = objectClassesMap;
        this.properties = new PropertyArray(props);
        this.bIncludeSize_ = bIncludeSize;
        this.orderBy_ = orderBy;
        int storeIDPropIdx = -1;
        int objectClassPropIdx = -1;
        for (int i = 0; i < props.length; ++i) {
            if (props[i] == CMProperty.STOREID) {
                storeIDPropIdx = i;
                continue;
            }
            if (props[i] != CMProperty.OBJECTCLASS) continue;
            objectClassPropIdx = i;
        }
        try {
            if (storeIDPropIdx < 0) {
                throw new IllegalStateException("STOREID property is missing in querySize property list.");
            }
            if (objectClassPropIdx < 0) {
                throw new IllegalStateException("OBJECTCLASS property is missing in querySize property list.");
            }
            while (rs.next()) {
                Object storeID = rs.getValue(storeIDPropIdx);
                this.objectSizeInfoList_.add(new ObjectSizeInfoArray(storeID.toString()));
            }
        }
        finally {
            CMQueryUtils.safeQueryResultsRelease(rs);
            rs.getStore().getLockManager().releaseLocks();
        }
        this.requestHandler_.resetLockedPaths();
        this.calculateTotals(bAllClassesInEntireCS);
        if (this.orderBy_ != null && this.orderBy_.length > 0) {
            SizeInfoComparator sizeInfoComparator = null;
            if (this.orderBy_[0].columnName_.equalsIgnoreCase("size")) {
                sizeInfoComparator = this.orderBy_[0].descending_ ? new ComparatorBySizeDesc() : new ComparatorBySizeAsc();
            } else if (this.orderBy_[0].columnName_.equalsIgnoreCase("count")) {
                sizeInfoComparator = this.orderBy_[0].descending_ ? new ComparatorByCountDesc() : new ComparatorByCountAsc();
            }
            Collections.sort(this.objectSizeInfoList_, sizeInfoComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateTotals(boolean bAllClassesInEntireCS) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        CMObjectClasses objectClasses = store.getObjectClasses();
        if (bAllClassesInEntireCS && this.objectSizeInfoList_.size() == 1) {
            Map<Integer, Long> allClassCounts = CMDbStoreSizeUtil.selectAllClassCounts(store);
            Set<Integer> allClasses = allClassCounts.keySet();
            Iterator<Integer> iter = allClasses.iterator();
            CMSizeInfoArray sizeInfoArray = new CMSizeInfoArray();
            while (iter.hasNext()) {
                Integer classIdObject = iter.next();
                long classCount = allClassCounts.get(classIdObject);
                int classId = classIdObject;
                CMObjectClass objectClass = objectClasses.getClassByID(classId);
                String className = objectClass.getName();
                CMCountInfo sizeInfo = new CMCountInfo(className, classCount);
                sizeInfoArray.add(sizeInfo);
            }
            this.objectSizeInfoList_.get(0).setSizeInfoArray(sizeInfoArray);
        } else {
            TotalSizeExecutable sizeUtil = new TotalSizeExecutable((CMDbStore)this.getStore());
            for (int i = 0; i < this.objectSizeInfoList_.size(); ++i) {
                CMSizeInfoArray sizeInfoArray = new CMSizeInfoArray();
                String currentStoreID = this.objectSizeInfoList_.get((int)i).storeID_;
                CMStoreXPath storeIDPath = null;
                String sPath = "storeID(\"" + currentStoreID + "\")";
                storeIDPath = new CMStoreXPath(sPath, 10);
                Set<String> classesSet = this.objectClassesMap_.keySet();
                for (String classIdString : classesSet) {
                    CMObjectClass objectClass = objectClasses.getClassByID(Integer.valueOf(classIdString));
                    String className = objectClass.getName();
                    CMCountInfo sizeInfo = null;
                    try {
                        StringBuffer buffer = new StringBuffer();
                        store.getLockManager().releaseLocks();
                        this.requestHandler_.resetLockedPaths();
                        buffer.setLength(0);
                        Set<String> tablesSet = this.objectClassesMap_.get(classIdString);
                        if (tablesSet == null) continue;
                        buffer.append(storeIDPath + "//*[");
                        buffer.append("@objectClass=\"");
                        buffer.append(className);
                        buffer.append("\"");
                        buffer.append("]");
                        CMStoreXPath path = new CMStoreXPath(buffer.toString(), 10);
                        this.requestHandler_.addObjectContextToLockPaths(path);
                        this.requestHandler_.LockPaths();
                        CMIntList objectIDsList = null;
                        CMStoreQueryResults results = null;
                        try {
                            results = store.executeQuery(path, null, null, 0, 32768, (List<String>)null);
                            if (results == null) continue;
                            objectIDsList = new CMIntList();
                            while (results.next()) {
                                objectIDsList.add(results.getObjectID());
                            }
                        }
                        finally {
                            if (results == null) continue;
                            results.release();
                            continue;
                        }
                        int[] objectIDs = objectIDsList.toArray();
                        if (!this.bIncludeSize_) {
                            sizeInfo = new CMCountInfo(className, objectIDs.length);
                        } else if (objectClass == CMObjectClass.OUTPUT) {
                            long dataSize = 0L;
                            long metadataSize = 0L;
                            if (objectIDsList.size() > 0) {
                                OutputTotalSizeExecutable exec = new OutputTotalSizeExecutable((CMDbStore)this.getStore());
                                exec.calculate(tablesSet, objectIDs);
                                dataSize = exec.getDataSize();
                                metadataSize = exec.getMetadataSize();
                            }
                            sizeInfo = new CMOutputCountSizeInfo(className, objectIDs.length, dataSize, metadataSize);
                        } else {
                            long totalSize = 0L;
                            if (objectIDsList.size() > 0) {
                                totalSize = sizeUtil.calculate(tablesSet, objectIDs);
                            }
                            sizeInfo = new CMCountSizeInfo(className, objectIDs.length, totalSize);
                        }
                        sizeInfoArray.add(sizeInfo);
                    }
                    finally {
                        store.getLockManager().releaseLocks();
                        this.requestHandler_.resetLockedPaths();
                    }
                }
                this.objectSizeInfoList_.get(i).setSizeInfoArray(sizeInfoArray);
            }
        }
    }

    public void saveInDatabase() throws CMException {
        if (this.currentStoreID_ == null || this.objectClass_ == null) {
            return;
        }
        CMStore store = CMExecutionContext.get().getStore();
        CMDbStoreSizeUtil.saveAllTotalsInDatabase(store, this.currentStoreID_, this.objectClass_.getID(), this.sizeInfoArray_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws CMException {
        this.currentStoreID_ = null;
        this.sizeInfoArray_ = new CMSizeInfoArray();
        CMStore store = CMExecutionContext.get().getStore();
        CMStoreQueryResults results = null;
        CMStoreXPath storeIDPath = null;
        try {
            do {
                store.getLockManager().releaseLocks();
                this.requestHandler_.resetLockedPaths();
                ++this.currentIdx_;
                if (this.currentIdx_ >= this.objectSizeInfoList_.size()) {
                    this.currentIdx_ = -2;
                    boolean bl = false;
                    return bl;
                }
                this.currentStoreID_ = this.objectSizeInfoList_.get((int)this.currentIdx_).storeID_;
                this.sizeInfoArray_ = this.objectSizeInfoList_.get((int)this.currentIdx_).sizeInfoArray_;
                if (this.currentStoreID_ == null) {
                    boolean bl = false;
                    return bl;
                }
                String sPath = "storeID(\"" + this.currentStoreID_ + "\")";
                storeIDPath = new CMStoreXPath(sPath, 10);
                this.requestHandler_.addObjectContextToLockPaths(storeIDPath);
                this.requestHandler_.LockPaths();
            } while ((results = store.executeQuery(storeIDPath, null, null, 0, 32768, (List<String>)null)) == null || !results.next());
            this.objectClass_ = results.getObjectClass();
            this.searchpath_ = results.getSearchPath();
            this.defaultName_ = results.getName();
        }
        finally {
            store.getLockManager().releaseLocks();
            this.requestHandler_.resetLockedPaths();
            if (results != null) {
                results.release();
            }
        }
        return true;
    }

    @Override
    public Object getValue(int index) throws CMException {
        CMProperty prop = this.properties.get(index);
        if (this.currentStoreID_ == null) {
            throw new IndexOutOfBoundsException();
        }
        if (prop == CMProperty.STOREID) {
            return this.currentStoreID_;
        }
        if (prop == CMProperty.SEARCHPATH) {
            return this.searchpath_;
        }
        if (prop == CMProperty.OBJECTCLASS) {
            return this.objectClass_;
        }
        if (prop == CMProperty.DEFAULTNAME) {
            return this.defaultName_;
        }
        if (prop == this.sizeInfoArrayProperty_) {
            return this.sizeInfoArray_;
        }
        return null;
    }

    @Override
    public Object getValue(CMProperty prop) throws CMException {
        return this.getValue(this.properties.indexOf(prop));
    }

    @Override
    public boolean wasAcquired() {
        return false;
    }

    @Override
    public int getObjectID() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public String getPath() {
        return this.searchpath_;
    }

    @Override
    public String getSearchPath() {
        return this.searchpath_;
    }

    @Override
    public String getParentSearchPath() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public int getParentObjectID() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public String getSecurityReference() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public CMAncestors getAncestors() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public String getName() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public CMObjectClass getObjectClass() {
        return this.objectClass_;
    }

    @Override
    public boolean hasPermission(String permission) {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public boolean hasExternalProperty(CMProperty property) {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public int getState() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public int getTenantID() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public void exclude() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public void reset() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public void release() {
    }

    @Override
    public void rewind() {
        throw new IllegalStateException("not supported.");
    }

    @Override
    public boolean supportsRewind() {
        return true;
    }

    @Override
    public boolean supportsSkipObjects() {
        return false;
    }

    @Override
    public CMStore getStore() {
        return this.requestHandler_.getStore();
    }

    private class SizeInfoComparator
    implements Comparator<ObjectSizeInfoArray> {
        private int sort_order_ = 0;
        private int sort_by_ = 0;

        SizeInfoComparator(int sort_order, int sort_by) {
            this.sort_order_ = sort_order;
            this.sort_by_ = sort_by;
        }

        @Override
        public int compare(ObjectSizeInfoArray typedLhs, ObjectSizeInfoArray typedRhs) {
            CMCountInfo countInfoRhs;
            CMSizeInfoArray sizeInfoArrayLhs = typedLhs.sizeInfoArray_;
            CMSizeInfoArray sizeInfoArrayRhs = typedRhs.sizeInfoArray_;
            CMCountInfo countInfoLhs = sizeInfoArrayLhs == null ? null : (CMCountInfo)sizeInfoArrayLhs.getItem(0);
            CMCountInfo cMCountInfo = countInfoRhs = sizeInfoArrayRhs == null ? null : (CMCountInfo)sizeInfoArrayRhs.getItem(0);
            if (countInfoLhs == null && countInfoRhs == null) {
                return 0;
            }
            if (countInfoLhs == null) {
                return 1;
            }
            if (countInfoRhs == null) {
                return -1;
            }
            if (this.sort_by_ == 0 && countInfoLhs instanceof CMCountSizeInfo && countInfoRhs instanceof CMCountSizeInfo) {
                CMCountSizeInfo sizeInfoLhs = (CMCountSizeInfo)countInfoLhs;
                CMCountSizeInfo sizeInfoRhs = (CMCountSizeInfo)countInfoRhs;
                if (sizeInfoLhs.getSize() == sizeInfoRhs.getSize()) {
                    return 0;
                }
                return this.sort_order_ == 0 ? (sizeInfoLhs.getSize() - sizeInfoRhs.getSize() < 0L ? 1 : -1) : (sizeInfoLhs.getSize() - sizeInfoRhs.getSize() < 0L ? -1 : 1);
            }
            if (this.sort_by_ == 1) {
                if (countInfoLhs.getCount() == countInfoRhs.getCount()) {
                    return 0;
                }
                return this.sort_order_ == 0 ? (countInfoLhs.getCount() - countInfoRhs.getCount() < 0L ? 1 : -1) : (countInfoLhs.getCount() - countInfoRhs.getCount() < 0L ? -1 : 1);
            }
            return -1;
        }
    }

    private class ComparatorByCountAsc
    extends SizeInfoComparator {
        ComparatorByCountAsc() {
            super(1, 1);
        }
    }

    private class ComparatorByCountDesc
    extends SizeInfoComparator {
        ComparatorByCountDesc() {
            super(0, 1);
        }
    }

    private class ComparatorBySizeAsc
    extends SizeInfoComparator {
        ComparatorBySizeAsc() {
            super(1, 0);
        }
    }

    private class ComparatorBySizeDesc
    extends SizeInfoComparator {
        ComparatorBySizeDesc() {
            super(0, 0);
        }
    }

    private class ObjectSizeInfoArray {
        public String storeID_;
        public CMSizeInfoArray sizeInfoArray_;

        public ObjectSizeInfoArray(String storeID) {
            this.storeID_ = storeID;
            this.sizeInfoArray_ = null;
        }

        public void setSizeInfoArray(CMSizeInfoArray sizeInfoArray) {
            this.sizeInfoArray_ = sizeInfoArray;
        }
    }
}

