/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store;

import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreDeadlock;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;

public class CMWhileDeadlockExecutor {
    private static void sleepOnDeadlock() {
        long randomNumber;
        long timeToSleep;
        CMIndications.CMTrace("cmRetryRequestOnDeadlock");
        String randomNumberString = String.valueOf(Thread.currentThread().hashCode());
        int size = randomNumberString.length();
        if (size > 2) {
            randomNumberString = randomNumberString.substring(size - 2);
        }
        if ((timeToSleep = AdvancedSettings.DBDEADLOCKRETRYTIME) > (randomNumber = Long.valueOf(randomNumberString).longValue())) {
            timeToSleep -= randomNumber;
        }
        try {
            Thread.sleep(timeToSleep);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void checkSimulateDeadlock(int deadlockRetryNumber) throws CMStoreDeadlock {
        if (AdvancedSettings.DBDEADLOCKTHROW > AdvancedSettings.DBDEADLOCKRETRYMAX - deadlockRetryNumber) {
            CMIndications.CMTrace("Deadlock simulated");
            throw new CMStoreDeadlock(new CMException("Deadlock simulated"));
        }
    }

    public static void execute(Object obj, Object deadlockContext, Method deadlockExecuteMethod) throws CMException, Throwable {
        int retryCount = AdvancedSettings.DBDEADLOCKRETRYMAX;
        while (true) {
            try {
                deadlockExecuteMethod.invoke(obj, deadlockContext, retryCount);
                return;
            }
            catch (InvocationTargetException ex) {
                Throwable te = ex.getTargetException();
                if (te instanceof CMStoreDeadlock && retryCount-- > 0) {
                    CMWhileDeadlockExecutor.sleepOnDeadlock();
                    continue;
                }
                throw te;
            }
            break;
        }
    }

    public static <T> T execute(DeadlockProtected<T> runnable, ICMDbConnection con, String defaultError) throws CMException {
        CMStoreDeadlock de;
        int retryCount = AdvancedSettings.DBDEADLOCKRETRYMAX;
        while (true) {
            try {
                return runnable.execute();
            }
            catch (SQLException se) {
                CMException ce = CMDbStoreExceptionUtil.analyzeSQLException(con, se, defaultError);
                if (ce instanceof CMStoreDeadlock) {
                    de = (CMStoreDeadlock)ce;
                }
                throw ce;
            }
            catch (CMStoreDeadlock cmd) {
                de = cmd;
            }
            catch (CMException cme) {
                throw cme;
            }
            catch (Exception e) {
                throw new CMException(e, defaultError);
            }
            if (retryCount-- <= 0) break;
            CMWhileDeadlockExecutor.sleepOnDeadlock();
        }
        throw de;
    }

    public <T> T exec(DeadlockProtected<T> runnable, ICMDbConnection con, String defaultError) throws CMException {
        return CMWhileDeadlockExecutor.execute(runnable, con, defaultError);
    }

    public static interface DeadlockProtected<T> {
        public T execute() throws Exception;
    }
}

