/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store;

public class InternalStoreId {
    private static final char[] bin2hex = "0123456789ABCDEF".toCharArray();
    private static final byte[] hex2bin = new byte[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 16, 16, 16, 16, 16, 16, 10, 11, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 10, 11, 12, 13, 14, 15};
    protected final long sl1;
    protected final long sl2;

    public InternalStoreId(InternalStoreId other) {
        this(other.sl1, other.sl2);
    }

    public InternalStoreId(long long1, long long2) {
        this.sl1 = long1;
        this.sl2 = long2;
    }

    public InternalStoreId(String storeId) throws IllegalArgumentException {
        if (storeId == null) {
            throw new IllegalArgumentException();
        }
        char[] buf = storeId.toCharArray();
        if (buf.length != 33 || buf[0] != 'i') {
            throw new IllegalArgumentException();
        }
        this.sl1 = InternalStoreId.parseHex(buf, 1);
        this.sl2 = InternalStoreId.parseHex(buf, 17);
    }

    private static void longToHexString(long l, char[] buf, int off) {
        for (int i = off + 15; i >= off; --i) {
            buf[i] = bin2hex[(int)(l & 0xFL)];
            l >>>= 4;
        }
    }

    public String stringValue() {
        char[] buf = new char[33];
        buf[0] = 105;
        InternalStoreId.longToHexString(this.sl1, buf, 1);
        InternalStoreId.longToHexString(this.sl2, buf, 17);
        return new String(buf);
    }

    public String toString() {
        return this.stringValue();
    }

    public int hashCode() {
        return (int)this.sl2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InternalStoreId)) {
            return false;
        }
        InternalStoreId other = (InternalStoreId)obj;
        return this.sl1 == other.sl1 && this.sl2 == other.sl2;
    }

    protected boolean equals(InternalStoreId id) {
        return this.sl1 == id.sl1 && this.sl2 == id.sl2;
    }

    private static long parseHex(char[] buf, int off) {
        int limit = off + 16;
        long v = 0L;
        while (off < limit) {
            v <<= 4;
            char ch = buf[off];
            if (ch > 'f') {
                throw new NumberFormatException();
            }
            byte b = hex2bin[ch];
            if (b == 16) {
                throw new NumberFormatException();
            }
            v |= (long)b;
            ++off;
        }
        return v;
    }

    public static InternalStoreId fromString(String value) {
        try {
            return new InternalStoreId(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean validate(String value) {
        try {
            new InternalStoreId(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

