/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store.path;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePathWhereClauseInfo;
import com.cognos.cm.store.path.CMStorePredicateAttribute;
import com.cognos.cm.store.path.CMStorePredicateComparison;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import com.cognos.cm.store.path.ICMStorePath;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CMStorePath
implements ICMStorePath {
    private static boolean dbgGetStackTrace_ = false;
    private static final String sDebugLMKey_ = "CM.debugLM";
    private String obtainedStack_ = null;
    protected ArrayList<Object> fullPath_;
    protected String path_;
    protected String originalSearchPath_;
    protected boolean bCompound_;
    protected boolean hasDescendantSteps_;
    protected int usageLockManager_ = 10;
    private boolean locksHaveBeenObtained_;
    private int[] cacheResults_ = null;

    protected void initTokenizer(StreamTokenizer toker) {
        toker.resetSyntax();
        toker.slashSlashComments(false);
        toker.slashStarComments(false);
        toker.eolIsSignificant(false);
        try {
            while (this.isWhiteSpace(toker.nextToken())) {
            }
        }
        catch (IOException iOException) {
        }
        finally {
            toker.pushBack();
        }
    }

    protected boolean isWhiteSpace(int c) {
        return c == 32 || c == 9;
    }

    protected CMStorePathStep CreateNewStep(int axis) {
        return new CMStorePathStep(axis);
    }

    @Override
    public String getName() {
        if (this.fullPath_ == null) {
            return "";
        }
        CMStorePathStep lastStep = (CMStorePathStep)this.fullPath_.get(this.fullPath_.size() - 1);
        return lastStep.getName();
    }

    @Override
    public String getNameEncoded() {
        if (this.fullPath_ == null) {
            return "";
        }
        return ((CMStorePathStep)this.fullPath_.get(this.fullPath_.size() - 1)).toStringEncoded();
    }

    @Override
    public String getPath() {
        if (this.path_ == null) {
            if (this.fullPath_ == null) {
                this.path_ = "/";
            } else {
                StringBuffer path = new StringBuffer("/");
                for (int idx = 0; idx < this.fullPath_.size() - 1; ++idx) {
                    path.append(((CMStorePathStep)this.fullPath_.get(idx)).toStringEncoded());
                    path.append("/");
                }
                this.path_ = path.toString();
            }
        }
        return this.path_;
    }

    @Override
    public String getFullPath() {
        if (this.fullPath_ == null) {
            return "/";
        }
        return this.getPath() + this.getNameEncoded();
    }

    @Override
    public String getOriginalPath() {
        if (this.originalSearchPath_ != null) {
            return this.originalSearchPath_;
        }
        return this.getPath();
    }

    @Override
    public String getSubpath(int depth) {
        if (depth < 0 || this.fullPath_ == null || depth > this.fullPath_.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (depth == 0) {
            return "/";
        }
        StringBuffer strBuf = new StringBuffer(256);
        for (int i = 0; i < depth; ++i) {
            strBuf.append(((CMStorePathStep)this.fullPath_.get(i)).toString());
        }
        return strBuf.toString();
    }

    @Override
    public String getDescendantSubpath(int depth) {
        if (depth < 0 || this.fullPath_ == null || depth > this.fullPath_.size()) {
            throw new IndexOutOfBoundsException();
        }
        StringBuffer strBuf = new StringBuffer(256);
        for (int i = depth; i < this.fullPath_.size(); ++i) {
            strBuf.append(((CMStorePathStep)this.fullPath_.get(i)).toString());
        }
        return strBuf.toString();
    }

    @Override
    public CMStorePath getParent() {
        if (this.fullPath_ == null) {
            return this;
        }
        CMStoreXPath parent = new CMStoreXPath();
        if (this.fullPath_.size() > 1) {
            parent.fullPath_ = new ArrayList<Object>(this.fullPath_);
            parent.fullPath_.remove(parent.fullPath_.size() - 1);
        }
        return parent;
    }

    @Override
    public CMStorePath getParent(int depth) {
        if (depth < 0 || this.fullPath_ == null || depth > this.fullPath_.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (depth == 0) {
            try {
                new CMStoreXPath("/");
            }
            catch (CMStoreParseException cMStoreParseException) {
                // empty catch block
            }
        }
        CMStoreXPath parent = new CMStoreXPath();
        StringBuffer parentPath = null;
        if (this.fullPath_.size() > 0) {
            parent.fullPath_ = new ArrayList(depth);
            parentPath = new StringBuffer();
        }
        for (int iStep = 0; iStep < depth; ++iStep) {
            Object step = this.fullPath_.get(iStep);
            parent.fullPath_.add(step);
            parentPath.append(step.toString());
            parent.originalSearchPath_ = parentPath.toString();
        }
        return parent;
    }

    @Override
    public ICMStorePath getChild(String name) {
        CMStoreXPath childPath = new CMStoreXPath();
        childPath.fullPath_ = this.fullPath_ != null ? new ArrayList<Object>(this.fullPath_) : new ArrayList();
        childPath.fullPath_.add(new CMStorePathStep(1, name));
        return childPath;
    }

    @Override
    public CMStorePath removeStep(int stepNum) {
        CMStoreXPath childPath = new CMStoreXPath();
        if (this.fullPath_ == null) {
            return childPath;
        }
        int iSize = this.fullPath_.size();
        if (stepNum < 0) {
            stepNum = iSize + stepNum;
        }
        if (this.fullPath_ != null) {
            childPath.fullPath_ = new ArrayList(iSize - 1);
        }
        for (int iStep = 0; iStep < iSize; ++iStep) {
            if (iStep == stepNum) continue;
            childPath.fullPath_.add(this.fullPath_.get(iStep));
        }
        return childPath;
    }

    @Override
    public int size() {
        return this.fullPath_ == null ? 0 : this.fullPath_.size();
    }

    @Override
    public CMStorePathStep stepAt(int index) {
        if (this.fullPath_ == null || index < 0 || index > this.fullPath_.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return (CMStorePathStep)this.fullPath_.get(index);
    }

    @Override
    public ICMStorePath compoundPathElementAt(int index) {
        if (this.fullPath_ == null || index < 0 || index > this.fullPath_.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return (ICMStorePath)this.fullPath_.get(index);
    }

    @Override
    public String elementAt(int index) {
        if (this.fullPath_ == null || index < 0 || index > this.fullPath_.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.fullPath_.get(index).toString();
    }

    @Override
    public void append(ICMStorePath otherPath, int startIdx, int endIdx) {
        if (this.fullPath_ == null) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = startIdx; i < endIdx && i < otherPath.size(); ++i) {
            this.fullPath_.add(((CMStorePath)otherPath).fullPath_.get(i));
        }
    }

    @Override
    public void append(ICMStorePath otherPath, int startIdx) {
        this.append(otherPath, startIdx, Integer.MAX_VALUE);
    }

    @Override
    public String getCacheQueryPath() {
        return this.getCacheQueryPath(0);
    }

    @Override
    public String getCacheQueryPath(int iStartStep) {
        if (this.fullPath_ == null) {
            return "/";
        }
        try {
            this.ResolveCurrentUserSteps(true);
        }
        catch (CMStoreParseException cMStoreParseException) {
            // empty catch block
        }
        StringBuffer path = new StringBuffer("");
        for (int idx = iStartStep; idx < this.fullPath_.size(); ++idx) {
            CMConstants.FunctionDef function = null;
            CMStorePathStep step = (CMStorePathStep)this.fullPath_.get(idx);
            if (idx == 0) {
                function = step.getNodeSetFunction();
            }
            if (function != null) {
                CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)step.Predicates.get(0);
                path.append(parsedFunc.toCacheExpression(null));
                continue;
            }
            path.append("/");
            path.append(step.getCacheQuery());
        }
        return path.toString();
    }

    @Override
    public String getWhereClause(CMStorePathWhereClauseInfo wcInfo) throws CMException {
        if (this.size() == 0) {
            return "";
        }
        try {
            this.ResolveCurrentUserSteps(true);
        }
        catch (CMStoreParseException cMStoreParseException) {
            // empty catch block
        }
        CMStorePathStep step = (CMStorePathStep)this.fullPath_.get(this.fullPath_.size() - 1);
        return step.getWhereClause(wcInfo);
    }

    @Override
    public String getCAMQuery() {
        CMStorePathPredicateFunction predFunc;
        CMStoreXPathStep step22;
        if (this.fullPath_ == null || this.fullPath_.size() == 0) {
            return "/";
        }
        if (1 == this.fullPath_.size() && null != (step22 = (CMStoreXPathStep)this.fullPath_.get(0)) && null != step22.Predicates && 1 == step22.Predicates.size() && null != (predFunc = (CMStorePathPredicateFunction)step22.Predicates.get(0)) && null != predFunc.function_ && CMConstants.FUNC_IDENTITYOBJECTS_DEF == predFunc.function_ && null != predFunc.args && 0 < predFunc.args.size()) {
            CMStoreXPath argPath = (CMStoreXPath)predFunc.args.get(0);
            return argPath.toString() + "//~";
        }
        try {
            this.ResolveCurrentUserSteps(true);
        }
        catch (CMStoreParseException step22) {
            // empty catch block
        }
        StringBuffer results = new StringBuffer(1024);
        for (int i = 0; i < this.fullPath_.size(); ++i) {
            if (this.bCompound_ && i > 0) {
                results.append("|");
            }
            String stepQuery = ((CMStorePathStep)this.fullPath_.get(i)).getCAMQuery(i);
            results.append(stepQuery);
        }
        String strRet = results.toString();
        if (strRet.equals("/directory/*[@objectClass='namespace']")) {
            strRet = "/directory/namespace";
        }
        return strRet;
    }

    @Override
    public String getCAMIDFromFirstStep() {
        if (this.size() > 0 && this.fullPath_.get(0) instanceof CMStorePathStep) {
            return ((CMStorePathStep)this.fullPath_.get(0)).getCAMIDLiteral();
        }
        return null;
    }

    @Override
    public boolean isUnion() {
        return this.bCompound_;
    }

    @Override
    public List<ICMStorePath> getUnion() {
        if (!this.bCompound_) {
            throw new IllegalStateException("getUnion() invoked on a non-compound CMStorePath instance");
        }
        ArrayList<ICMStorePath> paths = new ArrayList<ICMStorePath>(this.fullPath_.size());
        for (Object o : this.fullPath_) {
            paths.add((ICMStorePath)o);
        }
        return paths;
    }

    protected void SetDefaultAxis(CMStorePath path) throws CMStoreParseException {
        if (path.fullPath_ == null) {
            return;
        }
        for (int iStep = 0; iStep < path.fullPath_.size(); ++iStep) {
            Object stepObj = path.fullPath_.get(iStep);
            if (path.bCompound_) {
                if (((CMStorePath)stepObj).fullPath_ == null) {
                    throw new CMStoreParseException("cmInvalidSearchPath", new CMException.Parm("Path", this.originalSearchPath_));
                }
                this.SetDefaultAxis((CMStorePath)stepObj);
                continue;
            }
            if (stepObj.getClass() != CMStorePathStep.class && stepObj.getClass() != CMStoreXPathStep.class) continue;
            CMStorePathStep step = (CMStorePathStep)stepObj;
            if (step.axis != 99) continue;
            step.axis = 1;
        }
    }

    public String toString() {
        if (this.fullPath_ == null || this.fullPath_.size() == 0) {
            return "/";
        }
        StringBuffer results = new StringBuffer(1024);
        for (int i = 0; i < this.fullPath_.size(); ++i) {
            if (this.bCompound_ && i > 0) {
                results.append("|");
            }
            results.append(this.fullPath_.get(i).toString());
        }
        return results.toString();
    }

    @Override
    public boolean resolvableInCache() {
        if (this.fullPath_ == null) {
            return true;
        }
        boolean resolvable = true;
        int stepCount = this.fullPath_.size();
        for (int stepIdx = 0; stepIdx != stepCount && resolvable; ++stepIdx) {
            resolvable = ((CMStorePathStep)this.fullPath_.get(stepIdx)).resolvableInCache();
        }
        return resolvable;
    }

    @Override
    public void ResolveCurrentUserSteps(boolean bResolveSession) throws CMStoreParseException {
    }

    @Override
    public String getPathNameForNode(int stepNum) {
        if (this.fullPath_ == null) {
            return "";
        }
        int iSize = this.fullPath_.size();
        if (stepNum < 0) {
            stepNum = iSize + stepNum;
        }
        if (stepNum >= iSize) {
            return null;
        }
        CMStorePathStep pathStep = (CMStorePathStep)this.fullPath_.get(stepNum);
        if (pathStep.Predicates == null) {
            return null;
        }
        CMStorePathPredicate pathPredicate = null;
        if (pathStep.Predicates.size() == 1) {
            pathPredicate = (CMStorePathPredicate)pathStep.Predicates.get(0);
        } else if (pathStep.Predicates.size() == 2) {
            pathPredicate = (CMStorePathPredicate)pathStep.Predicates.get(1);
        } else {
            return null;
        }
        if (pathPredicate == null || pathPredicate.PredicateExpressions.size() != 3) {
            return null;
        }
        try {
            CMStorePredicateAttribute predAttr = (CMStorePredicateAttribute)pathPredicate.PredicateExpressions.get(0);
            if (predAttr == null || predAttr.property != CMProperty.NAME && predAttr.property != CMProperty.DEFAULTNAME) {
                return null;
            }
            CMStorePredicateComparison predCompare = (CMStorePredicateComparison)pathPredicate.PredicateExpressions.get(1);
            if (predCompare.comparison != 2) {
                return null;
            }
            CMStorePredicateStringLiteral predLiteral = (CMStorePredicateStringLiteral)pathPredicate.PredicateExpressions.get(2);
            return predLiteral.literal;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    @Override
    public int[] getCacheResults() {
        return this.cacheResults_;
    }

    @Override
    public void setCacheResults(int[] cacheResults) {
        this.cacheResults_ = cacheResults;
    }

    @Override
    public void setLocksHaveBeenObtained() {
        this.locksHaveBeenObtained_ = true;
        if (dbgGetStackTrace_) {
            this.obtainedStack_ = CMIndications.getStacktraceText_Trimmed();
        }
    }

    @Override
    public void clearLocksHaveBeenObtained() {
        this.locksHaveBeenObtained_ = false;
        this.obtainedStack_ = null;
    }

    @Override
    public boolean getLocksHaveBeenObtained() {
        return this.locksHaveBeenObtained_;
    }

    @Override
    public int getLockManagerUsageFlag() {
        return this.usageLockManager_;
    }

    @Override
    public void setLockManagerUsageFlag(int usage) throws IllegalStateException {
        if (this.locksHaveBeenObtained_) {
            String msg = "The Lock Manager usage flag cannot be set after locks have been obtained for this path." + this.originalSearchPath_;
            if (this.obtainedStack_ != null) {
                msg = msg + "\nLocks were obtained here - ";
                msg = msg + this.obtainedStack_;
            }
            throw new IllegalStateException(msg);
        }
        this.usageLockManager_ = usage;
    }

    @Override
    public boolean hasDescendantSteps() {
        return this.hasDescendantSteps_;
    }

    @Override
    public void clearHasDescendantSteps() {
        this.hasDescendantSteps_ = false;
    }

    @Override
    public CMStorePathPredicateFunction getPredicateFunction(CMConstants.FunctionDef function) {
        if (this.fullPath_ == null) {
            return null;
        }
        for (int idx = 0; idx < this.fullPath_.size(); ++idx) {
            CMStorePathStep step;
            CMStorePathPredicateFunction predicateFunction;
            if (!(this.fullPath_.get(idx) instanceof CMStorePathStep) || (predicateFunction = (step = (CMStorePathStep)this.fullPath_.get(idx)).getPredicateFunction(function)) == null) continue;
            return predicateFunction;
        }
        return null;
    }

    @Override
    public List<ICMStorePath> getSecondaryPaths() {
        ArrayList<ICMStorePath> paths = new ArrayList<ICMStorePath>();
        if (this.fullPath_ == null) {
            return paths;
        }
        for (int i = 0; i < this.fullPath_.size(); ++i) {
            Object stepObject = this.fullPath_.get(i);
            if (stepObject instanceof CMStorePath) {
                paths.addAll(((ICMStorePath)stepObject).getSecondaryPaths());
                continue;
            }
            if (!(stepObject instanceof CMStorePathStep)) continue;
            CMStorePathStep step = (CMStorePathStep)stepObject;
            ArrayList<CMStorePathPredicateFunction> functions = step.getNodeSetParamFunctions();
            for (int j = 0; j < functions.size(); ++j) {
                CMStorePathPredicateFunction function = functions.get(j);
                if (function.function_ != CMConstants.FUNC_CONTAINSREFERENCES_DEF) continue;
                for (int k = 0; k < function.args.size(); ++k) {
                    Object argument = function.args.get(k);
                    if (!(argument instanceof CMStorePath)) continue;
                    paths.add((CMStorePath)argument);
                }
            }
        }
        return paths;
    }

    @Override
    public void setOriginalPath(String string) {
        this.originalSearchPath_ = string;
    }

    public static CMStorePath rewriteFirstStep(CMStorePath query2) {
        CMStoreXPath cacheQuery = null;
        if (query2.size() != 1) {
            try {
                CMStoreXPath path = (CMStoreXPath)CMStoreXPath.parse("/*");
                path.append(query2, 1);
                cacheQuery = path;
            }
            catch (CMStoreParseException cMStoreParseException) {
                // empty catch block
            }
        }
        return cacheQuery;
    }

    @Override
    public void validateWithUserContext() throws CMException {
        if (this.fullPath_ == null) {
            return;
        }
        if (CMExecutionContext.get().getContext().getCurrentUserSession() == null) {
            throw new IllegalArgumentException("Function validateWithUserContext() can only be called after the userSession is initialized");
        }
        for (int i = 0; i < this.fullPath_.size(); ++i) {
            Object stepObject = this.fullPath_.get(i);
            if (!(stepObject instanceof CMStorePathStep)) continue;
            CMStorePathStep step = (CMStorePathStep)stepObject;
            this.validatePredicateFunctions(step);
        }
    }

    private void validatePredicateFunctions(CMStorePathStep step) throws CMException {
        List<CMStorePredicateElement> predicates = step.Predicates;
        if (predicates == null || predicates.size() == 0) {
            return;
        }
        for (int index = 0; index < predicates.size(); ++index) {
            CMStorePathPredicate pathPredicate = (CMStorePathPredicate)predicates.get(index);
            if (pathPredicate.PredicateExpressions == null) continue;
            for (int j = 0; j < pathPredicate.PredicateExpressions.size(); ++j) {
                CMStorePredicateElement predicateExpression = pathPredicate.PredicateExpressions.get(j);
                if (!(predicateExpression instanceof CMStorePathPredicateFunction)) continue;
                CMStorePathPredicateFunction predicateFunction = (CMStorePathPredicateFunction)predicateExpression;
                predicateFunction.validate();
            }
        }
    }

    static {
        Properties sysProps = System.getProperties();
        dbgGetStackTrace_ = sysProps.containsKey(sDebugLMKey_);
    }
}

