/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store.path;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMDescendantModifiedProperty;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.PropertyMapping;
import com.cognos.cm.store.path.CMPathStepTokenizer;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathWhereClauseInfo;
import com.cognos.cm.store.path.CMStorePredicateAttribute;
import com.cognos.cm.store.path.CMStorePredicateBool;
import com.cognos.cm.store.path.CMStorePredicateComparison;
import com.cognos.cm.store.path.CMStorePredicateDouble;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.store.path.CMStorePredicateInteger;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.date.DateUtils;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CMStorePathPredicate
implements CMStorePredicateElement {
    public List<CMStorePredicateElement> PredicateExpressions;
    int endChar;
    boolean canBeProcessedByCache;
    static char endChar_Brace = (char)93;
    static char endChar_Paren = (char)41;
    private static int[] reversedOperators = new int[]{0, 4, 2, 6, 1, 5, 3};

    protected void initTokenizer(StreamTokenizer toker) {
        toker.resetSyntax();
        toker.wordChars(65, 90);
        toker.wordChars(97, 122);
        toker.wordChars(34, 34);
        toker.wordChars(36, 39);
        toker.wordChars(46, 46);
        toker.wordChars(63, 63);
        toker.wordChars(94, 96);
        toker.wordChars(123, 126);
        toker.wordChars(48, 57);
        toker.wordChars(45, 45);
        toker.wordChars(43, 43);
        toker.wordChars(42, 42);
        toker.wordChars(47, 47);
        toker.ordinaryChar(39);
        toker.ordinaryChar(34);
        if (this.endChar == 93) {
            toker.whitespaceChars(127, 255);
            toker.ordinaryChar(endChar_Brace);
        } else if (this.endChar == 41) {
            toker.whitespaceChars(0, 32);
            toker.ordinaryChar(endChar_Paren);
        } else if (this.endChar == -1) {
            toker.whitespaceChars(0, 32);
            toker.ordinaryChar(this.endChar);
        }
        toker.slashSlashComments(false);
        toker.slashStarComments(false);
        toker.eolIsSignificant(false);
    }

    public CMStorePathPredicate() {
        this.PredicateExpressions = new ArrayList<CMStorePredicateElement>();
        this.canBeProcessedByCache = true;
    }

    public CMStorePathPredicate(CMPathStepTokenizer toker, int end) throws IOException, CMStoreParseException {
        this(toker, end, 0);
    }

    public CMStorePathPredicate(CMPathStepTokenizer toker, int end, int attributeHandling) throws IOException, CMStoreParseException {
        int iToken;
        this.endChar = end;
        this.initTokenizer(toker);
        this.PredicateExpressions = new ArrayList<CMStorePredicateElement>();
        this.canBeProcessedByCache = true;
        while ((iToken = toker.nextToken()) != this.endChar) {
            CMStorePredicateElement elem = CMStorePathPredicate.ProcessToken(iToken, toker, attributeHandling);
            if (elem != null) {
                this.canBeProcessedByCache = this.canBeProcessedByCache && elem.CanBeProcessedByCache();
                this.PredicateExpressions.add(elem);
            }
            this.initTokenizer(toker);
        }
        if (this.PredicateExpressions.size() <= 0) {
            throw new CMStoreParseException("cmEmptyPredicate");
        }
        if (this.PredicateExpressions.size() == 1 && this.PredicateExpressions.get(0) instanceof CMStorePredicateAttribute) {
            this.canBeProcessedByCache = false;
        }
    }

    public CMObjectClass CreateClassPredicate(String classDefinition) throws CMStoreParseException, CMStoreNotAvailable, CMStoreUnexpected {
        CMStore store = CMExecutionContext.get().getStore();
        CMObjectClass cls = store.getObjectClasses().getClassByName(classDefinition);
        if (cls == null) {
            throw new CMStoreParseException("cmBadClass", new CMException.Parm("Class", classDefinition));
        }
        PropertyMapping propMap = store.getMetadata().getPropertyMap();
        this.PredicateExpressions.add(new CMStorePredicateAttribute(propMap.objectClass()));
        this.PredicateExpressions.add(new CMStorePredicateComparison(2));
        this.PredicateExpressions.add(new CMStorePredicateStringLiteral(classDefinition));
        return cls;
    }

    static CMStorePredicateElement ProcessToken(int iToken, CMPathStepTokenizer toker, int attributeHandling) throws IOException, CMStoreParseException {
        if (iToken == -1 || iToken == 10) {
            throw new CMStoreParseException("cmUnterminatedPredicate");
        }
        if (iToken == -3) {
            if (toker.sval.equalsIgnoreCase("and")) {
                return new CMStorePredicateBool("and");
            }
            if (toker.sval.equalsIgnoreCase("or")) {
                return new CMStorePredicateBool("or");
            }
            CMConstants.FunctionDef function = CMConstants.findPredicateFunction(toker.sval);
            if (function != null) {
                return new CMStorePathPredicateFunction(function, toker);
            }
            if (toker.sval.equalsIgnoreCase("object") && toker.nextToken() == 58 && toker.nextToken() == 58) {
                return new CMStorePredicateAttribute(toker, 0);
            }
            try {
                int nVal = Integer.parseInt(toker.sval);
                return new CMStorePredicateInteger(nVal);
            }
            catch (NumberFormatException nVal) {
                try {
                    double dVal = Double.parseDouble(toker.sval);
                    return new CMStorePredicateDouble(dVal);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new CMStoreParseException("cmBadPredicateAttr", new CMException.Parm("Predicate", toker.sval));
                }
            }
        }
        if (iToken == 39 || iToken == 34) {
            return new CMStorePredicateStringLiteral(toker, iToken);
        }
        if (iToken == 64) {
            return new CMStorePredicateAttribute(toker, attributeHandling);
        }
        if (iToken == 93 || iToken == 41) {
            String theChar = new String();
            theChar = theChar + (char)iToken;
            throw new CMStoreParseException("cmBadPredTerminate", new CMException.Parm("terminateChar", theChar));
        }
        if (iToken == 40) {
            return new CMStorePathPredicate(toker, 41);
        }
        if (iToken == 61 || iToken == 33 || iToken == 60 || iToken == 62) {
            return new CMStorePredicateComparison(iToken, toker);
        }
        if (iToken >= 0 && iToken <= 32) {
            return null;
        }
        throw new CMStoreParseException("cmBadPredicateAttr", new CMException.Parm("Predicate", toker.sval));
    }

    @Override
    public String debugDisplay() {
        String ret = "(";
        for (int index = 0; index < this.PredicateExpressions.size(); ++index) {
            CMStorePredicateElement elem = this.PredicateExpressions.get(index);
            ret = ret + elem.debugDisplay();
        }
        ret = ret + ")";
        return ret;
    }

    @Override
    public boolean CanBeProcessedByCache() {
        return this.canBeProcessedByCache;
    }

    @Override
    public String toCacheExpression(CMStorePredicateElement elmExpressionPartner) {
        StringBuffer ret = new StringBuffer(32);
        CMStorePredicateAttribute elemProperty = null;
        int exprCount = this.PredicateExpressions.size();
        boolean bNeedBool = false;
        CMStorePredicateElement lastBool = null;
        for (int index = 0; index != exprCount; ++index) {
            String elemExpr;
            CMStorePredicateElement elem = this.PredicateExpressions.get(index);
            if (elem != null && elem.getClass() == CMStorePredicateBool.class) {
                if (!bNeedBool) continue;
                lastBool = elem;
                continue;
            }
            if (elem != null && elem.getClass() == CMStorePredicateAttribute.class) {
                boolean skipExpr = false;
                if (index + 2 < exprCount) {
                    ArrayList<CMStorePredicateElement> result = new ArrayList<CMStorePredicateElement>();
                    if (!elem.CanBeProcessedByCache()) {
                        index += 2;
                        continue;
                    }
                    skipExpr = this.expressionEvaluated(elem, this.PredicateExpressions.get(index + 1), this.PredicateExpressions.get(index + 2), result);
                    if (skipExpr) {
                        int exprCount2 = result.size();
                        for (int exprIdx = 0; exprIdx != exprCount2; ++exprIdx) {
                            CMStorePredicateElement el = (CMStorePredicateElement)result.get(exprIdx);
                            if (el.getClass() == CMStorePredicateAttribute.class) {
                                elemProperty = (CMStorePredicateAttribute)el;
                                if (elemProperty.property != CMProperty.OBJECTCLASS) {
                                    elemProperty = null;
                                }
                            }
                            ret.append(el.toCacheExpression(elemProperty));
                            bNeedBool = true;
                        }
                        index += 2;
                        continue;
                    }
                }
                CMStorePredicateAttribute attr = (CMStorePredicateAttribute)elem;
                elemProperty = attr.property == CMProperty.OBJECTCLASS || attr.property == CMProperty.DEPLOYEDOBJECTUSAGE || attr.property == CMProperty.HASMESSAGE || attr.property == CMProperty._ISBURSTOUTPUT || attr.property == CMProperty._HASRECIPIENTS || attr.property == CMProperty._HASRECIPIENTSEMAIL || attr.property == CMProperty.TENANTID ? attr : null;
            }
            if (!elem.CanBeProcessedByCache() || (elemExpr = elem.toCacheExpression(elemProperty)) == null || elemExpr.length() <= 0) continue;
            if (lastBool != null) {
                ret.append(lastBool.toCacheExpression(null));
                lastBool = null;
            }
            ret.append(elemExpr);
            bNeedBool = true;
        }
        return ret.toString();
    }

    protected boolean expressionEvaluated(CMStorePredicateElement lhs, CMStorePredicateElement op, CMStorePredicateElement rhs, List<CMStorePredicateElement> resultToSubstitute) {
        if (op.getClass() == CMStorePredicateComparison.class) {
            int compareOperator = ((CMStorePredicateComparison)op).comparison;
            CMStorePredicateAttribute attr = null;
            CMStorePredicateStringLiteral lit = null;
            if (rhs.getClass() == CMStorePredicateAttribute.class) {
                attr = (CMStorePredicateAttribute)rhs;
                if (lhs.getClass() == CMStorePredicateStringLiteral.class) {
                    lit = (CMStorePredicateStringLiteral)lhs;
                }
            } else if (rhs.getClass() == CMStorePredicateStringLiteral.class) {
                lit = (CMStorePredicateStringLiteral)rhs;
                if (lhs.getClass() == CMStorePredicateAttribute.class) {
                    attr = (CMStorePredicateAttribute)lhs;
                }
            }
            if (attr != null && lit != null) {
                if (attr.property == CMProperty.LASTCONFIGURATIONMODIFICATIONTIME) {
                    try {
                        Date literalDate = DateUtils.parse((String)lit.literal);
                        Date lastTimeConfigurationModified = CMDescendantModifiedProperty.get().getValue();
                        int compareResults = lastTimeConfigurationModified.compareTo(literalDate);
                        if (lhs == lit) {
                            compareResults = -compareResults;
                        }
                        int resultBit = 2;
                        if (compareResults < 0) {
                            resultBit = 4;
                        } else if (compareResults > 0) {
                            resultBit = 1;
                        }
                        resultToSubstitute.add(new CMStorePredicateAttribute(CMProperty.OBJECTCLASS));
                        resultToSubstitute.add(new CMStorePredicateComparison(2));
                        if ((resultBit & compareOperator) == 0) {
                            resultToSubstitute.add(new CMStorePredicateInteger(-1));
                        } else {
                            resultToSubstitute.add(new CMStorePredicateStringLiteral(CMObjectClass.CONFIGURATION.getName()));
                        }
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (attr.property.getMeaning() == CMPropertyMeaning.SHOWN) {
                    if (lhs == lit) {
                        compareOperator = this.reverseComparison(compareOperator);
                    }
                    return this.evaluateShownPredicate(lit, compareOperator, resultToSubstitute);
                }
            }
        }
        return false;
    }

    int reverseComparison(int operator) {
        if (operator < reversedOperators.length) {
            return reversedOperators[operator];
        }
        return operator;
    }

    private boolean evaluateShownPredicate(CMStorePredicateStringLiteral lit, int operation, List<CMStorePredicateElement> substitution) {
        try {
            if (operation != 2 && operation != 5) {
                throw new IllegalStateException("Can't use operator '" + new CMStorePredicateComparison(operation).toString() + "' with boolean property");
            }
            boolean selectShown = CMXMLUtils.parseBooleanAttribute(lit.literal);
            if (operation == 5) {
                boolean bl = selectShown = !selectShown;
            }
            if (this.userCanSeeHiddenObjects()) {
                if (!selectShown) {
                    substitution.add(new CMStorePredicateAttribute(CMProperty.OBJECTCLASS));
                    substitution.add(new CMStorePredicateComparison(2));
                    substitution.add(new CMStorePredicateInteger(-1));
                }
            } else {
                substitution.add(new CMStorePredicateAttribute(CMProperty.HIDDEN));
                substitution.add(new CMStorePredicateComparison(2));
                substitution.add(new CMStorePredicateInteger(selectShown ? 0 : 1));
            }
        }
        catch (Exception ex) {
            CMIndications.logException(ex);
        }
        return true;
    }

    private boolean userCanSeeHiddenObjects() throws CMException {
        CMExecutionContext eCtx = CMExecutionContext.get();
        return eCtx.currentUserCanSeeHiddenObjects();
    }

    @Override
    public String getWhereClause(CMStorePredicateElement elmExpressionPartner, CMStorePathWhereClauseInfo wcInfo) throws CMException {
        StringBuffer strClause = new StringBuffer();
        int nLen = this.PredicateExpressions.size();
        int nLenMinusOne = nLen - 1;
        int nLenMinusTwo = nLen - 2;
        if (nLen > 1) {
            strClause.append("(");
        }
        CMStorePredicateElement elemNext = this.PredicateExpressions.get(0);
        for (int index = 0; index < nLen; ++index) {
            CMStorePredicateElement elem = elemNext;
            if (elem == null) {
                elem = this.PredicateExpressions.get(index);
            }
            if (index < nLenMinusOne) {
                elemNext = this.PredicateExpressions.get(index + 1);
                if (index < nLenMinusTwo && elemNext.getClass() == CMStorePredicateComparison.class) {
                    ArrayList<CMStorePredicateElement> exprResult;
                    CMStorePredicateElement elem2Next = this.PredicateExpressions.get(index + 2);
                    boolean skipExpr = this.expressionEvaluated(elem, elemNext, elem2Next, exprResult = new ArrayList<CMStorePredicateElement>());
                    if (!skipExpr) {
                        CMStorePredicateStringLiteral opArg = null;
                        CMStorePredicateComparison comparison = null;
                        if (elem2Next.getClass() == CMStorePredicateStringLiteral.class) {
                            CMStorePredicateStringLiteral literal = (CMStorePredicateStringLiteral)elem2Next;
                            if (literal.literal.length() == 0 && !this.isTenantIDPredicate(elem)) {
                                opArg = literal;
                            }
                            if (elem.getClass() == CMStorePredicateAttribute.class && elemNext.getClass() == CMStorePredicateComparison.class) {
                                CMStorePredicateAttribute attribute = (CMStorePredicateAttribute)elem;
                                comparison = new CMStorePredicateComparison(((CMStorePredicateComparison)elemNext).comparison);
                                comparison.property = attribute.property;
                                if (attribute.property.getBehaviourName() == "isNotNULL") {
                                    boolean booleanValue = false;
                                    try {
                                        booleanValue = CMXMLUtils.parseBooleanAttribute(literal.literal);
                                    }
                                    catch (CMException cMException) {
                                        // empty catch block
                                    }
                                    if (comparison.comparison == 2 && booleanValue) {
                                        comparison.comparison = 5;
                                    } else if (comparison.comparison == 5 && booleanValue) {
                                        comparison.comparison = 2;
                                    }
                                    opArg = new CMStorePredicateStringLiteral("");
                                    elemNext = comparison;
                                    elem2Next = opArg;
                                } else if (wcInfo.hasMultipleRecords(attribute.property) && comparison.comparison == 5) {
                                    comparison.comparison = 2;
                                    strClause.append("not ");
                                }
                            }
                        }
                        strClause.append(elem.getWhereClause(elem2Next, wcInfo));
                        if (comparison != null) {
                            strClause.append(comparison.getWhereClause(opArg, wcInfo));
                        } else {
                            strClause.append(elemNext.getWhereClause(opArg, wcInfo));
                        }
                        strClause.append(elem2Next.getWhereClause(elem, wcInfo));
                    } else if (exprResult.size() == 3) {
                        CMStorePredicateElement lhs = (CMStorePredicateElement)exprResult.get(0);
                        CMStorePredicateElement op = (CMStorePredicateElement)exprResult.get(1);
                        CMStorePredicateElement rhs = (CMStorePredicateElement)exprResult.get(2);
                        strClause.append(lhs.getWhereClause(rhs, wcInfo));
                        strClause.append(op.getWhereClause(null, wcInfo));
                        strClause.append(rhs.getWhereClause(lhs, wcInfo));
                    }
                    elemNext = null;
                    index += 2;
                    continue;
                }
            } else {
                elemNext = null;
            }
            strClause.append(elem.getWhereClause(null, wcInfo));
        }
        if (nLen > 1) {
            strClause.append(")");
        }
        String strResult = strClause.toString();
        while (nLen > 1) {
            String x;
            if (strResult.startsWith("( or")) {
                x = "(";
                strResult = x = x + strResult.substring(5);
                continue;
            }
            if (!strResult.startsWith("( and")) break;
            x = "(";
            strResult = x = x + strResult.substring(6);
        }
        if (strResult.equals("()") || strResult.equals("( )")) {
            strResult = "";
        }
        return strResult;
    }

    private boolean isTenantIDPredicate(CMStorePredicateElement elem) {
        return elem.getClass() == CMStorePredicateAttribute.class && ((CMStorePredicateAttribute)elem).property.hasMeaning(CMPropertyMeaning.TENANTID);
    }

    @Override
    public String toAccmanSearchFilter(CMStorePredicateElement elmExpressionPartner) {
        StringBuffer strClause = new StringBuffer();
        int nLen = this.PredicateExpressions.size();
        for (int index = 0; index < nLen; ++index) {
            CMStorePredicateElement pred = this.PredicateExpressions.get(index);
            if (pred.getClass() == CMStorePredicateAttribute.class) continue;
            strClause.append(pred.toAccmanSearchFilter(null));
        }
        return strClause.toString();
    }

    @Override
    public String toAccmanSearchFilter(CMStorePredicateElement elmExpressionPartner, String propList) {
        StringBuffer strClause = new StringBuffer();
        int nLen = this.PredicateExpressions.size();
        for (int index = 0; index < nLen; ++index) {
            CMStorePredicateElement pred = this.PredicateExpressions.get(index);
            if (pred.getClass() == CMStorePredicateAttribute.class) continue;
            strClause.append(pred.toAccmanSearchFilter(null));
        }
        return strClause.toString();
    }

    public boolean idPredicateReferencesExternalObject(List<String> ids, int index) {
        boolean bRet = true;
        int nLen = this.PredicateExpressions.size();
        if (++index < nLen) {
            CMStorePredicateElement pred1 = this.PredicateExpressions.get(index);
            if (pred1.getClass() != CMStorePredicateComparison.class) {
                bRet = false;
            } else {
                CMStorePredicateComparison op = (CMStorePredicateComparison)pred1;
                if (op.comparison != 2) {
                    bRet = false;
                } else if (++index < nLen) {
                    CMStorePredicateElement pred2 = this.PredicateExpressions.get(index);
                    if (pred2.getClass() != CMStorePredicateStringLiteral.class) {
                        bRet = false;
                    } else if (ids != null) {
                        CMStorePredicateStringLiteral lit = (CMStorePredicateStringLiteral)pred2;
                        if (CMCAMIDHelper.CAMIDIsExternal(lit.literal)) {
                            ids.add(lit.literal);
                        } else {
                            bRet = false;
                        }
                    }
                } else {
                    bRet = false;
                }
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    public boolean hasSecurityIDPredicate(List<String> ids) {
        boolean bRet = true;
        int nLen = this.PredicateExpressions.size();
        for (int index = 0; index < nLen; ++index) {
            CMStorePredicateElement pred = this.PredicateExpressions.get(index);
            if (pred.getClass() == CMStorePredicateAttribute.class) {
                CMStorePredicateAttribute prop = (CMStorePredicateAttribute)pred;
                if (!prop.property.getName().equalsIgnoreCase("id")) {
                    bRet = false;
                } else {
                    bRet = this.idPredicateReferencesExternalObject(ids, index);
                    index += 2;
                }
            } else {
                bRet = false;
            }
            if (!bRet) break;
        }
        return bRet;
    }

    public boolean hasPermissionFunction() {
        boolean bRet = false;
        int nLen = this.PredicateExpressions.size();
        for (int index = 0; index < nLen; ++index) {
            CMStorePredicateElement pred = this.PredicateExpressions.get(index);
            if (pred.getClass() != CMStorePathPredicateFunction.class) continue;
            CMStorePathPredicateFunction func = (CMStorePathPredicateFunction)pred;
            if (func.function_ != CMConstants.FUNC_PERMISSION_DEF) continue;
            return true;
        }
        return bRet;
    }

    public String getName() {
        int nLen = this.PredicateExpressions.size();
        for (int index = 0; index < nLen; ++index) {
            CMStorePredicateElement pred2;
            CMStorePredicateElement pred1 = this.PredicateExpressions.get(index);
            if (pred1.getClass() != CMStorePredicateAttribute.class) continue;
            CMStorePredicateAttribute predAttr = (CMStorePredicateAttribute)pred1;
            if (predAttr.property != CMProperty.DEFAULTNAME && predAttr.property != CMProperty.NAME || ++index >= nLen) continue;
            CMStorePredicateComparison op = (CMStorePredicateComparison)this.PredicateExpressions.get(index);
            if (op.comparison != 2 || ++index >= nLen || (pred2 = this.PredicateExpressions.get(index)).getClass() != CMStorePredicateStringLiteral.class) continue;
            CMStorePredicateStringLiteral lit = (CMStorePredicateStringLiteral)pred2;
            return lit.literal;
        }
        return null;
    }

    public boolean hasAcquirablePropertyPredicate() {
        int nLen = this.PredicateExpressions.size();
        for (int index = 0; index < nLen; ++index) {
            CMStorePredicateElement pred = this.PredicateExpressions.get(index);
            if (pred.getClass() == CMStorePredicateAttribute.class) {
                CMStorePredicateAttribute predicateAttribute = (CMStorePredicateAttribute)pred;
                if (predicateAttribute.property == null || !predicateAttribute.property.isInheritable()) continue;
                return true;
            }
            if (pred.getClass() != CMStorePathPredicateFunction.class) continue;
            CMStorePathPredicateFunction function = (CMStorePathPredicateFunction)pred;
            if (function.args == null) continue;
            for (int i = 0; i < function.args.size(); ++i) {
                CMStorePathFunctionArgument arg;
                if (!(function.args.get(i) instanceof CMStorePathFunctionArgument) || (arg = (CMStorePathFunctionArgument)function.args.get(i)) == null || !arg.hasAcquirablePropertyPredicate()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        for (int index = 0; index < this.PredicateExpressions.size(); ++index) {
            results.append(this.PredicateExpressions.get(index).toString());
        }
        return results.toString();
    }

    static class ObjectRef {
        Object value_;

        public ObjectRef() {
        }

        public ObjectRef(Object value) {
            this.value_ = value;
        }

        public Object get() {
            return this.value_;
        }

        public void set(Object value) {
            this.value_ = value;
        }
    }
}

