/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store.path;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.UserSessionCache;
import com.cognos.cm.server.UserSessionCacheEntry;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryInfo;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMPathStepTokenizer;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePathUtils;
import com.cognos.cm.store.path.CMStorePathWhereClauseInfo;
import com.cognos.cm.store.path.CMStorePredicateAttribute;
import com.cognos.cm.store.path.CMStorePredicateDouble;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.store.path.CMStorePredicateInteger;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class CMStorePathPredicateFunction
extends CMStorePathPredicate {
    public CMConstants.FunctionDef function_;
    public List<Object> args;
    public List<CMObjectReference> argsResolved;
    private boolean canResolveReference_;
    private boolean argumentsResolved_;

    @Override
    protected void initTokenizer(StreamTokenizer toker) {
        toker.resetSyntax();
        toker.whitespaceChars(0, 32);
        toker.wordChars(65, 90);
        toker.wordChars(97, 122);
        toker.wordChars(36, 39);
        toker.wordChars(46, 46);
        toker.wordChars(63, 63);
        toker.wordChars(94, 96);
        toker.wordChars(123, 125);
        toker.wordChars(48, 57);
        toker.wordChars(45, 45);
        toker.wordChars(43, 43);
        toker.wordChars(42, 42);
        toker.ordinaryChar(41);
        toker.ordinaryChar(44);
        toker.ordinaryChar(39);
        toker.ordinaryChar(34);
        toker.slashSlashComments(false);
        toker.slashStarComments(false);
        toker.eolIsSignificant(false);
    }

    public CMStorePathPredicateFunction() {
    }

    public CMStorePathPredicateFunction(CMConstants.FunctionDef function, CMPathStepTokenizer toker) throws IOException, CMStoreParseException {
        int invocationArgCount;
        int iToken;
        this.function_ = function;
        Object currentArg = null;
        this.initTokenizer(toker);
        boolean expectingArg = false;
        int[] argTypes = this.function_.getArgTypes();
        int definitionArgCount = argTypes != null ? argTypes.length : 0;
        boolean varArgs = false;
        if (toker.nextToken() != 40) {
            throw new CMStoreParseException("cmBadPredNoArgs", new CMException.Parm("Name", this.function_.getName()));
        }
        while ((iToken = toker.nextToken()) != 41) {
            if (iToken == -1) {
                throw new CMStoreParseException("cmBadFuncNoEnd");
            }
            if (iToken == 44) {
                if (currentArg == null) {
                    throw new CMStoreParseException("cmBadFuncEmptyArg");
                }
                currentArg = null;
                expectingArg = true;
                continue;
            }
            if (currentArg == null) {
                int type;
                if (this.args == null) {
                    this.args = new ArrayList<Object>();
                }
                this.argsResolved = new ArrayList<CMObjectReference>();
                if (definitionArgCount == 0) {
                    throw new CMStoreParseException("cmBadPredNoArgs", new CMException.Parm("Name", this.function_.getName()));
                }
                if (varArgs) {
                    type = argTypes[definitionArgCount - 1] & 0xFF;
                } else {
                    if (this.args.size() == argTypes.length) {
                        throw new CMStoreParseException("cmBadArgCount", new CMException.Parm("Name", this.function_.getName()));
                    }
                    int aType = argTypes[this.args.size()];
                    type = aType & 0xFF;
                    varArgs = (aType & Integer.MIN_VALUE) != 0;
                }
                try {
                    if (type == 1) {
                        CMStoreXPath arg = new CMStoreXPath();
                        toker.pushBack();
                        boolean bAllowsCompoundPath = false;
                        if (this.function_.getID() == 17 || this.function_.getID() == 16) {
                            bAllowsCompoundPath = true;
                        }
                        arg.parsePath(toker, false, bAllowsCompoundPath);
                        currentArg = arg;
                    } else if (type == 7) {
                        if (iToken == 39 || iToken == 34) {
                            currentArg = new CMStorePathFunctionArgument(iToken, toker, 0);
                            type = 5;
                        } else {
                            CMStoreXPath arg = new CMStoreXPath();
                            toker.pushBack();
                            boolean bAllowsCompoundPath = false;
                            if (this.function_.getID() == 17 || this.function_.getID() == 16) {
                                bAllowsCompoundPath = true;
                            }
                            arg.parsePath(toker, false, bAllowsCompoundPath);
                            currentArg = arg;
                            type = 1;
                        }
                    } else {
                        int attributeHandling = 0;
                        if (type == 8) {
                            attributeHandling = 1;
                        } else if (this.function_.getID() == 27) {
                            attributeHandling = 2;
                        }
                        currentArg = new CMStorePathFunctionArgument(iToken, toker, attributeHandling);
                    }
                }
                catch (CMException ex) {
                    this.throwBadFunctionArgument(ex);
                }
                if (type != 1) {
                    CMStorePathPredicate argument = (CMStorePathPredicate)currentArg;
                    List<CMStorePredicateElement> preds = argument.PredicateExpressions;
                    if (preds.size() != 1) {
                        this.throwBadFunctionArgument(null);
                    }
                    if (type == 2) {
                        if (preds.get(0).getClass() == CMStorePredicateStringLiteral.class) {
                            CMStorePredicateStringLiteral literal = (CMStorePredicateStringLiteral)preds.get(0);
                            try {
                                CMXMLUtils.parseBooleanAttribute(literal.literal);
                            }
                            catch (CMException ex) {
                                this.throwBadFunctionArgument(ex);
                            }
                        } else if (preds.get(0).getClass() == CMStorePathPredicateFunction.class) {
                            CMStorePathPredicateFunction funcPred = (CMStorePathPredicateFunction)preds.get(0);
                            if (funcPred.function_.getReturnType() != 2) {
                                this.throwBadFunctionArgument(null);
                            }
                        } else if (preds.get(0).getClass() != CMStorePredicateAttribute.class) {
                            this.throwBadFunctionArgument(null);
                        }
                    } else if (type == 6) {
                        if (preds.get(0).getClass() != CMStorePredicateDouble.class) {
                            this.throwBadFunctionArgument(null);
                        }
                    } else if (type == 3) {
                        if (preds.get(0).getClass() != CMStorePredicateAttribute.class) {
                            this.throwBadFunctionArgument(null);
                        }
                    } else if (type == 5) {
                        if (preds.get(0).getClass() != CMStorePredicateStringLiteral.class) {
                            this.throwBadFunctionArgument(null);
                        }
                    } else if (type == 4 && preds.get(0).getClass() != CMStorePredicateInteger.class) {
                        this.throwBadFunctionArgument(null);
                    }
                }
                this.args.add(currentArg);
            }
            expectingArg = false;
        }
        if (expectingArg) {
            throw new CMStoreParseException("cmBadFuncEmptyArg");
        }
        int n = invocationArgCount = this.args != null ? this.args.size() : 0;
        if (invocationArgCount < definitionArgCount) {
            boolean isOptional;
            boolean bl = isOptional = 0 != (argTypes[invocationArgCount] & 0x40000000);
            if (!isOptional) {
                throw new CMStoreParseException("cmBadArgCount", new CMException.Parm("Name", this.function_.getName()));
            }
        }
        if (this.function_ == CMConstants.FUNC_STOREID_DEF) {
            CMStorePathPredicate property = (CMStorePathPredicate)this.args.get(0);
            CMStorePredicateStringLiteral arg = (CMStorePredicateStringLiteral)property.PredicateExpressions.get(0);
            if (arg.literal.length() < 1) {
                this.throwBadFunctionArgument(null);
            }
            if (arg.literal.charAt(0) == 'x') {
                this.function_ = CMConstants.FUNC_CAMID_DEF;
                if (arg.literal.length() == 1) {
                    arg.literal = ":";
                } else {
                    this.convertArgStoreIDToCAMID(arg);
                }
            }
        } else if (this.function_ == CMConstants.FUNC_HASPROPERTY_DEF) {
            CMProperty prop;
            CMStorePathPredicate property = (CMStorePathPredicate)this.args.get(0);
            CMStorePredicateStringLiteral literal = (CMStorePredicateStringLiteral)property.PredicateExpressions.get(0);
            List<CMProperty> props = CMPropertySet.CM.getProperties(literal.literal);
            if (props == null || props.size() == 0) {
                this.throwBadFunctionArgument(new CMException("cmBadProp", new CMException.Parm("Value", literal.literal)));
            }
            if ((prop = props.get(0)) == null) {
                this.throwBadFunctionArgument(new CMException("cmBadProp", new CMException.Parm("Value", literal.literal)));
            }
            if (!prop.isInheritable() && !prop.isInternal()) {
                this.throwBadFunctionArgument(new CMException("cmBadFuncArgInherit", new CMException.Parm("Name", prop.getName())));
            }
        } else if (this.function_ == CMConstants.FUNC_PERMISSION_DEF) {
            CMStorePathPredicate property = (CMStorePathPredicate)this.args.get(0);
            CMStorePredicateStringLiteral x = (CMStorePredicateStringLiteral)property.PredicateExpressions.get(0);
            toker.addPermission(x.literal);
        } else if (this.function_ == CMConstants.FUNC_CONTAINSREFERENCES_DEF || this.function_ == CMConstants.FUNC_MATCHESIDENTITY_DEF) {
            CMStorePathPredicate arg = (CMStorePathPredicate)this.args.get(0);
            CMStorePredicateAttribute attrArg = (CMStorePredicateAttribute)arg.PredicateExpressions.get(0);
            CMDbProperty property = (CMDbProperty)attrArg.property;
            if (property.getType() != CMPropertyTypes.BIBUS_BASECLASSARRAY || !property.isStoredAsArray() && property.getMaxOccurs() != 1) {
                this.throwBadFunctionArgument(null);
            }
            for (int argIdx = 1; argIdx < this.args.size(); ++argIdx) {
                Object argument = this.args.get(argIdx);
                ICMStorePath path = null;
                if (!(argument instanceof CMStorePath)) {
                    String literal = null;
                    if (argument instanceof CMStorePathPredicate) {
                        CMStorePredicateStringLiteral predicate = (CMStorePredicateStringLiteral)((CMStorePathPredicate)argument).PredicateExpressions.get(0);
                        literal = predicate.literal;
                    } else {
                        literal = argument.toString();
                    }
                    try {
                        path = new CMStoreXPath(literal);
                    }
                    catch (CMStoreParseException ex) {
                        this.throwBadFunctionArgument(ex);
                    }
                } else {
                    path = (ICMStorePath)argument;
                }
                if (path.getPredicateFunction(CMConstants.FUNC_CONTAINSREFERENCES_DEF) == null && path.getPredicateFunction(CMConstants.FUNC_MATCHESIDENTITY_DEF) == null) continue;
                this.throwBadFunctionArgument(null);
            }
            this.canResolveReference_ = property.isStoreIDBased();
        } else if (this.function_ == CMConstants.FUNC_OWNEDBY_DEF) {
            CMStoreXPath path;
            Object arg = this.args.get(0);
            if (!(arg instanceof CMStoreXPath)) {
                this.throwBadFunctionArgument(null);
            }
            if ((path = (CMStoreXPath)arg).isUnion()) {
                this.throwBadFunctionArgument(null);
            }
        } else if (this.function_ == CMConstants.FUNC_CAMID_DEF) {
            CMStorePathPredicate property = (CMStorePathPredicate)this.args.get(0);
            CMStorePredicateStringLiteral x = (CMStorePredicateStringLiteral)property.PredicateExpressions.get(0);
            if (x.literal.length() <= 0) {
                x.literal = ":";
            }
        } else if (this.function_ == CMConstants.FUNC_DEFAULTOUTPUT_DEF) {
            if (this.args == null || this.args.size() != 1 && this.args.size() != 3 && this.args.size() != 4) {
                throw new CMStoreParseException("cmBadArgCount", new CMException.Parm("Name", this.function_.getName()));
            }
            if (this.args.size() >= 3) {
                String supportedFormats;
                CMDbProperty propFormat;
                String formatHint = this.args.get(1).toString();
                if (formatHint != null && formatHint.length() > 2 && (propFormat = (CMDbProperty)CMProperty.FORMAT).getEnumID(formatHint = formatHint.substring(1, formatHint.length() - 1)) == -1) {
                    throw new CMStoreParseException("cmBadOutputFormat", new CMException.Parm("Format", formatHint));
                }
                String localeHint = this.args.get(2).toString();
                if (localeHint != null && localeHint.length() > 2) {
                    localeHint = localeHint.substring(1, localeHint.length() - 1);
                    try {
                        IConfiguration config = ConfigurationFactory.getConfig();
                        String locale = config.normalizeLocale(localeHint);
                        if (!config.validateContentLocale(locale)) {
                            locale = config.mapContentLocale(locale, false);
                        }
                    }
                    catch (CMConfigurationException ex) {
                        throw new CMStoreParseException("cmBadContentLocale", new CMException.Parm("Locale", localeHint));
                    }
                }
                if (this.args.size() == 4 && (supportedFormats = this.args.get(3).toString()) != null && supportedFormats.length() > 2) {
                    supportedFormats = supportedFormats.substring(1, supportedFormats.length() - 1);
                    CMStorePathUtils.parseSpaceDelimitedFormats(supportedFormats);
                }
            }
        } else if (this.function_ == CMConstants.FUNC_EXPANDREFERENCES_DEF) {
            CMStorePathPredicate predicate = (CMStorePathPredicate)this.args.get(1);
            CMStorePredicateAttribute predicateAttr = (CMStorePredicateAttribute)predicate.PredicateExpressions.get(0);
            CMProperty argProperty = predicateAttr.property;
            if (argProperty.getType() != CMPropertyTypes.BIBUS_BASECLASSARRAY) {
                this.throwBadFunctionArgument(new CMException("cmBadPropInExpr", new CMException.Parm("Prop", argProperty.getName())));
            }
        } else if (this.function_ == CMConstants.FUNC_PASSPORTID_DEF) {
            CMStorePathPredicate property = (CMStorePathPredicate)this.args.get(0);
            CMStorePredicateStringLiteral arg = (CMStorePredicateStringLiteral)property.PredicateExpressions.get(0);
            if (arg.literal.length() < 1) {
                this.throwBadFunctionArgument(null);
            }
            if (null == CMExecutionContext.get().getServiceId()) {
                throw new CMStoreParseException("cmRequestNotTrusted");
            }
            UserSessionCache usc = CMExecutionContext.getSessionCache();
            UserSessionCacheEntry usce = usc.lookupPassport(arg.literal);
            this.function_ = CMConstants.FUNC_CAMID_DEF;
            if (usce != null) {
                int sessionsTenantID = usce.getTenantId();
                if (CMExecutionContext.get().canSeeObjectsWithTenantId(sessionsTenantID)) {
                    arg.literal = usce.getCurrentUser();
                }
            }
        }
    }

    protected void convertArgStoreIDToCAMID(CMStorePredicateStringLiteral arg) {
        arg.setQuoteChar('\"');
        arg.literal = CMCAMIDHelper.storeID2CAMID(arg.literal);
    }

    @Override
    public boolean CanBeProcessedByCache() {
        if (this.function_ == CMConstants.FUNC_HASPROPERTY_DEF) {
            CMStorePredicateStringLiteral literal = (CMStorePredicateStringLiteral)((CMStorePathPredicate)this.args.get((int)0)).PredicateExpressions.get(0);
            List<CMProperty> props = CMPropertySet.CM.getProperties(literal.literal);
            if (props == null || props.size() == 0) {
                return false;
            }
            CMProperty prop = props.get(0);
            return prop == CMProperty.POLICIES;
        }
        return this.function_.supportedByCache();
    }

    @Override
    public String toCacheExpression(CMStorePredicateElement elmExpressionPartner) {
        CMStorePredicateStringLiteral literal;
        StringBuffer ret = new StringBuffer();
        if (this.function_ == CMConstants.FUNC_HASPROPERTY_DEF) {
            literal = (CMStorePredicateStringLiteral)((CMStorePathPredicate)this.args.get((int)0)).PredicateExpressions.get(0);
            List<CMProperty> props = CMPropertySet.CM.getProperties(literal.literal);
            if (props == null || props.size() == 0) {
                return ":1";
            }
            CMProperty prop = props.get(0);
            if (prop != CMProperty.POLICIES) {
                return ":1";
            }
        }
        ret.append("F");
        ret.append(this.function_.getID());
        ret.append("(");
        if (this.function_ == CMConstants.FUNC_PERMISSION_DEF || this.function_ == CMConstants.FUNC_HASPROPERTY_DEF || this.function_ == CMConstants.FUNC_DATASRCSIGNON_DEF || this.function_ == CMConstants.FUNC_PERSONALDATASRCSIGNON_DEF) {
            literal = (CMStorePredicateStringLiteral)((CMStorePathPredicate)this.args.get((int)0)).PredicateExpressions.get(0);
            ret.append(literal.toCacheExpression(null));
        } else if (this.args != null) {
            int[] argTypes = this.function_.getArgTypes();
            for (int index = 0; index < this.args.size(); ++index) {
                if (index > 0) {
                    ret.append(", ");
                }
                if (argTypes[index] == 1) {
                    ICMStorePath path = (ICMStorePath)this.args.get(index);
                    ret.append(path.getCacheQueryPath());
                    continue;
                }
                CMStorePredicateElement elem = (CMStorePredicateElement)this.args.get(index);
                ret.append(elem.toCacheExpression(elmExpressionPartner));
            }
        }
        ret.append(")");
        return ret.toString();
    }

    @Override
    public String getWhereClause(CMStorePredicateElement elmExpressionPartner, CMStorePathWhereClauseInfo wcInfo) throws CMException {
        String retStr = "";
        if (this.function_ == CMConstants.FUNC_CONTAINS_DEF || this.function_ == CMConstants.FUNC_STARTSWITH_DEF || this.function_ == CMConstants.FUNC_ENDSWITH_DEF) {
            retStr = this.sqlLikeStringClause(wcInfo);
        } else if (this.function_ == CMConstants.FUNC_NOT_DEF) {
            retStr = this.sqlNotClause(wcInfo);
        } else if (this.function_ == CMConstants.FUNC_HASPROPERTY_DEF) {
            retStr = this.sqlHasPropertyClause(wcInfo);
        } else if (this.function_ == CMConstants.FUNC_OWNEDBY_DEF) {
            retStr = this.sqlOwnedByClause(wcInfo);
        } else if (this.function_ == CMConstants.FUNC_CONTAINSREFERENCES_DEF) {
            retStr = this.sqlContainsReferencesClause(wcInfo);
        } else if (this.function_ == CMConstants.FUNC_MATCHESIDENTITY_DEF) {
            retStr = this.sqlMatchesIdentityClause(wcInfo);
        } else if (this.function_ == CMConstants.FUNC_ISNULL_DEF) {
            retStr = this.sqlIsNullClause(wcInfo);
        }
        return retStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws CMStoreParseException {
        if (this.function_ == CMConstants.FUNC_CONTAINSREFERENCES_DEF) {
            CMStorePathFunctionArgument arg0 = (CMStorePathFunctionArgument)this.args.get(0);
            CMStorePredicateAttribute property = (CMStorePredicateAttribute)arg0.PredicateExpressions.get(0);
            CMDbProperty prop = (CMDbProperty)property.property;
            if (prop.getName().equals("notificationList")) {
                boolean bAllowAccess = false;
                Object arg1 = this.args.get(1);
                CMStoreQueryResults results = null;
                if (CMExecutionContext.get().getCurrentUserIsAdministrator()) {
                    bAllowAccess = true;
                } else if (CMCAMIDHelper.isCurrentUser((ICMStorePath)arg1)) {
                    bAllowAccess = true;
                } else {
                    try {
                        CMStore store = CMExecutionContext.get().getStore();
                        results = store.executeQuery((CMStorePath)arg1, null, null, 0, 4, null);
                        if (results != null && results.next()) {
                            bAllowAccess = true;
                        }
                    }
                    catch (CMException e) {
                        CMIndications.logException(e);
                    }
                    finally {
                        if (results != null) {
                            results.release();
                        }
                    }
                }
                if (!bAllowAccess) {
                    throw new CMStoreParseException("cmSubscriptionNotSupported");
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.function_.getName());
        buffer.append("(");
        if (this.args != null) {
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.args.get(i).toString());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String sqlLikeStringClause(CMStorePathWhereClauseInfo wcInfo) throws CMException {
        StringBuffer strClause = new StringBuffer();
        CMStorePredicateAttribute property = (CMStorePredicateAttribute)((CMStorePathPredicate)this.args.get((int)0)).PredicateExpressions.get(0);
        CMStorePredicateStringLiteral literal = (CMStorePredicateStringLiteral)((CMStorePathPredicate)this.args.get((int)1)).PredicateExpressions.get(0);
        strClause.append(property.getWhereClause(this, wcInfo));
        strClause.append(" like ");
        strClause.append(literal.getWhereClause(this, wcInfo));
        String retStr = strClause.toString();
        return retStr;
    }

    private String sqlNotClause(CMStorePathWhereClauseInfo wcInfo) throws CMException {
        StringBuffer strClause = new StringBuffer();
        strClause.append(" not (");
        strClause.append(((CMStorePathPredicate)this.args.get(0)).getWhereClause(null, wcInfo));
        strClause.append(")");
        String retStr = strClause.toString();
        return retStr;
    }

    private String sqlHasPropertyClause(CMStorePathWhereClauseInfo wcInfo) throws CMException {
        CMDbProperty prop;
        StringBuffer strClause = new StringBuffer();
        CMStorePredicateStringLiteral literal = (CMStorePredicateStringLiteral)((CMStorePathPredicate)this.args.get((int)0)).PredicateExpressions.get(0);
        List<CMProperty> props = CMPropertySet.CM.getProperties(literal.literal);
        if (props == null || props.size() == 0) {
            this.throwBadFunctionArgument(new CMException("cmBadProp", new CMException.Parm("Value", literal.literal)));
        }
        if ((prop = (CMDbProperty)props.get(0)).isStoredAsArray()) {
            strClause.append(wcInfo.startExistsExpression(prop));
            strClause.append(wcInfo.endExistsExpression());
        } else if (wcInfo.requiresSpecialIsNullHandling(prop)) {
            strClause.append(wcInfo.getIsNullExpression(wcInfo.getColumn(prop, true, true), false));
        } else {
            strClause.append(wcInfo.getColumn(prop, true, true));
            strClause.append(" is not null ");
        }
        String retStr = strClause.toString();
        return retStr;
    }

    private String sqlIsNullClause(CMStorePathWhereClauseInfo wcInfo) throws CMException {
        CMDbProperty prop;
        StringBuffer strClause = new StringBuffer();
        CMStorePredicateStringLiteral literal = (CMStorePredicateStringLiteral)((CMStorePathPredicate)this.args.get((int)0)).PredicateExpressions.get(0);
        List<CMProperty> props = CMPropertySet.CM.getProperties(literal.literal);
        if (props == null || props.size() != 1) {
            this.throwBadFunctionArgument(new CMException("cmBadProp", new CMException.Parm("Value", literal.literal)));
        }
        if ((prop = (CMDbProperty)props.get(0)).isStoredAsArray()) {
            strClause.append(" not (");
            strClause.append(wcInfo.startExistsExpression(prop, false));
            strClause.append(wcInfo.endExistsExpression());
            strClause.append(")");
        } else if (wcInfo.requiresSpecialIsNullHandling(prop)) {
            strClause.append(wcInfo.getIsNullExpression(wcInfo.getColumn(prop, true, true), true));
        } else {
            strClause.append(wcInfo.getColumn(prop, true, true));
            strClause.append(" is null ");
        }
        String retStr = strClause.toString();
        return retStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sqlOwnedByClause(CMStorePathWhereClauseInfo wcInfo) throws CMException {
        StringBuffer strClause = new StringBuffer();
        CMStoreXPath path = (CMStoreXPath)this.args.get(0);
        CMExecutionContext ctx = CMExecutionContext.get();
        strClause.append(wcInfo.getColumn(CMProperty.OWNER, true));
        strClause.append(" = ");
        CMDbStoreObjectReference accountReference = null;
        CMStorePathStep step = path.stepAt(0);
        if (step.bCurrentUser_ && path.size() == 1) {
            accountReference = new CMDbStoreObjectReference(ctx.getCurrentUserAccountObjectID(), CMObjectClass.ACCOUNT, "~");
        } else {
            CMStoreQueryResults results;
            block7: {
                results = null;
                try {
                    results = CMExecutionContext.get().getStore().executeQuery(path, null, null, 0, 512, null);
                    if (!results.next()) break block7;
                    int objectID = results.getObjectID();
                    CMObjectClass objClass = results.getObjectClass();
                    if (objClass == CMObjectClass.ACCOUNT && !results.next()) {
                        accountReference = new CMDbStoreObjectReference(objectID, objClass, null);
                    }
                }
                catch (Throwable throwable) {
                    CMQueryUtils.safeQueryResultsRelease(results);
                    throw throwable;
                }
            }
            CMQueryUtils.safeQueryResultsRelease(results);
        }
        if (accountReference != null) {
            strClause.append(wcInfo.addLiteral(CMProperty.OWNER, accountReference));
            return strClause.toString();
        } else {
            strClause.append(wcInfo.addLiteral(null, new Integer(-1)));
        }
        return strClause.toString();
    }

    private String sqlContainsReferencesClause(CMStorePathWhereClauseInfo wcInfo) throws CMException {
        boolean argumentIsLargeNodeset;
        StringBuffer strClause = new StringBuffer();
        CMStorePredicateAttribute property = (CMStorePredicateAttribute)((CMStorePathPredicate)this.args.get((int)0)).PredicateExpressions.get(0);
        CMDbProperty prop = (CMDbProperty)property.property;
        this.resolveArguments();
        int listCount = 0;
        CMStoreQueryInfo queryInfo = null;
        boolean propUsesProxies = prop.requiresProxies();
        boolean bl = argumentIsLargeNodeset = prop.isStoredAsArray() && this.argsResolved != null && this.argsResolved.size() > wcInfo.getMaxRefObjectsInline();
        if (prop.isStoredAsArray()) {
            queryInfo = this.startExistExpressionForNodeset(strClause, argumentIsLargeNodeset, prop, this.argsResolved, wcInfo);
        }
        if (!argumentIsLargeNodeset) {
            strClause.append(wcInfo.getColumn(prop, true));
            strClause.append(" in (");
        }
        int argCount = this.argsResolved.size();
        for (int argIdx = 0; argIdx != argCount; ++argIdx) {
            CMObjectReference argument = this.argsResolved.get(argIdx);
            if (!argumentIsLargeNodeset) {
                if (listCount > 0) {
                    strClause.append(wcInfo.getLiteralsSeparator());
                }
                strClause.append(wcInfo.addLiteral(prop, argument));
                ++listCount;
                continue;
            }
            wcInfo.addLiteralNotInline(queryInfo, prop, argument);
        }
        if (listCount == 0) {
            if (propUsesProxies || prop.isStoreIDBased()) {
                if (!argumentIsLargeNodeset) {
                    strClause.append("-1");
                }
            } else {
                strClause.append("'\u0000'");
            }
        }
        if (!argumentIsLargeNodeset) {
            strClause.append(")");
        }
        if (prop.isStoredAsArray()) {
            strClause.append(wcInfo.endExistsExpression());
        }
        String retStr = strClause.toString();
        return retStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String sqlMatchesIdentityClause(CMStorePathWhereClauseInfo wcInfo) throws CMException {
        boolean argumentIsLargeNodeset;
        StringBuffer strClause = new StringBuffer();
        CMStorePredicateAttribute property = (CMStorePredicateAttribute)((CMStorePathPredicate)this.args.get((int)0)).PredicateExpressions.get(0);
        CMDbProperty prop = (CMDbProperty)property.property;
        CMExecutionContext ctx = CMExecutionContext.get();
        ArrayList<CMObjectReference> ids = ctx.getCurrentUserIdentity();
        boolean propUsesProxies = prop.requiresProxies();
        CMStoreQueryInfo queryInfo = null;
        boolean bl = argumentIsLargeNodeset = prop.isStoredAsArray() && ids != null && ids.size() > wcInfo.getMaxRefObjectsInline();
        if (prop.isStoredAsArray()) {
            queryInfo = this.startExistExpressionForNodeset(strClause, argumentIsLargeNodeset, prop, ids, wcInfo);
        }
        if (!argumentIsLargeNodeset) {
            strClause.append(wcInfo.getColumn(prop, true));
            strClause.append(" in (");
        }
        if (ids != null && ids.size() > 0) {
            int listCount = 0;
            int idCnt = ids.size();
            for (int idIdx = 0; idIdx != idCnt; ++idIdx) {
                CMDbStoreObjectReference ref = (CMDbStoreObjectReference)ids.get(idIdx);
                if (propUsesProxies) {
                    String camID = CMCAMIDHelper.CAMIDFromSearchPath(ref.getSecurityReference());
                    if (CMCAMIDHelper.CAMIDIsExternal(camID) || CMCAMIDHelper.isFixedCAMID(camID)) {
                        CMStoreQueryResults results;
                        block23: {
                            String refQueryStr = ref.getSecurityReference();
                            results = null;
                            try {
                                results = ctx.getStore().executeQuery(new CMStoreXPath(refQueryStr), null, null, 0, 33280, null);
                                if (!results.next()) break block23;
                                int objectID = results.getObjectID();
                                CMDbStoreObjectReference objectRef = new CMDbStoreObjectReference(objectID, null, null);
                                if (!argumentIsLargeNodeset) {
                                    if (listCount > 0) {
                                        strClause.append(wcInfo.getLiteralsSeparator());
                                    }
                                    strClause.append(wcInfo.addLiteral(prop, objectRef));
                                    ++listCount;
                                    break block23;
                                }
                                wcInfo.addLiteralNotInline(queryInfo, prop, objectRef);
                            }
                            catch (CMException cMException) {
                                CMQueryUtils.safeQueryResultsRelease(results);
                                continue;
                                catch (Throwable throwable) {
                                    CMQueryUtils.safeQueryResultsRelease(results);
                                    throw throwable;
                                }
                            }
                        }
                        CMQueryUtils.safeQueryResultsRelease(results);
                        continue;
                    }
                    try {
                        CMObjectReference objectRef = CMCAMIDHelper.normalizeSecurityReference(ctx.getStore(), ref.getSecurityReference(), true, false, true, true);
                        if (!argumentIsLargeNodeset) {
                            if (listCount > 0) {
                                strClause.append(wcInfo.getLiteralsSeparator());
                            }
                            strClause.append(wcInfo.addLiteral(prop, objectRef));
                            ++listCount;
                            continue;
                        }
                        wcInfo.addLiteralNotInline(queryInfo, prop, objectRef);
                    }
                    catch (CMException cMException) {}
                    continue;
                }
                if (listCount > 0) {
                    strClause.append(wcInfo.getLiteralsSeparator());
                }
                strClause.append(wcInfo.addLiteral(prop, ref.getSecurityReference()));
                ++listCount;
            }
        } else if (propUsesProxies) {
            if (!argumentIsLargeNodeset) {
                strClause.append("-1");
            }
        } else {
            strClause.append("'\u0000'");
        }
        if (!argumentIsLargeNodeset) {
            strClause.append(")");
        }
        if (prop.isStoredAsArray()) {
            strClause.append(wcInfo.endExistsExpression());
        }
        String retStr = strClause.toString();
        return retStr;
    }

    private CMStoreQueryInfo startExistExpressionForNodeset(StringBuffer strClause, boolean argumentNotInline, CMProperty prop, List<CMObjectReference> nodeset, CMStorePathWhereClauseInfo wcInfo) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        CMStoreQueryInfo queryInfo = null;
        if (!argumentNotInline) {
            strClause.append(wcInfo.startExistsExpression(prop));
            strClause.append(" and ");
        } else {
            strClause.append(wcInfo.startExistsExpressionFromClause(prop));
            String columnName = wcInfo.getColumn(prop, true);
            queryInfo = wcInfo.constructWhereCMIDsNotInline(ctx.getStore(), nodeset.size(), columnName);
            strClause.append(queryInfo.getFromClause());
            strClause.append(wcInfo.startExistsExpressionWhereClause(prop));
            strClause.append(" and ");
            strClause.append(queryInfo.getWhereClause());
            wcInfo.addLiteralValue(new Integer(queryInfo.getQueryID()));
        }
        return queryInfo;
    }

    public String getStringArgument(int idx) {
        if (this.args == null || this.args.size() <= idx) {
            return null;
        }
        CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)this.args.get(idx);
        CMStorePredicateStringLiteral sliteral = (CMStorePredicateStringLiteral)arg.PredicateExpressions.get(0);
        return sliteral.literal;
    }

    public CMStorePath getPathArgument(int idx) {
        if (this.args == null || this.args.size() <= idx) {
            return null;
        }
        Object arg = this.args.get(idx);
        if (arg instanceof CMStorePath) {
            return (CMStorePath)arg;
        }
        return null;
    }

    private void throwBadFunctionArgument(Exception ex) throws CMStoreParseException {
        throw new CMStoreParseException(ex, "cmBadFuncArg", new CMException.Parm("Name", this.function_.getName()));
    }

    public boolean canResolveReference() {
        return this.canResolveReference_;
    }

    public boolean argumentsResolved() {
        return this.argumentsResolved_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveArguments() throws CMException {
        if (this.argumentsResolved_) {
            return;
        }
        this.argumentsResolved_ = true;
        if (this.function_ == CMConstants.FUNC_CONTAINSREFERENCES_DEF) {
            CMStorePredicateAttribute property = (CMStorePredicateAttribute)((CMStorePathPredicate)this.args.get((int)0)).PredicateExpressions.get(0);
            CMDbProperty prop = (CMDbProperty)property.property;
            CMStorePath path = null;
            int argCount = this.args.size();
            for (int argIdx = 1; argIdx != argCount; ++argIdx) {
                Object argument = this.args.get(argIdx);
                if (argument instanceof CMStorePath) {
                    path = (CMStorePath)argument;
                }
                if (!prop.isStoreIDBased()) continue;
                CMStoreQueryResults resolveArgResults = null;
                try {
                    resolveArgResults = CMExecutionContext.get().getStore().executeQuery(path, null, null, 0, 512, null);
                    while (resolveArgResults.next()) {
                        int objectID = resolveArgResults.getObjectID();
                        CMObjectClass objClass = resolveArgResults.getObjectClass();
                        CMDbStoreObjectReference objectRef = new CMDbStoreObjectReference(objectID, objClass, null);
                        this.argsResolved.add(objectRef);
                    }
                }
                catch (Throwable throwable) {
                    CMQueryUtils.safeQueryResultsRelease(resolveArgResults);
                    throw throwable;
                }
                CMQueryUtils.safeQueryResultsRelease(resolveArgResults);
            }
        }
    }
}

