/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store.path;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.path.CMPathStepTokenizer;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathWhereClauseInfo;
import com.cognos.cm.store.path.CMStorePredicateAttribute;
import com.cognos.cm.store.path.CMStorePredicateBool;
import com.cognos.cm.store.path.CMStorePredicateComparison;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.util.CMStringUtils;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CMStorePathStep {
    int axis = 99;
    public String NodeTest = "";
    public List<CMStorePredicateElement> Predicates;
    boolean parsingPredicates = false;
    boolean bWildCard_ = false;
    protected List<String> filterPermissions_;
    protected boolean requiresReadAccess_;
    public boolean bCurrentUser_;
    public boolean bCurrentSession_;
    private boolean bBurstStep_ = false;
    private int externalClassCount = -1;
    private int internalClassCount = -1;

    protected void initTokenizer(StreamTokenizer toker) {
        toker.resetSyntax();
        toker.whitespaceChars(0, 32);
        toker.wordChars(127, 65535);
        toker.wordChars(33, 57);
        toker.wordChars(59, 90);
        toker.wordChars(92, 92);
        toker.wordChars(94, 126);
        toker.ordinaryChar(47);
        if (!this.parsingPredicates) {
            toker.wordChars(32, 32);
        }
        toker.slashSlashComments(false);
        toker.slashStarComments(false);
        toker.eolIsSignificant(false);
    }

    public CMStorePathStep(int axis) {
        this.axis = axis;
    }

    public CMStorePathStep(int axis, String nodetest) {
        this.axis = axis;
        this.NodeTest = nodetest;
    }

    public CMStorePathStep(String stepDefinition) throws IOException, CMStoreParseException {
        StringReader sr = new StringReader(stepDefinition);
        CMPathStepTokenizer toker = new CMPathStepTokenizer(sr);
        this.Parse(toker);
    }

    public void Parse(CMPathStepTokenizer toker) throws IOException, CMStoreParseException {
        int iToken;
        this.Predicates = new ArrayList<CMStorePredicateElement>();
        String previousWord = "";
        this.initTokenizer(toker);
        while ((iToken = toker.nextToken()) != -1) {
            if (iToken == -3) {
                if (this.parsingPredicates) {
                    if (toker.sval.equalsIgnoreCase("and")) {
                        this.Predicates.add(new CMStorePredicateBool("and"));
                        continue;
                    }
                    if (toker.sval.equalsIgnoreCase("or")) {
                        this.Predicates.add(new CMStorePredicateBool("or"));
                        continue;
                    }
                    throw new CMStoreParseException("cmBadNodeTestDef");
                }
                previousWord = previousWord + toker.sval;
                continue;
            }
            if (iToken == 58) {
                iToken = toker.nextToken();
                if (iToken == 58) {
                    if (this.axis != 99) {
                        throw new CMStoreParseException("cmPathAxisOnce");
                    }
                    if (previousWord.equalsIgnoreCase("child")) {
                        this.axis = 1;
                    } else if (previousWord.equalsIgnoreCase("descendant")) {
                        this.axis = 7;
                    } else if (previousWord.equalsIgnoreCase("descendant-or-self")) {
                        this.axis = 8;
                    } else if (previousWord.equalsIgnoreCase("directChild")) {
                        this.axis = 1;
                    } else if (previousWord.equalsIgnoreCase("directDescendant")) {
                        this.axis = 7;
                    } else if (previousWord.equalsIgnoreCase("parent")) {
                        this.axis = 11;
                    } else if (previousWord.equalsIgnoreCase("traverse")) {
                        this.axis = 13;
                    } else if (previousWord.length() <= 0) {
                        this.axis = 1;
                    } else {
                        throw new CMStoreParseException("cmBadAxisDefAt", new CMException.Parm("Value", previousWord));
                    }
                    previousWord = "";
                    continue;
                }
                previousWord = previousWord + ':';
                toker.pushBack();
                continue;
            }
            if (iToken == 91) {
                CMStorePredicateElement obj;
                if (this.NodeTest.length() <= 0) {
                    this.SetNodeTest(previousWord);
                }
                previousWord = "";
                if (this.Predicates.size() > 0 && (obj = this.Predicates.get(this.Predicates.size() - 1)).getClass().getName().equals("com.cognos.cm.store.CMStorePathPredicate")) {
                    this.Predicates.add(new CMStorePredicateBool("and"));
                }
                this.parsingPredicates = true;
                this.Predicates.add(new CMStorePathPredicate(toker, 93));
                this.initTokenizer(toker);
                continue;
            }
            if (iToken == 47 || iToken == 124) {
                toker.pushBack();
                if (iToken != 124) break;
                previousWord = previousWord.trim();
                break;
            }
            if (iToken == 39) {
                throw new CMStoreParseException("cmBadCharInNodeTest", new CMException.Parm("Value", Integer.toString(iToken)));
            }
            previousWord = previousWord + (char)iToken;
        }
        if (this.NodeTest.length() <= 0) {
            this.SetNodeTest(previousWord);
        }
        if (this.NodeTest.length() <= 0 && this.axis != 11) {
            throw new CMStoreParseException("cmEmptyNodeTest");
        }
        this.filterPermissions_ = toker.getFilterPermissions();
        this.requiresReadAccess_ = toker.requiresReadAccess();
    }

    public boolean hasPredicates() {
        return this.Predicates != null && this.Predicates.size() > 0;
    }

    public boolean TestContainsWildCards() {
        return this.NodeTest.indexOf(42) >= 0;
    }

    protected void SetNodeTest(String name) throws CMStoreParseException {
        if (name.equals("*")) {
            this.bWildCard_ = true;
            this.NodeTest = new String(name);
        } else if (name.equals("..")) {
            this.bWildCard_ = true;
            this.NodeTest = new String("*");
            if (this.axis != 99 && this.axis != 11) {
                throw new CMStoreParseException("cmPathAxisOnce");
            }
            this.axis = 11;
        } else {
            this.NodeTest = new String(name);
        }
    }

    public void setAxis(int axis) {
        this.axis = axis;
    }

    public int getAxis() {
        return this.axis;
    }

    public boolean isDescendant() {
        return this.axis == 7 || this.axis == 8;
    }

    public String getName() {
        return this.NodeTest;
    }

    public String toStringEncoded() {
        return this.NodeTest;
    }

    public boolean requiresReadAccess() {
        return this.requiresReadAccess_;
    }

    public List<String> getFilterPermissions() {
        return this.filterPermissions_;
    }

    public boolean isNodeSetFunction() {
        if (this.Predicates != null && this.Predicates.size() > 0 && this.Predicates.get(0).getClass() == CMStorePathPredicateFunction.class) {
            CMStorePathPredicateFunction predFunction = (CMStorePathPredicateFunction)this.Predicates.get(0);
            return predFunction.function_.getReturnType() == 1;
        }
        return false;
    }

    public CMConstants.FunctionDef getNodeSetFunction() {
        if (this.Predicates != null && this.Predicates.size() > 0 && this.Predicates.get(0).getClass() == CMStorePathPredicateFunction.class) {
            CMStorePathPredicateFunction predFunction = (CMStorePathPredicateFunction)this.Predicates.get(0);
            if (predFunction.function_.getReturnType() == 1) {
                return predFunction.function_;
            }
        }
        return null;
    }

    public CMStorePathPredicateFunction getPredicateFunction(CMConstants.FunctionDef function) {
        if (this.Predicates != null && this.Predicates.size() > 0) {
            for (int index = 0; index < this.Predicates.size(); ++index) {
                CMStorePathPredicate pathPredicate = (CMStorePathPredicate)this.Predicates.get(index);
                if (pathPredicate.PredicateExpressions == null) continue;
                for (int j = 0; j < pathPredicate.PredicateExpressions.size(); ++j) {
                    CMStorePredicateElement predicateExpression = pathPredicate.PredicateExpressions.get(j);
                    if (!(predicateExpression instanceof CMStorePathPredicateFunction)) continue;
                    CMStorePathPredicateFunction functionExpression = (CMStorePathPredicateFunction)predicateExpression;
                    if (functionExpression.function_ != function) continue;
                    return functionExpression;
                }
            }
        }
        return null;
    }

    public boolean hasSecurityIDPredicate(List<String> ids) {
        boolean bRet = true;
        if (this.Predicates != null && this.Predicates.size() > 0) {
            for (int index = 0; index < this.Predicates.size(); ++index) {
                CMStorePathPredicate pred = (CMStorePathPredicate)this.Predicates.get(index);
                if (pred.hasSecurityIDPredicate(ids)) continue;
                return false;
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    public boolean resolvableInCache() {
        if (this.Predicates != null) {
            int predCount = this.Predicates.size();
            for (int predIdx = 0; predIdx != predCount; ++predIdx) {
                CMStorePredicateElement el = this.Predicates.get(predIdx);
                if (el.CanBeProcessedByCache()) continue;
                return false;
            }
        }
        return true;
    }

    public String getCacheQuery() {
        StringBuffer stepQuery = new StringBuffer(String.valueOf(this.axis));
        stepQuery.append(':');
        if (this.bWildCard_) {
            stepQuery.append('*');
        } else {
            stepQuery.append(String.valueOf(CMStringUtils.getUTF8Length(this.NodeTest)));
        }
        stepQuery.append(':');
        stepQuery.append(this.NodeTest);
        if (this.Predicates != null) {
            int preds = this.Predicates.size();
            boolean bCanProcess = false;
            for (int i = 0; i < preds; ++i) {
                CMStorePredicateElement pred = this.Predicates.get(i);
                if (!pred.CanBeProcessedByCache()) continue;
                bCanProcess = true;
                break;
            }
            if (bCanProcess) {
                boolean bNotFirst = false;
                stepQuery.append('[');
                for (int i = 0; i < preds; ++i) {
                    String predExpr;
                    CMStorePredicateElement pred = this.Predicates.get(i);
                    if (!pred.CanBeProcessedByCache() || (predExpr = pred.toCacheExpression(null)) == null || predExpr.length() <= 0) continue;
                    if (bNotFirst) {
                        stepQuery.append(" and ");
                    } else {
                        bNotFirst = true;
                    }
                    stepQuery.append(predExpr);
                }
                stepQuery.append(']');
            }
        }
        return stepQuery.toString();
    }

    public String getWhereClause(CMStorePathWhereClauseInfo wcInfo) throws CMException {
        int predicateCount;
        int n = predicateCount = this.Predicates != null ? this.Predicates.size() : 0;
        if (!this.bWildCard_ || predicateCount > 0) {
            StringBuffer strClause = new StringBuffer();
            boolean bAddAnd = false;
            String andExpression = " and ";
            for (int index = 0; index < predicateCount; ++index) {
                CMStorePredicateElement elem = this.Predicates.get(index);
                if (elem.CanBeProcessedByCache() && wcInfo.suppressCachePredicates()) continue;
                if (elem.getClass() == CMStorePredicateBool.class) {
                    andExpression = elem.getWhereClause(null, wcInfo);
                    bAddAnd = true;
                    continue;
                }
                String expr = elem.getWhereClause(null, wcInfo);
                if (expr == null || expr.length() <= 0) continue;
                if (bAddAnd) {
                    strClause.append(andExpression);
                    andExpression = " and ";
                }
                strClause.append(expr);
                bAddAnd = true;
            }
            return strClause.toString();
        }
        return "";
    }

    public String toAccmanSearchFilter() {
        StringBuffer accmanQuery = new StringBuffer();
        int preds = this.Predicates.size();
        for (int i = 0; i < preds; ++i) {
            CMStorePredicateElement pred = this.Predicates.get(i);
            accmanQuery.append(pred.toAccmanSearchFilter(null));
        }
        String ret = accmanQuery.toString();
        if (ret.length() > 0) {
            return ret;
        }
        return null;
    }

    public String toAccmanSearchFilter(String propList) {
        StringBuffer accmanQuery = new StringBuffer();
        int preds = this.Predicates.size();
        for (int i = 0; i < preds; ++i) {
            CMStorePredicateElement pred = this.Predicates.get(i);
            accmanQuery.append(pred.toAccmanSearchFilter(null, propList));
        }
        String ret = accmanQuery.toString();
        if (ret.length() > 0) {
            return ret;
        }
        return null;
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        int startPredicate = 0;
        if (this.Predicates != null && this.Predicates.size() > 0) {
            CMStorePredicateElement predEl = this.Predicates.get(0);
            if (predEl.getClass() == CMStorePathPredicateFunction.class) {
                CMStorePathPredicateFunction func = (CMStorePathPredicateFunction)predEl;
                if (func.function_.getReturnType() == 1) {
                    startPredicate = 1;
                    results.append(predEl.toString());
                }
            } else {
                CMStorePathPredicate pred = (CMStorePathPredicate)predEl;
                if (pred.PredicateExpressions.size() == 3) {
                    CMStorePredicateElement lhs = pred.PredicateExpressions.get(0);
                    CMStorePredicateElement op = pred.PredicateExpressions.get(1);
                    CMStorePredicateElement rhs = pred.PredicateExpressions.get(2);
                    if (op.getClass() == CMStorePredicateComparison.class && ((CMStorePredicateComparison)op).comparison == 2) {
                        CMStorePredicateAttribute attr = null;
                        CMStorePredicateStringLiteral lit = null;
                        if (rhs.getClass() == CMStorePredicateAttribute.class) {
                            attr = (CMStorePredicateAttribute)rhs;
                            if (lhs.getClass() == CMStorePredicateStringLiteral.class) {
                                lit = (CMStorePredicateStringLiteral)lhs;
                            }
                        } else if (rhs.getClass() == CMStorePredicateStringLiteral.class) {
                            lit = (CMStorePredicateStringLiteral)rhs;
                            if (lhs.getClass() == CMStorePredicateAttribute.class) {
                                attr = (CMStorePredicateAttribute)lhs;
                            }
                        }
                        if (attr != null && lit != null && attr.property == CMProperty.OBJECTCLASS) {
                            CMStorePathStep.appendAxis(results, this.axis);
                            results.append(lit.literal);
                            ++startPredicate;
                        }
                    }
                }
            }
        }
        if (startPredicate == 0) {
            CMStorePathStep.appendAxis(results, this.axis);
            results.append(this.NodeTest);
        }
        if (this.Predicates != null) {
            for (int index = startPredicate; index < this.Predicates.size(); ++index) {
                results.append("[");
                results.append(this.Predicates.get(index).toString());
                results.append("]");
            }
        }
        return results.toString();
    }

    public String getCAMQuery(int iStepNum) {
        StringBuffer results = new StringBuffer();
        int startPredicate = 0;
        if (this.Predicates != null && this.Predicates.size() > 0) {
            CMStorePredicateElement predEl = this.Predicates.get(0);
            if (predEl.getClass() == CMStorePathPredicateFunction.class) {
                CMStorePathPredicateFunction func = (CMStorePathPredicateFunction)predEl;
                if (func.function_.getReturnType() == 1) {
                    startPredicate = 1;
                    results.append(predEl.toString());
                }
            } else {
                CMStorePathPredicate pred = (CMStorePathPredicate)predEl;
                if (pred.PredicateExpressions.size() == 3 && iStepNum == 0) {
                    CMStorePredicateElement lhs = pred.PredicateExpressions.get(0);
                    CMStorePredicateElement op = pred.PredicateExpressions.get(1);
                    CMStorePredicateElement rhs = pred.PredicateExpressions.get(2);
                    if (op.getClass() == CMStorePredicateComparison.class && ((CMStorePredicateComparison)op).comparison == 2) {
                        CMStorePredicateAttribute attr = null;
                        CMStorePredicateStringLiteral lit = null;
                        if (rhs.getClass() == CMStorePredicateAttribute.class) {
                            attr = (CMStorePredicateAttribute)rhs;
                            if (lhs.getClass() == CMStorePredicateStringLiteral.class) {
                                lit = (CMStorePredicateStringLiteral)lhs;
                            }
                        } else if (rhs.getClass() == CMStorePredicateStringLiteral.class) {
                            lit = (CMStorePredicateStringLiteral)rhs;
                            if (lhs.getClass() == CMStorePredicateAttribute.class) {
                                attr = (CMStorePredicateAttribute)lhs;
                            }
                        }
                        if (attr != null && lit != null && attr.property == CMProperty.OBJECTCLASS) {
                            CMStorePathStep.appendAxis(results, this.axis);
                            results.append(lit.literal);
                            ++startPredicate;
                        }
                    }
                }
            }
        }
        if (startPredicate == 0) {
            CMStorePathStep.appendAxis(results, this.axis);
            results.append(this.NodeTest);
        }
        if (this.Predicates != null) {
            while (startPredicate < this.Predicates.size()) {
                if (!((CMStorePathPredicate)this.Predicates.get(startPredicate)).hasPermissionFunction()) {
                    results.append("[");
                    results.append(this.Predicates.get(startPredicate).toString());
                    results.append("]");
                }
                ++startPredicate;
            }
        }
        return results.toString();
    }

    public String getCAMIDLiteral() {
        if (this.getNodeSetFunction() != CMConstants.FUNC_CAMID_DEF) {
            return null;
        }
        CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)this.Predicates.get(0);
        if (parsedFunc.args.size() > 0) {
            CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)parsedFunc.args.get(0);
            CMStorePredicateStringLiteral camidLiteral = (CMStorePredicateStringLiteral)arg.PredicateExpressions.get(0);
            return camidLiteral.literal;
        }
        return null;
    }

    public void setClass(CMObjectClass objClass) {
    }

    private void analyzeClassesInPathPredicates() {
        this.externalClassCount = 0;
        this.internalClassCount = 0;
        CMStore store = null;
        if (this.Predicates != null) {
            Iterator<CMStorePredicateElement> iter = this.Predicates.iterator();
            CMStorePredicateElement lhs = null;
            while (iter.hasNext()) {
                CMStorePredicateElement op1 = iter.next();
                if (op1.getClass() == CMStorePredicateBool.class) continue;
                CMStorePathPredicate pred = (CMStorePathPredicate)op1;
                if (pred.PredicateExpressions == null) {
                    return;
                }
                Iterator<CMStorePredicateElement> innerIter = pred.PredicateExpressions.iterator();
                while (innerIter.hasNext()) {
                    CMStorePredicateElement op = innerIter.next();
                    if (op.getClass() == CMStorePredicateComparison.class && lhs != null) {
                        if (!innerIter.hasNext()) continue;
                        CMStorePredicateElement rhs = innerIter.next();
                        CMStorePredicateAttribute attr = null;
                        CMStorePredicateStringLiteral lit = null;
                        if (rhs.getClass() == CMStorePredicateAttribute.class) {
                            attr = (CMStorePredicateAttribute)rhs;
                            if (lhs.getClass() == CMStorePredicateStringLiteral.class) {
                                lit = (CMStorePredicateStringLiteral)lhs;
                            }
                        } else if (rhs.getClass() == CMStorePredicateStringLiteral.class) {
                            lit = (CMStorePredicateStringLiteral)rhs;
                            if (lhs.getClass() == CMStorePredicateAttribute.class) {
                                attr = (CMStorePredicateAttribute)lhs;
                            }
                        }
                        if (attr == null || lit == null || attr.property != CMProperty.OBJECTCLASS) continue;
                        try {
                            CMObjectClass cls;
                            if (store == null) {
                                store = CMExecutionContext.get().getStore();
                            }
                            if ((cls = store.getObjectClasses().getClassByName(lit.literal)).isExternal()) {
                                ++this.externalClassCount;
                                continue;
                            }
                            ++this.internalClassCount;
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    lhs = op;
                }
            }
        }
    }

    public boolean searchingByGloballyUniqueString() {
        boolean bResult = false;
        String andExpression = "and";
        if (this.Predicates != null) {
            Iterator<CMStorePredicateElement> iter = this.Predicates.iterator();
            CMStorePredicateElement lhs = null;
            while (iter.hasNext()) {
                CMStorePredicateElement op1 = iter.next();
                if (op1.getClass() == CMStorePredicateBool.class) {
                    CMStorePredicateBool opBool = (CMStorePredicateBool)op1;
                    if (andExpression.compareTo(opBool.toCacheExpression(null)) == 0) continue;
                    return false;
                }
                CMStorePathPredicate pred = (CMStorePathPredicate)op1;
                if (pred.PredicateExpressions == null) {
                    return false;
                }
                Iterator<CMStorePredicateElement> innerIter = pred.PredicateExpressions.iterator();
                while (innerIter.hasNext()) {
                    CMStorePredicateElement op = innerIter.next();
                    if (op.getClass() == CMStorePredicateComparison.class && lhs != null) {
                        if (!innerIter.hasNext()) continue;
                        CMStorePredicateElement rhs = innerIter.next();
                        CMStorePredicateAttribute attr = null;
                        CMStorePredicateStringLiteral lit = null;
                        if (rhs.getClass() == CMStorePredicateAttribute.class) {
                            attr = (CMStorePredicateAttribute)rhs;
                            if (lhs.getClass() == CMStorePredicateStringLiteral.class) {
                                lit = (CMStorePredicateStringLiteral)lhs;
                            }
                        } else if (rhs.getClass() == CMStorePredicateStringLiteral.class) {
                            lit = (CMStorePredicateStringLiteral)rhs;
                            if (lhs.getClass() == CMStorePredicateAttribute.class) {
                                attr = (CMStorePredicateAttribute)lhs;
                            }
                        }
                        if (attr == null || lit == null || attr.property != CMProperty.EVENTID && attr.property != CMProperty.TASKID && attr.property != CMProperty.ID && attr.property != CMProperty.DOCUMENTID && attr.property != CMProperty.DISPATCHERPATH) continue;
                        if (((CMStorePredicateComparison)op).comparison == 2) {
                            bResult = true;
                            continue;
                        }
                        return false;
                    }
                    if (op.getClass() == CMStorePredicateBool.class) {
                        CMStorePredicateBool opBool = (CMStorePredicateBool)op;
                        if (andExpression.compareTo(opBool.toCacheExpression(null)) == 0) continue;
                        return false;
                    }
                    lhs = op;
                }
            }
        }
        return bResult;
    }

    public ArrayList<CMStorePathPredicateFunction> getNodeSetParamFunctions() {
        ArrayList<CMStorePathPredicateFunction> functions = new ArrayList<CMStorePathPredicateFunction>();
        if (this.Predicates != null && this.Predicates.size() > 0) {
            block0: for (int i = 0; i < this.Predicates.size(); ++i) {
                if (this.Predicates.get(i).getClass() != CMStorePathPredicateFunction.class) continue;
                CMStorePathPredicateFunction predFunction = (CMStorePathPredicateFunction)this.Predicates.get(i);
                int[] argTypes = predFunction.function_.getArgTypes();
                for (int j = 0; j < argTypes.length; ++j) {
                    if (argTypes[j] != 1) continue;
                    functions.add(predFunction);
                    continue block0;
                }
            }
        }
        return functions;
    }

    private static void appendAxis(StringBuffer buf, int axis) {
        buf.append("/");
        switch (axis) {
            case 7: {
                buf.append("descendant");
                buf.append("::");
                break;
            }
            case 8: {
                buf.append('/');
                break;
            }
            case 13: {
                buf.append("traverse");
                buf.append("::");
            }
        }
    }

    public boolean isBurstStep() {
        return this.bBurstStep_;
    }

    public void setBurstStep(boolean b) {
        this.bBurstStep_ = b;
    }

    public int numPredicates() {
        return this.Predicates == null ? 0 : this.Predicates.size();
    }

    public void appendPredicate(CMStorePathPredicate pred) {
        if (this.Predicates == null) {
            this.Predicates = new ArrayList<CMStorePredicateElement>();
        }
        this.Predicates.add(pred);
    }

    public void removePredicate(int idx) {
        this.Predicates.remove(idx);
    }

    public boolean hasAcquirablePropertyPredicate() {
        if (this.Predicates != null && this.Predicates.size() > 0) {
            for (int index = 0; index < this.Predicates.size(); ++index) {
                CMStorePathPredicate pred = (CMStorePathPredicate)this.Predicates.get(index);
                if (!pred.hasAcquirablePropertyPredicate()) continue;
                return true;
            }
        }
        return false;
    }

    public void appendPredicate(String expression) {
        StringReader reader = new StringReader(expression);
        CMPathStepTokenizer toker = new CMPathStepTokenizer(reader);
        CMStorePathPredicate predicate = null;
        try {
            predicate = new CMStorePathPredicate(toker, -1);
        }
        catch (Exception ex) {
            throw new RuntimeException("Encountered problem parsing the dataSourceName predicate", ex);
        }
        this.Predicates.add(predicate);
    }

    public boolean hasPredicatesReferencingExternalClass() {
        if (this.externalClassCount == -1) {
            this.analyzeClassesInPathPredicates();
        }
        return this.externalClassCount > 0;
    }

    public boolean hasPredicatesReferencingInternalClass() {
        if (this.internalClassCount == -1) {
            this.analyzeClassesInPathPredicates();
        }
        return this.internalClassCount > 0;
    }
}

