/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store.path;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.path.CMPathStepTokenizer;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathWhereClauseInfo;
import com.cognos.cm.store.path.CMStorePredicateAttribute;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMXMLUtils;
import java.io.IOException;

public class CMStorePredicateStringLiteral
implements CMStorePredicateElement {
    public String literal;
    private char quoteChar;
    private final char escapeChar = (char)92;
    private final String escapeSuffix_sqlserver = " {escape '\\'}";
    private final String escapeSuffix_sybase = " escape '\\'";
    private final String specialChars = "\\[]%";
    private boolean bEscaped_ = false;

    public CMStorePredicateStringLiteral(String value) {
        this.quoteChar = (char)39;
        this.literal = value;
    }

    private void initTokenizer(CMPathStepTokenizer toker) {
        toker.resetSyntax();
    }

    public CMStorePredicateStringLiteral(CMPathStepTokenizer toker, int endToken) throws IOException, CMStoreParseException {
        int iToken;
        this.initTokenizer(toker);
        this.literal = null;
        StringBuffer sb = new StringBuffer(50);
        this.quoteChar = (char)endToken;
        while ((iToken = toker.nextToken()) != -1 && iToken != 10) {
            if (iToken == endToken) {
                int iNextToken = toker.nextToken();
                if (iNextToken == endToken) {
                    sb.append((char)endToken);
                    continue;
                }
                toker.pushBack();
                break;
            }
            if (iToken == -3) {
                sb.append(toker.sval);
                continue;
            }
            sb.append((char)iToken);
        }
        this.literal = sb.toString();
    }

    @Override
    public String debugDisplay() {
        return this.toCacheExpression(null);
    }

    @Override
    public boolean CanBeProcessedByCache() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String toCacheExpression(CMStorePredicateElement elmExpressionPartner) {
        String strRet = null;
        try {
            if (elmExpressionPartner != null && elmExpressionPartner.getClass() == CMStorePredicateAttribute.class) {
                CMStorePredicateAttribute elmAttribute = (CMStorePredicateAttribute)elmExpressionPartner;
                CMProperty partnerProp = elmAttribute.property;
                if (partnerProp == CMProperty.OBJECTCLASS) {
                    CMStore store = CMExecutionContext.get().getStore();
                    CMObjectClass cls = store.getObjectClasses().getClassByName(this.literal);
                    if (cls == null) return null;
                    strRet = cls.getCacheLiteral();
                } else if (partnerProp == CMProperty.DEPLOYEDOBJECTUSAGE) {
                    short enumId = ((CMDbProperty)partnerProp).getEnumID(this.literal);
                    strRet = ":" + Integer.toString(enumId) + ":";
                } else {
                    if (partnerProp.getType() == CMPropertyTypes.XML_BOOLEAN) {
                        if (!CMXMLUtils.parseBooleanAttribute(this.literal)) return ":0:";
                        return ":1:";
                    }
                    if (partnerProp == CMProperty.TENANTID) {
                        strRet = ":" + Integer.toString(this.toTenantId(this.literal)) + ":";
                    }
                }
            }
            if (strRet != null) return strRet;
            StringBuffer literalBuf = new StringBuffer(20);
            literalBuf.append("L");
            literalBuf.append(String.valueOf(this.literal.length()));
            literalBuf.append(':');
            literalBuf.append(this.literal);
            return literalBuf.toString();
        }
        catch (CMException e) {
            return "";
        }
    }

    private int toTenantId(String literal) {
        try {
            CMStore store = CMExecutionContext.get().getStore();
            TenantRegistry tenantRegistry = store.getTenantRegistry();
            return tenantRegistry.getTenantIdIntFromString(literal, false);
        }
        catch (CMException e) {
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public String getWhereClause(CMStorePredicateElement elmExpressionPartner, CMStorePathWhereClauseInfo wcInfo) throws CMException {
        CMProperty property = null;
        String literalValue = this.literal;
        boolean bNeedEscape = false;
        if (CMDbConnection.dbms_ == 1 || CMDbConnection.dbms_ == 4) {
            bNeedEscape = true;
        }
        if (elmExpressionPartner != null) {
            if (elmExpressionPartner.getClass() == CMStorePathPredicateFunction.class) {
                CMStorePathPredicateFunction theFunction = (CMStorePathPredicateFunction)elmExpressionPartner;
                if (theFunction.function_ == CMConstants.FUNC_CONTAINS_DEF) {
                    literalValue = bNeedEscape ? "%" + this.escape(this.literal) + "%" : "%" + this.literal + "%";
                } else if (theFunction.function_ == CMConstants.FUNC_STARTSWITH_DEF) {
                    literalValue = bNeedEscape ? this.escape(this.literal) + "%" : this.literal + "%";
                } else if (theFunction.function_ == CMConstants.FUNC_ENDSWITH_DEF) {
                    literalValue = bNeedEscape ? "%" + this.escape(this.literal) : "%" + this.literal;
                }
            } else if (elmExpressionPartner.getClass() == CMStorePredicateAttribute.class) {
                CMStorePredicateAttribute elmAttribute = (CMStorePredicateAttribute)elmExpressionPartner;
                property = elmAttribute.property;
            }
        }
        String result = null;
        if (this.literal.length() > 0 || property.hasMeaning(CMPropertyMeaning.TENANTID)) {
            if (property != null && property.getIndexProperty() != null) {
                CMDbProperty indexProp = (CMDbProperty)property.getIndexProperty();
                result = wcInfo.addLiteral(indexProp, CMDbStoreUtil.getIndexValue(this.literal));
            } else {
                result = wcInfo.addLiteral(property, literalValue);
            }
        } else {
            result = "";
        }
        if (wcInfo.inExistsExpression()) {
            if (this.bEscaped_ && CMDbConnection.dbms_ == 1) {
                return result + " {escape '\\'}" + wcInfo.endExistsExpression();
            }
            if (this.bEscaped_ && CMDbConnection.dbms_ == 4) {
                return result + " escape '\\'" + wcInfo.endExistsExpression();
            }
            return result + wcInfo.endExistsExpression();
        }
        if (this.bEscaped_ && CMDbConnection.dbms_ == 1) {
            result = result + " {escape '\\'}";
        } else if (this.bEscaped_ && CMDbConnection.dbms_ == 4) {
            result = result + " escape '\\'";
        }
        return result;
    }

    @Override
    public String toAccmanSearchFilter(CMStorePredicateElement elmExpressionPartner) {
        return "";
    }

    @Override
    public String toAccmanSearchFilter(CMStorePredicateElement elmExpressionPartner, String props) {
        return "";
    }

    public String toString() {
        return this.quoteChar + CMStoreXPath.attributeEncodeString(this.literal, this.quoteChar) + this.quoteChar;
    }

    private String escape(String lit) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < "\\[]%".length(); ++i) {
            char specialChar = "\\[]%".charAt(i);
            int endPos = lit.indexOf(specialChar);
            if (endPos == -1) {
                ret.append(lit);
                continue;
            }
            ret.delete(0, ret.length());
            while (endPos != -1) {
                this.bEscaped_ = true;
                ret.append(lit.substring(0, endPos));
                ret.append('\\');
                ret.append(specialChar);
                lit = lit.substring(endPos + 1);
                endPos = lit.indexOf(specialChar);
            }
            ret.append(lit);
            lit = ret.toString();
        }
        return lit;
    }

    public void setQuoteChar(char c) {
        this.quoteChar = c;
    }
}

