/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store.path;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.path.CMPathStepTokenizer;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPathStep;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cmutils.hash.HashUtil;
import com.cognos.cmutils.path.SearchPathEncoder;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class CMStoreXPath
extends CMStorePath {
    private boolean disallowObsoleteClasses_ = false;

    @Override
    protected CMStorePathStep CreateNewStep(int axis) {
        return new CMStoreXPathStep(axis, this.disallowObsoleteClasses_);
    }

    protected CMStoreXPath(CMStoreXPath src, int lmUsage) {
        this.bCompound_ = src.bCompound_;
        this.path_ = src.path_;
        this.fullPath_ = src.fullPath_;
        this.usageLockManager_ = lmUsage;
    }

    CMStoreXPath(int lmUsage, boolean disallowObsoleteClasses) {
        this.bCompound_ = false;
        this.path_ = null;
        this.fullPath_ = new ArrayList();
        this.usageLockManager_ = lmUsage;
        this.disallowObsoleteClasses_ = disallowObsoleteClasses;
    }

    public CMStoreXPath(int lmUsage) {
        this(lmUsage, false);
    }

    public CMStoreXPath(String path, int lmUsage) throws CMStoreParseException {
        this(null, path, false, lmUsage, false);
    }

    public CMStoreXPath(CMStorePath parent, String childPath, boolean mayBeRelative, int lmUsage) throws CMStoreParseException {
        this(parent, childPath, mayBeRelative, lmUsage, false);
    }

    public CMStoreXPath(CMStorePath parent, String childPath, boolean mayBeRelative, int lmUsage, boolean disallowObsoleteClasses) throws CMStoreParseException {
        this.originalSearchPath_ = parent != null && parent.originalSearchPath_ != null ? parent.originalSearchPath_ + "/" + childPath : childPath;
        this.usageLockManager_ = lmUsage;
        this.disallowObsoleteClasses_ = disallowObsoleteClasses;
        if (childPath == null) {
            throw new RuntimeException("CMStoreXPath childPath=null");
        }
        if (childPath.length() == 0) {
            throw new CMStoreParseException("cmInvalidSearchPath", new CMException.Parm("Path", childPath));
        }
        if (childPath.endsWith("/") && childPath.length() > 1) {
            throw new CMStoreParseException("cmCannotEndWithSlash");
        }
        if ('~' == childPath.charAt(0) && null == parent) {
            parent = new CMStoreXPath(this.usageLockManager_);
            CMStoreXPathStep child = new CMStoreXPathStep(1);
            child.bCurrentUser_ = true;
            parent.fullPath_.add(child);
            if (childPath.length() > 1) {
                char c = childPath.charAt(1);
                if (c == '~') {
                    if (childPath.length() > 2) {
                        if (childPath.charAt(2) != '/') {
                            throw new CMStoreParseException("cmBadAccountExpr");
                        }
                        childPath = childPath.substring(3);
                    } else {
                        childPath = "";
                    }
                    CMStoreXPathStep sessionchild = new CMStoreXPathStep(1);
                    sessionchild.bCurrentSession_ = true;
                    CMExecutionContext.get().setAuthenticateCreateSession();
                    parent.fullPath_.add(sessionchild);
                } else {
                    if (c != '/') {
                        throw new CMStoreParseException("cmBadAccountExpr");
                    }
                    childPath = childPath.substring(2);
                }
                if (childPath.length() > 0 && childPath.charAt(0) == '/') {
                    childPath = "descendant-or-self::" + childPath.substring(1);
                }
            } else {
                childPath = "";
            }
        }
        this.fullPath_ = parent != null && parent.fullPath_ != null && (childPath.length() == 0 || childPath.charAt(0) != '/') ? new ArrayList<Object>(parent.fullPath_) : new ArrayList();
        StringReader sr = new StringReader(childPath);
        CMPathStepTokenizer tokens = new CMPathStepTokenizer(sr);
        this.parsePath(tokens, false, true);
        try {
            if (tokens.nextToken() != -1) {
                throw new CMStoreParseException("cmInvalidSearchPath", new CMException.Parm("Path", childPath));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected CMStoreXPath(CMStoreXPath src) {
        this(src, 10);
    }

    CMStoreXPath() {
        this(10);
    }

    public CMStoreXPath(String path) throws CMStoreParseException {
        this(path, 10);
    }

    public CMStoreXPath(CMStorePath parent, String childPath, boolean mayBeRelative) throws CMStoreParseException {
        this(parent, childPath, mayBeRelative, 10, false);
    }

    public CMStoreXPath(CMStorePath parent, String childPath, boolean mayBeRelative, boolean disallowObsoleteClasses) throws CMStoreParseException {
        this(parent, childPath, mayBeRelative, 10, disallowObsoleteClasses);
    }

    public static CMStoreXPath createCAMCurrentAccountPath(CMStoreXPath namespacePath) {
        CMStoreXPath path = new CMStoreXPath();
        path.fullPath_ = new ArrayList(namespacePath.fullPath_);
        return path;
    }

    void parsePath(CMPathStepTokenizer tokens, boolean bCompoundComponent, boolean bAllowCompoundPath) throws CMStoreParseException {
        this.initTokenizer(tokens);
        boolean bSepChar = false;
        try {
            int iToken;
            while ((iToken = tokens.nextToken()) != -1 && iToken != 41 && iToken != 44) {
                CMStorePathStep step;
                if (iToken == 47) {
                    if (bSepChar) {
                        step = this.CreateNewStep(8);
                        this.hasDescendantSteps_ = true;
                        step.Parse(tokens);
                        this.fullPath_.add(step);
                        bSepChar = false;
                        this.initTokenizer(tokens);
                        continue;
                    }
                    bSepChar = true;
                    continue;
                }
                if (iToken == 124) {
                    CMStoreXPath compoundComponent;
                    bSepChar = false;
                    if (bCompoundComponent) {
                        tokens.pushBack();
                        break;
                    }
                    if (!bAllowCompoundPath) {
                        throw new CMStoreParseException("cmBadCharInNodeTest", new CMException.Parm("Value", Integer.toString(iToken)));
                    }
                    if (!this.bCompound_) {
                        compoundComponent = new CMStoreXPath(this, this.usageLockManager_);
                        this.path_ = null;
                        this.fullPath_ = new ArrayList();
                        this.fullPath_.add(compoundComponent);
                    }
                    compoundComponent = new CMStoreXPath(this.usageLockManager_, this.disallowObsoleteClasses_);
                    compoundComponent.parsePath(tokens, true, false);
                    this.fullPath_.add(compoundComponent);
                    this.bCompound_ = true;
                    continue;
                }
                if (iToken == 126 && this.fullPath_.size() == 0) {
                    CMStoreXPathStep userStep = new CMStoreXPathStep(1);
                    userStep.bCurrentUser_ = true;
                    this.fullPath_.add(userStep);
                    iToken = tokens.nextToken();
                    if (iToken != 126) {
                        tokens.pushBack();
                        continue;
                    }
                    CMStoreXPathStep sessionchild = new CMStoreXPathStep(1);
                    sessionchild.bCurrentSession_ = true;
                    this.fullPath_.add(sessionchild);
                    continue;
                }
                tokens.pushBack();
                step = this.CreateNewStep(99);
                step.Parse(tokens);
                if (step.getNodeSetFunction() != null && this.fullPath_.size() >= 1) {
                    throw new CMStoreParseException("cmInvalidNodeSetStep", new CMException.Parm("Name", step.getNodeSetFunction().getName()));
                }
                this.fullPath_.add(step);
                this.hasDescendantSteps_ |= step.isDescendant();
                bSepChar = false;
                this.initTokenizer(tokens);
            }
            tokens.pushBack();
        }
        catch (IOException e) {
            CMStoreParseException storeE = new CMStoreParseException(e, "cmErrParse");
            CMIndications.logException(storeE);
            this.fullPath_ = null;
            throw storeE;
        }
        catch (CMStoreParseException spex) {
            throw new CMStoreParseException((Exception)spex, "cmInvalidSearchPath", new CMException.Parm("Path", this.originalSearchPath_));
        }
        this.SetDefaultAxis(this);
        if (this.fullPath_.size() == 0) {
            this.fullPath_ = null;
        } else if (!this.bCompound_) {
            for (int i = 0; i < this.fullPath_.size(); ++i) {
                CMStorePathStep step = (CMStorePathStep)this.fullPath_.get(i);
                CMConstants.FunctionDef function = step.getNodeSetFunction();
                if (function != CMConstants.FUNC_STOREID_DEF || i <= 0) continue;
                throw new CMStoreParseException("cmInvalidSearchPath", new CMException.Parm("Path", this.originalSearchPath_));
            }
        }
    }

    public static CMStoreXPath fromStoreID(String storeID) {
        String sb = CMStoreXPath.encodeStoreIdToPathString(storeID);
        try {
            return new CMStoreXPath(null, sb, false, 10);
        }
        catch (CMStoreParseException e) {
            throw new RuntimeException("Unexpected.");
        }
    }

    public static String encodeStoreIdToPathString(String storeID) {
        StringBuffer sb = new StringBuffer(64);
        sb.append(CMConstants.FUNC_STOREID_DEF.getName()).append("(\"").append(storeID).append("\")");
        return sb.toString();
    }

    public static String attributeEncodeString(String src, char delimiter) {
        return SearchPathEncoder.escapeDelimiter((String)src, (char)delimiter);
    }

    public static String attributeEncodeString(String src) {
        return SearchPathEncoder.escapeDelimiter((String)src, (char)'\'');
    }

    public static String attributeQuoteString(String src) {
        return SearchPathEncoder.quoteString((String)src);
    }

    public static ICMStorePath parse(String s, int lockManagerUsage) throws CMStoreParseException {
        return new CMStoreXPath(null, s, false, lockManagerUsage, false);
    }

    public static CMStorePath parse(String s) throws CMStoreParseException {
        return new CMStoreXPath(null, s, false);
    }

    public static ICMStorePath parse(String s, boolean disallowObsoleteClasses) throws CMStoreParseException {
        return new CMStoreXPath(null, s, false, disallowObsoleteClasses);
    }

    @Override
    public void ResolveCurrentUserSteps(boolean bResolveSession) throws CMStoreParseException {
        this.ResolveCurrentUserSteps(bResolveSession, true);
    }

    public void ResolveCurrentUserSteps(boolean bResolveSession, boolean bUsePath) throws CMStoreParseException {
        if (this.bCompound_) {
            return;
        }
        if (this.fullPath_ != null && this.fullPath_.size() > 0) {
            CMStoreXPathStep step = (CMStoreXPathStep)this.fullPath_.get(0);
            if (step.bCurrentUser_ && (!step.bCurrentSession_ || bResolveSession || this.fullPath_.size() > 1)) {
                try {
                    String userPathStr;
                    CMExecutionContext ctx = CMExecutionContext.get();
                    String string = userPathStr = bUsePath ? ctx.getCurrentUserPath() : ctx.getCurrentUserSearchPath();
                    if (null == userPathStr || 0 >= userPathStr.length()) {
                        throw new CMStoreParseException("cmBadSession");
                    }
                    if (null == this.originalSearchPath_) {
                        this.originalSearchPath_ = userPathStr;
                    }
                    CMStoreXPath userPath = new CMStoreXPath(userPathStr, this.usageLockManager_);
                    int userPathSize = userPath.fullPath_.size();
                    this.fullPath_.remove(0);
                    this.fullPath_.addAll(0, userPath.fullPath_);
                    step.bCurrentUser_ = false;
                    if (this.fullPath_.size() > userPathSize) {
                        step = (CMStoreXPathStep)this.fullPath_.get(userPathSize);
                        if (step.bCurrentSession_) {
                            String curPassport = ctx.getAccManPassportID();
                            if (null == curPassport) {
                                throw new CMStoreParseException("cmBadSession");
                            }
                            userPathStr = "session[@defaultName='" + new HashUtil().hash(curPassport) + "']";
                            StringReader sr = new StringReader(userPathStr);
                            CMPathStepTokenizer tokens = new CMPathStepTokenizer(sr);
                            step.Parse(tokens);
                            tokens = null;
                            step.bCurrentSession_ = false;
                            step.bCurrentUser_ = false;
                        }
                    }
                }
                catch (IOException e) {
                    CMStoreParseException storeE = new CMStoreParseException(e, "cmErrParse");
                    CMIndications.logException(storeE);
                    this.fullPath_ = null;
                    throw storeE;
                }
            }
        }
    }
}

